/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.model3.ws.reader;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.image.ImageRecord;
import com.stratadata.model3.image.TaxonImageSet;
import com.stratadata.model3.image.ZipFileImageLoader;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SynonymScheme;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.user.User;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import com.stratadata.model3.well.analysis.hdr.AbundanceSchemeImpl;
import com.stratadata.model3.ws.Workspace;
import com.stratadata.model3.ws.reader.ParsedWorkspace;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import model3.TxGroup;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.SBException;

public class XmlReader
implements ParsedWorkspace {
    private static final Logger LOGGER = Logger.getLogger(XmlReader.class.getName());
    private final Workspace workspace;
    private Map<Integer, ParsedWorkspace.ParsedTaxonInfo> parsedTaxonInfo = new HashMap<Integer, ParsedWorkspace.ParsedTaxonInfo>();

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    public XmlReader(Document xmlDocument, ZipFile zipFile) {
        this.workspace = new Workspace();
        if (zipFile != null) {
            this.workspace.setImageLoader(new ZipFileImageLoader(zipFile.getName()));
        }
        this.parseXMLDocument(xmlDocument);
    }

    private void parseXMLDocument(Document xmlDocument) {
        Element txList;
        Iterator uit;
        ZipFile zip = null;
        IteratorIterable it = xmlDocument.getDescendants((Filter)new ElementFilter("UserList"));
        if (it.hasNext()) {
            Element userList = (Element)it.next();
            uit = userList.getChildren().iterator();
            while (uit.hasNext()) {
                User user = XmlReader.parseUser((Element)uit.next());
                this.workspace.getUserService().addUser(user);
            }
        }
        if (it.hasNext()) {
            throw new IllegalStateException("Error - XML document contains more than one user list");
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonList"));
        while (it.hasNext()) {
            txList = (Element)it.next();
            uit = txList.getContent((Filter)new ElementFilter("Taxon")).iterator();
            while (uit.hasNext()) {
                this.parseTaxon((Element)uit.next(), zip);
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonList"));
        while (it.hasNext()) {
            txList = (Element)it.next();
            uit = txList.getContent((Filter)new ElementFilter("Genus")).iterator();
            while (uit.hasNext()) {
                this.parseGenus((Element)uit.next());
            }
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("TaxonGroup"));
        while (it.hasNext()) {
            Element xmlGs = (Element)it.next();
            TxGroup txGroup = this.parseTxGroup(xmlGs);
        }
        it = xmlDocument.getDescendants((Filter)new ElementFilter("SynonymScheme"));
        while (it.hasNext()) {
            this.parseSynonymScheme((Element)it.next());
        }
    }

    private static Optional<String> findString(Element el, String cname) {
        return Optional.ofNullable(el.getChildText(cname));
    }

    private static User parseUser(Element xml) {
        int userID = XmlReader.findString(xml, "UserID").map(Integer::parseInt).orElseThrow(() -> new IllegalStateException("UserID null in XML - invalid"));
        User user = new User(userID);
        user.setName(xml.getChildText("UserName"));
        user.setAbr(xml.getChildTextNormalize("Abbreviation"));
        String discipline = xml.getChildTextNormalize("DisciplineID");
        if (discipline != null && discipline.length() > 0) {
            user.setDiscipline(Discipline.getDisc((String)discipline));
        }
        return user;
    }

    private void parseTaxon(Element xml, ZipFile zip) {
        int genID = XmlReader.findString(xml, "GenusID").map(Integer::parseInt).orElseThrow(() -> new IllegalStateException("GenusID null in XML - invalid"));
        int specID = XmlReader.findString(xml, "SpeciesID").map(Integer::parseInt).orElseThrow(() -> new IllegalStateException("SpeciesID null in XML - invalid"));
        String cat_mnem = XmlReader.findString(xml, "Category").orElse("");
        Category category = new Category(cat_mnem);
        Genus genus = new Genus(genID);
        Taxon taxon = new Taxon(specID);
        genus.setCategory(category);
        taxon.setGenus(genus);
        taxon.setSpecies(xml.getChildText("Species"));
        genus.setGenusName(xml.getChildText("Genus"));
        XmlReader.findString(xml, "GQ1").ifPresent(s -> genus.setQualifier(0, new Qualifier(0, s)));
        XmlReader.findString(xml, "GQ2").ifPresent(s -> genus.setQualifier(1, new Qualifier(1, s)));
        XmlReader.findString(xml, "GQ3").ifPresent(s -> genus.setQualifier(2, new Qualifier(2, s)));
        XmlReader.findString(xml, "GQ4").ifPresent(s -> genus.setQualifier(3, new Qualifier(3, s)));
        XmlReader.findString(xml, "SubGenus").ifPresent(s -> genus.setSubGenus(s));
        XmlReader.findString(xml, "SQ1").ifPresent(s -> taxon.setQualifier(4, new Qualifier(4, s)));
        XmlReader.findString(xml, "SQ2").ifPresent(s -> taxon.setQualifier(5, new Qualifier(5, s)));
        XmlReader.findString(xml, "SQ3").ifPresent(s -> taxon.setQualifier(6, new Qualifier(6, s)));
        XmlReader.findString(xml, "SQ4").ifPresent(s -> taxon.setQualifier(7, new Qualifier(7, s)));
        XmlReader.findString(xml, "SubSpecies").ifPresent(s -> taxon.setSubSpecies(s));
        XmlReader.findString(xml, "Alphacode").ifPresent(s -> taxon.setAlphaCode(s));
        XmlReader.findString(xml, "Author").ifPresent(s -> taxon.setAuthor(s));
        XmlReader.findString(xml, "Notes").ifPresent(s -> taxon.setNotes(s));
        XmlReader.findString(xml, "Reference").ifPresent(s -> taxon.setReference(s));
        XmlReader.findString(xml, "URL").ifPresent(s -> taxon.setUrl(s));
        Object yearString = xml.getChildTextNormalize("Year");
        if (yearString != null) {
            if (!taxon.getAuthor().isEmpty()) {
                yearString = taxon.getAuthor() + " " + (String)yearString;
            }
            taxon.setAuthor((String)yearString);
        }
        this.workspace.getTaxonService().addTaxon(taxon);
        String donorString = taxon.toString(true, false);
        String noAuthorDonorString = taxon.toString(false, false);
        this.parsedTaxonInfo.put(taxon.getSpecID(), new ParsedWorkspace.ParsedTaxonInfo(taxon.getSpecID(), donorString, noAuthorDonorString));
        IteratorIterable imageSetElementIterator = xml.getDescendants((Filter)new ElementFilter("ImageSet"));
        while (imageSetElementIterator.hasNext()) {
            Element xmlImageSet = (Element)imageSetElementIterator.next();
            IteratorIterable imageIterator = xmlImageSet.getDescendants((Filter)new ElementFilter("Image"));
            ArrayList<ImageRecord> imageRecords = new ArrayList<ImageRecord>();
            while (imageIterator.hasNext()) {
                Element imageElement = (Element)imageIterator.next();
                String idString = imageElement.getChildTextNormalize("ImageID");
                if (idString == null) {
                    throw new IllegalStateException("ID null in XML - invalid");
                }
                int imageID = Integer.parseInt(idString);
                String fileName = imageElement.getChildTextNormalize("File");
                String caption = imageElement.getChildTextNormalize("Caption");
                imageRecords.add(new ImageRecord(imageID, caption, fileName));
            }
            int imageSetID = this.workspace.getImageRecordService().storeImageSet(0, imageRecords, this.workspace.getImageLoader());
            this.workspace.getTaxonImageService().addTaxonImageSet(specID, new TaxonImageSet(imageSetID, specID, true));
        }
    }

    @Override
    public Optional<ParsedWorkspace.ParsedTaxonInfo> getParsedTaxonInfo(int specID) {
        return Optional.ofNullable(this.parsedTaxonInfo.get(specID));
    }

    private void parseGenus(Element xml) {
        int genID = XmlReader.findString(xml, "GenusID").map(Integer::parseInt).orElseThrow(() -> new IllegalStateException("ID null in XML - invalid"));
        if (this.workspace.getGenusService().findGenus(genID).isPresent()) {
            return;
        }
        String cat_mnem = XmlReader.findString(xml, "Category").orElse("");
        Category category = new Category(cat_mnem);
        Genus genus = new Genus(genID);
        genus.setCategory(category);
        genus.setGenusName(xml.getChildText("Genus"));
        XmlReader.findString(xml, "GQ1").ifPresent(s -> genus.setQualifier(0, new Qualifier(0, s)));
        XmlReader.findString(xml, "GQ2").ifPresent(s -> genus.setQualifier(1, new Qualifier(1, s)));
        XmlReader.findString(xml, "GQ3").ifPresent(s -> genus.setQualifier(2, new Qualifier(2, s)));
        XmlReader.findString(xml, "GQ4").ifPresent(s -> genus.setQualifier(3, new Qualifier(3, s)));
        XmlReader.findString(xml, "SubGenus").ifPresent(s -> genus.setSubGenus(s));
        this.workspace.getGenusService().addGenus(genus);
    }

    private TxGroup parseTxGroup(Element xml) {
        TxGroup group;
        try {
            group = TxGroup.parseTxGroup(xml, this.workspace);
        }
        catch (SQLException | ParseException | SBException e) {
            throw new IllegalStateException(e);
        }
        Element taxonList = xml.getChild("TaxonList");
        LinkedList<Taxon> grpTaxa = new LinkedList<Taxon>();
        if (taxonList != null) {
            for (Element el : taxonList.getContent((Filter)new ElementFilter("Taxon"))) {
                String strgID = el.getChildTextNormalize("SpeciesID");
                if (strgID == null) {
                    throw new IllegalStateException("ID null in XML - invalid");
                }
                int specID = Integer.parseInt(strgID);
                Taxon species = (Taxon)this.workspace.getTaxonService().findTaxon(specID).orElseThrow(() -> new IllegalStateException("Unparsed taxon in group " + group.getName() + " (" + el.getChildTextNormalize("Species") + ")"));
                grpTaxa.add(species);
            }
        } else {
            for (Element element : xml.getChildren("Taxon")) {
                int specID = Integer.parseInt(element.getAttributeValue("SpeciesID"));
                Taxon species = (Taxon)this.workspace.getTaxonService().findTaxon(specID).orElseThrow(() -> new IllegalStateException("Unparsed taxon in group " + group.getName() + " (" + element.getChildTextNormalize("Species") + ")"));
                grpTaxa.add(species);
            }
        }
        group.addTaxaBySpecID(grpTaxa.stream().map(Taxon::getSpecID).collect(Collectors.toSet()));
        LinkedList<Genus> genera = new LinkedList<Genus>();
        if (taxonList != null) {
            for (Element el : taxonList.getContent((Filter)new ElementFilter("Genus"))) {
                String strgID = el.getChildTextNormalize("GenusID");
                if (strgID == null) {
                    throw new IllegalStateException("GenusID null in XML - invalid");
                }
                int genID = Integer.parseInt(strgID);
                Genus genus = (Genus)this.workspace.getGenusService().findGenus(genID).orElseThrow(() -> new IllegalStateException("Unparsed genus in group " + group.getName() + " (" + el.getChildTextNormalize("Genus") + ")"));
                genera.add(genus);
            }
        } else {
            for (Object o : xml.getChildren("Genus")) {
                int genID = Integer.parseInt(((Element)o).getAttributeValue("GenusID"));
                this.workspace.getGenusService().findGenus(genID).ifPresentOrElse(g -> genera.add((Genus)g), () -> LOGGER.warning("Missing genus with id: " + genID + " for group " + group.getName() + " - probable malformed XML file"));
            }
        }
        return group;
    }

    private void parseSynonymScheme(Element xml) {
        String name = xml.getChildText("SchemeName");
        String strgID = xml.getChildTextNormalize("SchemeID");
        if (strgID == null) {
            throw new IllegalStateException("ID null in XML - invalid");
        }
        int schemeID = Integer.parseInt(strgID);
        SynonymScheme scheme = new SynonymScheme(schemeID, name);
        this.workspace.addSynonymScheme(scheme);
        for (Element el : xml.getContent((Filter)new ElementFilter("Entry"))) {
            strgID = el.getChildTextNormalize("SpeciesID");
            if (strgID == null) {
                throw new IllegalStateException("ID null in XML - invalid");
            }
            int specID = Integer.parseInt(strgID);
            strgID = el.getChildTextNormalize("PrefID");
            if (strgID == null) {
                throw new IllegalStateException("ID null in XML - invalid");
            }
            int prefID = Integer.parseInt(strgID);
            this.workspace.getSynonymService().addSynonym(scheme.getSchID(), specID, prefID);
        }
    }

    public static AbundanceScheme parseAbundanceScheme(Element xml) {
        String strgID = xml.getChildTextNormalize("SchemeID");
        if (strgID == null) {
            throw new IllegalStateException("ID null in abundance scheme XML - invalid");
        }
        int ID = Integer.parseInt(strgID);
        AbundanceSchemeImpl abundanceScheme = new AbundanceSchemeImpl(ID);
        abundanceScheme.setName(xml.getChildText("SchemeName"));
        for (Element el : xml.getContent((Filter)new ElementFilter("Category"))) {
            String entryName = el.getChildText("Name");
            String abr = el.getChildTextNormalize("Entry");
            int lowBound = Integer.parseInt(el.getChildTextNormalize("LowBound"));
            int outputValue = Integer.parseInt(el.getChildTextNormalize("OutputValue"));
            abundanceScheme.addEntry(new AbundanceScheme.AbundanceSchemeEntry(entryName, abr, lowBound, outputValue));
        }
        return abundanceScheme;
    }
}

