/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.util.Objects;
import util.AgeFormat;
import util.DepthUnits;
import util.DoubleRange;
import util.SB;

public class AccumulationRateInterval {
    private final DoubleRange depthRange;
    private final double accumulationRate;
    private final char depthUnits;
    private final AgeFormat ageFormat;

    public AccumulationRateInterval(DoubleRange depthRange, double accumulationRate, char depthUnits, AgeFormat ageFormat) {
        this.depthRange = depthRange;
        this.accumulationRate = accumulationRate;
        this.depthUnits = depthUnits;
        this.ageFormat = ageFormat;
    }

    public DoubleRange getDepthRange() {
        return this.depthRange;
    }

    public double getAccumulationRate() {
        return this.accumulationRate;
    }

    public AgeFormat getAgeFormat() {
        return this.ageFormat;
    }

    public char getDepthUnits() {
        return this.depthUnits;
    }

    public String getAccumRateString() {
        String rateString = Double.isInfinite(this.accumulationRate) ? "\u221e" : Double.toString(SB.roundToSignificantFigures((double)this.accumulationRate, (int)3));
        return rateString + " " + DepthUnits.getUnits((char)this.depthUnits).getAbr() + "/" + this.ageFormat.getDescr();
    }

    public String toString() {
        return "AccumulationRateInterval{depthRange=" + String.valueOf(this.depthRange) + ", accumulationRate=" + this.accumulationRate + ", depthUnits=" + this.depthUnits + ", ageFormat=" + String.valueOf(this.ageFormat) + "}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccumulationRateInterval that = (AccumulationRateInterval)o;
        return Double.compare(this.accumulationRate, that.accumulationRate) == 0 && this.depthUnits == that.depthUnits && Objects.equals(this.depthRange, that.depthRange) && this.ageFormat == that.ageFormat;
    }

    public int hashCode() {
        return Objects.hash(this.depthRange, this.accumulationRate, Character.valueOf(this.depthUnits), this.ageFormat);
    }
}

