/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.Audit;
import model3.SBRestrictable;
import model3.SBdb;
import model3.TSCreatorReader;
import org.jdom2.Element;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SBPermissionException;
import util.SbugsLink;

public class AgeCurve
extends SBObservable
implements Comparable,
SbugsLink {
    public static String[] styles = new String[]{"Solid"};
    public static final int STYLE_SOLID = 0;
    private static final Logger LOGGER = Logger.getLogger(AgeCurve.class.toString());
    private SBdb db;
    private int curveID;
    private List<AgeCurveValue> trace = null;
    private int schID;
    private String title;
    private String units;
    private Double oldest;
    private Double youngest;
    private Color colour;
    private float lineWidth;
    private int style;
    private String fileName;
    private Audit audit;
    private AgeCurve link;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AgeCurve(File file, String title, String units, Color colour, int style, float lineWidth, int schID) throws IOException {
        this.title = title;
        this.units = units;
        this.style = style;
        this.lineWidth = lineWidth;
        this.schID = schID;
        this.colour = colour;
        this.fileName = file.getPath();
        this.trace = new LinkedList<AgeCurveValue>();
        this.db = null;
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            String buff;
            while ((buff = in.readLine()) != null) {
                StringTokenizer tok;
                if (buff.trim().length() == 0 || (tok = new StringTokenizer(buff, " ,;\t")).countTokens() < 2) continue;
                try {
                    while (tok.hasMoreTokens()) {
                        AgeCurveValue val = new AgeCurveValue();
                        val.age = Double.parseDouble(tok.nextToken());
                        val.value = Double.parseDouble(tok.nextToken());
                        this.trace.add(val);
                    }
                }
                catch (NumberFormatException ex) {
                    System.out.println("Number format exception in : " + buff);
                }
            }
            return;
        }
    }

    public AgeCurve(TSCreatorReader.TSCCurve curve, String units, Color colour, int style, float lineWidth, int schID) {
        this.schID = schID;
        this.title = curve.name;
        this.units = units;
        this.lineWidth = lineWidth;
        this.colour = colour;
        this.style = style;
        this.trace = new LinkedList<AgeCurveValue>();
        this.db = null;
        for (TSCreatorReader.TSCPoint point : curve.getPoints()) {
            AgeCurveValue value = new AgeCurveValue();
            value.age = point.age;
            if (this.youngest == null || value.age < this.youngest) {
                this.youngest = value.age;
            }
            if (this.oldest == null || value.age > this.oldest) {
                this.oldest = value.age;
            }
            value.value = point.value;
            this.trace.add(value);
        }
    }

    AgeCurve(SBdb db, int curveID, int schID, String title, String units, float lineWidth, Color colour, int style, Audit audit) throws SQLException {
        this.curveID = curveID;
        this.schID = schID;
        this.title = title;
        this.units = units;
        this.lineWidth = lineWidth;
        this.colour = colour;
        this.style = style;
        this.audit = audit;
        this.db = db;
    }

    private void loadTrace() throws SQLException {
        if (this.trace != null) {
            return;
        }
        this.trace = new LinkedList<AgeCurveValue>();
        if (this.db != null && this.db.isConnected()) {
            String sql = "SELECT age, trace_value FROM " + this.db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + this.curveID + " ORDER BY age";
            try (Statement stmt = this.db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                while (rs.next()) {
                    double age;
                    AgeCurveValue value = new AgeCurveValue();
                    value.age = age = rs.getDouble("age");
                    if (this.youngest == null || age < this.youngest) {
                        this.youngest = age;
                    }
                    if (this.oldest == null || age > this.oldest) {
                        this.oldest = age;
                    }
                    value.value = rs.getDouble("trace_value");
                    this.trace.add(value);
                }
            }
        }
    }

    static void loadAll(SBdb db, List ageCurves) throws SQLException {
        String sql = "SELECT curve_id, sch_id, title, units, linewidth, colour, style," + Audit.sqlFieldString() + " FROM " + db.DBTableName("AGE_CURVE");
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                int curveID = rs.getInt("curve_id");
                int schID = rs.getInt("sch_id");
                String title = rs.getString("title");
                String units = rs.getString("units");
                float lineWidth = rs.getFloat("linewidth");
                Color colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                int style = rs.getInt("style");
                Audit audit = new Audit(rs);
                ageCurves.add(new AgeCurve(db, curveID, schID, title, units, lineWidth, colour, style, audit));
            }
        }
    }

    void store(SBdb db) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        this.audit = new Audit();
        this.curveID = db.nextControl("AGE_CURVE", "CURVE_ID");
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "INSERT INTO " + db.DBTableName("AGE_CURVE") + " ( curve_id, sch_id, title, units, linewidth, colour, style," + Audit.sqlFieldString() + ") VALUES (";
            sql = sql + this.curveID + "," + this.schID + "," + SB.DBString((String)this.title) + "," + SB.DBString((String)this.units) + "," + this.lineWidth + "," + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)true) + "," + this.style + "," + this.audit.sqlInsert(db, stmt) + ")";
            stmt.executeUpdate(db.modQuery(sql));
        }
        if (this.trace != null) {
            String sql = "INSERT INTO " + db.DBTableName("AGE_TRACE") + " (curve_id, age, trace_value) VALUES (" + this.curveID + ",?,?)";
            try (PreparedStatement pStmt = db.getDatabase().prepareStatement(db.modQuery(sql));){
                for (AgeCurveValue value : this.trace) {
                    pStmt.setDouble(1, value.age);
                    pStmt.setDouble(2, value.value);
                    try {
                        pStmt.executeUpdate();
                    }
                    catch (SQLException sqle) {
                        System.out.println("SQL Exception " + sqle.getMessage() + " while inserting value: " + value.age + "," + value.value);
                    }
                }
            }
        }
    }

    public void updateAttributes(SBdb db) throws SBException, SQLException, SBPermissionException {
        if (this.curveID <= 0) {
            return;
        }
        if (!SBRestrictable.canWrite(db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "UPDATE " + db.DBTableName("AGE_CURVE") + " SET sch_id=" + this.schID + ",title=" + SB.DBString((String)this.title) + ",units=" + SB.DBString((String)this.units) + ",linewidth=" + this.lineWidth + ",colour=" + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)true) + ",style=" + this.style + "," + this.audit.sqlUpdate(db, stmt, false);
            sql = sql + " WHERE curve_id=" + this.curveID;
            stmt.executeUpdate(db.modQuery(sql));
        }
        this.setChanged();
        this.notifyObservers();
    }

    void delete(SBdb db) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "DELETE FROM " + db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + this.curveID;
            stmt.executeUpdate(db.modQuery(sql));
            sql = "DELETE FROM " + db.DBTableName("AGE_CURVE") + " WHERE curve_id=" + this.curveID;
            stmt.executeUpdate(db.modQuery(sql));
        }
    }

    public void deleteRow(SBdb db, AgeCurveValue curveValue) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(db)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "DELETE FROM " + db.DBTableName("AGE_TRACE") + " WHERE curve_id=" + this.curveID + " AND age > " + (curveValue.age - 0.001) + " AND age < " + (curveValue.age + 0.001);
            stmt.executeUpdate(db.modQuery(sql));
        }
        if (this.trace != null) {
            this.trace.remove(curveValue);
        }
        this.setChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Double getYoungest() {
        if (this.youngest == null) {
            this.setYoungest();
        }
        return this.youngest;
    }

    private void setYoungest() {
        for (AgeCurveValue val : this.getTrace()) {
            if (this.youngest != null && !(val.age < this.youngest)) continue;
            this.youngest = val.age;
        }
    }

    public Double getOldest() {
        if (this.oldest == null) {
            this.setOldest();
        }
        return this.oldest;
    }

    private void setOldest() {
        for (AgeCurveValue val : this.getTrace()) {
            if (this.oldest != null && !(val.age > this.oldest)) continue;
            this.oldest = val.age;
        }
    }

    public Double getMin(Double minAge, Double maxAge) {
        Double min = null;
        for (AgeCurveValue val : this.getTrace()) {
            if (minAge != null && maxAge != null && (val.age < minAge || val.age > maxAge) || min != null && !(val.value < min)) continue;
            min = val.value;
        }
        return min;
    }

    public Double getMax(Double minAge, Double maxAge) {
        Double max = null;
        for (AgeCurveValue val : this.getTrace()) {
            if (minAge != null && maxAge != null && (val.age < minAge || val.age > maxAge) || max != null && !(val.value > max)) continue;
            max = val.value;
        }
        return max;
    }

    public int getSchID() {
        return this.schID;
    }

    public void setSchID(int schID) {
        this.schID = schID;
    }

    public String getFilename() {
        return this.fileName;
    }

    public List<AgeCurveValue> getTrace() {
        if (this.trace == null) {
            try {
                this.loadTrace();
            }
            catch (SQLException sqle) {
                LOGGER.log(Level.SEVERE, "Error loading age trace", sqle);
                this.trace = new LinkedList<AgeCurveValue>();
            }
        }
        return this.trace;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }

    public Color getColour() {
        return this.colour;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCurveID() {
        return this.curveID;
    }

    public String toString() {
        return this.title;
    }

    public double getValue(double age) {
        AgeCurveValue n1 = null;
        AgeCurveValue n2 = null;
        for (AgeCurveValue n : this.getTrace()) {
            if (n.age < age) {
                n1 = n;
                continue;
            }
            if (Math.abs(n.age - age) < 0.01) {
                return n.value;
            }
            if (!(n.age > age)) continue;
            n2 = n;
            break;
        }
        if (n1 != null && n2 != null) {
            return n1.value + (age - n1.age) * ((n2.value - n1.value) / (n2.age - n1.age));
        }
        return 0.0;
    }

    public int compareTo(Object rhs) {
        return this.title.compareToIgnoreCase(rhs.toString());
    }

    private AgeCurve(AgeCurve rhs) {
        this.title = rhs.title;
        this.units = rhs.units;
        this.style = rhs.style;
        this.lineWidth = rhs.lineWidth;
        this.colour = rhs.colour;
        this.trace = new LinkedList<AgeCurveValue>();
        for (AgeCurveValue value : rhs.trace) {
            AgeCurveValue valCopy = new AgeCurveValue();
            valCopy.age = value.age;
            valCopy.value = value.value;
            this.trace.add(valCopy);
        }
    }

    private AgeCurve() {
    }

    AgeCurve copyToWorkspace(SBdb ws, SBdb db) throws SQLException, SBException {
        if (db.getAgeCurve(this.curveID) != this) {
            throw new IllegalArgumentException("Illegal AgeCurve copy");
        }
        AgeCurve copy = new AgeCurve(this);
        copy.curveID = this.curveID;
        this.audit.fillWorkspace(db, ws);
        copy.audit = new Audit(this.audit);
        return copy;
    }

    public AgeCurve copyToDatabase(SBdb ws, SBdb db) throws SQLException, SBException {
        if (ws.getAgeCurve(this.curveID) != this) {
            throw new IllegalArgumentException("Illegal AgeCurve copy");
        }
        AgeCurve copy = new AgeCurve(this);
        copy.audit = new Audit(db, ws, this.audit);
        return copy;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<AgeCurve Name=\"" + this.title + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<CurveID>" + this.curveID + "</CurveID>\n");
        out.write(ind + "<Title>" + SB.getXMLstring((String)this.title) + "</Title>\n");
        out.write(ind + "<Units>" + SB.getXMLstring((String)this.units) + "</Units>\n");
        String propertiesString = this.style + "|" + this.lineWidth + "|" + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)false);
        out.write(ind + "<Properties>" + SB.getXMLstring((String)propertiesString) + "</Properties>\n");
        this.audit.writeXML(out, indent + 3);
        String rowString = ind + "<Row Age=\"%s\" Value=\"%s\"/>\n";
        for (AgeCurveValue row : this.getTrace()) {
            out.write(String.format(rowString, row.age, row.value));
        }
        out.write(ind1 + "</AgeCurve>\n");
    }

    static AgeCurve parseXML(SBdb ws, Element el) throws ParseException, SQLException, SBException {
        assert (!ws.isConnected());
        AgeCurve curve = new AgeCurve();
        curve.trace = new LinkedList<AgeCurveValue>();
        curve.title = el.getChildText("Title");
        curve.units = el.getChildText("Units");
        curve.curveID = Integer.parseInt(el.getChildText("CurveID"));
        String properties = el.getChildText("Properties");
        String[] props = properties.split("\\|");
        if (props.length == 3) {
            curve.style = Integer.parseInt(props[0]);
            curve.lineWidth = Float.parseFloat(props[1]);
            curve.colour = ColourUtils.getColour((String)props[2]);
        }
        curve.audit = new Audit(ws, el.getChild("Audit"));
        for (Element row : el.getChildren("Row")) {
            AgeCurveValue value = new AgeCurveValue();
            value.age = Double.parseDouble(row.getAttributeValue("Age"));
            if (curve.youngest == null || curve.youngest > value.age) {
                curve.youngest = value.age;
            }
            if (curve.oldest == null || curve.oldest < value.age) {
                curve.oldest = value.age;
            }
            value.value = Double.parseDouble(row.getAttributeValue("Value"));
            curve.trace.add(value);
        }
        return curve;
    }

    public AgeCurve getLink() {
        return this.link;
    }

    public void setLink(AgeCurve link) {
        this.link = link;
    }

    void setAnalyst(Userdef analyst) {
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public static class AgeCurveValue {
        double age;
        double value;

        public double getAge() {
            return this.age;
        }

        public double getValue() {
            return this.value;
        }
    }
}

