/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.well.CoreShift;
import com.stratadata.model3.well.CoreShiftDepth;
import java.io.BufferedWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import model3.SBdb;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.exception.StackError;

public class Coreshift {
    private final SBdb db;
    private boolean isDirty = false;
    private CoreShift list;

    Coreshift(SBdb db, int wellID) throws SQLException {
        this.db = db;
        this.load(wellID);
    }

    public Coreshift() {
        this.db = null;
        try {
            this.load(0);
        }
        catch (SQLException e) {
            StackError.showStackError((String)e.toString(), (SQLException)e);
        }
    }

    Coreshift(SBdb db, Element xml) throws SBException {
        this.db = db;
        this.list = new CoreShift();
        IteratorIterable it = xml.getDescendants((Filter)new ElementFilter("CoreShiftDepth"));
        while (it.hasNext()) {
            Element shiftEl = (Element)it.next();
            double depth = 0.0;
            String strg = shiftEl.getChildTextNormalize("Depth");
            if (strg != null) {
                depth = DepthUtils.parseDepthString((String)strg);
            }
            float shift = 0.0f;
            strg = shiftEl.getChildTextNormalize("Shift");
            if (strg != null) {
                shift = (float)DepthUtils.parseDepthString((String)strg);
            }
            this.list.add(new CoreShiftDepth(depth, shift));
        }
        this.list.sort();
        CoreShiftDepth last = null;
        Iterator dit = this.list.iterator();
        while (dit.hasNext()) {
            CoreShiftDepth d = (CoreShiftDepth)dit.next();
            if (last != null && last.getDepth() == d.getDepth()) {
                if (last.getShift() == d.getShift()) {
                    dit.remove();
                } else {
                    d.setDepth(d.getDepth() + 0.001);
                }
            }
            last = d;
        }
    }

    public Coreshift(Coreshift rhs) {
        this.db = rhs.db;
        this.list = new CoreShift(rhs.list);
        this.isDirty = false;
    }

    public Coreshift(SBdb db, Coreshift rhs) {
        this.db = db;
        this.list = new CoreShift(rhs.list);
        this.isDirty = true;
    }

    public CoreShift getCoreShiftCopy() {
        return new CoreShift(this.list);
    }

    void update(int wellID, CoreShift coreshift) throws SQLException {
        coreshift.sort();
        this.list = coreshift;
        this.isDirty = true;
        this.store(wellID);
    }

    public void updateFromCoredInterval(int wellID, double topDepth, double baseDepth, Float topShift, Float baseShift) throws SQLException {
        CoreShiftDepth csd2;
        CoreShiftDepth csd3;
        List listCopy = this.list.getListCopy();
        for (CoreShiftDepth csd4 : listCopy) {
            System.out.println("CoreShift before: " + csd4.getDepth() + " / " + csd4.getShift());
        }
        ListIterator it = listCopy.listIterator();
        boolean found = false;
        while (it.hasNext()) {
            csd3 = (CoreShiftDepth)it.next();
            if (!(Math.abs(baseDepth - 0.01 - csd3.getDepth()) < 0.0099)) continue;
            found = true;
            if (baseShift != null) {
                if (!((double)Math.abs(baseShift.floatValue() - csd3.getShift()) > 0.001)) continue;
                csd3.setShift(baseShift.floatValue());
                this.isDirty = true;
                break;
            }
            it.remove();
            this.isDirty = true;
            break;
        }
        if (!found && baseShift != null) {
            it = listCopy.listIterator();
            int insertPos = 0;
            while (it.hasNext() && !(baseDepth - 0.01 < (csd2 = (CoreShiftDepth)it.next()).getDepth())) {
                ++insertPos;
            }
            listCopy.add(insertPos, new CoreShiftDepth(baseDepth - 0.01, baseShift.floatValue()));
            this.isDirty = true;
        }
        found = false;
        it = listCopy.listIterator(listCopy.size());
        while (it.hasPrevious()) {
            csd3 = (CoreShiftDepth)it.previous();
            if (!(Math.abs(topDepth - csd3.getDepth()) < 0.0099)) continue;
            found = true;
            if (topShift != null) {
                if (!((double)Math.abs(topShift.floatValue() - csd3.getShift()) > 0.001)) continue;
                csd3.setShift(topShift.floatValue());
                this.isDirty = true;
                break;
            }
            it.remove();
            this.isDirty = true;
            break;
        }
        if (!found && topShift != null) {
            it = listCopy.listIterator();
            int insertPos = 0;
            while (it.hasNext() && !(topDepth < (csd2 = (CoreShiftDepth)it.next()).getDepth())) {
                ++insertPos;
            }
            listCopy.add(insertPos, new CoreShiftDepth(topDepth, topShift.floatValue()));
            this.isDirty = true;
        }
        listCopy.forEach(csd -> System.out.println("CoreShift after: " + csd.getDepth() + " / " + csd.getShift()));
        if (this.isDirty) {
            this.list = new CoreShift();
            listCopy.forEach(csd -> this.list.add(csd));
            this.store(wellID);
        }
    }

    private void load(int wellID) throws SQLException {
        if (this.list == null) {
            this.list = new CoreShift();
            if (this.db != null && this.db.isConnected()) {
                String sql = "SELECT depth, shift FROM " + this.db.DBTableName("CORESHIFT") + " WHERE well_id=" + wellID + " ORDER BY depth";
                try (Statement stmt = this.db.getDatabase().createStatement();){
                    ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
                    while (rs.next()) {
                        double depth = rs.getDouble("depth");
                        float shift = rs.getFloat("shift");
                        this.list.add(new CoreShiftDepth(depth, shift));
                    }
                }
                this.isDirty = false;
            }
        }
    }

    public Iterator<CoreShiftDepth> iterator() {
        return this.list.iterator();
    }

    public void add(int wellID, double depth, float shift) throws SQLException {
        if (this.list == null) {
            this.load(wellID);
        }
        boolean found = false;
        int pos = 0;
        for (CoreShiftDepth shiftDepth : this.list) {
            if (Math.abs(shiftDepth.getDepth() - depth) < (double)0.0029f) {
                shiftDepth.setShift(shift);
                this.isDirty = true;
                found = true;
                break;
            }
            if (depth < shiftDepth.getDepth()) break;
            ++pos;
        }
        if (!found) {
            CoreShiftDepth d = new CoreShiftDepth(depth, shift);
            this.list.add(pos, d);
            this.isDirty = true;
        }
    }

    public void store(int wellID) throws SQLException {
        if (this.isDirty) {
            this.deleteAll(wellID);
            String sql = "INSERT INTO " + this.db.DBTableName("CORESHIFT") + "(well_id,depth,shift) VALUES (" + wellID + ",?,?)";
            try (PreparedStatement pstmt = this.db.getDatabase().prepareStatement(this.db.modQuery(sql));){
                for (CoreShiftDepth shiftDepth : this.list) {
                    pstmt.setDouble(1, shiftDepth.getDepth());
                    pstmt.setFloat(2, shiftDepth.getShift());
                    pstmt.executeUpdate();
                }
            }
            this.isDirty = false;
        }
    }

    private void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.db.DBTableName("CORESHIFT") + " WHERE well_id=" + wellID;
        try (Statement stmt = this.db.getDatabase().createStatement();){
            stmt.executeUpdate(this.db.modQuery(sql));
        }
    }

    double getCorrectedDepth(double depth) {
        return this.list.getCorrectedDepth(depth);
    }

    public double getShift(double depth) {
        return this.list.getShift(depth);
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        Iterator it = this.list.iterator();
        if (it.hasNext()) {
            out.write((String)ind + "<CoreShift>\n");
            while (it.hasNext()) {
                out.write((String)ind + "<CoreShiftDepth>\n");
                CoreShiftDepth coreShiftDepth = (CoreShiftDepth)it.next();
                String ddepth = SB.getDepthString((double)coreShiftDepth.getDepth(), (char)units, (int)2).trim();
                String shift = SB.getDepthString((double)coreShiftDepth.getShift(), (char)units, (int)2).trim();
                if (ddepth != null && ddepth.length() > 0) {
                    out.write((String)ind + (String)ind + "<Depth>" + ddepth + "</Depth>\n");
                }
                if (shift != null && shift.length() > 0) {
                    out.write((String)ind + (String)ind + "<Shift>" + shift + "</Shift>\n");
                }
                out.write((String)ind + "</CoreShiftDepth>\n");
            }
            out.write("</CoreShift>\n");
        }
    }

    public boolean hasShifts() {
        if (this.list == null) {
            return false;
        }
        return this.list.size() > 0;
    }
}

