/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.SBEvent;
import model3.SBdb;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class EventXLSReader {
    private final SBdb ws;
    private final Workbook wb;
    private String top;
    private String base;
    private final String name;
    private final List<Event> events = new LinkedList<Event>();
    private short eventTypeColumn = (short)-1;
    private static final Logger LOGGER = Logger.getLogger(EventXLSReader.class.getName());
    final int COL_AGE = 0;
    final int COL_TOP = 2;
    final int COL_BASE = 3;
    final int COL_SPORADIC = 4;
    final int COL_PRESENT = 5;
    final int COL_COMMON = 6;
    final int COL_FREQUENT = 7;
    final int COL_ABUNDANT = 8;
    final int COL_SP = 9;
    final int COL_DC = 10;
    final int COL_TAXON = 11;
    final int COL_AUTHOR = 12;

    public EventXLSReader(SBdb ws, File file) throws IOException, InvalidFormatException {
        this.ws = ws;
        try (FileInputStream is = new FileInputStream(file);){
            this.wb = WorkbookFactory.create((InputStream)is);
        }
        for (int j = 0; j < this.wb.getNumberOfSheets(); ++j) {
            Sheet sheet = this.wb.getSheetAt(j);
            System.out.println("Contains sheet: " + this.wb.getSheetName(j) + "/" + sheet.getSheetName() + "\n");
        }
        String n = file.getName();
        if (n.lastIndexOf(46) > 1) {
            n = n.substring(0, n.lastIndexOf(46));
        }
        this.name = n;
    }

    public List<String> scanPrefixes(List<String> ignoredColumns) {
        Sheet sheet = this.wb.getSheetAt(0);
        short nameCell = 0;
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + String.valueOf(this.ws));
            return null;
        }
        for (short cellNum = titleRow.getFirstCellNum(); cellNum < titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            String colName = cell.getStringCellValue();
            try {
                EvXLSColumn column = EvXLSColumn.getColumnType(colName);
                if (column.equals((Object)EvXLSColumn.TYPE)) {
                    this.eventTypeColumn = cellNum;
                    continue;
                }
                if (!column.equals((Object)EvXLSColumn.EVENT)) continue;
                nameCell = cellNum;
                continue;
            }
            catch (IllegalStateException ex) {
                ignoredColumns.add(colName);
            }
        }
        LinkedList<String> prefixes = new LinkedList<String>();
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            String cellString;
            Cell cell;
            Row row = sheet.getRow(nRow);
            if (row == null || (cell = row.getCell((int)(this.eventTypeColumn < 0 ? nameCell : this.eventTypeColumn))) == null || cell.getCellType() != CellType.STRING && cell.getCellType() != CellType.FORMULA || (cellString = cell.getStringCellValue()) == null) continue;
            cellString = cellString.trim();
            if (this.eventTypeColumn < 0) {
                String[] eventNames;
                for (String eventName : eventNames = cellString.split(",")) {
                    String[] words;
                    if ((eventName = eventName.trim()).isEmpty() || (words = eventName.split(" ")).length <= 1 || prefixes.contains(words[0].toUpperCase())) continue;
                    prefixes.add(words[0].toUpperCase());
                }
                continue;
            }
            if (prefixes.contains(cellString)) continue;
            prefixes.add(cellString);
        }
        return prefixes;
    }

    public void getEvents(SBdb ws) throws SQLException, SBException {
        Sheet sheet = this.wb.getSheetAt(0);
        String[] columns = new String[20];
        Row titleRow = sheet.getRow(0);
        if (titleRow == null) {
            System.out.println("column titles null for sheet: " + String.valueOf(ws));
            return;
        }
        for (short cellNum = titleRow.getFirstCellNum(); cellNum < titleRow.getLastCellNum(); cellNum = (short)(cellNum + 1)) {
            Cell cell = titleRow.getCell((int)cellNum);
            if (cellNum >= columns.length) {
                System.out.println("CellNumber: " + cellNum + " exceeds column title length!");
            }
            if (cell == null) {
                System.out.println("Can't get cell for cellNum: " + cellNum);
                continue;
            }
            columns[cellNum] = cell.getStringCellValue();
        }
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            LinkedList<Event> toAddSingle = new LinkedList<Event>();
            LinkedList<Event> toAddTop = new LinkedList<Event>();
            LinkedList<Event> toAddBase = new LinkedList<Event>();
            Double age = null;
            Double errMinus = null;
            Double errPlus = null;
            String desc = null;
            String comment = null;
            EventType eventType = null;
            String[] eventNames = null;
            Confidence conf = Confidence.CONFIDENT;
            for (short cellNum = row.getFirstCellNum(); cellNum < columns.length; cellNum = (short)(cellNum + 1)) {
                Cell cell = row.getCell((int)cellNum);
                if (cell == null || cell.toString().isEmpty()) continue;
                try {
                    EvXLSColumn type = EvXLSColumn.getColumnType(columns[cellNum]);
                    switch (type.ordinal()) {
                        case 1: {
                            String cellTypeString = cell.getStringCellValue().trim();
                            if (cellTypeString == null) break;
                            if (this.top != null && cellTypeString.trim().equalsIgnoreCase(this.top)) {
                                eventType = EventType.TOP;
                                break;
                            }
                            if (this.base != null && cellTypeString.trim().equalsIgnoreCase(this.base)) {
                                eventType = EventType.BASE;
                                break;
                            }
                            eventType = EventType.SINGLE;
                            break;
                        }
                        case 0: {
                            String cellString = cell.getStringCellValue().trim();
                            if (cellString == null) break;
                            eventNames = cellString.split(",");
                            break;
                        }
                        case 4: {
                            age = this.readCellValueAsNumeric(cell);
                            if (age == null) {
                                throw new SBException("Can't read Age from cell contents '" + cell.toString() + "' at row number: " + nRow);
                            }
                            age = SB.round((double)age, (int)6);
                            break;
                        }
                        case 5: {
                            errMinus = this.readCellValueAsNumeric(cell);
                            if (errMinus == null) {
                                throw new SBException("Can't read negative error value from cell contents '" + cell.toString() + "' at row number: " + nRow);
                            }
                            errMinus = SB.round((double)errMinus, (int)6);
                            break;
                        }
                        case 6: {
                            errPlus = this.readCellValueAsNumeric(cell);
                            if (errPlus == null) {
                                throw new SBException("Can't read positive error value from cell contents '" + cell.toString() + "' at row number: " + nRow);
                            }
                            errPlus = SB.round((double)errPlus, (int)6);
                            break;
                        }
                        case 3: {
                            desc = cell.getStringCellValue();
                            break;
                        }
                        case 9: {
                            comment = cell.getStringCellValue();
                            break;
                        }
                        case 8: {
                            Object confString = cell.getStringCellValue();
                            if (((String)confString).length() > 1) {
                                confString = ((String)confString).substring(0, 1).toUpperCase() + ((String)confString).substring(1).toLowerCase();
                                conf = Confidence.getConfidence((String)confString);
                            } else {
                                break;
                            }
                        }
                    }
                    continue;
                }
                catch (IllegalStateException ex) {
                    LOGGER.log(Level.INFO, "Error creating cmpstd event", ex);
                }
            }
            if (eventNames != null) {
                block21: for (String eventName : eventNames) {
                    if ((eventName = eventName.trim()).isEmpty()) continue;
                    if (this.eventTypeColumn < 0) {
                        if (this.top != null && eventName.toUpperCase().startsWith(this.top + " ")) {
                            eventName = eventName.substring(this.top.length() + 1).trim();
                            eventType = EventType.TOP;
                        } else if (this.base != null && eventName.toUpperCase().startsWith(this.base + " ")) {
                            eventName = eventName.substring(this.base.length() + 1).trim();
                            eventType = EventType.BASE;
                        } else {
                            eventType = EventType.SINGLE;
                        }
                    }
                    Event rowEvent = null;
                    for (Event event : this.events) {
                        if (!event.eventBuilder.getName().equals(eventName)) continue;
                        event.eventBuilder.setUpType(eventType, true, null, null);
                        rowEvent = event;
                        break;
                    }
                    if (rowEvent == null) {
                        rowEvent = new Event();
                        rowEvent.name = eventName;
                        rowEvent.eventBuilder = new SBEvent.Builder().name(eventName).isGenerate(eventType != EventType.SINGLE);
                        for (EventType type : EventType.values()) {
                            rowEvent.eventBuilder.setUpType(type, false, null, null);
                        }
                        rowEvent.eventBuilder.setUpType(eventType, true, null, null);
                        rowEvent.conf = Confidence.CONFIDENT;
                        this.events.add(rowEvent);
                    }
                    switch (eventType) {
                        case BASE: {
                            toAddBase.add(rowEvent);
                            continue block21;
                        }
                        case TOP: {
                            toAddTop.add(rowEvent);
                            continue block21;
                        }
                        default: {
                            toAddSingle.add(rowEvent);
                        }
                    }
                }
            }
            for (Event rowEvent : toAddTop) {
                if (age != null) {
                    rowEvent.top = age;
                }
                if (errMinus != null) {
                    rowEvent.topErrMinus = errMinus;
                }
                if (errPlus == null) continue;
                rowEvent.topErrPlus = errPlus;
            }
            for (Event rowEvent : toAddBase) {
                if (age != null) {
                    rowEvent.base = age;
                }
                if (errMinus != null) {
                    rowEvent.baseErrMinus = errMinus;
                }
                if (errPlus == null) continue;
                rowEvent.baseErrPlus = errPlus;
            }
            for (Event rowEvent : toAddSingle) {
                if (age != null) {
                    rowEvent.single = age;
                }
                if (errMinus != null) {
                    rowEvent.baseErrMinus = errMinus;
                    rowEvent.topErrMinus = errMinus;
                }
                if (errPlus == null) continue;
                rowEvent.baseErrPlus = errPlus;
                rowEvent.topErrPlus = errPlus;
            }
            for (Event rowEvent : toAddTop) {
                if (desc != null && !desc.isEmpty()) {
                    rowEvent.eventBuilder.desc(desc);
                }
                if (comment != null && !comment.isEmpty()) {
                    rowEvent.topComment = comment;
                }
                rowEvent.conf = conf;
            }
            for (Event rowEvent : toAddBase) {
                if (desc != null && !desc.isEmpty()) {
                    rowEvent.eventBuilder.desc(desc);
                }
                if (comment != null && !comment.isEmpty()) {
                    rowEvent.baseComment = comment;
                }
                rowEvent.conf = conf;
            }
            for (Event rowEvent : toAddSingle) {
                if (desc != null && !desc.isEmpty()) {
                    rowEvent.eventBuilder.desc(desc);
                }
                if (comment != null && !comment.isEmpty()) {
                    rowEvent.singleComment = comment;
                }
                rowEvent.conf = conf;
            }
        }
        try {
            for (Event event : this.events) {
                event.wsEvent = ws.addSBEvent(event.eventBuilder);
            }
        }
        catch (SBPermissionException pe) {
            LOGGER.log(Level.WARNING, "Permission error adding events to cmpstd", pe);
        }
    }

    private Double readCellValueAsNumeric(Cell cell) {
        Double value;
        if (cell.getCellType() == CellType.NUMERIC) {
            value = cell.getNumericCellValue();
        } else {
            String stringValue = cell.toString();
            try {
                value = Double.valueOf(stringValue.trim());
            }
            catch (NumberFormatException pe) {
                value = null;
            }
        }
        return value;
    }

    public void getBujakEvents(SBdb ws) throws SQLException, SBException {
        Sheet sheet = this.wb.getSheetAt(0);
        for (int nRow = 1; nRow <= sheet.getLastRowNum(); ++nRow) {
            boolean isTop;
            Cell cell;
            Row row = sheet.getRow(nRow);
            if (row == null || (cell = row.getCell(0)) == null) continue;
            Double age = cell != null && cell.getCellType() == CellType.NUMERIC ? Double.valueOf(cell.getNumericCellValue()) : Double.valueOf(cell.getStringCellValue());
            age = SB.round((double)age, (int)6);
            cell = row.getCell(11);
            String cellString = cell.getStringCellValue().trim();
            if (cellString == null) continue;
            String[] eventType = new String[2];
            for (int col = 2; col <= 3; ++col) {
                cell = row.getCell(col);
                if (cell == null || cell.getStringCellValue() == null || cell.getStringCellValue().trim().isEmpty()) continue;
                eventType[col - 2] = cell.getStringCellValue();
            }
            String abundSuffix = "";
            Confidence conf = Confidence.CONFIDENT;
            block11: for (int col = 4; col <= 8; ++col) {
                cell = row.getCell(col);
                if (cell == null || cell.getStringCellValue() == null || !cell.getStringCellValue().toLowerCase().equals("x")) continue;
                switch (col) {
                    case 4: {
                        abundSuffix = "[S]";
                        conf = Confidence.POSSIBLE;
                        continue block11;
                    }
                    case 5: {
                        continue block11;
                    }
                    case 6: {
                        abundSuffix = "[C]";
                        continue block11;
                    }
                    case 7: {
                        abundSuffix = "[F]";
                        continue block11;
                    }
                    case 8: {
                        abundSuffix = "[A]";
                    }
                }
            }
            if (eventType[0] != null && eventType[0].toLowerCase().startsWith("x")) {
                isTop = true;
            } else if (eventType[1] != null && eventType[1].toLowerCase().startsWith("x")) {
                isTop = false;
            } else {
                System.out.println("Ambiguous event type for taxon: " + cellString);
                continue;
            }
            String eventName = cellString + (abundSuffix.length() > 0 ? " " : "") + abundSuffix;
            String eventDesc = "";
            cell = row.getCell(12);
            if (cell != null && cell.getCellType() == CellType.NUMERIC) {
                eventDesc = cell.getStringCellValue();
            }
            Event rowEvent = null;
            for (Event event : this.events) {
                if (!event.name.equals(eventName)) continue;
                rowEvent = event;
                break;
            }
            if (rowEvent == null) {
                rowEvent = new Event();
                rowEvent.name = eventName;
                rowEvent.eventBuilder = new SBEvent.Builder().name(eventName).isGenerate(true).desc(eventDesc);
                rowEvent.conf = conf;
                this.events.add(rowEvent);
            }
            if (isTop) {
                rowEvent.top = age;
                rowEvent.eventBuilder.setUpType(EventType.TOP, true, null, null);
                continue;
            }
            rowEvent.base = age;
            rowEvent.eventBuilder.setUpType(EventType.BASE, true, null, null);
        }
        try {
            for (Event event : this.events) {
                event.wsEvent = ws.addSBEvent(event.eventBuilder);
            }
        }
        catch (SBPermissionException pe) {
            LOGGER.log(Level.WARNING, "Permission error adding events to workspace", pe);
        }
    }

    public CompositeStandard getCompositeStandard(List<SBException> exceptions) throws SBException, SQLException {
        LinkedList<CompositeStandardEvent.Builder> builders = new LinkedList<CompositeStandardEvent.Builder>();
        Double minAge = null;
        Double maxAge = null;
        for (Event event : this.events) {
            Double[] eventAges;
            CompositeStandardEvent.Builder builder;
            if (event.wsEvent == null || event.wsEvent.getLink() == null) continue;
            if (event.top != null) {
                builder = new CompositeStandardEvent.Builder().event(event.wsEvent);
                builder.type(EventType.TOP);
                builder.csu(event.top);
                builder.confidence(event.conf);
                builder.errMinus(event.topErrMinus);
                builder.errPlus(event.topErrPlus);
                builder.comment(event.topComment);
                builders.add(builder);
            }
            if (event.base != null) {
                builder = new CompositeStandardEvent.Builder().event(event.wsEvent);
                builder.type(EventType.BASE);
                builder.csu(event.base);
                builder.errPlus(event.baseErrPlus);
                builder.errMinus(event.baseErrMinus);
                builder.comment(event.baseComment);
                builder.confidence(event.conf);
                builders.add(builder);
            }
            if (event.single != null) {
                builder = new CompositeStandardEvent.Builder().event(event.wsEvent);
                builder.type(EventType.SINGLE);
                builder.csu(event.single);
                builder.errMinus(event.topErrMinus);
                builder.errPlus(event.topErrPlus);
                builder.confidence(event.conf);
                builder.comment(event.singleComment);
                builders.add(builder);
            }
            Double[] doubleArray = new Double[2];
            Double d = event.top != null ? Double.valueOf(event.top - (event.topErrMinus != null ? event.topErrMinus : 0.0)) : (doubleArray[0] = null);
            doubleArray[1] = event.base != null ? Double.valueOf(event.base + (event.baseErrPlus != null ? event.baseErrPlus : 0.0)) : null;
            for (Double age : eventAges = doubleArray) {
                if (age == null) continue;
                if (minAge == null || age < minAge) {
                    minAge = age;
                }
                if (maxAge != null && !(age > maxAge)) continue;
                maxAge = age;
            }
        }
        if (minAge == null) {
            minAge = 0.0;
        }
        if (maxAge == null) {
            maxAge = 0.0;
        }
        try {
            return this.ws.addCompositeStandard(this.name, minAge, maxAge, maxAge, maxAge, true, builders, null, 0, null);
        }
        catch (InvalidFieldException | SBPermissionException e) {
            exceptions.add(new SBException(e.getMessage()));
            return null;
        }
    }

    public void setPrefixes(String top, String base) {
        this.top = top;
        this.base = base;
    }

    private static enum EvXLSColumn {
        EVENT(new String[]{"EVENT", "NAME"}),
        TYPE(new String[]{"TYPE", "EVENTTYPE"}),
        GENERATE(new String[]{"GENERATE"}),
        DESC(new String[]{"DESC"}),
        AGE(new String[]{"AGE", "CSU"}),
        AGEERRMINUS(new String[]{"MINUS", "CSUMINUS", "AGEMINUS"}),
        AGEERRPLUS(new String[]{"PLUS", "CSUPLUS", "AGEPLUS"}),
        NULLCOLUMN(new String[]{"XXXXXXXXXXXXXXXXXXX"}),
        CONFIDENCE(new String[]{"CONFIDENCE"}),
        COMMENT(new String[]{"COMMENTS", "COMMENT"});

        private final String[] titles;

        private EvXLSColumn(String[] titles) {
            this.titles = titles;
        }

        static EvXLSColumn getColumnType(String title) {
            if (title == null || title.trim().isEmpty()) {
                return NULLCOLUMN;
            }
            title = title.toUpperCase().trim();
            for (EvXLSColumn col : EvXLSColumn.values()) {
                for (String title1 : col.titles) {
                    if (!title.equals(title1)) continue;
                    return col;
                }
            }
            throw new IllegalStateException("Unrecognised column title: " + title);
        }
    }

    private static class Event {
        String name;
        SBEvent wsEvent;
        SBEvent.Builder eventBuilder;
        Double top;
        Double topErrMinus;
        Double topErrPlus;
        String topComment;
        Double base;
        Double baseErrMinus;
        Double baseErrPlus;
        String baseComment;
        Double single;
        String singleComment;
        Confidence conf;

        private Event() {
        }
    }
}

