/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.audit.AuditImpl;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Qualifier;
import com.stratadata.model3.taxon.SearchMode;
import com.stratadata.model3.taxon.TaxonQual;
import com.stratadata.model3.user.UserService;
import com.stratadata.util.process.ProgressMonitor;
import java.awt.Color;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import model3.Audit;
import model3.Category;
import model3.SBdb;
import model3.taxa.GenusListener;
import model3.taxa.GenusUpdatePublisher;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SbugsLink;
import util.SortEntry;
import util.exception.StackError;
import util.status.SbugsStatus;

public class Genus
implements Comparable<Genus>,
SortEntry,
SbugsLink,
SbugsStatus,
Category.CategoryListener {
    private final com.stratadata.model3.taxon.Genus genus;
    private Genus link;
    private final GenusUpdatePublisher updatePublisher = new GenusUpdatePublisher(this);

    public void registerListener(GenusListener listener) {
        this.updatePublisher.registerListener(listener);
    }

    public void deleteListener(GenusListener listener) {
        this.updatePublisher.deleteListener(listener);
    }

    public void notifyListeners() {
        this.updatePublisher.notifyListeners();
    }

    void setNotifySpeciesAdded(int specID) {
        this.updatePublisher.speciesAdded(specID);
    }

    void setNotifySpeciesRemoved(int specID) {
        this.updatePublisher.speciesRemoved(specID);
    }

    void setNotifyDeleted() {
        this.updatePublisher.setGenusDeleted();
    }

    public String getGenus() {
        return this.genus.getGenusName();
    }

    public String getSubGenus() {
        return this.genus.getSubGenus();
    }

    public com.stratadata.model3.taxon.Genus getGenusCopy() {
        return com.stratadata.model3.taxon.Genus.copy((com.stratadata.model3.taxon.Genus)this.genus);
    }

    public Category getCategory() {
        if (this.genus.getCategory() == null) {
            return null;
        }
        return Category.copy((Category)this.genus.getCategory());
    }

    public String getCategoryMnemonic() {
        if (this.genus.getCategory() == null) {
            return "";
        }
        return this.genus.getCategory().getMnemonic();
    }

    public Qualifier getQ1() {
        return this.genus.getQ1();
    }

    public Qualifier getQ2() {
        return this.genus.getQ2();
    }

    public Qualifier getQ3() {
        return this.genus.getQ3();
    }

    public Qualifier getQ4() {
        return this.genus.getQ4();
    }

    Discipline getDisc() {
        return this.genus.getCategory().getDiscipline();
    }

    public Color getColour() {
        return this.genus.getColour();
    }

    public int getGenID() {
        return this.genus.getGenID();
    }

    Date getUpdated() {
        return Date.from(this.genus.getAudit().getUpdated());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCat) {
        return this.toString(includeCat, null);
    }

    String toString(boolean includeCat, List<Integer> italics) {
        return this.genus.toString(includeCat, italics);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean includeCat) {
        return this.genus.toAttributedString(useItalics, includeCat);
    }

    public void setLink(Genus link) {
        this.link = link;
    }

    public Genus getLink() {
        return this.link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Genus load(SBdb sbdb, int genID, Statement statement, Genus genus) throws SQLException {
        if (genus != null && genus.getGenID() != genID) {
            throw new IllegalArgumentException("Attempt to refresh genus with incorrect ID");
        }
        Object query = "SELECT gen_id,cat_mnem,genus,sub_genus,q1,q2,q3,q4,colour," + Audit.sqlFieldString();
        query = (String)query + " FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + genID;
        query = sbdb.modQuery((String)query);
        Statement stmt = statement != null ? statement : sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery((String)query);
            if (rs.next()) {
                Builder builder = Genus.getBuilderFromResultSet(rs, sbdb.getCategoryService());
                if (genus == null) {
                    Genus genus2 = builder.build(genID, sbdb.getCategoryService());
                    return genus2;
                }
                com.stratadata.model3.taxon.Genus.copyFields((com.stratadata.model3.taxon.Genus)genus.genus, (com.stratadata.model3.taxon.Genus)builder.genus);
                genus.updatePublisher.setGenusDetailsUpdated();
                Genus genus3 = genus;
                return genus3;
            }
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        return null;
    }

    static Genus[] load(SBdb sbdb, String cat_mnem, String genus, String subGenus, Qualifier gq1, Qualifier gq2, Qualifier gq3, Qualifier gq4) throws SQLException {
        List<Genus> genera;
        String sql = "SELECT cat_mnem, gen_id, genus, sub_genus, q1, q2, q3, q4,colour," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GENUS") + " WHERE ";
        if (cat_mnem != null) {
            sql = sql + "cat_mnem='" + cat_mnem + "' AND ";
        }
        sql = sql + " ucase(genus)=" + SB.DBString((String)genus.toUpperCase());
        if (gq1 != null) {
            sql = gq1.hasQuals() ? sql + " AND lcase(q1)='" + String.valueOf(gq1) + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (gq2 != null) {
            sql = gq2.hasQuals() ? sql + " AND lcase(q2)='" + String.valueOf(gq2) + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (gq3 != null) {
            sql = gq3.hasQuals() ? sql + " AND lcase(q3)='" + String.valueOf(gq3) + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subGenus != null) {
            sql = !subGenus.isEmpty() ? sql + " AND ucase(sub_genus)=" + SB.DBString((String)subGenus.toUpperCase()) : sql + " AND (sub_genus IS NULL or sub_genus='')";
        }
        if (gq4 != null) {
            sql = gq4.hasQuals() ? sql + " AND lcase(q4)='" + String.valueOf(gq4) + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            genera = Genus.getGeneraFromResultSet(rs, sbdb.getCategoryService());
        }
        if (!genera.isEmpty()) {
            return genera.toArray(new Genus[genera.size()]);
        }
        return null;
    }

    static String[] getSelectColumns() {
        return new String[]{"cat_mnem", "gen_id", "genus", "sub_genus", "q1", "q2", "q3", "q4", "colour", "creator", "created", "modifier", "modified", "updater", "updated"};
    }

    static List<String> getSearchQueryConditions(com.stratadata.model3.taxon.Genus g, SearchMode searchMode) {
        BiFunction<String, String, String> queryFunction = switch (searchMode) {
            default -> throw new MatchException(null, null);
            case SearchMode.LOOKUP -> (columnName, s) -> "lcase(" + columnName + ")=lcase(" + SB.DBString((String)s) + ")";
            case SearchMode.SEARCH -> (columnName, s) -> "lcase(" + columnName + ") like lcase(" + SB.DBString((String)s) + ")";
            case SearchMode.SOUNDEX -> (columnName, s) -> "upper(soundex(" + columnName + "))=soundex('" + s.replaceAll("%", "") + "')";
        };
        Predicate<String> useField = fieldValue -> !fieldValue.isEmpty() && !"%".equals(fieldValue);
        LinkedList<String> conditions = new LinkedList<String>();
        if (g.getCategory() != null && searchMode != SearchMode.SOUNDEX) {
            conditions.add(queryFunction.apply("g.cat_mnem", g.getCategory().getMnemonic() + (searchMode == SearchMode.SEARCH ? "%" : "")));
        }
        if (useField.test(g.getGenusName())) {
            conditions.add(queryFunction.apply("genus", g.getGenusName()));
        }
        if (useField.test(g.getSubGenus())) {
            conditions.add(queryFunction.apply("sub_genus", g.getSubGenus()));
        } else if (searchMode == SearchMode.LOOKUP) {
            conditions.add("(sub_genus IS NULL or sub_genus='')");
        }
        for (int i = 0; i < 4; ++i) {
            if (g.getQualifier(i).hasQuals()) {
                if (searchMode == SearchMode.LOOKUP) {
                    conditions.add("lcase(g.q" + (i + 1) + ")='" + g.getQualifier(i).toString(false) + "'");
                    continue;
                }
                conditions.add("lcase(g.q" + (i + 1) + ") like '%" + g.getQualifier(i).toString(false) + "%'");
                continue;
            }
            if (searchMode != SearchMode.LOOKUP) continue;
            conditions.add("(g.q" + (i + 1) + " IS NULL or g.q" + (i + 1) + "='')");
        }
        return conditions;
    }

    private static Builder getBuilderFromResultSet(ResultSet rs, CategoryService categoryService) throws SQLException {
        int genID = rs.getInt("gen_id");
        AuditImpl audit = Audit.getAuditFromResultSet(rs);
        com.stratadata.model3.taxon.Genus dGen = new com.stratadata.model3.taxon.Genus(genID, audit);
        dGen.setCategory((Category)categoryService.findCategory(rs.getString("cat_mnem")).get());
        dGen.setGenusName(rs.getString("genus"));
        dGen.setSubGenus(rs.getString("sub_genus"));
        for (int i = 0; i < 4; ++i) {
            dGen.setQualifier(i, new Qualifier(i, rs.getString("q" + (i + 1))));
        }
        dGen.setColour(ColourUtils.getDBColour((String)rs.getString("colour")));
        Builder builder = new Builder(dGen);
        return builder;
    }

    static Builder getBuilderFromResultSet(ResultSet rs, int genID, CategoryService categoryService) throws SQLException {
        AuditImpl audit = Audit.getAuditFromResultSet(rs, "g_");
        com.stratadata.model3.taxon.Genus dGen = new com.stratadata.model3.taxon.Genus(genID, audit);
        dGen.setCategory((Category)categoryService.findCategory(rs.getString("g_cat_mnem")).get());
        dGen.setGenusName(rs.getString("g_genus"));
        dGen.setSubGenus(rs.getString("g_sub_genus"));
        for (int i = 0; i < 4; ++i) {
            dGen.setQualifier(i, new Qualifier(i, rs.getString("g_q" + (i + 1))));
        }
        dGen.setColour(ColourUtils.getDBColour((String)rs.getString("g_colour")));
        Builder builder = new Builder(dGen);
        return builder;
    }

    private static List<Genus> getGeneraFromResultSet(ResultSet rs, CategoryService categoryService) throws SQLException {
        LinkedList<Genus> genera = new LinkedList<Genus>();
        while (rs.next()) {
            Builder builder = Genus.getBuilderFromResultSet(rs, categoryService);
            genera.add(builder.build(builder.genus.getGenID(), categoryService));
        }
        return genera;
    }

    public static void loadAll(SBdb sbdb, Map<Integer, Genus> map) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT gen_id,cat_mnem,genus,sub_genus,q1,q2,q3,q4,colour," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("genus");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Builder builder = Genus.getBuilderFromResultSet(rs, sbdb.getCategoryService());
                int genID = builder.genus.getGenID();
                try {
                    map.put(genID, builder.build(genID, sbdb.getCategoryService()));
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Throwable)re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkNSpecies(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) AS nspecies FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + this.getGenID();
        int nSpecies = 0;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                nSpecies = rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(SBdb sbdb) throws SQLException {
        if (!sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store workspace Genus");
        }
        if (this.getGenID() < 1) {
            throw new IllegalStateException("Attempt to store genus with illegal ID: " + this.getGenID());
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        this.genus.updateAudit((UserService)sbdb, Audit.getDatabaseServerDate(sbdb, stmt).toInstant());
        String sql = "INSERT INTO " + sbdb.DBTableName("GENUS") + " ( cat_mnem, gen_id, genus";
        if (this.genus.getQ1().hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.genus.getQ2().hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.genus.getQ3().hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.genus.getSubGenus().isEmpty()) {
            sql = sql + ",sub_genus";
        }
        if (this.genus.getQ4().hasQuals()) {
            sql = sql + ",q4";
        }
        sql = sql + ",colour";
        sql = sql + "," + Audit.sqlFieldString() + ") VALUES ('" + this.genus.getCategory().getMnemonic() + "'," + this.genus.getGenID() + "," + SB.DBString((String)this.genus.getGenusName());
        if (this.genus.getQ1().hasQuals()) {
            sql = sql + ",'" + this.genus.getQ1().toString(false) + "'";
        }
        if (this.genus.getQ2().hasQuals()) {
            sql = sql + ",'" + this.genus.getQ2().toString(false) + "'";
        }
        if (this.genus.getQ3().hasQuals()) {
            sql = sql + ",'" + this.genus.getQ3().toString(false) + "'";
        }
        if (!this.genus.getSubGenus().isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.genus.getSubGenus());
        }
        if (this.genus.getQ4().hasQuals()) {
            sql = sql + ",'" + this.genus.getQ4().toString(false) + "'";
        }
        sql = sql + "," + ColourUtils.DBColourString((Color)this.genus.getColour(), (boolean)false, (boolean)true);
        sql = sql + "," + Audit.sqlInsert(this.genus.getAudit()) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateColour(SBdb sbdb, Color colour) throws SQLException {
        if (colour == null) {
            throw new IllegalArgumentException("Cannot set Genus colour to null");
        }
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + sbdb.DBTableName("GENUS") + " SET colour=" + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true) + " WHERE gen_id=" + this.getGenID();
            try {
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        this.genus.setColour(colour);
        this.updatePublisher.setGenusDetailsUpdated();
    }

    void update(SBdb sbdb, com.stratadata.model3.taxon.Genus genus) throws SQLException {
        if (sbdb.isConnected()) {
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                genus.updateAudit(this.genus.getAudit(), (UserService)sbdb, Audit.getDatabaseServerDate(sbdb, stmt).toInstant());
                String sql = "UPDATE " + sbdb.DBTableName("GENUS") + " SET cat_mnem=" + SB.DBString((String)genus.getCategory().getMnemonic()) + ",genus=" + SB.DBString((String)genus.getGenusName()) + ",q1=" + SB.DBString((String)genus.getQ1().toString(false)) + ",q2=" + SB.DBString((String)genus.getQ2().toString(false)) + ",q3=" + SB.DBString((String)genus.getQ3().toString(false)) + ",q4=" + SB.DBString((String)genus.getQ4().toString(false)) + ",colour=" + ColourUtils.DBColourString((Color)genus.getColour(), (boolean)false, (boolean)true) + ",sub_genus=" + SB.DBString((String)genus.getSubGenus()) + "," + Audit.sqlUpdate(genus.getAudit()) + " WHERE gen_id=" + this.getGenID();
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        }
        genus.setCategory((Category)sbdb.getCategoryService().findCategory(genus.getCategory().getMnemonic()).get());
        com.stratadata.model3.taxon.Genus.copyFields((com.stratadata.model3.taxon.Genus)this.genus, (com.stratadata.model3.taxon.Genus)genus);
        this.updatePublisher.setGenusDetailsUpdated();
    }

    boolean checkDelete(SBdb sbdb) throws SQLException, SBException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT COUNT(spec_id) as n_spec from " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=" + this.getGenID();
            int count = 0;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (!rs.next()) {
                throw new RuntimeException("Result set did not return any results");
            }
            count = rs.getInt("n_spec");
            if (count == 0) {
                sql = "SELECT COUNT(grp_id) as n_grp from " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=" + this.getGenID();
                rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next() && (count = rs.getInt("n_grp")) > 0) {
                    boolean bl = false;
                    return bl;
                }
                sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=" + this.getGenID();
                int updated = stmt.executeUpdate(sbdb.modQuery(sql));
                if (updated < 1) {
                    throw new SBException("No records updated in delete genus: " + this.genus.getGenusName());
                }
                this.updatePublisher.setGenusDeleted();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteGenera(SBdb sbdb, Set<Integer> genIDs, ProgressMonitor monitor) throws SQLException {
        int NSTATEMENTS = 3;
        PreparedStatement[] pStmt = new PreparedStatement[3];
        int n = 0;
        String sql = "SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "SELECT distinct grp_id FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        Iterator<Integer> it = genIDs.iterator();
        int i = 0;
        try {
            while (it.hasNext()) {
                int genID = it.next();
                boolean deleted = false;
                pStmt[0].setInt(1, genID);
                ResultSet rs = pStmt[0].executeQuery();
                if (!rs.next()) {
                    pStmt[1].setInt(1, genID);
                    rs = pStmt[1].executeQuery();
                    if (!rs.next()) {
                        pStmt[2].setInt(1, genID);
                        pStmt[2].executeUpdate();
                        deleted = true;
                    }
                }
                if (!deleted) {
                    it.remove();
                }
                if (monitor == null) continue;
                if (monitor.isInterrupted()) {
                    return;
                }
                monitor.setValue(i++);
            }
            return;
        }
        finally {
            n = 0;
            while (true) {
                if (n >= pStmt.length) {
                }
                pStmt[n].close();
                ++n;
            }
        }
    }

    public static int deleteUnusedGenera(SBdb sbdb) throws SQLException {
        int nRows;
        String sql = "DELETE FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + ")";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            System.out.println("Number of rows deleted from GROUPMBR_GENUS: " + nRows);
            sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + ")";
            nRows = stmt.executeUpdate(sbdb.modQuery(sql));
        }
        return nRows;
    }

    public boolean equalsBuilder(Builder builder, boolean ignoreCase) {
        return this.genus.equivalent(builder.genus, ignoreCase);
    }

    public boolean equals(Genus genus) {
        return this.genus.equals((Object)genus);
    }

    public int hashCode() {
        return this.genus.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Genus other = (Genus)obj;
        return this.genus.equals((Object)other.genus);
    }

    com.stratadata.model3.audit.Audit getAudit() {
        return this.genus.getAudit();
    }

    Qualifier getQualifier(int pos) {
        return this.genus.getQualifier(pos);
    }

    @Override
    public int compareTo(Genus o) {
        return this.genus.compareTo(o.genus);
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("   Category : " + this.genus.getCategory().getMnemonic() + eol);
        if (this.genus.getQ1().hasQuals()) {
            out.write("   Pre-Genus qualifier : " + this.genus.getQ1().toString(true) + eol);
        }
        out.write("   Genus : " + this.genus.getGenusName() + eol);
        if (this.genus.getQ2().hasQuals()) {
            out.write("   Post-Genus qualifier : " + this.genus.getQ2().toString(true) + eol);
        }
        if (this.genus.getQ3().hasQuals()) {
            out.write("   Pre-Subgenus qualifier : " + this.genus.getQ3().toString(true) + eol);
        }
        if (!this.genus.getSubGenus().isEmpty()) {
            out.write("   Subgenus : " + this.genus.getSubGenus() + eol);
        }
        if (this.genus.getQ4().hasQuals()) {
            out.write("   Post-Subgenus qualifier : " + this.genus.getQ4().toString(true) + eol);
        }
    }

    void clean(boolean convertCase, Category cat) {
        if (convertCase) {
            this.genus.setGenusName(com.stratadata.model3.taxon.Genus.toGenusCase((String)this.genus.getGenusName()));
            this.genus.setSubGenus(com.stratadata.model3.taxon.Genus.toGenusCase((String)this.genus.getSubGenus()));
        }
        this.genus.setCategory(cat);
        this.updatePublisher.setGenusDetailsUpdated();
        this.notifyListeners();
    }

    public static List<Genus> search(SBdb sbdb, String catMnem, boolean includeSubCategories, String genus, String subGenus) throws SQLException {
        ArrayList<Genus> list = new ArrayList<Genus>();
        String sql = "SELECT distinct gen_id FROM " + sbdb.DBTableName("GENUS") + " g ";
        String search = Genus.getSearchString(sbdb, null, catMnem, includeSubCategories, genus, subGenus);
        if (!search.isEmpty()) {
            sql = sql + " WHERE " + search;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(sbdb.getGenus(rs.getInt("gen_id")));
            }
        }
        return list;
    }

    static String getSearchString(SBdb db, Discipline disc, String catMnem, boolean includeSubCategories, String genus, String subGenus) {
        String text;
        Object sql = "";
        if (disc != null) {
            sql = (String)sql + "g.cat_mnem=c.cat_mnem AND c.disc_id='" + disc.getChar() + "' ";
        }
        if (catMnem.length() > 0) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = includeSubCategories ? (String)sql + "g.cat_mnem like '" + catMnem + "%'" : (String)sql + "g.cat_mnem='" + catMnem + "'";
        }
        if ((text = genus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(g.genus) like '" + text + "'" : (String)sql + "ucase(g.genus)='" + text + "'";
        }
        if ((text = subGenus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(g.sub_genus) like '" + text + "'" : (String)sql + "ucase(g.sub_genus)='" + text + "'";
        }
        return sql;
    }

    private Genus(Builder builder, int genID) {
        this.genus = new com.stratadata.model3.taxon.Genus(genID);
        com.stratadata.model3.taxon.Genus.copyFields((com.stratadata.model3.taxon.Genus)this.genus, (com.stratadata.model3.taxon.Genus)builder.genus);
    }

    public String getSortEntry() {
        return this.toString(true);
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public String statusString() {
        return this.toString(true);
    }

    @Override
    public void onCategoryDetailsUpdated(String originalMnemonic, Category updatedCategory) {
        if (!this.genus.getCategory().getMnemonic().equals(originalMnemonic)) {
            return;
        }
        Category existing = this.genus.getCategory();
        this.genus.setCategory(updatedCategory);
        if (!Category.equivalent((Category)existing, (Category)updatedCategory)) {
            this.updatePublisher.setGenusDetailsUpdated();
            this.notifyListeners();
        }
    }

    public static class Builder {
        public final com.stratadata.model3.taxon.Genus genus;

        public Builder() {
            this(null);
        }

        public Builder(com.stratadata.model3.taxon.Genus genus) {
            this.genus = genus == null ? new com.stratadata.model3.taxon.Genus() : genus;
        }

        public static Builder copyOf(Genus genus) {
            return new Builder(com.stratadata.model3.taxon.Genus.copy((com.stratadata.model3.taxon.Genus)genus.genus));
        }

        Genus build(int genID, CategoryService categoryService) {
            if (genID <= 0) {
                throw new IllegalArgumentException("Attempt to build Genus with ID: " + genID);
            }
            if (this.genus.getGenusName().isEmpty()) {
                throw new IllegalArgumentException("Attempt to build Genus with no name");
            }
            Category category = (Category)categoryService.findCategory(this.genus.getCategory() != null ? this.genus.getCategory().getMnemonic() : "").orElseThrow(IllegalArgumentException::new);
            this.genus.setCategory(category);
            return new Genus(this, genID);
        }

        Genus store(SBdb sbdb) throws SQLException {
            int genID = sbdb.nextControl("GENUS", "GEN_ID");
            Genus genus = this.build(genID, sbdb.getCategoryService());
            genus.store(sbdb);
            return genus;
        }

        public Builder genusName(String name) {
            this.genus.setGenusName(name);
            return this;
        }

        public Builder subGenus(String name) {
            this.genus.setSubGenus(name);
            return this;
        }

        public Builder colour(Color c) {
            this.genus.setColour(c);
            return this;
        }

        public Builder qual(int position, String s) {
            if (s == null || s.isEmpty() || position < 0 || position > 3) {
                return this;
            }
            if (!this.genus.getQualifier(position).hasQuals()) {
                this.genus.setQualifier(position, new Qualifier(position, s.trim()));
            } else {
                for (TaxonQual parsed : TaxonQual.parse((String)s, (int)position)) {
                    this.genus.getQualifier(position).addQual(parsed);
                }
            }
            return this;
        }

        public Builder qual(int position, Qualifier q) {
            if (position < 0 || position > 3) {
                return this;
            }
            if (q == null) {
                this.genus.setQualifier(position, new Qualifier(position));
            } else {
                this.genus.setQualifier(position, q);
            }
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            for (int i = 0; i < 4; ++i) {
                if (!this.genus.getQualifier(i).hasQuals()) continue;
                return true;
            }
            return false;
        }

        public String getName() {
            return this.genus.getGenusName();
        }

        public String getSubGenus() {
            return this.genus.getSubGenus();
        }

        public Color getColour() {
            return this.genus.getColour();
        }
    }
}

