/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.wellinterp.DepthAgeCurve;
import com.stratadata.model3.wellinterp.DuplicateNodeException;
import com.stratadata.model3.wellinterp.LOCNode;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import model3.Audit;
import model3.CompositeStandard;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.TVDepth;
import model3.Well;
import org.jdom2.Element;
import util.AgeFormat;
import util.ColourUtils;
import util.DepthUnits;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBObservable;
import util.SbugsCompoundEdit;
import util.SbugsEdit;
import util.status.SbugsStatus;

public class LOC
extends SBObservable
implements SbugsStatus {
    private final SBdb sbdb;
    Color status = UNKNOWN;
    String conflictReason;
    private Color colour = Color.BLACK;
    private float lineWidth = 0.5f;
    private String comments;
    private Audit audit = new Audit();
    private Integer prefStdID = null;
    private static final Logger LOGGER = Logger.getLogger(LOC.class.getName());
    private final DepthAgeCurve curve = new DepthAgeCurve();

    LOC(LOC loc, SBdb db) throws SQLException, SBException {
        this.sbdb = db;
        this.copyPrimitives(loc);
        this.audit = new Audit(this.sbdb, loc.sbdb, loc.audit);
        this.curve.addNodes((Collection)loc.curve.getNodes());
        this.status = NOTSTORED;
    }

    LOC(LOC loc) {
        this.colour = loc.colour;
        this.lineWidth = loc.lineWidth;
        this.comments = loc.comments;
        this.sbdb = loc.sbdb;
        this.audit = new Audit(loc.audit);
        this.curve.addNodes((Collection)loc.curve.getNodes());
        this.status = NOTSTORED;
    }

    public LOCNode getNode(int index) {
        return this.curve.getNode(index);
    }

    public int getSize() {
        return this.curve.getSize();
    }

    public DepthAgeCurve getDepthAgeCurve() {
        DepthAgeCurve copyCurve = new DepthAgeCurve();
        copyCurve.addNodes((Collection)this.curve.getNodes());
        return copyCurve;
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    LOC(SBdb ws, LOC rhs) throws SQLException, SBException {
        this.sbdb = ws;
        this.copyPrimitives(rhs);
        this.curve.addNodes((Collection)rhs.curve.getNodes());
        this.audit = new Audit(rhs.audit);
        this.audit.fillWorkspace(rhs.sbdb, ws);
        this.status = STORED;
    }

    private void copyPrimitives(LOC rhs) {
        this.colour = new Color(rhs.getColour().getRed(), rhs.getColour().getGreen(), rhs.getColour().getBlue());
        this.lineWidth = rhs.lineWidth;
        this.comments = rhs.comments;
    }

    public void setColour(Color locColour, int wellID, int interpID) throws SQLException {
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET  colour=" + ColourUtils.DBColourString((Color)locColour, (boolean)false, (boolean)true) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.colour = locColour;
        this.updateAudit(wellID, interpID);
    }

    public void setWeight(float weight, int wellID, int interpID) throws SQLException {
        if ((double)Math.abs(this.lineWidth - weight) < 0.1) {
            return;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET linewidth=" + weight + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.lineWidth = weight;
        this.updateAudit(wellID, interpID);
    }

    double getTopDepth() {
        return this.curve.getTopDepth();
    }

    double getBaseDepth() {
        return this.curve.getBaseDepth();
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    LOC(SBdb ws, Element xml) throws ParseException, SQLException, SBException {
        Element elc;
        this.sbdb = ws;
        String strg = xml.getChildTextNormalize("LineWidth");
        if (strg != null) {
            this.lineWidth = Float.parseFloat(strg);
        }
        if ((elc = xml.getChild("Colour")) != null) {
            this.colour = SB.parseColour((Element)elc);
        }
        if ((strg = xml.getChildTextNormalize("Comment")) != null) {
            this.comments = strg;
        }
        Iterator it = xml.getChildren("Node").iterator();
        LinkedList<LOCNode> nodes = new LinkedList<LOCNode>();
        while (it.hasNext()) {
            Element xmlNode = (Element)it.next();
            strg = xmlNode.getChildTextNormalize("Depth");
            if (strg == null) continue;
            double depth = Double.parseDouble(strg);
            strg = xmlNode.getChildTextNormalize("CSU");
            if (strg == null) continue;
            double csu = Double.parseDouble(strg);
            int bnd = 3;
            strg = xmlNode.getChildTextNormalize("Boundary");
            if (strg != null) {
                bnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
            }
            nodes.add(new LOCNode(depth, csu, bnd));
        }
        this.curve.addNodes(nodes);
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(ws, el);
        } else {
            System.out.println("Warning: no audit info for LOC: " + String.valueOf((Object)this));
        }
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException, SQLException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<LOC>\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind2 + "<LineWidth>" + this.lineWidth + "</LineWidth>\n");
        SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind2);
        if (this.comments != null && !this.comments.isEmpty()) {
            out.write(ind2 + "<Comments>" + this.comments + "</Comments>");
        }
        String ind3 = SB.getXMLIndent((int)(indent + 3 + 3));
        for (LOCNode node : this.curve.getNodes()) {
            out.write(ind2 + "<Node>\n");
            out.write(ind3 + "<Depth>" + node.getDepth() + "</Depth>\n");
            out.write(ind3 + "<CSU>" + node.getAge() + "</CSU>\n");
            out.write(ind3 + "<Boundary>" + node.getBoundaryType() + "</Boundary>\n");
            out.write(ind2 + "</Node>\n");
        }
        this.audit.writeXML(out, indent + 3);
        out.write(ind1 + "</LOC>\n");
    }

    public int getBoundary(double depth) {
        return this.curve.getBoundary(depth);
    }

    public void setUncf(int wellID, int interpID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            for (int i = 0; i < this.curve.getSize() - 1; ++i) {
                LOCNode node = this.curve.getNode(i);
                LOCNode next = this.curve.getNode(i + 1);
                if (!(Math.abs(next.getDepth() - node.getDepth()) < (double)0.0029f)) continue;
                int bnd = 4;
                String sql = "UPDATE " + this.sbdb.DBTableName("LOCNODE") + " SET bnd=" + bnd + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND node_key='" + node.getKey() + "'";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                this.curve.updateBnd(node, bnd);
            }
        }
    }

    LOC(SBdb sbdb, CompositeStandard std, int wellID, int interpID, double depth1, double depth2, double csu1, double csu2) throws SQLException {
        this.sbdb = sbdb;
        try {
            this.addNode(depth1, csu1, 3);
            this.addNode(depth2, csu2, 3);
        }
        catch (DuplicateNodeException duplicateNodeException) {
            // empty catch block
        }
        if (std != null) {
            this.prefStdID = std.getStdID();
        }
        this.store(wellID, interpID);
    }

    public LOC(SBdb SB2, int stdID, int interpID, int wellID, Color colour, float lineWidth) {
        this.sbdb = SB2;
        this.colour = colour;
        this.lineWidth = lineWidth;
        if (stdID > 0) {
            this.prefStdID = stdID;
        }
        this.status = NOTSTORED;
    }

    LOC(SBdb SB2, int stdID, int interpID, int wellID, Color colour, float lineWidth, String comment, Audit audit) throws SBException, SQLException {
        this.sbdb = SB2;
        this.colour = colour;
        this.lineWidth = lineWidth;
        this.audit = audit;
        this.comments = comment;
        this.loadNodes(wellID, interpID);
        this.prefStdID = stdID;
        this.status = STORED;
    }

    LOC(SBdb sbdb, int wellID, int interpID) throws SQLException {
        this.sbdb = sbdb;
        String sql = "SELECT std_id,colour,linewidth,comments," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("LOC") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                this.prefStdID = rs.getInt("std_id");
                this.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                this.lineWidth = rs.getFloat("linewidth");
                this.comments = rs.getString("comments");
                this.audit = new Audit(rs);
                this.loadNodes(wellID, interpID);
            }
        }
    }

    public void setPrefStd(CompositeStandard std, int wellID, int interpID) throws SQLException {
        int id;
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.setCompositeStandard: wellID is " + wellID + ", interpID is " + interpID);
        }
        int n = id = std != null ? std.getStdID() : 0;
        if (this.prefStdID == null || id != this.prefStdID) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET std_id=" + String.valueOf(id == 0 ? "NULL" : Integer.valueOf(id)) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.setChanged();
            this.prefStdID = id;
        }
    }

    private void loadNodes(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to method: wellID is " + wellID + ", interpID is " + interpID);
        }
        String sql = "SELECT depth,age,bnd,node_key FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                double age = rs.getDouble("age");
                int bnd = rs.getInt("bnd");
                try {
                    LOCNode node = this.curve.addNode(depth, age, bnd);
                    if (node == null) continue;
                    node.setDatabaseKey(rs.getString("node_key"));
                }
                catch (DuplicateNodeException ex) {
                    System.out.println("Tried to load duplicate node: " + ex.getMessage());
                }
            }
        }
    }

    public final void addNode(double depth, double age, int bnd, int wellID, int interpID, boolean sort) throws SQLException, DuplicateNodeException {
        LOCNode node = this.addNode(depth, age, bnd, sort);
        try {
            this.storeNode(node, wellID, interpID);
        }
        catch (SQLException e) {
            this.curve.removeNode(node);
            throw e;
        }
        this.updateAudit(wellID, interpID);
    }

    private void storeNode(LOCNode node, int wellID, int interpID) throws SQLException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("LOCNODE") + " (well_id,interp_id,node_key,depth,age,bnd) VALUES (" + wellID + "," + interpID + ",'" + node.getKey() + "'," + node.getDepth() + "," + node.getAge() + "," + node.getBnd() + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            node.setDatabaseKey(node.getKey());
        }
    }

    final void deleteNode(LOCNode node, int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.deleteNode: wellID is " + wellID + ", interpID is: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE interp_id=" + interpID + " AND well_id=" + wellID + " AND node_key='" + node.getDeletionKey() + "'";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public final LOCNode addNode(double depth, double age, int bnd) throws DuplicateNodeException {
        return this.addNode(depth, age, bnd, true);
    }

    public final LOCNode addNode(double depth, double age, int bnd, boolean sort) throws DuplicateNodeException {
        LOCNode node = this.curve.addNode(depth, age, bnd, false);
        this.setChanged();
        return node;
    }

    LOCNodeEdit addNode(int bnd, double depth, double age, int wellID, int interpID) throws InvalidFieldException, SQLException {
        try {
            this.curve.checkNewNode(depth, age);
        }
        catch (DuplicateNodeException ex) {
            throw new InvalidFieldException("This node already exists");
        }
        LOCNode node = new LOCNode(depth, age, bnd);
        LOCNodeEdit edit = new LOCNodeEdit(this, wellID, interpID, null, node);
        edit.doEdit();
        return edit;
    }

    SbugsCompoundEdit deleteNode(int wellID, int interpID, LOCNode node) throws SQLException, InvalidFieldException, SBException {
        if (!this.curve.containsKey(node.getKey())) {
            return null;
        }
        SbugsCompoundEdit cEdit = new SbugsCompoundEdit("delete node");
        cEdit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, node, null)));
        LOCNode prevNode = null;
        LOCNode nextNode = null;
        Iterator<LOCNode> it = this.getNodeIterator();
        while (it.hasNext()) {
            LOCNode n = it.next();
            if (n == node) {
                if (!it.hasNext()) break;
                nextNode = it.next();
                break;
            }
            prevNode = n;
        }
        if (prevNode != null && IGDIntervalZone.isDisconformableBnd(prevNode.getBnd()) && (nextNode == null || nextNode.getDepth() > node.getDepth())) {
            cEdit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, prevNode, new LOCNode(prevNode.getDepth(), prevNode.getAge(), 3))));
        }
        cEdit.doEdits();
        this.updateAudit(wellID, interpID);
        this.setChanged();
        this.notifyObservers();
        return cEdit;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return "Line of Correlation";
    }

    public Color getStatus() {
        return this.status;
    }

    private void updateAudit(int wellID, int interpID) throws SQLException {
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET " + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.audit = temp;
    }

    UndoableEdit updateNode(double depth, double age, int bnd, LOCNode node, int wellID, int interpID) throws InvalidFieldException, SBException, SQLException {
        if (bnd != node.getBnd() && (int)(node.getDepth() * 1000.0) == (int)(depth * 1000.0) && IGDIntervalZone.isDisconformableBnd(node.getBnd()) ^ IGDIntervalZone.isDisconformableBnd(bnd)) {
            throw new InvalidFieldException(IGDIntervalZone.isDisconformableBnd(node.getBnd()) ? "New boundary must be disconformable type" : "Only horizontal sections can be disconformable");
        }
        if (depth < node.getDepth()) {
            Object comp;
            Iterator iterator = this.curve.getNodes().iterator();
            while (iterator.hasNext() && (comp = (LOCNode)iterator.next()) != node) {
                if (!(comp.getDepth() > depth)) continue;
                if (Math.abs(comp.getDepth() - depth) < (double)0.0029f) {
                    depth = comp.getDepth();
                    break;
                }
                throw new InvalidFieldException("Cannot change node depth to above previous node.");
            }
        } else if (depth > node.getDepth()) {
            boolean found = false;
            for (LOCNode n : this.curve.getNodes()) {
                if (n == node) {
                    found = true;
                    continue;
                }
                if (!found || !(n.getDepth() + (double)0.0029f < depth)) continue;
                System.out.println("n.depth=" + n.getDepth() + ",depth=" + depth);
                throw new InvalidFieldException("Cannot change node depth to below next node.");
            }
        }
        String newKey = LOCNode.getNodeKey((double)depth, (double)age);
        if (!node.getKey().equals(newKey) && this.curve.containsKey(newKey)) {
            throw new InvalidFieldException("Cannot change node, a node with that depth and age already exists.");
        }
        SbugsCompoundEdit edit = new SbugsCompoundEdit("Update node");
        bnd = this.updateUncnfs(node, depth, bnd, wellID, interpID, edit);
        edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, node, new LOCNode(depth, age, bnd))));
        edit.doEdits();
        this.updateAudit(wellID, interpID);
        this.setChanged();
        this.notifyObservers();
        return edit;
    }

    UndoableEdit updateDisconf(double depth, double newDepth, int wellID, int interpID) throws InvalidFieldException, SBException, SQLException {
        LOCNode n1 = null;
        LOCNode n2 = null;
        for (LOCNode node : this.curve.getNodes()) {
            if (n1 != null) {
                if (!(Math.abs(node.getDepth() - depth) < (double)0.0029f)) break;
                n2 = node;
                break;
            }
            if (!(Math.abs(node.getDepth() - depth) < (double)0.0029f) || !IGDIntervalZone.isDisconformableBnd(node.getBnd())) continue;
            n1 = node;
        }
        if (n1 != null && n2 != null) {
            int indexOfN2;
            SbugsCompoundEdit edit = null;
            int indexOfN1 = this.curve.getIndexOfNode(n1);
            if (newDepth < depth && indexOfN1 > 0) {
                LOCNode nodeBefore = this.curve.getNode(indexOfN1 - 1);
                if (Math.abs(nodeBefore.getDepth() - newDepth) < (double)0.0029f) {
                    newDepth = nodeBefore.getDepth();
                    edit = new SbugsCompoundEdit("Update disconformity");
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, nodeBefore, new LOCNode(nodeBefore.getDepth(), nodeBefore.getAge(), n1.getBnd()))));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n1, null)));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n2, new LOCNode(newDepth, n2.getAge(), n2.getBnd()))));
                } else if (nodeBefore.getDepth() > newDepth) {
                    throw new InvalidFieldException("Cannot change node depth to above previous node.");
                }
            } else if (newDepth > depth && (indexOfN2 = this.curve.getIndexOfNode(n2)) < this.curve.getSize() - 1) {
                LOCNode nodeAfter = this.curve.getNode(indexOfN2 + 1);
                if (Math.abs(nodeAfter.getDepth() - newDepth) < (double)0.0029f) {
                    newDepth = nodeAfter.getDepth();
                    edit = new SbugsCompoundEdit("Update disconformity");
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n1, new LOCNode(newDepth, n1.getAge(), n1.getBnd()))));
                    edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n2, null)));
                } else if (nodeAfter.getDepth() < newDepth) {
                    throw new InvalidFieldException("Cannot change node depth to below next node.");
                }
            }
            if (edit == null) {
                edit = new SbugsCompoundEdit("Update disconformity");
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n1, new LOCNode(newDepth, n1.getAge(), n1.getBnd()))));
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, n2, new LOCNode(newDepth, n2.getAge(), n2.getBnd()))));
            }
            edit.doEdits();
            this.updateAudit(wellID, interpID);
            this.setChanged();
            this.notifyObservers();
            return edit;
        }
        return null;
    }

    private int updateUncnfs(LOCNode node, double newDepth, int newBnd, int wellID, int interpID, SbugsCompoundEdit edit) {
        boolean sameDepth;
        int index = this.curve.getIndexOfNode(node);
        if (index < 0) {
            return newBnd;
        }
        if (index > 0) {
            LOCNode previous = this.curve.getNode(index - 1);
            boolean bl = sameDepth = Math.abs(previous.getDepth() - newDepth) < 0.001;
            if (IGDIntervalZone.isDisconformableBnd(previous.getBnd()) && !sameDepth) {
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, previous, new LOCNode(previous.getDepth(), previous.getAge(), 3))));
            } else if (!IGDIntervalZone.isDisconformableBnd(previous.getBnd()) && sameDepth) {
                edit.addEdit((UndoableEdit)((Object)new LOCNodeEdit(this, wellID, interpID, previous, new LOCNode(previous.getDepth(), previous.getAge(), 4))));
            }
        }
        if (index < this.curve.getSize() - 1) {
            LOCNode next = this.curve.getNode(index + 1);
            boolean bl = sameDepth = Math.abs(next.getDepth() - newDepth) < 0.001;
            if (IGDIntervalZone.isDisconformableBnd(newBnd) && !sameDepth) {
                newBnd = 3;
            } else if (!IGDIntervalZone.isDisconformableBnd(newBnd) && sameDepth) {
                newBnd = 4;
            }
        }
        return newBnd;
    }

    public boolean equals(LOC rhs) throws SQLException {
        if (this.curve.getSize() != rhs.curve.getSize()) {
            return false;
        }
        for (int i = 0; i < this.curve.getSize(); ++i) {
            if (this.curve.getNode(i).getKey().equals(rhs.curve.getNode(i).getKey())) continue;
            return false;
        }
        return true;
    }

    public final void store(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.store: wellID is " + wellID + ", interpID is " + interpID);
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("LOC") + " (well_id,interp_id,std_id,colour,linewidth,comments," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + String.valueOf(this.prefStdID != null ? this.prefStdID : "NULL") + "," + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)true) + "," + this.lineWidth + "," + SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            for (LOCNode node : this.curve.getNodes()) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("LOCNODE") + " (well_id,interp_id,node_key,depth,age,bnd) VALUES (" + wellID + "," + interpID + ",'" + node.getKey() + "'," + node.getDepth() + "," + node.getAge() + "," + node.getBnd() + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.status = STORED;
    }

    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to LOC.delete: wellID is " + wellID + ", interpID is: " + interpID);
        }
        String sqlNodes = "DELETE FROM " + this.sbdb.DBTableName("LOCNODE") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        String sql = "DELETE FROM " + this.sbdb.DBTableName("LOC") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sqlNodes));
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
    }

    void updateStatus(LOC loc) throws SQLException {
        this.status = STORED;
        if (loc == null || this.getNodes().isEmpty()) {
            this.status = NOTSTORED;
            this.conflictReason = "";
            return;
        }
        if (!this.colour.equals(loc.colour)) {
            this.status = CONFLICT;
            this.conflictReason = "Colour different";
            return;
        }
        if (this.lineWidth != loc.lineWidth) {
            this.status = CONFLICT;
            this.conflictReason = "Line width different";
        }
        if (this.curve.getSize() != loc.curve.getSize()) {
            this.status = CONFLICT;
            this.conflictReason = "Number of nodes different";
        } else {
            for (LOCNode node : this.curve.getNodes()) {
                boolean found = false;
                for (LOCNode cmpNode : loc.curve.getNodes()) {
                    if (!node.getKey().equals(cmpNode.getKey())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.status = CONFLICT;
                this.conflictReason = "Node at: " + node.getDepth() + "m conflicts";
                break;
            }
        }
    }

    public String getConflictReason() {
        return this.conflictReason;
    }

    public void writeDEX(FileWriter out, DecimalFormat nFormat, String eol, char units, String wellName) throws IOException {
        out.write("[LOC]" + eol);
        out.write("Well = " + wellName + eol);
        out.write("Line width = " + this.lineWidth + eol);
        out.write("Colour = " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        out.write(eol);
    }

    public boolean checkDepthBracketing(int cTD, int cBD, int nzTD, int nzBD) {
        if (nzTD == nzBD) {
            if (nzTD > cTD && nzTD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC lies inside existing data";
                return false;
            }
            if (nzTD == cTD && nzTD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths same as existing data";
                return false;
            }
        } else {
            if (nzTD < cTD && nzBD > cTD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD < cBD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depth overlap existing data";
                return false;
            }
            if (nzTD > cTD && nzBD < cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are overlapped by existing data";
                return false;
            }
            if (nzTD < cTD && nzBD > cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths overlap existing data";
                return false;
            }
            if (nzTD == cTD && nzBD == cBD) {
                this.status = CONFLICT;
                this.conflictReason = "New LOC depths are the same as existing data";
                return false;
            }
        }
        return true;
    }

    public double getAge(double depth, boolean extrapolate) {
        return this.curve.getAge((Number)depth, extrapolate, true);
    }

    public double getAge(float depth, boolean minPref) {
        return this.curve.getAge((Number)Float.valueOf(depth), true, minPref);
    }

    public double getDepth(double age, Double minDepth, Double maxDepth, boolean first) {
        Double d = this.curve.getDepthOfAge(age, minDepth, maxDepth, first);
        if (d == null) {
            return -1.0;
        }
        return d;
    }

    public Double getDepthOfAge(double age, Double minDepth, Double maxDepth, boolean first) {
        return this.curve.getDepthOfAge(age, minDepth, maxDepth, first);
    }

    public float[] getAgeLimits(float fromDepth, float toDepth) {
        return this.curve.getAgeLimits(fromDepth, toDepth);
    }

    public double[] getDepths(double age) {
        return this.curve.getDepths(age);
    }

    public Boolean isAgeIncreasing(double depth) throws SBException {
        return this.curve.isAgeIncreasing(depth);
    }

    public double getMaxDepth() {
        return this.curve.getMaxDepth();
    }

    public double getMinDepth() {
        return this.curve.getMinDepth();
    }

    public float getSedimentationRate(double depth) {
        return this.curve.getSedimentationRate(depth);
    }

    public int getStdIDPref() {
        if (this.prefStdID != null) {
            return this.prefStdID;
        }
        return 0;
    }

    public Color getColour() {
        return this.colour;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public String getComment() {
        return this.comments;
    }

    public List<LOCNode> getNodes() {
        return this.curve.getNodes();
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public void updateComment(String newComment, int wellID, int interpID) throws SQLException {
        if ((newComment = newComment.trim()).isEmpty()) {
            newComment = null;
        }
        if (SB.equal((Object)newComment, (Object)this.comments)) {
            return;
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("LOC") + " SET comments=" + (newComment == null ? "NULL" : SB.DBString((String)newComment)) + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.comments = newComment;
        this.updateAudit(wellID, interpID);
    }

    public Iterator<LOCNode> getNodeIterator() {
        return this.curve.getNodeIterator();
    }

    public double getMinAge() {
        return this.curve.getMinAge();
    }

    public double getMaxAge() {
        return this.curve.getMaxAge();
    }

    public double getMaxAge(Double maxDepth) {
        return this.curve.getMaxAge(maxDepth);
    }

    public double getMinAge(double minDepth) {
        return this.curve.getMinAge(minDepth);
    }

    public Point2D getAgeRange(double minDepth, double maxDepth) {
        assert (minDepth < maxDepth);
        double[] ageRange = this.curve.getAgeRange(minDepth, maxDepth);
        return new Point2D.Double(ageRange[0], ageRange[1]);
    }

    public Point2D getDepthRange(double minAge, double maxAge) {
        assert (minAge < maxAge);
        double[] depthRange = this.curve.getDepthRange(minAge, maxAge);
        return new Point2D.Double(depthRange[0], depthRange[1]);
    }

    public Disconformity[] getDisconformities() {
        LinkedList<Disconformity> discnfNodes = new LinkedList<Disconformity>();
        Iterator it = this.curve.getNodeIterator();
        block0: while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (!IGDIntervalZone.isDisconformableBnd(node.getBnd())) continue;
            double age1 = node.getAge();
            LOCNode node2 = null;
            while (node2 == null || IGDIntervalZone.isDisconformableBnd(node2.getBnd())) {
                if (!it.hasNext()) break block0;
                node2 = (LOCNode)it.next();
            }
            double age2 = node2.getAge();
            double[] ages = new double[]{Math.min(age1, age2), Math.max(age1, age2)};
            double depth = node.getDepth();
            discnfNodes.add(new Disconformity(ages, depth, age2 > age1, node.getBnd()));
        }
        if (discnfNodes.isEmpty()) {
            return null;
        }
        return discnfNodes.toArray(new Disconformity[discnfNodes.size()]);
    }

    public double[][] getReversals() {
        Iterator it = this.curve.getNodeIterator();
        LOCNode lastNode = null;
        LinkedList<double[]> revs = new LinkedList<double[]>();
        double[] rev = null;
        while (it.hasNext()) {
            LOCNode node = (LOCNode)it.next();
            if (lastNode == null) {
                lastNode = node;
                continue;
            }
            if (node.getAge() < lastNode.getAge()) {
                if (rev == null) {
                    rev = new double[2];
                    rev[0] = lastNode.getDepth();
                }
            } else if (rev != null) {
                rev[1] = lastNode.getDepth();
                revs.add(rev);
                rev = null;
            }
            lastNode = node;
        }
        if (rev != null) {
            rev[1] = lastNode.getDepth();
            revs.add(rev);
        }
        if (revs.isEmpty()) {
            return null;
        }
        double[][] depths = new double[revs.size()][];
        for (int i = 0; i < revs.size(); ++i) {
            depths[i] = (double[])revs.get(i);
        }
        return depths;
    }

    public void verifyNodes() {
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for LOC");
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public String getRateString(LOCNode node, char units, AgeFormat af, Well well) {
        LOCNode n = null;
        Iterator<LOCNode> it = this.getNodeIterator();
        while (it.hasNext()) {
            LOCNode itNode = it.next();
            if (itNode != node) continue;
            n = it.next();
            break;
        }
        if (n == null) {
            return "";
        }
        if (IGDIntervalZone.isDisconformableBnd(node.getBnd())) {
            return SB.roundToSignificantFigures((double)((n.getAge() - node.getAge()) * af.getMultiplyer()), (int)3) + " " + af.getDescr();
        }
        Object sedRate = "";
        if (Math.abs(n.getAge() - node.getAge()) < 0.001) {
            sedRate = (String)sedRate + "\u221e";
        } else {
            double topDepth = n.getDepth();
            double baseDepth = node.getDepth();
            try {
                if (well != null) {
                    TVDepth baseTVD;
                    TVDepth topTVD = well.getTVDlist(false).getTVD(topDepth);
                    if (topTVD != null && topTVD.getTVDepth() != null) {
                        topDepth = topTVD.getTVDepth();
                    }
                    if ((baseTVD = well.getTVDlist(false).getTVD(baseDepth)) != null && baseTVD.getTVDepth() != null) {
                        baseDepth = baseTVD.getTVDepth();
                    }
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Error getting TVD value in LOC: ", e);
            }
            double r = (DepthUtils.convFromM((double)topDepth, (char)units) - DepthUtils.convFromM((double)baseDepth, (char)units)) / (n.getAge() - node.getAge());
            sedRate = (String)sedRate + SB.roundToSignificantFigures((double)(r /= af.getMultiplyer()), (int)3);
        }
        return (String)sedRate + " " + DepthUnits.getUnits((char)units).getAbr() + "/" + af.getDescr();
    }

    public AgeFormat getAgeFormatIdeal() {
        if (this.getMaxAge() < 5.0) {
            return AgeFormat.KA;
        }
        return AgeFormat.MA;
    }

    public class LOCNodeEdit
    extends SbugsEdit {
        private final String presentationName;
        private final int wellID;
        private final int interpID;
        private final LOCNode originalNode;
        private final LOCNode newNode;
        final /* synthetic */ LOC this$0;

        private LOCNodeEdit(LOC this$0, int wellID, int interpID, LOCNode originalNode, LOCNode newNode) {
            Object s;
            LOC lOC = this$0;
            Objects.requireNonNull(lOC);
            this.this$0 = lOC;
            this.wellID = wellID;
            this.interpID = interpID;
            this.originalNode = originalNode;
            this.newNode = newNode;
            if (originalNode != null && newNode != null) {
                s = "update node ";
                if (originalNode.getBnd() != newNode.getBnd()) {
                    s = (String)s + "line style";
                }
            } else {
                s = originalNode != null ? "delete node" : "new node";
            }
            this.presentationName = s;
        }

        public void doEdit() throws SQLException {
            block3: {
                try {
                    this.redo();
                }
                catch (RuntimeException re) {
                    if (re.getCause() == null) break block3;
                    if (re.getCause() instanceof SQLException) {
                        throw (SQLException)re.getCause();
                    }
                    throw re;
                }
            }
        }

        private void insertActionDB(LOCNode node) throws SQLException {
            this.this$0.storeNode(node, this.wellID, this.interpID);
        }

        private void insertActionModel(LOCNode node) {
            try {
                this.this$0.curve.addNode(node);
            }
            catch (DuplicateNodeException duplicateNodeException) {
                throw new RuntimeException("Error inserting node", duplicateNodeException);
            }
        }

        private void deleteActionDB(LOCNode node) throws SQLException {
            this.this$0.deleteNode(node, this.wellID, this.interpID);
        }

        private void deleteActionModel(LOCNode node) {
            this.this$0.curve.removeNode(node);
        }

        public void undo() {
            try {
                if (this.newNode != null) {
                    this.deleteActionDB(this.newNode);
                }
                if (this.originalNode != null) {
                    this.insertActionDB(this.originalNode);
                }
                this.this$0.sbdb.commit();
            }
            catch (SQLException e) {
                this.this$0.sbdb.doRollback();
                throw new RuntimeException("SQL Error undoing LOCNode edit", e);
            }
            if (this.newNode != null) {
                this.deleteActionModel(this.newNode);
            }
            if (this.originalNode != null) {
                this.insertActionModel(this.originalNode);
            }
            this.this$0.setChanged();
            this.this$0.notifyObservers();
            super.undo();
        }

        public void redo() {
            try {
                if (this.originalNode != null) {
                    this.deleteActionDB(this.originalNode);
                }
                if (this.newNode != null) {
                    this.insertActionDB(this.newNode);
                }
                this.this$0.sbdb.commit();
            }
            catch (SQLException e) {
                this.this$0.sbdb.doRollback();
                throw new RuntimeException("SQL Error redoing LOCNode edit", e);
            }
            if (this.originalNode != null) {
                this.deleteActionModel(this.originalNode);
            }
            if (this.newNode != null) {
                this.insertActionModel(this.newNode);
            }
            this.this$0.setChanged();
            this.this$0.notifyObservers();
            super.redo();
        }

        public String getPresentationName() {
            return this.presentationName;
        }
    }

    public static class Disconformity {
        private final double[] ages;
        private final double depth;
        private final boolean normal;
        private final int bnd;

        Disconformity(double[] ages, double depth, boolean normal, int bnd) {
            this.depth = depth;
            this.ages = ages;
            this.normal = normal;
            this.bnd = bnd;
        }

        public double[] getAges() {
            return this.ages;
        }

        public double getDepth() {
            return this.depth;
        }

        public boolean getNormal() {
            return this.normal;
        }

        public int getBnd() {
            return this.bnd;
        }
    }
}

