/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.wellinterp.LOCNode;
import model3.TVDList;
import model3.TVDepth;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;

public class LOCNodePair {
    private final LOCNode topNode;
    private final LOCNode baseNode;

    public LOCNodePair(LOCNode topNode, LOCNode baseNode) {
        this.topNode = topNode;
        this.baseNode = baseNode;
    }

    public double getAccumRate(TVDList tvdList) {
        if (Math.abs(this.topNode.getAge() - this.baseNode.getAge()) < 0.001) {
            return Double.POSITIVE_INFINITY;
        }
        double topDepth = this.topNode.getDepth();
        double baseDepth = this.baseNode.getDepth();
        if (tvdList != null) {
            TVDepth baseTVD;
            TVDepth topTVD = tvdList.getTVD(topDepth);
            if (topTVD != null && topTVD.getTVDepth() != null) {
                topDepth = topTVD.getTVDepth();
            }
            if ((baseTVD = tvdList.getTVD(baseDepth)) != null && baseTVD.getTVDepth() != null) {
                baseDepth = baseTVD.getTVDepth();
            }
        }
        return (topDepth - baseDepth) / (this.topNode.getAge() - this.baseNode.getAge());
    }

    public double getAccumRate(char units, AgeFormat af, TVDList tvdList) {
        if (Math.abs(this.topNode.getAge() - this.baseNode.getAge()) < 0.001) {
            return Double.POSITIVE_INFINITY;
        }
        double topDepth = this.topNode.getDepth();
        double baseDepth = this.baseNode.getDepth();
        if (tvdList != null) {
            TVDepth baseTVD;
            TVDepth topTVD = tvdList.getTVD(topDepth);
            if (topTVD != null && topTVD.getTVDepth() != null) {
                topDepth = topTVD.getTVDepth();
            }
            if ((baseTVD = tvdList.getTVD(baseDepth)) != null && baseTVD.getTVDepth() != null) {
                baseDepth = baseTVD.getTVDepth();
            }
        }
        double rate = (DepthUtils.convFromM((double)topDepth, (char)units) - DepthUtils.convFromM((double)baseDepth, (char)units)) / (this.topNode.getAge() - this.baseNode.getAge());
        return rate /= af.getMultiplyer();
    }

    public String getAccumRateString(char units, AgeFormat af, TVDList tvdList) {
        double rate = this.getAccumRate(units, af, tvdList);
        String rateString = Double.isInfinite(rate) ? "\u221e" : Double.toString(SB.roundToSignificantFigures((double)rate, (int)3));
        return rateString + " " + DepthUnits.getUnits((char)units).getAbr() + "/" + af.getDescr();
    }

    public double getTopDepth() {
        return this.topNode.getDepth();
    }

    public double getBaseDepth() {
        return this.baseNode.getDepth();
    }
}

