/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model3.Audit;
import model3.SBdb;
import model3.SeismicMarker;
import model3.Well;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class Markers
extends Observable {
    private final SBdb sbdb;
    private final ArrayList<SeismicMarker> list = new ArrayList();

    public Markers(SBdb SB2) {
        this.sbdb = SB2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeismicMarker get(int i) {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            return this.list.get(i);
        }
    }

    public int getSize() {
        return this.list.size();
    }

    public List<SeismicMarker> getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(SeismicMarker seismicMarker) throws SBException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(this.checkOverlap(seismicMarker), seismicMarker);
        }
        this.setChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOverlap(SeismicMarker marker) throws SBException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            int insertPoint = 0;
            int nzD = (int)(marker.getDepth() * 100.0);
            for (SeismicMarker compareWith : this.list) {
                if (compareWith != marker) {
                    int cD = (int)(compareWith.getDepth() * 100.0);
                    if (nzD == cD) {
                        throw new SBException("Seismic marker depth already exists: " + marker.toString());
                    }
                    if (nzD < cD) break;
                    ++insertPoint;
                    continue;
                }
                return -1;
            }
            return insertPoint;
        }
    }

    public void load(int wellID) throws SQLException {
        String sql = "SELECT depth,name,colour," + Audit.sqlFieldString() + " FROM " + this.sbdb.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String name = rs.getString("name");
                Color colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                SeismicMarker seismicMarker = new SeismicMarker(depth, name, colour, new Audit(rs));
                seismicMarker.status = SeismicMarker.STORED;
                try {
                    this.add(seismicMarker);
                }
                catch (SBException e) {
                    System.out.println("Error adding marker: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromView(SBdb db, String wellCode) throws SQLException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        String sql = "SELECT depth,name,colour FROM " + db.DBTableName("WELLSMARK_MASTER") + " WHERE well_code=" + SB.DBString((String)wellCode);
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                double depth = rs.getDouble("depth");
                String name = rs.getString("name");
                Color colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                SeismicMarker seismicMarker = new SeismicMarker(depth, name, colour);
                try {
                    this.add(seismicMarker);
                }
                catch (SBException e) {
                    System.out.println("Error adding seismic point: " + e.getMessage());
                }
            }
        }
        this.setChanged();
    }

    public void deleteAll(int wellID) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, Collection<SeismicMarker> toDelete) throws SQLException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            for (SeismicMarker marker : toDelete) {
                if (!this.list.contains(marker)) {
                    throw new IllegalArgumentException("Attempt to delete seismic marker from wrong well");
                }
                marker.delete(this.sbdb, wellID);
            }
        }
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            this.list.removeAll(toDelete);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(int wellID) throws SQLException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            boolean refresh = false;
            while (it.hasNext()) {
                if (it.next().status != SeismicMarker.NOTSTORED) continue;
                refresh = true;
                break;
            }
            if (!refresh) {
                return;
            }
            this.deleteAll(wellID);
            it = this.list.iterator();
            while (it.hasNext()) {
                it.next().store(this.sbdb, wellID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(Statement stmt, int wellID) throws SQLException, SBException {
        Object sql = "SELECT depth,updated ";
        sql = (String)sql + " FROM " + this.sbdb.DBTableName("WELLSMARK") + " WHERE well_id=" + wellID;
        sql = this.sbdb.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        SeismicMarker notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        boolean reload = false;
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            while (rs.next()) {
                int key = (int)(rs.getDouble("depth") * 1000.0);
                keys.add(key);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (SeismicMarker o : this.list) {
                    if ((int)(o.getDepth() * 1000.0) != key) continue;
                    found = true;
                    if (time == null || !time.after(o.getUpdated())) break;
                    reload = true;
                    notifier = o;
                    break;
                }
                if (found) continue;
                reload = true;
                break;
            }
        }
        if (reload || keys.size() < this.list.size()) {
            if (notifier == null) {
                arrayList = this.list;
                synchronized (arrayList) {
                    notifier = this.list.get(0);
                }
            }
            this.load(wellID);
            this.setChanged();
            if (notifier == null) {
                arrayList = this.list;
                synchronized (arrayList) {
                    notifier = this.list.get(0);
                }
            }
            this.notifyObservers(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIntervalStatus(Color status) {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            while (it.hasNext()) {
                it.next().status = status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            while (it.hasNext()) {
                it.next().writeDEX(out, eol, units);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            while (it.hasNext()) {
                it.next().writeXML(out, indent, units);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for seismic markers");
        }
        ArrayList<SeismicMarker> arrayList = this.list;
        synchronized (arrayList) {
            Iterator<SeismicMarker> it = this.list.iterator();
            while (it.hasNext()) {
                it.next().setAnalyst(analyst);
            }
        }
    }

    public boolean updateFromMaster(int wellID, String wellCode) throws SQLException, SBException, SBPermissionException {
        if (!this.sbdb.hasSmarkMaster) {
            return true;
        }
        Markers viewMarkers = new Markers(this.sbdb);
        viewMarkers.loadFromView(this.sbdb, wellCode);
        LinkedList<SeismicMarker> toAdd = new LinkedList<SeismicMarker>();
        boolean conflict = false;
        for (SeismicMarker viewC : viewMarkers.list) {
            boolean found = false;
            for (SeismicMarker dbC : this.list) {
                if (!(Math.abs(dbC.getDepth() - viewC.getDepth()) < (double)0.0029f)) continue;
                if (dbC.getName().equals(viewC.getName()) && dbC.getColour().equals(viewC.getColour())) {
                    found = true;
                    break;
                }
                conflict = true;
                break;
            }
            if (conflict) break;
            if (found) continue;
            toAdd.add(viewC);
        }
        if (!conflict) {
            Well well = this.sbdb.getWell(wellID);
            for (SeismicMarker marker : toAdd) {
                well.addMarker(marker.getDepth(), marker.getName(), marker.getColour());
            }
        }
        return !conflict;
    }
}

