/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.DictionaryEvent;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.SectionType;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import model3.Audit;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Sample;
import model3.Taxon;
import model3.WellInterp;
import model3.WellOccQueryResult;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.status.SbugsStatus;

public class SBEvent
extends Observable
implements SbugsStatus,
SbugsLink,
Comparable {
    private final SBdb sbdb;
    private final DictionaryEvent dictEvent;
    private Taxon taxon = null;
    private char evExtent;
    private Audit audit;
    private SBEvent link = null;
    private Color status = UNKNOWN;
    private int nOccs = -1;
    public static final float SMALL = 1.0E-5f;
    private static final String SELECT = "SELECT ev_id,name,spec_id,disc_id,generate,ev_extent,ev_desc,abr,\n   has_top, has_base, has_single,\n   pfx_well_top,pfx_well_base,pfx_well_single,\n   pfx_scheme_top,pfx_scheme_base,pfx_scheme_single," + Audit.sqlFieldString();
    static final String BLANK_PREFIX_CODE = "_";
    private static final Function<String, String> PREFIX_MAPPER = prefix -> {
        if (prefix.isEmpty()) {
            prefix = BLANK_PREFIX_CODE;
        }
        return SB.DBString((String)prefix);
    };

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public boolean hasType(EventType type) {
        return this.dictEvent.isPermitted(type);
    }

    void writeDEX(FileWriter out, String eol, SimpleDateFormat df, boolean includeCompositeInfo) throws IOException {
        out.write("Event = " + this.toString() + eol);
        out.write("   ID : " + this.dictEvent.getEvID() + eol);
        if (this.taxon != null) {
            out.write("Species id : " + this.taxon.getSpecID() + eol);
        }
        if (this.dictEvent.isGenerate()) {
            out.write("   Use as top or base : true" + eol);
        }
        if (this.evExtent != ' ' && this.evExtent > '\u0000') {
            out.write("   Extent : " + this.evExtent + eol);
        }
        if (this.dictEvent.getDescription().isPresent()) {
            out.write("   Description : " + (String)this.dictEvent.getDescription().get() + eol);
        }
        out.write("   Created : " + df.format(this.audit.created) + eol);
        out.write("   Creator : " + this.audit.creator + eol);
        out.write(eol);
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        String finalIndent = ind;
        LinkedList<CallSite> lines = new LinkedList<CallSite>();
        lines.add((CallSite)((Object)("<Event Name=\"" + SB.getXMLstring((String)this.getName()) + "\">\n")));
        lines.add((CallSite)((Object)((String)ind + "<Name>" + SB.getXMLstring((String)this.getName()) + "</Name>\n")));
        this.dictEvent.getAbr().ifPresent(abr -> lines.add((CallSite)((Object)(finalIndent + "<Abbreviation>" + SB.getXMLstring((String)abr) + "</Abbreviation>\n"))));
        lines.add((CallSite)((Object)((String)ind + "<ID>" + this.dictEvent.getEvID() + "</ID>\n")));
        if (this.taxon != null) {
            lines.add((CallSite)((Object)((String)ind + "<SpeciesID>" + this.taxon.getSpecID() + "</SpeciesID>\n")));
        }
        for (EventType evType : EventType.values()) {
            if (!this.dictEvent.isPermitted(evType)) continue;
            String hasFieldName = SBEvent.getXmlName(FieldType.HAS, evType);
            lines.add((CallSite)((Object)((String)ind + "<" + hasFieldName + ">" + Boolean.TRUE + "</" + hasFieldName + ">\n")));
            String wpFieldName = SBEvent.getXmlName(FieldType.PFX_WELL, evType);
            this.dictEvent.getPrefix(evType, EventContext.WELL, false).ifPresent(pfxWell -> lines.add((CallSite)((Object)(finalIndent + "<" + wpFieldName + ">" + pfxWell + "</" + wpFieldName + ">\n"))));
            String spFieldName = SBEvent.getXmlName(FieldType.PFX_SCHEME, evType);
            this.dictEvent.getPrefix(evType, EventContext.SCHEME, false).ifPresent(pfxScheme -> lines.add((CallSite)((Object)(finalIndent + "<" + spFieldName + ">" + pfxScheme + "</" + spFieldName + ">\n"))));
        }
        lines.add((CallSite)((Object)((String)ind + "<Generate>" + Boolean.toString(this.dictEvent.isGenerate()) + "</Generate>\n")));
        if (this.evExtent != ' ' && this.evExtent > '\u0000') {
            lines.add((CallSite)((Object)((String)ind + "<Extent>" + this.evExtent + "</Extent>\n")));
        }
        this.dictEvent.getDescription().ifPresent(evDesc -> lines.add((CallSite)((Object)(finalIndent + "<Description>" + SB.getXMLstring((String)evDesc) + "</Description>\n"))));
        for (String string : lines) {
            out.write(string);
        }
        this.audit.writeXML(out, indent);
        out.write("</Event>\n");
    }

    static void loadAll(SBdb sbdb, List list, int projectID) throws SQLException {
        String sql = "SELECT e.ev_id,e.spec_id,e.disc_id,e.ev_extent,e.ev_desc,e.abr,e.generate,e.name,\n     e.abnsch_id,e.abn_abr,e.has_top,e.has_base,e.has_single,\n     e.pfx_well_top,e.pfx_well_base,e.pfx_well_single,\n     e.pfx_scheme_top,e.pfx_scheme_base,e.pfx_scheme_single," + Audit.sqlFieldString("e");
        sql = sql + " FROM " + sbdb.DBTableName("EVENTDIC") + " e";
        if (projectID > 0) {
            sql = sql + ", " + sbdb.DBTableName("EVENTS") + " we, " + sbdb.DBTableName("WELLIST") + " wl," + sbdb.DBTableName("WELLIST_MBR") + " wlm WHERE e.ev_id=we.ev_id AND wlm.well_id=we.well_id AND wl.proj_id=" + projectID + " AND wl.wellist_id=wlm.wellist_id";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("ev_id");
                Builder builder = SBEvent.getBuilderFromResultSet(sbdb, rs, "e");
                builder.audit(new Audit(rs, "e"));
                SBEvent event = builder.build(ID, sbdb);
                event.status = STORED;
                list.add(event);
            }
        }
    }

    public static int getSBEventSQL(SBdb db, String name) throws SQLException {
        String sql = "SELECT ev_id FROM " + db.DBTableName("EVENTDIC") + " WHERE ucase(name)=" + SB.DBString((String)name.trim().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                int n = rs.getInt("ev_id");
                return n;
            }
        }
        return 0;
    }

    private static Builder getBuilderFromResultSet(SBdb sbdb, ResultSet rs, String alias) throws SQLException {
        String discID;
        Builder builder = new Builder();
        builder.name(rs.getString("name"));
        int specID = rs.getInt("spec_id");
        if (specID > 0) {
            builder.taxon(sbdb.getTaxon(specID));
        }
        if ((discID = rs.getString("disc_id")) != null && !discID.isEmpty()) {
            builder.disc = Discipline.getDisc((String)discID);
        }
        builder.isGenerate(rs.getBoolean("generate"));
        builder.evExtent(SB.getDBChar((ResultSet)rs, (String)"ev_extent"));
        builder.desc(rs.getString("ev_desc"));
        builder.abr(rs.getString("abr"));
        for (EventType evType : EventType.values()) {
            boolean hasType = rs.getBoolean(SBEvent.getDbFieldName(FieldType.HAS, evType));
            String pfxWell = rs.getString(SBEvent.getDbFieldName(FieldType.PFX_WELL, evType));
            String pfxScheme = rs.getString(SBEvent.getDbFieldName(FieldType.PFX_SCHEME, evType));
            builder.setUpType(evType, hasType, pfxWell, pfxScheme);
        }
        if (alias == null) {
            builder.audit(new Audit(rs));
        } else {
            builder.audit(new Audit(rs, alias));
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SBEvent load(SBdb sbdb, int evID, Statement statement, SBEvent event) throws SQLException {
        if (event != null && event.getEvID() != evID) {
            throw new IllegalArgumentException("Attempt to refresh sbEvent with incorrect ID");
        }
        String sql = SELECT + " FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ev_id=" + evID;
        Statement stmt = statement == null ? sbdb.getDatabase().createStatement() : statement;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                Builder builder = SBEvent.getBuilderFromResultSet(sbdb, rs, null);
                if (event == null) {
                    event = builder.build(evID, sbdb);
                    event.status = STORED;
                    SBEvent sBEvent = event;
                    return sBEvent;
                }
                event.dictEvent.setName(builder.getName());
                event.taxon = builder.taxon;
                event.dictEvent.setDisc(builder.disc);
                event.dictEvent.setGenerate(builder.isGenerate());
                event.evExtent = builder.evExtent;
                event.dictEvent.setDescription(builder.evDesc);
                event.dictEvent.setAbr((String)builder.dictEvent.getAbr().orElse(null));
                for (EventType evType : EventType.values()) {
                    event.dictEvent.setUpType(evType, builder.dictEvent.isPermitted(evType), (String)builder.dictEvent.getPrefix(evType, EventContext.WELL, false).orElse(null), (String)builder.dictEvent.getPrefix(evType, EventContext.SCHEME, false).orElse(null));
                }
                event.audit = builder.audit;
                event.setChanged();
                SBEvent sBEvent = event;
                return sBEvent;
            }
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        return null;
    }

    public String statusString() {
        return this.toString(true, false, false, true);
    }

    public String toString() {
        return this.toString(true, false, false, true);
    }

    public String toString(boolean abr) {
        return this.toString(true, abr, false, true);
    }

    public String toString(boolean usePrefix, boolean abr, boolean useName, boolean isWell) {
        return this.dictEvent.toString(usePrefix, isWell ? EventContext.WELL : EventContext.SCHEME, abr, useName);
    }

    public String toString(EventType type, boolean isWell, boolean abr, boolean useNameWithAbr) {
        return this.dictEvent.toString(type, isWell ? EventContext.WELL : EventContext.SCHEME, abr, useNameWithAbr);
    }

    public boolean hasEvType(EventType evType) {
        return this.dictEvent.isPermitted(evType);
    }

    public String getPrefix(EventType evType, EventContext context, boolean useDefault) {
        return this.dictEvent.getPrefix(evType, context, useDefault).orElse(null);
    }

    public String getPrefix(EventContext context) {
        return this.dictEvent.getPrefix(context);
    }

    public String getCombinedPrefix() {
        String schemePrefix;
        String wellPrefix = this.getPrefix(EventContext.WELL);
        if (wellPrefix.equals(schemePrefix = this.getPrefix(EventContext.SCHEME))) {
            return wellPrefix;
        }
        return wellPrefix + ";" + schemePrefix;
    }

    public Color getStatus() {
        if (this.link != null) {
            this.status = STORED;
        }
        return this.status;
    }

    Date getUpdated() {
        return new Date(this.audit.updated.getTime());
    }

    void updateName(String name) throws SQLException, SBPermissionException {
        if (name.equals(this.dictEvent.getName())) {
            return;
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        DictionaryEvent parameters = DictionaryEvent.copyOf((DictionaryEvent)this.dictEvent);
        parameters.setName(name);
        if (SBEvent.lookup(this.sbdb, parameters, 0, false) != null) {
            return;
        }
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET name=" + SB.DBString((String)name) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.dictEvent.setName(name);
        this.audit = temp;
        this.setChanged();
    }

    private void storeDB() throws SQLException, SBPermissionException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store SBEvent in unconnected data model");
        }
        if (this.getEvID() <= 0) {
            throw new IllegalStateException("Attempt to store SBEvent with illegal evID: " + this.getEvID());
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("EVENTDIC") + " (ev_id,";
            if (this.taxon != null) {
                sql = sql + "spec_id,";
            }
            if (this.dictEvent.getDiscipline() != null) {
                sql = sql + "disc_id,";
            }
            sql = sql + "name,generate,ev_extent,ev_desc,abr,";
            for (EventType evType : EventType.values()) {
                sql = sql + SBEvent.getDbFieldName(FieldType.HAS, evType) + ",";
                sql = sql + SBEvent.getDbFieldName(FieldType.PFX_WELL, evType) + ",";
                sql = sql + SBEvent.getDbFieldName(FieldType.PFX_SCHEME, evType) + ",";
            }
            sql = sql + Audit.sqlFieldString() + ") VALUES (" + this.getEvID() + ",";
            if (this.taxon != null) {
                sql = sql + this.taxon.getSpecID() + ",";
            }
            if (this.dictEvent.getDiscipline() != null) {
                sql = sql + SB.DBString((String)("" + this.dictEvent.getDiscipline().getChar()));
            }
            sql = sql + SB.DBString((String)this.dictEvent.getName().trim()) + "," + this.sbdb.DBBoolean(this.dictEvent.isGenerate()) + "," + SB.DBChar((char)this.evExtent) + "," + SB.DBString((String)this.dictEvent.getDescription().orElse(null)) + "," + this.dictEvent.getAbr().map(abr -> SB.DBString((String)abr)).orElse("NULL") + ",";
            for (EventType evType : EventType.values()) {
                sql = sql + this.sbdb.DBBoolean(this.dictEvent.isPermitted(evType)) + ",";
                sql = sql + this.dictEvent.getPrefix(evType, EventContext.WELL, false).map(PREFIX_MAPPER).orElse("NULL") + ",";
                sql = sql + this.dictEvent.getPrefix(evType, EventContext.SCHEME, false).map(PREFIX_MAPPER).orElse("NULL") + ",";
            }
            sql = sql + this.audit.sqlInsert(this.sbdb, stmt);
            sql = sql + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = STORED;
    }

    static SBEvent lookup(SBdb sbdb, String prefixString, String name) throws SQLException {
        DictionaryEvent parameters = new DictionaryEvent();
        parameters.setName(name);
        return SBEvent.lookup(sbdb, prefixString, parameters, 0, null, false);
    }

    static SBEvent lookup(SBdb sbdb, DictionaryEvent parameters, int specID, Boolean generate) throws SQLException {
        return SBEvent.lookup(sbdb, null, parameters, specID, generate, false);
    }

    static SBEvent lookup(SBdb sbdb, DictionaryEvent parameters, int specID, Boolean generate, boolean asymmetricTypes) throws SQLException {
        return SBEvent.lookup(sbdb, null, parameters, specID, generate, asymmetricTypes);
    }

    static SBEvent lookup(SBdb sbdb, int specID) throws SQLException {
        return SBEvent.lookup(sbdb, null, null, specID, Boolean.TRUE, false);
    }

    private static SBEvent lookup(SBdb sbdb, String prefixString, DictionaryEvent parameters, int specID, Boolean generate, boolean asymmetricTypes) throws SQLException {
        String name = parameters.getName();
        if ((name == null || name.isEmpty()) && specID <= 0) {
            throw new IllegalArgumentException("Attempt to lookup event with no name or specID");
        }
        String sql = SELECT + " FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ";
        if (name != null && !name.isEmpty()) {
            sql = sql + "lcase(name)=lcase(" + SB.DBString((String)name.trim()) + ")";
            if (specID > 0) {
                sql = sql + " AND ";
            }
        }
        if (specID > 0) {
            sql = sql + " spec_id=" + specID;
        }
        if (generate != null) {
            sql = sql + " AND generate=" + sbdb.DBBoolean(generate);
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                boolean prefixMatches;
                Builder builder;
                int ID;
                block18: {
                    ID = rs.getInt("ev_id");
                    builder = SBEvent.getBuilderFromResultSet(sbdb, rs, null);
                    prefixMatches = false;
                    if (prefixString != null) {
                        for (EventType evType : EventType.values()) {
                            if (!builder.dictEvent.isPermitted(evType)) continue;
                            for (EventContext context : EventContext.values()) {
                                Optional prefix = builder.dictEvent.getPrefix(evType, context, false);
                                if (!prefix.isPresent() || !((String)prefix.get()).equalsIgnoreCase(prefixString)) continue;
                                prefixMatches = true;
                                break block18;
                            }
                        }
                    } else if (builder.dictEvent.isFunctionallyEquivalentTo(parameters, asymmetricTypes)) {
                        prefixMatches = true;
                    }
                }
                if (!prefixMatches) continue;
                SBEvent event = builder.build(ID, sbdb);
                event.status = STORED;
                SBEvent sBEvent = event;
                return sBEvent;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkGenerateUnique(Taxon taxon) throws GenerateUniqueException, SQLException {
        if (taxon == null) {
            return;
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT name FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE ev_id <> " + this.dictEvent.getEvID() + " AND spec_id=" + taxon.getSpecID() + " AND generate=" + this.sbdb.DBBoolean(true);
        String existingName = null;
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                existingName = rs.getString("name").trim();
            }
        }
        finally {
            stmt.close();
        }
        if (existingName != null) {
            throw new GenerateUniqueException("Cannot set 'generate' attribute, currently set for event: " + existingName);
        }
    }

    void delete() throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVLOAD") + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE ev_id=" + this.getEvID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.setChanged();
    }

    public int compareTo(Object rhsObj) {
        SBEvent rhs = (SBEvent)rhsObj;
        String s1 = this.getPrefix(EventContext.WELL) + " ";
        String s2 = rhs.getPrefix(EventContext.WELL) + " ";
        s1 = this.taxon != null ? s1 + this.taxon.toString(false, false) : s1 + this.getName();
        s2 = rhs.taxon != null ? s2 + rhs.taxon.toString(false, false) : s2 + rhs.getName();
        return s1.compareTo(s2);
    }

    public boolean isEquivalentTo(DictionaryEvent parameters) {
        return this.dictEvent.isFunctionallyEquivalentTo(parameters);
    }

    public int getEvID() {
        return this.dictEvent.getEvID();
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public int getSpecID() {
        if (this.taxon != null) {
            return this.taxon.getSpecID();
        }
        return 0;
    }

    public String getName() {
        return this.dictEvent.getName();
    }

    public String getDictionaryName() {
        if (this.taxon != null && this.taxon.toString().equals(this.dictEvent.getName())) {
            return "";
        }
        return this.dictEvent.getName();
    }

    public boolean isGenerate() {
        return this.dictEvent.isGenerate();
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public String getEvDesc() {
        return this.dictEvent.getDescription().orElse(null);
    }

    public String getAbr() {
        return this.dictEvent.getAbr().orElse(null);
    }

    public Taxon getTaxon() {
        return this.taxon;
    }

    public String getCatMnem() {
        if (this.taxon == null) {
            return null;
        }
        return this.taxon.getCatMnem();
    }

    public void setUpType(EventType type, boolean permitted, String wellPrefix, String schemePrefix) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to update event type on database object");
        }
        this.dictEvent.setUpType(type, permitted, wellPrefix, schemePrefix);
    }

    public int getNoccs(boolean refresh) throws SQLException {
        return this.getNoccs(refresh, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNoccs(boolean refresh, EventType type) throws SQLException {
        if (this.nOccs < 0 || refresh) {
            this.nOccs = 0;
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "SELECT count(samp_id) AS nOccs FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE ev_id=" + this.getEvID();
            if (type != null) {
                sql = sql + " AND ev_type='" + type.getChar() + "'";
            }
            try {
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    this.nOccs = rs.getInt("nOccs");
                }
            }
            finally {
                stmt.close();
            }
        }
        return this.nOccs;
    }

    public int getNcmpStdOccs() throws SQLException {
        return this.getNcmpStdOccs(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNcmpStdOccs(EventType type) throws SQLException {
        int n = 0;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT count(std_id) AS nOccs FROM " + this.sbdb.DBTableName("CMPSTDEV") + " WHERE ev_id=" + this.getEvID();
        if (type != null) {
            sql = sql + " AND ev_type='" + type.getChar() + "'";
        }
        try {
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                n = rs.getInt("nOccs");
            }
        }
        finally {
            stmt.close();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNcorrOccs() throws SQLException {
        int n = 0;
        String sql = "SELECT count(CORRSCH_ID) AS nOccs FROM " + this.sbdb.DBTableName("CHTLN_EV") + " WHERE ev_id=" + this.getEvID();
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                n = rs.getInt("nOccs");
            }
        }
        return n;
    }

    public List<WellOccQueryResult> getWellOccs() throws SQLException, SBException {
        return this.getWellOccs(-1, -1);
    }

    public List<WellOccQueryResult> getWellOccs(int filterInterpID, int wellListID) throws SQLException, SBException {
        LinkedList<WellOccQueryResult> results = new LinkedList<WellOccQueryResult>();
        Object sql = "SELECT e.well_id,e.interp_id,i.descrip,e.samp_id,e.ev_type,w.well_name,w.units,w.type FROM ";
        sql = (String)sql + this.sbdb.DBTableName("EVENTS") + " e," + this.sbdb.DBTableName("INTERP") + " i," + this.sbdb.DBTableName("WELLS") + " w ";
        if (wellListID > 0) {
            sql = (String)sql + "," + this.sbdb.DBTableName("WELLIST_MBR") + " wl";
        }
        sql = (String)sql + " WHERE e.ev_id=" + this.getEvID() + " AND e.interp_id=i.interp_id AND e.well_id=w.well_id ";
        if (filterInterpID >= 0) {
            sql = (String)sql + " AND i.interp_id=" + filterInterpID;
        }
        if (wellListID > 0) {
            sql = (String)sql + " AND w.well_id=wl.well_id AND wl.wellist_id=" + wellListID;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int interpID = rs.getInt("interp_id");
                String interpName = rs.getString("descrip");
                int sampID = rs.getInt("samp_id");
                char eventOccType = SB.getDBChar((ResultSet)rs, (String)"ev_type");
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                char sectionType = SB.getDBChar((ResultSet)rs, (String)"type");
                Sample sample = Sample.load(this.sbdb, wellID, sampID, SectionType.getSectionType((char)sectionType), null);
                sample.displayUnits = units;
                WellOccQueryResult result = new WellOccQueryResult(wellID, interpID, eventOccType, wellName, interpName, sample);
                results.add(result);
            }
        }
        Collections.sort(results);
        return results;
    }

    public static double[] getAgeStats(SBdb db, EventType eventType, List<WellOccQueryResult> occs) throws SQLException, SBException {
        ArrayList<Double> ages = null;
        for (WellOccQueryResult r : occs) {
            double age;
            if (r.type != eventType) continue;
            if (ages == null) {
                ages = new ArrayList<Double>();
            }
            WellInterp wellInterp = null;
            try {
                db.getWell(r.wellID).loadInterps();
                wellInterp = db.getWell(r.wellID).getInterp(r.interpID);
            }
            catch (SBException ex) {
                System.out.println("Exception from getAgeStats.getWell:" + ex.getMessage());
            }
            if (wellInterp == null) continue;
            wellInterp.loadLOC(r.wellID);
            if (wellInterp.getLOC() == null || !((age = wellInterp.getLOC().getAge(r.sample.getDepth(), false)) > 0.0)) continue;
            ages.add(age);
        }
        double[] stats = new double[3];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = 0.0;
        }
        if (ages != null && ages.size() >= 2) {
            double total = 0.0;
            for (Double d : ages) {
                total += d.doubleValue();
                stats[2] = stats[2] + 1.0;
            }
            double mean = total / (double)ages.size();
            Collections.sort(ages);
            double median = ages.size() % 2 == 0 ? ((Double)ages.get(ages.size() / 2) + (Double)ages.get(ages.size() / 2 - 1)) / 2.0 : (Double)ages.get((int)Math.floor(ages.size() / 2));
            stats[0] = mean;
            stats[1] = median;
        }
        return stats;
    }

    public List<CmpstdEventQueryResult> getCmpstdOccs() throws SQLException {
        LinkedList<CmpstdEventQueryResult> results = new LinkedList<CmpstdEventQueryResult>();
        Object sql = "SELECT c.std_id, c.ev_type, c.csu, s.name FROM ";
        sql = (String)sql + this.sbdb.DBTableName("CMPSTDEV") + " c," + this.sbdb.DBTableName("CMPSTD") + " s";
        sql = (String)sql + " WHERE ev_id=" + this.getEvID() + " AND c.std_id=s.std_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            while (rs.next()) {
                int stdID = rs.getInt("std_id");
                EventType evType = EventType.getType((String)rs.getString("ev_type"));
                double csu = rs.getDouble("csu");
                String csname = rs.getString("name");
                CmpstdEventQueryResult result = new CmpstdEventQueryResult(this, stdID, evType, csu, csname);
                results.add(result);
            }
        }
        return results;
    }

    public SBEvent getLink() {
        return this.link;
    }

    public void setLink(SBEvent link) {
        this.link = link;
    }

    public void findLink(SBdb db) throws SQLException {
        this.findLink(db, false);
    }

    public void findLink(SBdb db, boolean asymmetricTypes) throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to match database SBEvent");
        }
        if (this.sbdb == db) assert (false);
        DictionaryEvent query = DictionaryEvent.copyOf((DictionaryEvent)this.dictEvent);
        this.link = db.getSBEvent(query, asymmetricTypes);
        if (this.link == null && asymmetricTypes) {
            this.link = db.getSBEvent(query.getName());
        }
        if (this.link != null) {
            this.status = STORED;
        }
    }

    public void findLink(SBdb db, int evID) throws SQLException {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to match database SBEvent");
        }
        if (this.sbdb == db) assert (false);
        this.link = db.getSBEvent(evID);
        if (this.link != null) {
            this.status = STORED;
        }
    }

    void update(Builder builder) throws SQLException, GenerateUniqueException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        Audit temp = new Audit(builder.audit);
        GenerateUniqueException ex = null;
        if (this.sbdb.isConnected()) {
            builder.validate(this.getEvID(), this.sbdb);
            if (builder.isGenerate() && !this.isGenerate()) {
                try {
                    this.checkGenerateUnique(builder.taxon);
                }
                catch (GenerateUniqueException e) {
                    builder.isGenerate(false);
                    ex = e;
                }
            }
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET spec_id=" + String.valueOf(builder.getTaxon() == null ? "NULL" : Integer.valueOf(builder.getTaxon().getSpecID())) + ",name=" + SB.DBString((String)builder.getName()) + ",disc_id=" + (builder.disc == null ? "null" : SB.DBString((String)("" + builder.disc.getChar()))) + ",abr=" + SB.DBString((String)builder.getAbr()) + ",generate=" + this.sbdb.DBBoolean(builder.isGenerate()) + ",ev_extent=" + SB.DBChar((char)this.evExtent) + ",ev_desc=" + SB.DBString((String)builder.getDesc());
                for (EventType evType : EventType.values()) {
                    sql = sql + "," + SBEvent.getDbFieldName(FieldType.HAS, evType) + "=" + this.sbdb.DBBoolean(builder.dictEvent.isPermitted(evType));
                    sql = sql + "," + SBEvent.getDbFieldName(FieldType.PFX_WELL, evType) + "=" + builder.dictEvent.getPrefix(evType, EventContext.WELL, false).map(PREFIX_MAPPER).orElse("NULL");
                    sql = sql + "," + SBEvent.getDbFieldName(FieldType.PFX_SCHEME, evType) + "=" + builder.dictEvent.getPrefix(evType, EventContext.SCHEME, false).map(PREFIX_MAPPER).orElse("NULL");
                }
                sql = sql + "," + temp.sqlUpdate(this.sbdb, stmt, false);
                sql = sql + " WHERE ev_id=" + this.getEvID();
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.taxon = builder.taxon;
        this.evExtent = builder.evExtent;
        this.dictEvent.copyFrom(builder.dictEvent);
        this.audit = temp;
        this.status = STORED;
        if (ex != null) {
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGenerate(boolean newGenerate) throws GenerateUniqueException, SQLException {
        if (this.dictEvent.isGenerate() == newGenerate) {
            return;
        }
        if (newGenerate) {
            this.checkGenerateUnique(this.taxon);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("EVENTDIC") + " SET generate=" + this.sbdb.DBBoolean(newGenerate) + "," + this.audit.sqlUpdate(this.sbdb, stmt, false);
        sql = sql + " WHERE ev_id=" + this.getEvID();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        this.dictEvent.setGenerate(newGenerate);
    }

    public static List<SBEvent> search(SBdb sbdb, String name) throws SQLException, SBException {
        name = name.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
        String sql = "SELECT ev_id FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE ";
        if (name.indexOf(37) >= 0) {
            name = name.replace("[", "[[]");
            sql = sql + "ucase(name) like '" + name + "'";
        } else {
            sql = sql + "ucase(name)='" + name + "'";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<SBEvent> resultList = new LinkedList<SBEvent>();
            while (rs.next()) {
                SBEvent event = sbdb.getSBEvent(rs.getInt("ev_id"));
                resultList.add(event);
            }
            LinkedList<SBEvent> linkedList = resultList;
            return linkedList;
        }
    }

    public static List<SBEvent> search(SBdb sbdb, int[] specIDs) throws SQLException, SBException {
        String sql = "SELECT ev_id FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=";
        for (int i = 0; i < specIDs.length; ++i) {
            if (i > 0) {
                sql = sql + " OR spec_id=";
            }
            sql = sql + specIDs[i];
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            LinkedList<SBEvent> resultList = new LinkedList<SBEvent>();
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                SBEvent event = sbdb.getSBEvent(rs.getInt("ev_id"));
                resultList.add(event);
            }
            LinkedList<SBEvent> linkedList = resultList;
            return linkedList;
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for dictionary event: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    void setAbr(String abr) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set abr on connected database for dictionary event: " + String.valueOf(this));
        }
        if (this.dictEvent.getAbr().isEmpty()) {
            this.dictEvent.setAbr(abr);
        }
    }

    void setEvDesc(String desc) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set description on connected database for dictionary event: " + String.valueOf(this));
        }
        if (this.dictEvent.getDescription().isEmpty() || !((String)this.dictEvent.getDescription().get()).contains(desc)) {
            this.dictEvent.setDescription(desc);
        }
    }

    private SBEvent(Builder b, int evID, SBdb sbdb) {
        this.sbdb = sbdb;
        this.dictEvent = new DictionaryEvent(evID);
        this.dictEvent.copyFrom(b.dictEvent);
        this.evExtent = b.evExtent;
        this.taxon = b.taxon;
        this.audit = b.audit;
        this.status = NOTSTORED;
    }

    public static int autoMerge(SBdb db) throws SQLException, IOException {
        int nEvents = 0;
        String fileName = "StrataBugs Event Merge Log.txt";
        File file = new File(fileName);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
            System.out.println("Opened output file: " + file.getPath());
            out.write("\nStrataBugs event merge log: " + String.valueOf(new Date()) + "\n");
            Statement stmt = db.getDatabase().createStatement();
            Statement stmt2 = db.getDatabase().createStatement();
            String sql = "SELECT ev_id, spec_id, name FROM " + db.DBTableName("EVENTDIC") + " WHERE ev_desc='Generated from well data' AND generate='N'";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int nRows;
                int evID = rs.getInt("ev_id");
                int specID = rs.getInt("spec_id");
                String name = rs.getString("name");
                out.write("\nProcessing event: " + evID + " : " + name);
                sql = "SELECT count(*) AS nEvents FROM " + db.DBTableName("EVENTS") + " WHERE ev_id=" + evID;
                ResultSet rs2 = stmt2.executeQuery(sql);
                int nWellEvents = 0;
                if (rs2.next()) {
                    nWellEvents = rs2.getInt("nEvents");
                }
                rs2.close();
                sql = "SELECT count(*) AS nEvents FROM " + db.DBTableName("CMPSTDEV") + " WHERE ev_id=" + evID;
                rs2 = stmt2.executeQuery(sql);
                int nCmpStdEv = 0;
                if (rs2.next()) {
                    nCmpStdEv = rs2.getInt("nEvents");
                }
                rs2.close();
                out.write("\nEvent occurs: " + nWellEvents + " in wells and " + nCmpStdEv + " in Composite Standards");
                if (nWellEvents + nCmpStdEv > 0) {
                    int nRows2;
                    sql = "SELECT ev_id FROM " + db.DBTableName("EVENTDIC") + " WHERE name=" + SB.DBString((String)name) + " AND spec_id=" + specID + " AND generate='Y'";
                    rs2 = stmt2.executeQuery(sql);
                    int targetID = 0;
                    if (rs2.next()) {
                        targetID = rs2.getInt("ev_id");
                    }
                    rs2.close();
                    if (targetID == 0) {
                        out.write("\nNo target event found ******");
                        continue;
                    }
                    out.write("\nTarget event found is: " + targetID);
                    if (nWellEvents > 0) {
                        sql = "UPDATE " + db.DBTableName("EVENTS") + " SET ev_id=" + targetID + " WHERE ev_id=" + evID;
                        try {
                            nRows2 = stmt2.executeUpdate(sql);
                            out.write("\nNumber of well events updated " + nRows2);
                        }
                        catch (SQLException sqlex) {
                            out.write("\nCan't update well events due to: " + sqlex.toString());
                            continue;
                        }
                    }
                    if (nCmpStdEv > 0) {
                        sql = "UPDATE " + db.DBTableName("CMPSTDEV") + " SET ev_id=" + targetID + " WHERE ev_id=" + evID;
                        try {
                            nRows2 = stmt2.executeUpdate(sql);
                            out.write("\nNumber of composite standard events updated " + nRows2);
                        }
                        catch (SQLException sqlex) {
                            out.write("\nCan't update composite standard events due to: " + sqlex.toString());
                            continue;
                        }
                    }
                }
                if ((nRows = stmt2.executeUpdate(sql = "DELETE FROM " + db.DBTableName("EVENTDIC") + " WHERE ev_id=" + evID)) <= 0) continue;
                out.write("\n..Deleted.");
                ++nEvents;
            }
        }
        return nEvents;
    }

    void storeMatch(SBdb sbdb, String sourceID) throws SQLException {
        assert (!this.sbdb.isConnected() && sbdb.isConnected());
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "DELETE FROM " + sbdb.DBTableName("EVLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + SB.DBString((String)this.getName().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
            int nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            if (nRows == 0) {
                sql = "DELETE FROM " + sbdb.DBTableName("EVLOAD") + " WHERE source_id='" + sourceID + "' AND txt=" + SB.DBString((String)this.getName());
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            if (this.link != null && !this.getName().equals(this.link.getName())) {
                sql = "INSERT INTO " + sbdb.DBTableName("EVLOAD") + " (source_id,ev_id,txt) VALUES('" + sourceID + "'," + this.link.getEvID() + "," + SB.DBString((String)this.getName()) + ")";
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
        }
    }

    static String getDbFieldName(FieldType f, EventType e) {
        String fieldName = f.fieldName;
        switch (e) {
            case TOP: {
                return fieldName + "top";
            }
            case BASE: {
                return fieldName + "base";
            }
            case SINGLE: {
                return fieldName + "single";
            }
        }
        return null;
    }

    static String getXmlName(FieldType f, EventType e) {
        String fieldName = f.xmlName;
        switch (e) {
            case TOP: {
                return fieldName + "Top";
            }
            case BASE: {
                return fieldName + "Base";
            }
            case SINGLE: {
                return fieldName + "Single";
            }
        }
        return null;
    }

    static enum FieldType {
        HAS("has_", "Has"),
        PFX_WELL("pfx_well_", "PfxWell"),
        PFX_SCHEME("pfx_scheme_", "PfxScheme");

        final String fieldName;
        final String xmlName;

        private FieldType(String fieldName, String xmlName) {
            this.fieldName = fieldName;
            this.xmlName = xmlName;
        }
    }

    public static class Builder {
        Audit audit = new Audit();
        private String evDesc = "";
        private char evExtent;
        private Taxon taxon = null;
        private Discipline disc = null;
        private final DictionaryEvent dictEvent = new DictionaryEvent(0);

        public static Builder copyOf(SBEvent event) {
            Builder builder = new Builder();
            builder.dictEvent.copyFrom(event.dictEvent);
            builder.evExtent(event.evExtent);
            return builder;
        }

        void validate(int evID, SBdb sbdb) {
            if (evID < 1) {
                throw new IllegalArgumentException("Attempt to build SBEvent with illegal eventID: " + evID);
            }
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build SBEvent with null data model");
            }
            if (this.dictEvent.getName().isEmpty()) {
                throw new IllegalStateException("Attempt to build SBEvent with no name");
            }
            boolean hasAnyType = Stream.of(EventType.values()).anyMatch(evType -> this.dictEvent.isPermitted(evType));
            if (!hasAnyType) {
                throw new IllegalStateException("At least one type must be permitted");
            }
            if (Objects.equals(this.dictEvent.getName(), this.dictEvent.getAbr().orElse(null))) {
                this.dictEvent.setAbr(null);
            }
            if (this.taxon == null) {
                // empty if block
            }
        }

        SBEvent build(int evID, SBdb sbdb) {
            this.validate(evID, sbdb);
            return new SBEvent(this, evID, sbdb);
        }

        SBEvent store(SBdb sbdb) throws SQLException, SBPermissionException {
            int specID = sbdb.nextControl("EVENTDIC", "ev_id");
            SBEvent event = this.build(specID, sbdb);
            event.storeDB();
            return event;
        }

        public Builder isGenerate(boolean isGenerate) {
            this.dictEvent.setGenerate(isGenerate);
            return this;
        }

        public Builder disc(Discipline disc) {
            this.dictEvent.setDisc(disc);
            return this;
        }

        public Builder name(String name) {
            if (name == null) {
                name = "";
            }
            this.dictEvent.setName(name);
            return this;
        }

        public Builder desc(String desc) {
            this.dictEvent.setDescription(desc);
            return this;
        }

        public Builder taxon(Taxon taxon) {
            this.taxon = taxon;
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public Builder evExtent(char extent) {
            this.evExtent = extent;
            return this;
        }

        public Builder abr(String abr) {
            if (abr != null && ((abr = abr.trim()).isEmpty() || abr.equals(this.dictEvent.getName()))) {
                abr = null;
            }
            this.dictEvent.setAbr(abr);
            return this;
        }

        public Builder setUpType(EventType evType, boolean hasType, String pfxWell, String pfxScheme) {
            if (SBEvent.BLANK_PREFIX_CODE.equals(pfxWell)) {
                pfxWell = "";
            }
            if (SBEvent.BLANK_PREFIX_CODE.equals(pfxScheme)) {
                pfxScheme = "";
            }
            this.dictEvent.setUpType(evType, hasType, pfxWell, pfxScheme);
            return this;
        }

        public Builder parsePfx(Element xml) {
            for (EventType evType : EventType.values()) {
                String strg = xml.getChildTextNormalize(SBEvent.getXmlName(FieldType.HAS, evType));
                boolean hasType = false;
                String wpfx = null;
                String spfx = null;
                if (strg != null) {
                    hasType = Boolean.parseBoolean(strg);
                    strg = xml.getChildTextNormalize(SBEvent.getXmlName(FieldType.PFX_WELL, evType));
                    if (strg != null) {
                        wpfx = strg;
                    }
                    if ((strg = xml.getChildTextNormalize(SBEvent.getXmlName(FieldType.PFX_SCHEME, evType))) != null) {
                        spfx = strg;
                    }
                }
                this.dictEvent.setUpType(evType, hasType, wpfx, spfx);
            }
            return this;
        }

        public String getName() {
            return this.dictEvent.getName();
        }

        public DictionaryEvent getDictionaryEvent() {
            return this.dictEvent;
        }

        public Taxon getTaxon() {
            return this.taxon;
        }

        boolean isGenerate() {
            return this.dictEvent.isGenerate();
        }

        String getDesc() {
            return this.evDesc;
        }

        char getExtent() {
            return this.evExtent;
        }

        String getAbr() {
            return this.dictEvent.getAbr().orElse(null);
        }
    }

    public static class GenerateUniqueException
    extends SBException {
        public GenerateUniqueException(String msg) {
            super(msg);
        }
    }

    public class CmpstdEventQueryResult {
        public String stdName;
        public EventType type;
        public double csu;
        public int stdID;

        CmpstdEventQueryResult(SBEvent this$0, int stdID, EventType type, double csu, String name) {
            Objects.requireNonNull(this$0);
            this.stdID = stdID;
            this.type = type;
            this.csu = csu;
            this.stdName = name;
        }
    }
}

