/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import model3.Audit;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.Sample;
import model3.SbugsSampleObject;
import model3.Surface;
import model3.Well;
import model3.wellinterp.InterpItem;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class SQPick
implements SortEntry,
SbugsStatus,
SbugsSampleObject,
InterpItem {
    private final SBdb sbdb;
    private Surface surface;
    private String informalName = "";
    private Sample sample;
    private int bnd;
    private boolean questionable;
    private boolean observed = true;
    private Audit audit = new Audit();
    Color status = UNKNOWN;

    public static SQPick load(SBdb sbdb, Well well, int interpID, int sampID, int surfaceID, SQPick p) throws SQLException, SBException {
        String sql = "SELECT s.sch_id,bnd,qualifier,inf,observed," + Audit.sqlFieldString("p");
        sql = sql + " FROM " + sbdb.DBTableName("SQPICK") + " p, " + sbdb.DBTableName("SURFACE") + " s WHERE interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND samp_id=" + sampID + " AND p.surface_id=" + surfaceID + " AND p.surface_id=s.surface_id";
        Builder builder = null;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                int schID = rs.getInt("sch_id");
                IGDScheme scheme = sbdb.getIGDScheme(schID);
                int bnd = rs.getInt("bnd");
                builder = new Builder(sbdb, scheme.getSurface(surfaceID), well.getSample(sampID), bnd);
                String strg = rs.getString("qualifier");
                if (strg != null && strg.length() > 0 && strg.equals("?")) {
                    builder.questionable(true);
                }
                String infName = rs.getString("inf");
                builder.informalName(infName);
                String observedString = rs.getString("observed");
                boolean observed = true;
                if (observedString != null && observedString.length() > 0) {
                    observed = !observedString.equals("N");
                }
                builder.observed(observed);
                builder.audit(new Audit(rs, "p"));
                builder.status = STORED;
            }
        }
        if (builder == null) {
            return null;
        }
        if (p == null) {
            return builder.build();
        }
        if (p.surface != builder.surface || p.sample != builder.sample) {
            throw new IllegalArgumentException("Attempt to copy fields to unequivalent Sequence Pick object");
        }
        p.bnd = builder.bnd;
        p.informalName = builder.informalName;
        p.questionable = builder.questionable;
        p.audit = builder.audit;
        return p;
    }

    public SQPick(SBdb ws, SQPick dbPick, Well wsWell) throws SQLException, SBException {
        this.sbdb = ws;
        this.copyPrimitives(dbPick);
        this.audit = new Audit(dbPick.audit);
        this.audit.fillWorkspace(dbPick.sbdb, ws);
        IGDScheme dbScheme = dbPick.surface.getScheme();
        if (ws.getIGDScheme(dbScheme.getSchID()) == null) {
            dbScheme.loadUnits();
            IGDScheme wsScheme = IGDScheme.copyToWorkspace(ws, dbScheme);
            ws.addIGDScheme(wsScheme);
        }
        this.surface = ws.getIGDScheme(dbScheme.getSchID()).getSurface(dbPick.getSurfaceID());
        this.sample = wsWell.getSample(dbPick.getSample().getSampID());
        this.status = STORED;
    }

    public static SQPick copyToDatabase(SBdb db, SQPick wsPick) throws SBException, SQLException {
        Surface dbSurface = wsPick.sbdb.getIGDScheme(wsPick.getSurface().getSchID()).getSurface(wsPick.getSurface().getName(), wsPick.getSurfaceType()).getLink();
        if (dbSurface == null) {
            throw new SBException("No linked surface for sequence pick");
        }
        Sample dbSample = wsPick.sample.link;
        if (dbSample == null) {
            throw new SBException("Pick sample not linked");
        }
        Builder builder = new Builder(db, dbSurface, dbSample, wsPick.getBndInt()).informalName(wsPick.informalName).questionable(wsPick.questionable).observed(wsPick.observed);
        builder.audit(new Audit(db, wsPick.sbdb, wsPick.audit));
        return builder.build();
    }

    public String getQualifier() {
        if (this.questionable) {
            return "?";
        }
        return "";
    }

    @Override
    public Sample getSample() {
        return this.sample;
    }

    public final String getName() {
        if (this.informalName != null && this.informalName.length() > 0) {
            return this.informalName;
        }
        return this.surface.toString(true);
    }

    public String toString() {
        if (this.sample != null) {
            return this.sample.toString() + " " + this.getName();
        }
        return this.getName();
    }

    public String getInfName() {
        return this.informalName;
    }

    public int getBndInt() {
        return this.bnd;
    }

    public String getBnd() {
        return IGDIntervalZone.getBoundary(this.bnd);
    }

    public Surface getSurface() {
        return this.surface;
    }

    public Surface.SurfaceType getSurfaceType() {
        if (this.surface == null) {
            return null;
        }
        return this.surface.getType();
    }

    public String getTypeString() {
        if (this.surface == null) {
            return null;
        }
        return this.surface.getTypeString();
    }

    public boolean isObserved() {
        return this.observed;
    }

    private void copyPrimitives(SQPick rhs) {
        this.informalName = rhs.informalName;
        this.bnd = rhs.bnd;
        this.questionable = rhs.questionable;
        this.observed = rhs.observed;
    }

    @Override
    public void delete(int wellID, int interpID, Statement s) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to SQPick.delete: wellID is " + wellID + ", interpID is: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("sqpick") + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND surface_id=" + this.surface.getSurfaceID() + " AND interp_id=" + interpID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
    }

    public final void store(int wellID, int interpID) throws SQLException {
        if (this.surface == null) {
            throw new IllegalStateException("Attempt to store pick:" + this.toString() + " with no linked surface");
        }
        if (this.sample == null) {
            throw new IllegalStateException("Attempt to store pick: " + this.toString() + " with no linked sample");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            this.store(wellID, interpID, this.sample.getSampID(), this.surface.getSurfaceID(), stmt);
        }
    }

    private void store(int wellID, int interpID, int sampID, int surfaceID, Statement stmt) throws SQLException {
        if (surfaceID <= 0) {
            throw new IllegalArgumentException("Attempt to store pick with no surface ID");
        }
        if (sampID <= 0) {
            throw new IllegalArgumentException("Attempt to store pick with no sample ID");
        }
        if (this.informalName != null && this.surface != null && this.informalName.equals(this.surface.getName())) {
            this.informalName = null;
        }
        String sql = "INSERT INTO " + this.sbdb.DBTableName("sqpick") + " (well_id,interp_id,surface_id,inf,samp_id,bnd,qualifier,observed," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + surfaceID + "," + SB.DBString((String)this.informalName) + "," + sampID + "," + this.bnd + "," + (this.questionable ? "'?'" : "NULL") + "," + SB.DBString((String)(this.observed ? "Y" : "N")) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        this.status = STORED;
    }

    @Override
    public void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to SQPick.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Audit tempAudit = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("sqpick") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND surface_id=" + this.surface.getSurfaceID() + " AND interp_id=" + interpID;
            int nUpdated = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nUpdated != 1) {
                throw new SBException("Cannot update sequence pick: " + String.valueOf(this));
            }
        }
        this.audit = tempAudit;
    }

    public int getSurfaceID() {
        return this.surface.getSurfaceID();
    }

    public int getSampID() {
        return this.sample.getSampID();
    }

    public boolean isQuestionable() {
        return this.questionable;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public String getModifierString() throws SQLException, SBException {
        return this.sbdb.getUser(this.audit.modifier).getAbr();
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    @Override
    public Date getUpdated() {
        return this.audit.updated;
    }

    public String getSortEntry() {
        return this.sample.getSortEntry() + "-" + this.surface.toString().toUpperCase();
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.surface.getName();
    }

    @Override
    public List<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<SequencePick>\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<SampleID>" + this.sample.getSampID() + "</SampleID>\n");
        out.write(ind + "<SurfaceID>" + this.surface.getSurfaceID() + "</SurfaceID>\n");
        out.write(ind + "<SchemeID>" + this.surface.getSchID() + "</SchemeID>\n");
        out.write(ind + "<Name>" + SB.getXMLstring((String)(this.informalName != null && this.informalName.length() > 0 ? this.informalName : this.surface.getName())) + "</Name>\n");
        if (this.questionable) {
            out.write(ind + "<Questionable>" + this.questionable + "</Questionable>\n");
        }
        out.write(ind + "<Boundary>" + this.getBnd() + "</Boundary>\n");
        out.write(ind + "<Observed>" + this.observed + "</Observed>\n");
        LinkedList<Integer> users = this.audit.writeXML(out, indent + 3);
        out.write(ind1 + "</SequencePick>\n");
        return users;
    }

    public SQPick(SBdb db, Well well, Element xml) throws SQLException, SBException, ParseException {
        this.sbdb = db;
        String strg = xml.getChildTextNormalize("SampleID");
        if (strg != null) {
            int sampID = Integer.parseInt(strg);
            this.sample = well.getSample(sampID, true);
            if (this.sample == null) {
                throw new SBException("Cannot find Top Sample in Pick for ID: " + sampID);
            }
        }
        int surfaceID = 0;
        strg = xml.getChildTextNormalize("SurfaceID");
        if (strg != null) {
            surfaceID = Integer.parseInt(strg);
        }
        int schemeID = 0;
        strg = xml.getChildTextNormalize("SchemeID");
        if (strg == null) {
            throw new SBException("No surface scheme specified for Pick: " + String.valueOf(this.sample));
        }
        schemeID = Integer.parseInt(strg);
        this.surface = db.getIGDScheme(schemeID).getSurface(surfaceID);
        if (this.surface == null) {
            throw new SBException("No surface specified for Pick: " + String.valueOf(this.sample));
        }
        strg = xml.getChildTextNormalize("Name");
        if (strg != null && strg.length() > 0 && !strg.equalsIgnoreCase(this.surface.getName())) {
            this.informalName = strg;
        }
        if ((strg = xml.getChildTextNormalize("Questionable")) != null) {
            this.questionable = Boolean.parseBoolean(strg);
        }
        if ((strg = xml.getChildTextNormalize("Boundary")) != null) {
            this.bnd = IGDIntervalZone.getBoundaryTypeFromString(strg);
        }
        this.observed = (strg = xml.getChildTextNormalize("Observed")) != null ? Boolean.parseBoolean(strg) : true;
        Element el = xml.getChild("Audit");
        if (el != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for pick: " + String.valueOf(this));
        }
    }

    void updateStatus(List<SQPick> picks) throws SBException {
        if (this.sample != null) {
            // empty if block
        }
        this.status = NOTSTORED;
        for (SQPick pick : picks) {
            if (pick == this || !this.isFuncEquivalent(pick)) continue;
            this.status = STORED;
            if (!pick.surface.getName().trim().equals(this.surface.getName().trim())) {
                this.status = CONFLICT;
                break;
            }
            if (pick.surface.getType() != this.surface.getType()) {
                this.status = CONFLICT;
                break;
            }
            if (pick.getBndInt() != this.getBndInt()) {
                this.status = CONFLICT;
                break;
            }
            if (pick.questionable != this.questionable) {
                this.status = CONFLICT;
                break;
            }
            if (!(pick.getInfName() == null || pick.getInfName().equals(this.informalName) || pick.getInfName().equals(pick.getSurface().getName()) && this.informalName.equals(this.surface.getName()))) {
                this.status = CONFLICT;
                break;
            }
            if (pick.observed == this.observed) break;
            this.status = CONFLICT;
            break;
        }
    }

    @Override
    public boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof SQPick) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            SQPick comp = (SQPick)e;
            if (this.sample.isFuncEquivalent(comp.getSample()) && comp.getSurface() == this.surface) {
                return true;
            }
        }
        return false;
    }

    public void setInfName(String newInfName) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set informal name on database pick: " + String.valueOf(this));
        }
        if (newInfName == null) {
            newInfName = "";
        }
        System.out.println("Changing informal name for pick: " + String.valueOf(this) + " to: " + newInfName);
        this.informalName = newInfName;
    }

    public String getSchemeName() throws SQLException {
        return this.getSchemeName(false);
    }

    public String getSchemeName(boolean useLink) throws SQLException {
        if (this.surface == null) {
            return "Surface null";
        }
        if (this.surface.getSchID() > 0) {
            IGDScheme scheme;
            if (this.sbdb != null && (scheme = this.sbdb.getIGDScheme(this.surface.getSchID())) != null) {
                if (useLink && scheme.getLink() != null) {
                    return scheme.getLink().toString();
                }
                return scheme.toString();
            }
            return "Scheme ID = " + this.surface.getSchID();
        }
        return "";
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for SQPick: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    private SQPick(Builder builder) {
        this.sbdb = builder.sbdb;
        this.surface = builder.surface;
        this.sample = builder.sample;
        this.bnd = builder.bnd;
        this.informalName = builder.informalName;
        this.questionable = builder.questionable;
        this.observed = builder.observed;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    @Override
    public Sample getBaseSample() {
        return null;
    }

    @Override
    public Discipline getDiscipline() {
        return null;
    }

    @Override
    public int getSchID() {
        return this.surface.getSchID();
    }

    @Override
    public void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDesc() {
        return "sequence pick";
    }

    @Override
    public String getItemDescPlural() {
        return "sequence picks";
    }

    public static class Builder {
        private final SBdb sbdb;
        private final Surface surface;
        private final Sample sample;
        private String informalName = "";
        private boolean questionable = false;
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;
        private int bnd = 0;
        private boolean observed = true;

        public Builder(SBdb sbdb, Surface surface, Sample sample, int bnd) {
            this.sbdb = sbdb;
            this.sample = sample;
            this.surface = surface;
            if (bnd == 0) {
                bnd = surface.getBndDefault();
            }
            this.bnd = bnd;
        }

        public static Builder copyOf(SQPick rhs) {
            Builder builder = new Builder(rhs.sbdb, rhs.surface, rhs.sample, rhs.bnd);
            builder.informalName(rhs.informalName).questionable(rhs.questionable).audit(rhs.audit).observed(rhs.observed);
            return builder;
        }

        public static Builder copyOf(SQPick rhs, Sample newSample) {
            Builder builder = new Builder(rhs.sbdb, rhs.surface, newSample, rhs.bnd);
            builder.informalName(rhs.informalName).questionable(rhs.questionable).observed(rhs.observed);
            builder.audit = rhs.audit;
            return builder;
        }

        public Builder informalName(String informalName) {
            if (informalName != null && !informalName.isEmpty()) {
                this.informalName = informalName;
            }
            return this;
        }

        public Builder questionable(boolean questionable) {
            this.questionable = questionable;
            return this;
        }

        public Builder observed(boolean observed) {
            this.observed = observed;
            return this;
        }

        public Builder bnd(int bnd) {
            if (bnd >= 0) {
                this.bnd = bnd;
            }
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
                this.status = SbugsStatus.STORED;
            }
            return this;
        }

        public SQPick build() {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to build SQPick with null data model");
            }
            if (this.sample == null) {
                throw new IllegalStateException("Attempt to build SQPick with null sample");
            }
            if (this.surface == null) {
                throw new IllegalStateException("Attempt to build SQPick with null surface");
            }
            if (this.bnd < 0) {
                throw new IllegalStateException("Attempt to build SQPick with illgal bnd: " + this.bnd);
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new SQPick(this);
        }

        public SQPick build(int wellID, int interpID) throws SQLException {
            if (this.status == SbugsStatus.STORED) {
                System.out.println("WARNING: building SQPick with store, builder has stored status");
            }
            SQPick pick = this.build();
            pick.store(wellID, interpID);
            return pick;
        }

        public Sample getSample() {
            return this.sample;
        }

        public boolean isObserved() {
            return this.observed;
        }

        public Surface getSurface() {
            return this.surface;
        }
    }
}

