/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model3.Audit;
import model3.LASFile;
import model3.Lithology;
import model3.SBdb;
import model3.Sample;
import model3.SampleLithologyUnit;
import model3.WsLithology;
import model3.WsWell;
import util.DepthUtils;
import util.SBException;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class SampleLithology
implements SbugsStatus {
    Color status = UNKNOWN;
    List<SampleLithologyUnit> lithology = new LinkedList<SampleLithologyUnit>();

    SampleLithology() {
    }

    public List<SampleLithologyUnit> getLithology() {
        return this.lithology;
    }

    void add(SampleLithologyUnit unit) {
        this.lithology.add(unit);
        Collections.sort(this.lithology);
    }

    void store(int wellID, int sampID, SBdb db) throws SQLException, SBException {
        this.checkTotal();
        Statement stmt = db.getDatabase().createStatement();
        Object sql = "";
        for (SampleLithologyUnit unit : this.lithology) {
            sql = "INSERT INTO " + db.DBTableName("SBSLITH") + " (well_id,samp_id,lith_id,percnt," + Audit.sqlFieldString() + ") VALUES(" + wellID + "," + sampID + "," + unit.getDescription().getLithID() + "," + unit.getPercent() + "," + unit.getAudit().sqlInsert(db, stmt) + ")";
            stmt.executeUpdate(db.modQuery((String)sql));
        }
        stmt.close();
    }

    void updateLithology(List<SampleLithologyUnit> liths, int wellID, int sampID, SBdb db) throws SQLException, SBException {
        LinkedList<SampleLithologyUnit> newLiths = new LinkedList<SampleLithologyUnit>();
        this.lithology.clear();
        SampleLithology.clear(db, wellID, sampID);
        for (SampleLithologyUnit lith : liths) {
            Lithology desc;
            if (lith.getDescription() instanceof WsLithology) {
                WsLithology wslith = (WsLithology)lith.getDescription();
                desc = wslith.getLink();
            } else {
                desc = lith.getDescription();
            }
            SampleLithologyUnit newLith = new SampleLithologyUnit(db, desc, lith.getPercent());
            newLiths.add(newLith);
        }
        this.lithology = newLiths;
        Collections.sort(this.lithology);
        this.store(wellID, sampID, db);
    }

    static void clear(SBdb SB2, int wellID, int sampID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("SBSLITH") + " WHERE well_id=" + wellID + " AND samp_id=" + sampID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    private void checkTotal() throws SBException {
        int total = 0;
        for (SampleLithologyUnit unit : this.lithology) {
            if ((total += unit.getPercent()) <= 100) continue;
            throw new SBException("Attempt to store sample lithology with total > 100%");
        }
    }

    public Color getStatus(SampleLithology lith) {
        MergeStatus m = new MergeStatus(STORED);
        if (lith == null || lith.getLithology().isEmpty()) {
            this.status = NOTSTORED;
            return this.status;
        }
        m.compareStringField("Name", this.toString(), lith.toString(), true);
        this.status = m.getStatus();
        return this.status;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        Object strg = "";
        Collections.sort(this.lithology);
        for (SampleLithologyUnit unit : this.lithology) {
            strg = (String)strg + (!((String)strg).isEmpty() ? ", " : "") + String.valueOf(unit.getDescription());
            strg = (String)strg + " " + unit.getPercent() + "%";
        }
        return strg;
    }

    public void discardUnmatched() {
        LinkedList<SampleLithologyUnit> toKill = new LinkedList<SampleLithologyUnit>();
        for (SampleLithologyUnit unit : this.lithology) {
            WsLithology wslith;
            if (!(unit.getDescription() instanceof WsLithology) || (wslith = (WsLithology)unit.getDescription()).getLink() != null) continue;
            toKill.add(unit);
        }
        for (SampleLithologyUnit kill : toKill) {
            this.lithology.remove(kill);
        }
    }

    public static void readLAS(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample.Builder> samples, float interval, boolean useSampleTops, SampleType type) throws IOException, SBException, SQLException {
        LASFile lasFile = new LASFile(fileName);
        boolean[] requiredCurves = new boolean[lasFile.nCurves];
        LinkedList<WsLithology> liths = new LinkedList<WsLithology>();
        for (int i = 0; i < lasFile.nCurves; ++i) {
            LASFile.CurveHeader header = (LASFile.CurveHeader)lasFile.curveHeaders.get(i);
            if (header.units != null && header.units.equalsIgnoreCase("V/V")) {
                requiredCurves[i] = true;
                WsLithology lith = new WsLithology(header.mnem, -1);
                liths.add(lith);
                continue;
            }
            requiredCurves[i] = false;
        }
        double depth = 0.0;
        double lastDepth = 0.0;
        LinkedList<SampleLithologyUnit> lastUnits = null;
        int nDepthsInInterval = 0;
        for (Object o : lasFile.depths) {
            int i;
            LASFile.LogValue record = (LASFile.LogValue)o;
            LinkedList<SampleLithologyUnit> slithUnits = null;
            int curveIndex = 0;
            for (i = 0; i < lasFile.nCurves; ++i) {
                depth = record.depth;
                if (!requiredCurves[i]) continue;
                double colValue = record.values[i] * 100.0;
                if (slithUnits == null) {
                    slithUnits = new LinkedList<SampleLithologyUnit>();
                }
                slithUnits.add(new SampleLithologyUnit((Lithology)liths.get(curveIndex), (int)colValue));
                ++curveIndex;
            }
            if (lastDepth == 0.0) {
                lastDepth = depth;
            }
            if (slithUnits == null || SampleLithology.lithEqual(slithUnits, lastUnits) && !(depth - lastDepth >= (double)interval)) continue;
            if (depth - lastDepth < (double)interval) {
                if (lastUnits != null && nDepthsInInterval > 0) {
                    LinkedList<SampleLithologyUnit> averaged = new LinkedList<SampleLithologyUnit>();
                    for (i = 0; i < slithUnits.size(); ++i) {
                        SampleLithologyUnit s = (SampleLithologyUnit)slithUnits.get(i);
                        if (i >= lastUnits.size()) break;
                        SampleLithologyUnit l = (SampleLithologyUnit)lastUnits.get(i);
                        float sPercent = (float)s.getPercent() + (float)l.getPercent() * (float)nDepthsInInterval / (float)(nDepthsInInterval + 1);
                        SampleLithologyUnit replacement = new SampleLithologyUnit(s.getDescription(), (int)sPercent);
                        averaged.add(replacement);
                    }
                    lastUnits = averaged.size() == slithUnits.size() ? averaged : slithUnits;
                }
                ++nDepthsInInterval;
                continue;
            }
            if (interval > 0.0f) {
                depth = (double)Math.round(depth / (double)interval) * (double)interval;
            }
            double mDepth = DepthUtils.convToM((double)depth, (char)lasFile.depthUnits);
            Sample.Builder builder = new Sample.Builder().type(type);
            if (useSampleTops) {
                builder.topDepth(mDepth);
            } else {
                builder.baseDepth(mDepth);
            }
            samples.add(builder);
            for (SampleLithologyUnit unit : slithUnits) {
                if (unit.getPercent() <= 0) continue;
                builder.sampleLithology.add(unit);
            }
            lastDepth = depth;
            lastUnits = slithUnits;
        }
        if (liths != null) {
            lithList.addAll(liths);
        }
    }

    public static void readFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample.Builder> samples, boolean singleDepth, float interval, char units, boolean useSampleTops, SampleType type) throws IOException, SBException, SQLException {
        if (singleDepth) {
            SampleLithology.readSingleDepthFile(fileName, sbdb, well, lithList, samples, units, interval, useSampleTops, type);
        } else {
            SampleLithology.readDualDepthFile(fileName, sbdb, well, lithList, samples, units, type);
        }
    }

    private static void readSingleDepthFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample.Builder> samples, char units, float interval, boolean useSampleTops, SampleType type) throws IOException, SBException, SQLException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        WsLithology[] wsLiths = null;
        while ((buff = in.readLine()) != null) {
            if (!buff.trim().toUpperCase().startsWith("DEPTH")) continue;
            wsLiths = SampleLithology.parseFileColumns(buff);
            break;
        }
        double depth = 0.0;
        double lastDepth = 0.0;
        LinkedList<SampleLithologyUnit> lastUnits = null;
        int nDepthsInInterval = 0;
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(buff, " ,\t");
            int column = 0;
            LinkedList<SampleLithologyUnit> slithUnits = null;
            while (tok.hasMoreTokens()) {
                float colValue = Float.parseFloat(tok.nextToken().trim());
                if (column == 0) {
                    depth = colValue;
                } else if (wsLiths[column] != null) {
                    if (slithUnits == null) {
                        slithUnits = new LinkedList<SampleLithologyUnit>();
                    }
                    slithUnits.add(new SampleLithologyUnit(wsLiths[column], (int)colValue));
                }
                ++column;
            }
            if (lastDepth == 0.0) {
                lastDepth = depth;
            }
            if (slithUnits == null || SampleLithology.lithEqual(slithUnits, lastUnits) && !(depth - lastDepth >= (double)interval)) continue;
            if (depth - lastDepth < (double)interval) {
                if (lastUnits != null && nDepthsInInterval > 0) {
                    LinkedList<SampleLithologyUnit> averaged = new LinkedList<SampleLithologyUnit>();
                    for (int i = 0; i < slithUnits.size(); ++i) {
                        SampleLithologyUnit s = (SampleLithologyUnit)slithUnits.get(i);
                        if (i >= lastUnits.size()) break;
                        SampleLithologyUnit l = (SampleLithologyUnit)lastUnits.get(i);
                        float sPercent = (float)s.getPercent() + (float)l.getPercent() * (float)nDepthsInInterval / (float)(nDepthsInInterval + 1);
                        SampleLithologyUnit replacement = new SampleLithologyUnit(s.getDescription(), (int)sPercent);
                        averaged.add(replacement);
                    }
                    lastUnits = averaged.size() == slithUnits.size() ? averaged : slithUnits;
                }
                ++nDepthsInInterval;
                continue;
            }
            if (interval > 0.0f) {
                depth = (double)Math.round(depth / (double)interval) * (double)interval;
            }
            double mDepth = DepthUtils.convToM((double)depth, (char)units);
            Sample.Builder builder = new Sample.Builder().type(type);
            if (useSampleTops) {
                builder.topDepth(mDepth);
            } else {
                builder.baseDepth(mDepth);
            }
            samples.add(builder);
            for (SampleLithologyUnit unit : slithUnits) {
                if (unit.getPercent() <= 0) continue;
                builder.sampleLithology.add(unit);
            }
            lastDepth = depth;
            lastUnits = slithUnits;
        }
        in.close();
        if (wsLiths != null) {
            for (int i = 0; i < wsLiths.length; ++i) {
                WsLithology wsLith = wsLiths[i];
                if (wsLith == null) continue;
                lithList.add(wsLith);
            }
        }
    }

    public static void readDualDepthFile(String fileName, SBdb sbdb, WsWell well, LinkedList<WsLithology> lithList, LinkedList<Sample.Builder> samples, char units, SampleType type) throws IOException, SBException, SQLException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        WsLithology[] wsLiths = null;
        while ((buff = in.readLine()) != null) {
            if (!buff.trim().toUpperCase().startsWith("TOP")) continue;
            wsLiths = SampleLithology.parseFileColumns(buff);
            break;
        }
        float topDepth = 0.0f;
        float baseDepth = 0.0f;
        LinkedList<SampleLithologyUnit> slithUnits = null;
        while ((buff = in.readLine()) != null) {
            StringTokenizer tok = new StringTokenizer(buff, " ,\t");
            int column = 0;
            slithUnits = null;
            while (tok.hasMoreTokens()) {
                float colValue = Float.parseFloat(tok.nextToken().trim());
                if (column == 0) {
                    topDepth = colValue;
                } else if (column == 1) {
                    baseDepth = colValue;
                } else if (colValue > 1.0f && wsLiths[column] != null) {
                    if (slithUnits == null) {
                        slithUnits = new LinkedList<SampleLithologyUnit>();
                    }
                    slithUnits.add(new SampleLithologyUnit(wsLiths[column], (int)colValue));
                }
                ++column;
            }
            if (slithUnits == null) continue;
            double mTopDepth = DepthUtils.convToM((float)topDepth, (char)units);
            double mBaseDepth = DepthUtils.convToM((float)baseDepth, (char)units);
            Sample.Builder builder = new Sample.Builder().type(type).topDepth(mTopDepth).baseDepth(mBaseDepth);
            samples.add(builder);
            for (SampleLithologyUnit unit : slithUnits) {
                builder.sampleLithology.add(unit);
            }
        }
        in.close();
        if (wsLiths != null) {
            for (int i = 0; i < wsLiths.length; ++i) {
                WsLithology wsLith = wsLiths[i];
                if (wsLith == null) continue;
                lithList.add(wsLith);
            }
        }
    }

    static WsLithology[] parseFileColumns(String buff) throws SBException, SQLException {
        StringTokenizer tok = new StringTokenizer(buff, " ,\t");
        LinkedList<WsLithology> liths = new LinkedList<WsLithology>();
        while (tok.hasMoreTokens()) {
            String strg = tok.nextToken().trim().toUpperCase();
            WsLithology lith = null;
            lith = strg.equalsIgnoreCase("DEPTH") ? null : (strg.equalsIgnoreCase("TOP") ? null : (strg.equalsIgnoreCase("BASE") ? null : (strg.equalsIgnoreCase("NODE") ? null : (strg.equalsIgnoreCase("NOSA") ? null : new WsLithology(strg, -1)))));
            liths.add(lith);
        }
        WsLithology[] lithArray = new WsLithology[liths.size()];
        for (int i = 0; i < liths.size(); ++i) {
            lithArray[i] = (WsLithology)liths.get(i);
        }
        return lithArray;
    }

    static boolean lithEqual(LinkedList<SampleLithologyUnit> lith1, LinkedList<SampleLithologyUnit> lith2) {
        if (lith1 != null && lith2 == null) {
            return false;
        }
        if (lith1.size() != lith2.size()) {
            return false;
        }
        for (int i = 0; i < lith1.size(); ++i) {
            SampleLithologyUnit slith1 = lith1.get(i);
            SampleLithologyUnit slith2 = lith2.get(i);
            if (!slith1.getDescription().equals(slith2.getDescription())) {
                return false;
            }
            if (slith1.getPercent() == slith2.getPercent()) continue;
            return false;
        }
        return true;
    }
}

