/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.taxon.TaxonQual;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import model3.ConnectionProvider;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;
import util.SB;
import util.SBException;

public class Source {
    private final String ID;
    private String name;

    public Source(SBdb db, String abr, String name) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "INSERT INTO " + db.DBTableName("source") + " ( source_id, txt ) VALUES (" + SB.DBString((String)abr) + "," + SB.DBString((String)name) + ")";
            stmt.executeUpdate(db.modQuery(sql));
        }
        this.ID = abr;
        this.name = name;
    }

    private Source(String ID, String name) {
        this.ID = ID;
        this.name = name;
    }

    public void delete(SBdb db) throws SQLException {
        String[] tables = new String[]{"TXLOAD", "ENVTRN", "EVLOAD", "SOURCE"};
        try (Statement stmt = db.getDatabase().createStatement();){
            for (String table : tables) {
                stmt.executeUpdate(db.modQuery("DELETE FROM " + db.DBTableName(table) + " WHERE source_id =" + SB.DBString((String)this.ID)));
            }
        }
    }

    public void deleteMatch(SBdb db, String txt) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "DELETE FROM " + db.DBTableName("txload") + " WHERE txt=" + SB.DBString((String)txt) + " AND source_id=" + SB.DBString((String)this.ID);
            stmt.executeUpdate(db.modQuery(sql));
        }
    }

    public String getID() {
        return this.ID;
    }

    public int getNEnvs(SBdb db) throws SQLException {
        int n;
        try (Statement stmt = db.getDatabase().createStatement();){
            n = 0;
            String sql = "SELECT count(source_id) AS nEnv FROM " + db.DBTableName("envtrn") + " WHERE source_id=" + SB.DBString((String)this.ID);
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                n = rs.getInt("nEnv");
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getTaxon(SBdb db, Statement stmt, Taxon taxon) throws SQLException, SBException {
        boolean deleteStatement = false;
        if (stmt == null) {
            stmt = db.getDatabase().createStatement();
            deleteStatement = true;
        }
        try {
            String[] donorString = new String[2];
            donorString[0] = taxon.donorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
            if (taxon.noAuthorDonorString != null) {
                donorString[1] = taxon.noAuthorDonorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
            }
            for (int i = 0; i < donorString.length; ++i) {
                if (donorString[i] == null || donorString[i].isEmpty()) continue;
                String sql = "SELECT spec_id,occ_type FROM " + db.DBTableName("TXLOAD") + " WHERE source_id=" + SB.DBString((String)this.ID) + " AND ucase(txt)=" + SB.DBString((String)donorString[i]);
                try (ResultSet rs = stmt.executeQuery(db.modQuery(sql));){
                    if (!rs.next()) continue;
                    taxon.setLink(db.getTaxon(rs.getInt("spec_id")));
                    taxon.setDonorOccType(rs.getString("occ_type"));
                    break;
                }
            }
        }
        finally {
            if (deleteStatement) {
                stmt.close();
            }
        }
    }

    public void matchEvents(SBdb db, Collection<SBEvent> wsEvents) throws SQLException {
        String sql = "SELECT ev_id FROM " + db.DBTableName("EVLOAD") + " WHERE source_id=" + SB.DBString((String)this.ID) + " AND ucase(txt)=?";
        try (PreparedStatement pStmt = db.getDatabase().prepareStatement(db.modQuery(sql));){
            for (SBEvent event : wsEvents) {
                if (event.getLink() != null) continue;
                pStmt.setString(1, event.getName().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
                ResultSet rs = pStmt.executeQuery();
                if (!rs.next()) continue;
                event.setLink(db.getSBEvent(rs.getInt("ev_id")));
            }
        }
    }

    public int getnTxload(SBdb db) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "SELECT count(source_id) AS n FROM " + db.DBTableName("txload") + " WHERE source_id=" + SB.DBString((String)this.ID);
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            if (rs.next()) {
                int n = rs.getInt("n");
                return n;
            }
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(SBdb db, String name) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "UPDATE " + db.DBTableName("SOURCE") + " SET txt=" + SB.DBString((String)name) + " WHERE source_id=" + SB.DBString((String)this.ID);
            stmt.executeUpdate(sql);
            this.name = name;
        }
    }

    public static List<Source> getSources(SBdb db) throws SQLException {
        LinkedList<Source> list = new LinkedList<Source>();
        String sql = "SELECT source_id, txt FROM " + db.DBTableName("SOURCE") + " ORDER BY source_id";
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                list.add(new Source(rs.getString("source_id"), rs.getString("txt")));
            }
        }
        return list;
    }

    public void loadMatches(SBdb db, List<Taxon> taxa, List<String> donor) throws SQLException, SBException {
        String sql = "SELECT spec_id,txt FROM " + db.DBTableName("TXLOAD") + " WHERE source_id=" + SB.DBString((String)this.ID) + " ORDER BY txt";
        Statement stmt = db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(db.modQuery(sql));
        while (rs.next()) {
            taxa.add(db.getTaxon(rs.getInt("spec_id")));
            donor.add(rs.getString("txt"));
        }
        stmt.close();
        if (taxa.size() != donor.size()) {
            throw new SBException("Missing taxon in source match list");
        }
        stmt.close();
    }

    public void storeMatch(ConnectionProvider db, Taxon wsTaxon, String donorOccType) throws SQLException {
        Source.storeTaxonMatch(this.ID, wsTaxon, wsTaxon.getDonorString(), donorOccType, db);
    }

    private static void storeTaxonMatch(String sourceID, Taxon wsTaxon, String donorString, String donorOccType, ConnectionProvider db) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            Taxon link;
            String sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + SB.DBString((String)donorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            if (nRows == 0) {
                sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND txt=" + SB.DBString((String)donorString);
                stmt.executeUpdate(db.modQuery(sql));
            }
            if (wsTaxon.getLink() != null && (!donorString.equals((link = wsTaxon.getLink()).getTaxonCopy().toString(false, false, false, true)) || !link.getCatMnem().equals(wsTaxon.getCatMnem()) || TaxonQual.containsQualifier((String)donorString) || !link.getSubGenus().isBlank() || wsTaxon.getSubGenus() != null && !wsTaxon.getSubGenus().isBlank() && link.getSubGenus().isBlank() || link.getSubSpecies() != null && !link.getSubSpecies().isBlank())) {
                sql = "INSERT INTO " + db.DBTableName("TXLOAD") + " (source_id,spec_id,txt,occ_type) VALUES('" + sourceID + "'," + link.getSpecID() + "," + SB.DBString((String)donorString) + "," + SB.DBString((String)donorOccType) + ")";
                stmt.executeUpdate(db.modQuery(sql));
            }
        }
    }

    public void storeMatch(SBdb db, SBEvent event) throws SQLException {
        event.storeMatch(db, this.ID);
    }

    public String toString() {
        return this.ID;
    }
}

