/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import model3.Audit;
import model3.Genus;
import model3.SBRestrictable;
import model3.SBdb;
import model3.Taxon;
import model3.project.ProjectMember;
import model3.taxa.GenusListener;
import org.jdom2.Element;
import util.ColourUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.SortEntry;
import util.exception.StackError;
import util.status.SbugsStatus;

public class TxGroup
extends SBRestrictable
implements Comparable<TxGroup>,
SortEntry,
SbugsStatus,
ProjectMember,
SbugsLink,
GenusListener {
    private static final int DISC_THRESHOLD = 95;
    private final SBdb sbdb;
    private final int ID;
    private String name = "";
    private String abr = "";
    private Color colour = Color.WHITE;
    private String descr = null;
    private Audit audit = new Audit();
    private int projID;
    Color status = UNKNOWN;
    private static final Logger LOGGER = Logger.getLogger(TxGroup.class.getName());
    private Set<Integer> specIDs;
    private Set<Integer> genIDs;
    private TxGroup link;
    private Character discipline;

    private TxGroup(SBdb sbdb, int ID, String name, String abr, Color colour, int projID, String descr, Audit audit) throws SQLException {
        super("TXGROUP", "GRP_ID", false);
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group with ID: " + ID);
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group with null data model");
        }
        this.sbdb = sbdb;
        this.ID = ID;
        this.projID = projID;
        if (name != null) {
            this.name = name;
        }
        if (abr != null) {
            this.abr = abr;
        }
        if (colour != null) {
            this.colour = colour;
        }
        if (descr != null && descr.isEmpty()) {
            descr = null;
        }
        this.descr = descr;
        this.audit = audit != null ? audit : new Audit();
    }

    TxGroup(SBdb sbdb, String name, String abr, int ID, int projID, Color colour) throws SQLException, SBPermissionException {
        super("TXGROUP", "GRP_ID", false);
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group with ID: " + ID);
        }
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group with null data model");
        }
        this.sbdb = sbdb;
        this.ID = ID;
        this.name = name;
        this.abr = abr;
        this.projID = projID;
        this.colour = colour;
        this.initCollections();
        if (sbdb.isConnected()) {
            this.store();
        }
        this.setAcm(0);
    }

    private void initCollections() {
        ConcurrentHashMap speciesMap = new ConcurrentHashMap();
        this.specIDs = Collections.newSetFromMap(speciesMap);
        ConcurrentHashMap generaMap = new ConcurrentHashMap();
        this.genIDs = Collections.newSetFromMap(generaMap);
    }

    private void store() throws SQLException, SBPermissionException {
        if (this.ID <= 0) {
            throw new IllegalArgumentException("Attempt to store TxGroup with ID: " + this.ID);
        }
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException("No permission to store taxon group");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + this.sbdb.DBTableName("TXGROUP") + " (grp_id,name,proj_id,descr,colour," + Audit.sqlFieldString() + ") VALUES (" + this.ID + "," + SB.DBString((String)this.name) + "," + String.valueOf(this.projID > 0 ? Integer.valueOf(this.projID) : "NULL") + "," + (this.descr != null ? SB.DBString((String)this.descr) : "NULL") + "," + ColourUtils.DBColourString((Color)this.colour, (boolean)false, (boolean)true) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    static TxGroup copyToDatabase(SBdb ws, SBdb db, TxGroup wsGroup, int dbProjID) throws SQLException, SBException, SBPermissionException {
        Audit audit;
        if (ws.isConnected() || !db.isConnected()) {
            throw new IllegalArgumentException("Incorrect data model arguments to TxGroup.copyToDatabase");
        }
        int ID = TxGroup.nextControl(db);
        try {
            audit = new Audit(db, ws, wsGroup.getAudit());
        }
        catch (Exception e) {
            e.printStackTrace();
            audit = new Audit();
        }
        TxGroup dbGroup = new TxGroup(db, ID, wsGroup.getName(), wsGroup.getAbr(), wsGroup.getColour(), dbProjID, wsGroup.descr, audit);
        LinkedList<Taxon> dbTaxa = new LinkedList<Taxon>();
        for (Taxon taxon : ws.getTxGroupTaxa(wsGroup, false)) {
            if (taxon.getLink() == null) {
                throw new SBException("Cannot save: taxon: " + String.valueOf(taxon) + " not linked");
            }
            dbTaxa.add(taxon.getLink());
        }
        LinkedList<Genus> dbGenera = new LinkedList<Genus>();
        for (Genus genus : ws.getTxGroupGenera(wsGroup)) {
            if (genus.getLink() == null) {
                throw new SBException("Cannot save: genus: " + String.valueOf(genus) + " not in database");
            }
            dbGenera.add(genus.getLink());
        }
        dbGroup.store();
        dbGroup.addTaxa(dbTaxa);
        dbGroup.addGenera(dbGenera);
        return dbGroup;
    }

    static TxGroup copyToWorkspace(SBdb ws, TxGroup dbGroup) throws SQLException, SBException {
        if (ws.isConnected() || !dbGroup.sbdb.isConnected()) {
            throw new IllegalArgumentException("Incorrect data model arguments to TxGroup.copyToDatabase");
        }
        TxGroup group = new TxGroup(ws, dbGroup.ID, dbGroup.name, dbGroup.abr, dbGroup.colour, 0, dbGroup.descr, new Audit(dbGroup.audit));
        group.setAcm(0);
        group.load();
        dbGroup.audit.fillWorkspace(dbGroup.sbdb, ws);
        return group;
    }

    private TxGroup(SBdb sbdb, int ID) throws SQLException {
        super("TXGROUP", "GRP_ID", false);
        this.ID = ID;
        this.sbdb = sbdb;
        String sql = "SELECT name,abr,proj_id,descr,colour," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("TXGROUP") + " WHERE grp_id=" + ID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                this.name = rs.getString("name");
                this.abr = rs.getString("abr");
                this.projID = rs.getInt("proj_id");
                this.descr = rs.getString("descr");
                this.colour = ColourUtils.getDBColour((String)rs.getString("colour"));
                this.audit = new Audit(rs);
                this.setAcm(rs.getInt("acm"));
            }
        }
    }

    @Override
    public int getID() {
        return this.ID;
    }

    public String statusString() {
        return this.name;
    }

    public Color getStatus() {
        return this.status;
    }

    @Override
    public int compareTo(TxGroup rhs) {
        return this.name.compareToIgnoreCase(rhs.name);
    }

    public int getSize() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return this.specIDs.size();
    }

    public int getGenSize() throws SQLException {
        if (this.genIDs == null) {
            this.load();
        }
        return this.genIDs.size();
    }

    public int getSpecSize() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        int size = this.specIDs.size();
        for (int genID : this.genIDs) {
            size -= this.sbdb.getTaxonService().getTaxonCountForGenus(genID);
        }
        return size;
    }

    public Set<Integer> getSpecIDs() throws SQLException {
        if (this.specIDs == null) {
            this.load();
        }
        return new HashSet<Integer>(this.specIDs);
    }

    public Set<Integer> getGenIDs() throws SQLException {
        if (this.genIDs == null) {
            this.load();
        }
        return new HashSet<Integer>(this.genIDs);
    }

    public String getName() {
        return this.name;
    }

    public String getDescr() {
        return this.descr;
    }

    public String getSortEntry() {
        if (this.link != null) {
            return this.link.getName();
        }
        if (!this.sbdb.isConnected()) {
            return "*****" + this.name;
        }
        return this.name;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public TxGroup getLink() {
        return this.link;
    }

    public void setLink(TxGroup link) {
        this.link = link;
    }

    public String toString() {
        return this.name;
    }

    public void setColour(Color colour) throws SQLException, SBPermissionException, SBException {
        if (this.colour == null && colour != null || this.colour != null && !this.colour.equals(colour)) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                this.updateDetails(this.name, colour, this.projID, this.descr);
            }
            this.colour = colour;
            this.setChanged();
            this.notifyObservers(colour);
        }
    }

    void delete() throws SQLException, SBPermissionException, SBException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String[] sqls;
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBPermissionException("Attempt to delete read-only group");
            }
            for (String sql : sqls = new String[]{"DELETE FROM " + this.sbdb.DBTableName("TXGROUP_ACL") + " WHERE grp_id=" + this.ID, "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID, "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE grp_id=" + this.ID}) {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("TXGROUP") + " WHERE grp_id=" + this.ID;
            int nDel = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nDel != 1) {
                throw new SBException("Error deleting TxGroup : no group deleted");
            }
        }
    }

    public void updateDetails(String newName, Color colour, int projID, String descr) throws SQLException, SBException, SBPermissionException {
        if (descr != null && (descr = descr.trim()).isEmpty()) {
            descr = null;
        }
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group", true));
                }
                Audit temp = new Audit(this.audit);
                String sql = "UPDATE " + this.sbdb.DBTableName("txgroup") + " SET name=" + SB.DBString((String)newName) + ",proj_id=" + String.valueOf(projID > 0 ? Integer.valueOf(projID) : "NULL") + ",descr=" + (descr != null ? SB.DBString((String)descr) : "NULL") + ",colour=" + ColourUtils.DBColourString((Color)colour, (boolean)false, (boolean)true) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE grp_id=" + this.ID;
                if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                    throw new SBException("Cannot update group: " + this.name);
                }
                this.audit = temp;
            }
        }
        this.name = newName;
        this.colour = colour;
        this.projID = projID;
        this.descr = descr;
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public void setName(String newName) throws SQLException, SBException, SBPermissionException {
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException("Attempt to update read-only group");
                }
                Audit temp = new Audit(this.audit);
                String sql = "UPDATE " + this.sbdb.DBTableName("txgroup") + " SET name=" + SB.DBString((String)newName) + "," + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE grp_id=" + this.ID;
                if (stmt.executeUpdate(this.sbdb.modQuery(sql)) != 1) {
                    throw new SBException("Cannot update group: " + this.name);
                }
                this.audit = temp;
            }
        }
        this.name = newName;
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public String getAbr() {
        if (this.abr != null) {
            return this.abr;
        }
        return "";
    }

    public SBdb getDatabase() {
        if (this.sbdb == null) {
            throw new IllegalStateException("Null database pointer in class TxGroup");
        }
        return this.sbdb;
    }

    public Color getColour() {
        return this.colour;
    }

    @Override
    public int getProjID() {
        return this.projID;
    }

    public static TxGroup parseTxGroup(Element xml, SBdb sbdb) throws SBException, ParseException, SQLException {
        String strgID = xml.getChildTextNormalize("GroupID");
        if (strgID == null) {
            throw new SBException("ID null in XML - invalid");
        }
        int groupID = Integer.parseInt(strgID);
        String name = xml.getChildText("GroupName");
        String abr = xml.getChildText("Abbreviation");
        String descr = xml.getChildText("Description");
        Color colour = Color.WHITE;
        Element elc = xml.getChild("Colour");
        if (elc != null) {
            colour = SB.parseColour((Element)elc);
        }
        Audit audit = null;
        Element ela = xml.getChild("Audit");
        if (ela != null) {
            try {
                audit = new Audit(sbdb, ela);
            }
            catch (SBException sbe) {
                System.out.println("Message from Audit in TxGroup (ignored): " + sbe.getMessage());
            }
        } else {
            System.out.println("Warning: no audit info for TxGroup: " + name);
        }
        TxGroup group = new TxGroup(sbdb, groupID, name, abr, colour, 0, descr, audit);
        group.initCollections();
        return group;
    }

    static void load(SBdb sbdb, HashMap txGroups) throws SQLException {
        String sql = "SELECT grp_id,name,abr,proj_id,descr,colour," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("TXGROUP") + " ORDER BY name";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int ID = rs.getInt("grp_id");
                if (sbdb.getTxGroup(ID) != null) continue;
                TxGroup group = new TxGroup(sbdb, ID, rs.getString("name"), rs.getString("abr"), ColourUtils.getDBColour((String)rs.getString("colour")), rs.getInt("proj_id"), rs.getString("descr"), new Audit(rs));
                group.setAcm(rs.getInt("acm"));
                txGroups.put(ID, group);
            }
        }
    }

    static TxGroup refresh(SBdb sbdb, HashMap<Integer, TxGroup> txGroups, Connection conn) throws SQLException {
        TxGroup notifier;
        String sql = "SELECT grp_id, updated FROM " + sbdb.DBTableName("TXGROUP");
        HashSet<Integer> keys = new HashSet<Integer>();
        try (Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            notifier = null;
            while (rs.next()) {
                TxGroup g;
                int ID = rs.getInt("grp_id");
                keys.add(ID);
                Timestamp time = rs.getTimestamp("updated");
                TxGroup group = txGroups.get(ID);
                if (group == null) {
                    g = new TxGroup(sbdb, ID);
                    txGroups.put(ID, g);
                    notifier = g;
                    continue;
                }
                if (time == null || group.audit.updated != null && !time.after(group.audit.updated)) continue;
                System.out.println("Found updated group - copying..." + String.valueOf(group));
                g = new TxGroup(sbdb, ID);
                group.name = g.name;
                group.abr = g.abr;
                group.audit = new Audit(g.audit);
                group.descr = g.descr;
                group.colour = g.colour;
                if (group.specIDs != null) {
                    g.load();
                    group.specIDs.clear();
                    group.specIDs.addAll(g.specIDs);
                    group.genIDs.clear();
                    group.genIDs.addAll(g.genIDs);
                }
                group.setChanged();
                group.notifyObservers();
                sbdb.notifyTxGroupUpdate(ID);
            }
        }
        if (txGroups.size() != keys.size()) {
            Iterator<TxGroup> it = txGroups.values().iterator();
            while (it.hasNext()) {
                TxGroup group = it.next();
                if (keys.contains(group.ID)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = group;
            }
        }
        return notifier;
    }

    public boolean isMember(int specID, int synSchID) throws SQLException {
        int prefID;
        if (this.specIDs == null) {
            this.load();
        }
        if (synSchID > 0 && (prefID = this.sbdb.getSynSch(synSchID).getPref(specID)) > 0) {
            specID = prefID;
        }
        return this.specIDs.contains(specID);
    }

    public boolean isGenusMember(int genID) throws SQLException {
        if (this.genIDs == null) {
            this.load();
        }
        return this.genIDs.contains(genID);
    }

    public void removeMembers(Collection collection) throws SQLException {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Taxon && this.isMember(((Taxon)o).getSpecID(), 0)) {
                it.remove();
                continue;
            }
            if (!(o instanceof Genus) || !this.isGenusMember(((Genus)o).getGenID())) continue;
            it.remove();
        }
    }

    public void addTaxa(Collection<Taxon> taxa) throws SQLException, SBPermissionException {
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                HashSet<Integer> specIDsInserted = new HashSet<Integer>();
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException("Attempt to update read-only group");
                }
                for (Taxon taxon : taxa) {
                    if (this.isMember(taxon.getSpecID(), 0) || specIDsInserted.contains(taxon.getSpecID())) continue;
                    String sql = "INSERT INTO " + this.sbdb.DBTableName("GROUPMBR") + " (grp_id,spec_id) VALUES (";
                    sql = sql + this.ID + "," + taxon.getSpecID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    specIDsInserted.add(taxon.getSpecID());
                }
            }
            this.updateAudit();
        }
        for (Taxon taxon : taxa) {
            if (!this.specIDs.add(taxon.getSpecID())) continue;
            this.setChanged();
        }
        this.discipline = null;
        if (this.hasChanged()) {
            this.sbdb.notifyTxGroupUpdate(this.ID);
        }
        this.notifyObservers();
    }

    public void addTaxaBySpecID(Collection<Integer> newSpecies) {
        for (Integer specID : newSpecies) {
            if (!this.specIDs.add(specID)) continue;
            this.setChanged();
        }
        this.discipline = null;
        if (this.hasChanged()) {
            this.sbdb.notifyTxGroupUpdate(this.ID);
        }
        this.notifyObservers();
    }

    public void addDomainGenera(Collection<com.stratadata.model3.taxon.Genus> genera) throws SQLException, SBPermissionException {
        ArrayList<Genus> modelGenera = new ArrayList<Genus>();
        for (com.stratadata.model3.taxon.Genus genus : genera) {
            modelGenera.add(this.sbdb.getGenus(genus.getGenID()));
        }
        this.addGenera(modelGenera);
    }

    public void addGenera(Collection<Genus> genera) throws SQLException, SBPermissionException {
        if (genera.isEmpty()) {
            return;
        }
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "add genera to", "group", true));
                }
                HashSet<Integer> genIDsInserted = new HashSet<Integer>();
                String insertRoot = "INSERT INTO " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " (grp_id,gen_id) VALUES (" + this.ID + ",";
                String deleteRoot = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID + " AND spec_id IN (SELECT spec_id FROM " + this.sbdb.DBTableName("SPECIES") + " WHERE gen_id=";
                for (Genus genus : genera) {
                    if (this.isGenusMember(genus.getGenID()) || genIDsInserted.contains(genus.getGenID())) continue;
                    String sql = insertRoot + genus.getGenID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    sql = deleteRoot + genus.getGenID() + ")";
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                    genIDsInserted.add(genus.getGenID());
                }
            }
            this.updateAudit();
        }
        for (Genus genus : genera) {
            this.putGenus(genus);
            Set<Taxon> taxa = this.sbdb.getTaxa(genus.getGenID());
            for (Taxon mbr : taxa) {
                if (!this.specIDs.add(mbr.getSpecID())) continue;
                this.setChanged();
            }
        }
        this.discipline = null;
        if (this.hasChanged()) {
            this.sbdb.notifyTxGroupUpdate(this.ID);
        }
        this.notifyObservers();
    }

    void updateAudit() throws SQLException {
        Audit temp = new Audit(this.audit);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "UPDATE " + this.sbdb.DBTableName("TXGROUP") + " SET " + temp.sqlUpdate(this.sbdb, stmt, false) + " WHERE grp_id=" + this.ID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.audit = temp;
    }

    public void deleteAllTaxa() throws SQLException, SBPermissionException {
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String[] tables;
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group", true));
            }
            for (String table : tables = new String[]{this.sbdb.DBTableName("GROUPMBR"), this.sbdb.DBTableName("GROUPMBR_GENUS")}) {
                String sql = "DELETE FROM " + table + " WHERE grp_id=" + this.ID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        if (!this.specIDs.isEmpty()) {
            this.specIDs.clear();
            for (int genID : this.genIDs) {
                this.sbdb.getGenus(genID).deleteListener(this);
            }
            this.genIDs.clear();
            this.setChanged();
            this.updateAudit();
        }
    }

    public void deleteTaxa(List<Taxon> taxa) throws SQLException, SBPermissionException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group", true));
                }
                for (Taxon taxon : taxa) {
                    if (!this.isMember(taxon.getSpecID(), 0)) {
                        System.out.println("Taxon: " + taxon.getSpecID() + " to be deleted does not exist in group: " + this.ID);
                    }
                    String sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID + " AND spec_id=" + taxon.getSpecID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
        }
        for (Taxon taxon : taxa) {
            if (!this.specIDs.remove(taxon.getSpecID())) continue;
            this.setChanged();
        }
        this.discipline = null;
        if (this.hasChanged()) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                this.updateAudit();
            }
            this.sbdb.notifyTxGroupUpdate(this.ID);
        }
        this.notifyObservers();
    }

    public void deleteGenera(List<Genus> generaToDelete) throws SQLException, SBPermissionException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                if (!this.canWrite(this.sbdb, stmt)) {
                    throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group", true));
                }
                for (Genus genus : generaToDelete) {
                    if (!this.isGenusMember(genus.getGenID())) {
                        System.out.println("Genus: " + genus.getGenID() + " to be deleted does not exist in group: " + this.ID);
                    }
                    String sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE grp_id=" + this.ID + " AND gen_id=" + genus.getGenID();
                    stmt.executeUpdate(this.sbdb.modQuery(sql));
                }
            }
        }
        if (this.genIDs == null) {
            return;
        }
        for (Genus genus : generaToDelete) {
            if (!this.genIDs.remove(genus.getGenID())) continue;
            Set<Taxon> taxa = this.sbdb.getTaxa(genus.getGenID());
            HashSet<Integer> txIDs = new HashSet<Integer>();
            for (Taxon t : taxa) {
                txIDs.add(t.getSpecID());
            }
            this.specIDs.removeAll(txIDs);
            this.setChanged();
            genus.deleteListener(this);
        }
        this.discipline = null;
        if (this.hasChanged()) {
            if (this.sbdb != null && this.sbdb.isConnected()) {
                this.updateAudit();
            }
            this.sbdb.notifyTxGroupUpdate(this.ID);
        }
        this.notifyObservers();
    }

    boolean removeSpecies(int specID) {
        if (this.specIDs != null && this.specIDs.remove(specID)) {
            this.setChanged();
            return true;
        }
        return false;
    }

    boolean removeGenus(int genID) {
        if (this.genIDs != null && this.genIDs.remove(genID)) {
            try {
                for (Taxon taxon : this.sbdb.getTxGroupTaxa(this)) {
                    if (taxon.getGenID() != genID) continue;
                    this.specIDs.remove(taxon.getSpecID());
                }
                this.setChanged();
                this.sbdb.getGenus(genID).deleteListener(this);
                return true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    void insertSpecies(int specID) {
        if (this.specIDs != null) {
            try {
                if (!this.isMember(specID, 0)) {
                    this.specIDs.add(specID);
                    this.setChanged();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void load() throws SQLException {
        this.load(false);
    }

    void load(boolean force) throws SQLException {
        boolean load = false;
        if (this.specIDs == null || force) {
            this.initCollections();
            load = true;
        }
        if (this.sbdb.isConnected() && load) {
            LOGGER.log(Level.CONFIG, "Loading group: " + this.getName());
            try (Statement stmt = this.sbdb.getDatabase().createStatement();
                 Statement stmt2 = this.sbdb.getDatabase().createStatement();){
                String sql = "SELECT spec_id FROM " + this.sbdb.DBTableName("GROUPMBR") + " WHERE grp_id=" + this.ID;
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    this.specIDs.add(rs.getInt("spec_id"));
                }
                sql = "SELECT gen_id FROM " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE grp_id=" + this.ID;
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    this.putGenus(rs.getInt("gen_id"), stmt2);
                }
                if (!this.genIDs.isEmpty()) {
                    sql = "SELECT spec_id FROM " + this.sbdb.DBTableName("SPECIES") + " s INNER JOIN " + this.sbdb.DBTableName("GROUPMBR_GENUS") + " gg ON s.GEN_ID = gg.GEN_ID WHERE GG.GRP_ID=" + this.ID;
                    rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                    while (rs.next()) {
                        this.specIDs.add(rs.getInt("spec_id"));
                    }
                }
            }
        }
    }

    private void putGenus(int genID, Statement stmt) throws SQLException {
        this.putGenus(this.sbdb.getGenus(genID, stmt));
    }

    private void putGenus(Genus genus) throws SQLException {
        if (this.specIDs == null || this.genIDs == null) {
            throw new IllegalStateException();
        }
        genus.registerListener(this);
        if (this.genIDs.add(genus.getGenID())) {
            this.setChanged();
        }
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for group: " + String.valueOf(this));
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        if (this.sbdb.isConnected()) assert (false);
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write((String)ind + "<TaxonGroup Name=\"" + SB.getXMLstring((String)this.name) + "\">\n");
        String ind2 = (String)ind + "   ";
        if (this.name != null && this.name.length() > 0) {
            out.write(ind2 + "<GroupName>" + SB.getXMLstring((String)this.name) + "</GroupName>\n");
        }
        if (this.ID > 0) {
            out.write(ind2 + "<GroupID>" + this.ID + "</GroupID>\n");
        }
        if (this.abr != null && this.abr.length() > 0) {
            out.write(ind2 + "<Abbreviation>" + this.abr + "</Abbreviation>\n");
        }
        if (this.descr != null) {
            out.write(ind2 + "<Description>" + SB.getXMLstring((String)this.descr) + "</Description>\n");
        }
        if (this.colour != null) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind2);
        }
        this.audit.writeXML(out, ind2.length());
        for (Integer specID : this.specIDs) {
            out.write(ind2 + "<Taxon SpeciesID=\"" + specID + "\"/>\n");
        }
        for (Integer genID : this.genIDs) {
            out.write(ind2 + "<Genus GenusID=\"" + genID + "\"/>\n");
        }
        out.write((String)ind + "</TaxonGroup>\n");
    }

    public void updateStatus() throws SQLException {
        this.status = UNKNOWN;
        if (this.link == null) {
            this.status = NOTSTORED;
            return;
        }
        this.status = STORED;
        this.link.load();
        if (this.link.genIDs.size() != this.genIDs.size()) {
            this.status = CONFLICT;
            return;
        }
        for (Taxon taxon : this.sbdb.getTxGroupTaxa(this, false)) {
            if (taxon.getLink() == null && taxon.getStatus() == Taxon.NOTSTORED) {
                this.status = CONFLICT;
                break;
            }
            if (this.link.isMember(taxon.getLink().getSpecID(), 0)) continue;
            this.status = CONFLICT;
            break;
        }
        for (Genus genus : this.sbdb.getTxGroupGenera(this)) {
            if (genus.getLink() != null) {
                if (this.link.isGenusMember(genus.getLink().getGenID())) continue;
                this.status = CONFLICT;
                break;
            }
            this.status = CONFLICT;
            break;
        }
    }

    public List<String> getSets() throws SQLException {
        LinkedList<String> setNames = new LinkedList<String>();
        String sql = "SELECT s.name FROM " + this.sbdb.DBTableName("GROUPSET") + " s, " + this.sbdb.DBTableName("SETMBR") + " m WHERE s.grpset_id=m.grpset_id AND grp_id=" + this.ID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                setNames.add(rs.getString("name"));
            }
        }
        return setNames;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public static int nextControl(SBdb sbdb) throws SQLException {
        return sbdb.nextControl("TXGROUP", "grp_id");
    }

    /*
     * WARNING - void declaration
     */
    public Discipline getDiscipline(SBdb sbdb) throws SQLException {
        void var5_7;
        if (this.discipline != null) {
            return Discipline.getDisc((char)this.discipline.charValue());
        }
        class MutableInt {
            private int i;

            MutableInt(TxGroup this$0) {
                Objects.requireNonNull(this$0);
            }

            void incrememnt() {
                ++this.i;
            }
        }
        EnumMap<Discipline, MutableInt> counts = new EnumMap<Discipline, MutableInt>(Discipline.class);
        Discipline[] disciplineArray = Discipline.values();
        int n = disciplineArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            Discipline d = disciplineArray[var5_7];
            counts.put(d, new MutableInt(this));
            ++var5_7;
        }
        Collection<Taxon> txGroupTaxa = sbdb.getTxGroupTaxa(this);
        for (Taxon taxon : txGroupTaxa) {
            ((MutableInt)counts.get(taxon.getDisc())).incrememnt();
        }
        for (Map.Entry entry : counts.entrySet()) {
            double percent;
            if (txGroupTaxa.size() < 1 || !((percent = (double)((MutableInt)entry.getValue()).i / (double)txGroupTaxa.size()) * 100.0 > 95.0)) continue;
            this.discipline = Character.valueOf(((Discipline)entry.getKey()).getChar());
            return (Discipline)entry.getKey();
        }
        this.discipline = Character.valueOf('0');
        return null;
    }

    @Override
    public void onGenusDetailsUpdated(Genus genus) {
        if (!this.genIDs.contains(genus.getGenID())) {
            genus.deleteListener(this);
            return;
        }
        this.setChanged();
        this.notifyObservers(genus);
    }

    @Override
    public void onGenusDelete(Genus genus) {
    }

    @Override
    public void onGenusSpeciesListUpdated(Genus genus, Collection<Integer> speciesAdded, Collection<Integer> speciesRemoved) {
        if (!this.genIDs.contains(genus.getGenID())) {
            genus.deleteListener(this);
            return;
        }
        if (!speciesRemoved.isEmpty()) {
            try {
                this.load(true);
            }
            catch (SQLException ex) {
                StackError.showStackError((String)"SQL Error refreshing group members", (SQLException)ex);
                return;
            }
        } else {
            this.specIDs.addAll(speciesAdded);
        }
        this.setChanged();
        this.sbdb.notifyTxGroupUpdate(this.ID);
        this.notifyObservers();
    }
}

