/*
 * Decompiled with CFR 0.152.
 */
package model3;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import model3.Audit;
import model3.WellDocumentService;

public class WellDocument
extends com.stratadata.model3.wellinterp.WellDocument {
    private Audit audit;
    private String primaryWellName = "";
    private String interpDescr = "";
    private String creatorName = "";
    private long docLength;
    private String tempFileName = null;

    public WellDocument(int docID, int primaryWellID, Integer interpID, String descr, String path, Audit audit) {
        super(docID, primaryWellID, interpID, descr, path);
        this.audit = audit;
    }

    protected void setDocID(int docID) {
        throw new IllegalStateException("Don't set this!");
    }

    public Date getCreated() {
        return new Date(this.audit.getCreated().getTime());
    }

    public int getCreator() {
        return this.audit.getCreator();
    }

    public void setPrimaryWellName(String primaryWellName) {
        this.primaryWellName = primaryWellName;
    }

    public String getPrimaryWellName() {
        return this.primaryWellName;
    }

    public void setInterpDescr(String interpDescr) {
        this.interpDescr = interpDescr;
    }

    public String getInterpDescr() {
        return this.interpDescr;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setTempFileName(String tempFileName) {
        this.tempFileName = tempFileName;
    }

    public long getDocLength() {
        return this.docLength;
    }

    public void setDocLength(long docLength) {
        this.docLength = docLength;
    }

    public File getTempPDF(WellDocumentService sbdocs) throws SQLException, IOException {
        if (this.tempFileName != null) {
            return new File(this.tempFileName);
        }
        File tempFile = sbdocs.getDocumentContent(this.getDocID());
        this.tempFileName = tempFile.toString();
        return tempFile;
    }
}

