/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import model3.Audit;
import model3.DEXFile;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.SbugsSampleObject;
import model3.Well;
import model3.WsWell;
import model3.wellinterp.InterpItem;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class WellEvent
implements SbugsStatus,
SortEntry,
SbugsSampleObject,
InterpItem {
    private final SBdb sbdb;
    private SBEvent sbEvent;
    private Sample sample;
    private Double errPlus = null;
    private Double errMinus = null;
    private EventType type = EventType.TOP;
    private Discipline discID;
    private int analyst;
    private String qualifier;
    private String comments;
    private String source;
    private String company;
    private Confidence confidence;
    Color status = UNKNOWN;
    private Audit audit = new Audit();

    static WellEvent load(SBdb sbdb, Well well, int interpID, int evID, int sampID, EventType type, WellEvent e) throws SQLException, SBException {
        Builder builder = new Builder().event(sbdb.getSBEvent(evID)).sample(well.getSample(sampID)).type(type);
        Object sql = "SELECT disc_id,analyst,qualifier,comments,source,company,confidence,depthplus,depthminus,";
        sql = (String)sql + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + interpID + " AND well_id=" + well.getWellID() + " AND samp_id=" + sampID + " AND ev_id=" + evID + " AND ev_type=" + SB.DBChar((char)type.getChar());
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
            if (rs.next()) {
                String strg = rs.getString("disc_id");
                if (strg != null) {
                    builder.discID(Discipline.getDisc((char)strg.charAt(0)));
                }
                builder.analyst(rs.getInt("analyst"));
                builder.qualifier(rs.getString("qualifier"));
                builder.comments(rs.getString("comments"));
                builder.source(rs.getString("source"));
                builder.company(rs.getString("company"));
                builder.confidence(Confidence.getConfidence((int)rs.getInt("confidence")));
                double f = rs.getDouble("depthplus");
                if (!rs.wasNull()) {
                    builder.errPlus(f);
                }
                f = rs.getDouble("depthminus");
                if (!rs.wasNull()) {
                    builder.errMinus(f);
                }
                builder.audit(new Audit(rs));
                builder.status = STORED;
            }
        }
        if (e == null) {
            return builder.build(sbdb);
        }
        if (e.sample != builder.sample || e.sbEvent != builder.sbEvent || e.type != type) {
            throw new IllegalArgumentException("Attempt to copy fields to unequivalent Well Event object");
        }
        e.errPlus = builder.errPlus;
        e.errMinus = builder.errMinus;
        e.analyst = builder.analyst;
        e.qualifier = builder.qualifier;
        e.comments = builder.comments;
        e.company = builder.company;
        e.source = builder.source;
        e.discID = builder.discID;
        e.status = builder.status;
        e.confidence = builder.confidence;
        return e;
    }

    static Builder parse(DEXFile.DEXsection section, SBdb db, Well well) throws SQLException, SBException {
        Builder builder = new Builder();
        for (int i = 0; i < section.label.size(); ++i) {
            String label = ((String)section.label.get(i)).toUpperCase();
            String value = (String)section.value.get(i);
            if (label.equalsIgnoreCase("Type")) {
                builder.type(EventType.getType((String)value));
                continue;
            }
            if (label.equalsIgnoreCase("Event ID")) continue;
            if (label.equalsIgnoreCase("Sample ID")) {
                builder.sample(well.getSample(Integer.parseInt(value)));
                continue;
            }
            if (label.equalsIgnoreCase("Discipline")) {
                builder.discID(Discipline.getDisc((String)value));
                continue;
            }
            if (label.equalsIgnoreCase("Analyst")) {
                builder.analyst(db.getAddUserID(value));
                continue;
            }
            if (label.equalsIgnoreCase("Qualifier")) {
                builder.qualifier(value);
                continue;
            }
            if (label.equalsIgnoreCase("Comments")) {
                builder.comments(value);
                continue;
            }
            if (label.equalsIgnoreCase("Source")) {
                builder.source(value);
                continue;
            }
            if (label.equalsIgnoreCase("Company")) {
                builder.company(value);
                continue;
            }
            if (!label.equalsIgnoreCase("Modified")) continue;
            try {
                builder.audit.modified = SB.df.parse(value);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public String getComments() {
        return this.comments;
    }

    public String getModifierAbr() {
        if (this.sbdb == null) {
            return "" + this.audit.modifier;
        }
        try {
            return this.sbdb.getUser(this.audit.modifier).getAbr();
        }
        catch (Exception e) {
            return "Not found: " + this.audit.modifier;
        }
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public Sample getSample() {
        return this.sample;
    }

    public Double getErrPlus() {
        return this.errPlus;
    }

    public Double getErrMinus() {
        return this.errMinus;
    }

    public SBEvent getEvent() {
        return this.sbEvent;
    }

    public int getAnalyst() {
        return this.analyst;
    }

    public char getDiscID() {
        return Discipline.getChar((Discipline)this.discID);
    }

    @Override
    public Discipline getDiscipline() {
        return this.discID;
    }

    public Discipline getDiscIDTaxon() {
        if (this.discID != null) {
            return this.discID;
        }
        if (this.sbEvent.getTaxon() == null) {
            return null;
        }
        return this.sbEvent.getTaxon().getDisc();
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.toString(true, false, true);
    }

    public String toString(boolean type, boolean qual, boolean depth) {
        return this.toString(type, qual, depth, this.sample.displayUnits, false, false, true);
    }

    public String toString(boolean type, boolean qual, boolean depth, char units, boolean confidence, boolean abr) {
        return this.toString(type, qual, depth, units, confidence, abr, false);
    }

    public String toString(boolean type, boolean qual, boolean depth, char units, boolean confidence, boolean abr, boolean eventName) {
        String pfx;
        Object string = "";
        if (depth) {
            string = (String)string + this.sample.toString(units);
        }
        if (qual && this.qualifier != null && !this.qualifier.isEmpty()) {
            if (!((String)string).isEmpty()) {
                string = (String)string + " ";
            }
            string = (String)string + this.qualifier;
        }
        if ((pfx = this.sbEvent.getPrefix(this.type, EventContext.WELL, type)) != null) {
            if (!((String)string).isEmpty()) {
                string = (String)string + " ";
            }
            string = (String)string + pfx;
        }
        if (!((String)string).isEmpty()) {
            string = (String)string + " ";
        }
        string = (String)string + this.sbEvent.toString(false, abr, eventName, true);
        if (confidence && this.confidence != Confidence.CONFIDENT) {
            string = (String)string + " (" + String.valueOf(this.confidence) + ")";
        }
        return string;
    }

    public char getCharType() {
        return this.type.getChar();
    }

    public EventType getTypeObj() {
        return this.type;
    }

    public String getType() {
        return WellEvent.getType(this.type);
    }

    public static String getType(char type) {
        return WellEvent.getType(EventType.getType((String)("" + type)));
    }

    public static String getType(EventType type) {
        return type.toString(EventContext.WELL);
    }

    public Confidence getConfidence() {
        return this.confidence;
    }

    public Boundary getConfidenceAsBoundary() {
        switch (this.confidence) {
            case CONFIDENT: {
                return Boundary.CONF;
            }
            case PROBABLE: {
                return Boundary.PROB;
            }
            case POSSIBLE: {
                return Boundary.POSS;
            }
        }
        return Boundary.CONF;
    }

    @Override
    public void delete(int wellID, int interpID, Statement stmt) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to event deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("EVENTS") + " WHERE interp_id=" + interpID + " AND samp_id=" + this.sample.getSampID() + " AND well_id=" + wellID + " AND ev_id=" + this.sbEvent.getEvID() + " AND (ev_type";
        switch (this.type) {
            case SINGLE: {
                sql = sql + " is NULL or ev_type=' ' or ev_type";
            }
            case TOP: 
            case BASE: {
                sql = sql + "=" + SB.DBChar((char)this.type.getChar()) + ")";
            }
        }
        int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
        if (nRows != 1) {
            throw new SBException("Unexpected number of rows updated: " + nRows);
        }
        this.status = NOTSTORED;
    }

    void updateStatus(List<WellEvent> events) throws SBException, SQLException {
        this.status = NOTSTORED;
        for (WellEvent event : events) {
            if (event == this || !this.isFuncEquivalent(event)) continue;
            this.status = STORED;
            MergeStatus m = new MergeStatus(this.status);
            m.compareStringField("Analyst", event.getAnalystString(), this.getAnalystString(), false);
            m.compareStringField("Comments", event.comments, this.comments, false);
            m.compareStringField("Company", event.company, this.company, false);
            m.compareCharField("DiscID", Discipline.getChar((Discipline)event.discID), Discipline.getChar((Discipline)this.discID));
            m.compareStringField("Qualifier", event.qualifier, this.qualifier, false);
            m.compareStringField("Source", event.source, this.source, false);
            m.compareIntField("Confidence", event.confidence.getDBint(), this.confidence.getDBint());
            m.compareDoubleField("ErrPlus", event.errPlus != null ? event.errPlus : 0.0, this.errPlus != null ? this.errPlus : 0.0);
            m.compareDoubleField("ErrMinus", event.errMinus != null ? event.errMinus : 0.0, this.errMinus != null ? this.errMinus : 0.0);
            this.status = m.getStatus();
            break;
        }
    }

    final void store(int wellID, int interpID) throws SBException, SQLException {
        this.store(wellID, interpID, this.sample.getSampID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void store(int wellID, int interpID, int sampID) throws SBException, SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal argument to WellEvent.store: wellID is " + wellID + ", interpID is " + interpID);
        }
        if (this.status == NOTSTORED) {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "INSERT INTO " + this.sbdb.DBTableName("EVENTS") + " (interp_id,ev_id,ev_type,well_id,samp_id,disc_id,analyst,qualifier,comments,source,company,confidence,";
            if (this.errPlus != null) {
                sql = sql + "depthplus,";
            }
            if (this.errMinus != null) {
                sql = sql + "depthminus,";
            }
            sql = sql + Audit.sqlFieldString() + ") VALUES (" + interpID + "," + this.sbEvent.getEvID() + "," + SB.DBChar((char)this.type.getChar()) + "," + wellID + "," + sampID;
            sql = sql + "," + SB.DBChar((char)Discipline.getChar((Discipline)this.discID)) + "," + String.valueOf(this.analyst > 0 ? Integer.valueOf(this.analyst) : "NULL") + "," + SB.DBString((String)this.qualifier) + "," + SB.DBString((String)this.comments) + "," + SB.DBString((String)this.source) + "," + SB.DBString((String)this.company) + "," + this.confidence.getDBint() + ",";
            if (this.errPlus != null) {
                sql = sql + this.errPlus + ",";
            }
            if (this.errMinus != null) {
                sql = sql + this.errMinus + ",";
            }
            sql = sql + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            try {
                int nRows = stmt.executeUpdate(this.sbdb.modQuery(sql));
                if (nRows != 1) {
                    throw new SBException("Unexpected number of rows updated: " + nRows);
                }
            }
            finally {
                stmt.close();
            }
            this.status = STORED;
        } else if (this.status == PARTSTORED) {
            throw new SBException("Attempt to update SBEvent");
        }
    }

    public String getSource() {
        return this.source;
    }

    public String getCompany() {
        return this.company;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    @Override
    public Date getUpdated() {
        return this.audit.updated;
    }

    public SBEvent getSbEvent() {
        return this.sbEvent;
    }

    public int getSampID() {
        return this.sample.getSampID();
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public String getSortEntry() {
        return this.sample.getSortEntry() + "-" + this.sbEvent.getPrefix(this.type, EventContext.WELL, true) + "-" + this.sbEvent.getName().toUpperCase();
    }

    public Audit getAudit() {
        return this.audit;
    }

    public String getAnalystString() {
        if (this.analyst > 0) {
            try {
                return this.sbdb.getUser(this.analyst).getAbr();
            }
            catch (Exception ex) {
                return ex.getMessage();
            }
        }
        return "";
    }

    static Builder parse(SBdb ws, WsWell well, Element xml) throws SQLException, SBException, ParseException {
        Element el;
        Builder builder = new Builder();
        SBEvent sbEvent = null;
        String strg = xml.getChildTextNormalize("EventID");
        if (strg != null) {
            int eventID = Integer.parseInt(strg);
            sbEvent = ws.getSBEvent(eventID);
            if (sbEvent == null) {
                throw new SBException("Event null for ID: " + eventID + " in WellEvent constructor.");
            }
            builder.event(sbEvent);
        }
        if ((strg = xml.getChildTextNormalize("SampleID")) != null) {
            int sampID = Integer.parseInt(strg);
            builder.sample(well.getSample(sampID, true));
        }
        if ((strg = xml.getChildTextNormalize("DepthPlus")) != null) {
            Double depthPlus = Double.parseDouble(strg);
            builder.errPlus(depthPlus);
        }
        if ((strg = xml.getChildTextNormalize("DepthMinus")) != null) {
            Double depthMinus = Double.parseDouble(strg);
            builder.errMinus(depthMinus);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null && strg.length() > 0) {
            builder.type(EventType.getType((String)strg));
        }
        if ((strg = xml.getChildTextNormalize("Qualifier")) != null) {
            builder.qualifier(strg);
        }
        if ((strg = xml.getChildTextNormalize("Analyst")) != null) {
            builder.analyst(Integer.parseInt(strg));
        }
        if ((strg = xml.getChildTextNormalize("Source")) != null) {
            builder.source(strg);
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null) {
            builder.comments(strg);
        }
        if ((strg = xml.getChildTextNormalize("Company")) != null) {
            builder.company(strg);
        }
        if ((strg = xml.getChildTextNormalize("Uncertainty")) != null && strg.length() > 0) {
            builder.confidence(Confidence.getConfidence((int)Integer.parseInt(strg)));
        }
        if ((strg = xml.getChildTextNormalize("DisciplineID")) != null && strg.length() > 0) {
            builder.discID(Discipline.getDisc((char)strg.charAt(0)));
        }
        if ((el = xml.getChild("Audit")) != null) {
            builder.audit(new Audit(ws, el));
        }
        builder.status = NOTSTORED;
        return builder;
    }

    @Override
    public List<Integer> writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<WellEvent Event=\"" + SB.getXMLstring((String)this.toString()) + "\">\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        out.write(ind2 + "<EventID>" + this.sbEvent.getEvID() + "</EventID>\n");
        out.write(ind2 + "<SampleID>" + this.sample.getSampID() + "</SampleID>\n");
        if (this.errPlus != null) {
            out.write(ind2 + "<DepthPlus>" + this.errPlus + "</DepthPlus>\n");
        }
        if (this.errMinus != null) {
            out.write(ind2 + "<DepthMinus>" + this.errMinus + "</DepthMinus>\n");
        }
        out.write(ind2 + "<Type>" + this.getTypeObj().name() + "</Type>\n");
        if (this.qualifier != null && this.qualifier.length() > 0) {
            out.write(ind2 + "<Qualifier>" + SB.getXMLstring((String)this.qualifier) + "</Qualifier>\n");
        }
        if (this.analyst > 0) {
            out.write(ind2 + "<Analyst>" + this.analyst + "</Analyst>\n");
        }
        if (this.source != null && this.source.length() > 0) {
            out.write(ind2 + "<Source>" + SB.getXMLstring((String)this.source) + "</Source>\n");
        }
        if (this.comments != null && this.comments.length() > 0) {
            out.write(ind2 + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        if (this.company != null && this.company.length() > 0) {
            out.write(ind2 + "<Company>" + SB.getXMLstring((String)this.company) + "</Company>\n");
        }
        if (this.confidence.getDBint() > 0) {
            out.write(ind2 + "<Uncertainty>" + this.confidence.getDBint() + "</Uncertainty>\n");
        }
        if (this.discID != null) {
            out.write(ind2 + "<DisciplineID>" + this.discID.getChar() + "</DisciplineID>\n");
        }
        LinkedList<Integer> users = this.audit.writeXML(out, ind2.length());
        out.write(ind1 + "</WellEvent>\n");
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to WellEvent.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        Audit tempAudit = new Audit(this.audit);
        String sql = "UPDATE " + this.sbdb.DBTableName("events") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE well_id=" + wellID + " AND samp_id=" + this.sample.getSampID() + " AND ev_id=" + this.sbEvent.getEvID() + " AND interp_id=" + interpID + " AND (ev_type";
        switch (this.type) {
            case SINGLE: {
                sql = sql + " is NULL or ev_type";
            }
            case TOP: 
            case BASE: {
                sql = sql + "=" + SB.DBChar((char)this.type.getChar()) + ")";
            }
        }
        try {
            int nRow = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRow != 1) {
                throw new SBException("Error moving event: " + String.valueOf(this) + ". Number returned from update: " + nRow);
            }
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    @Override
    public boolean mergeSamples(Sample donor, Sample target) {
        if (this.sample == donor) {
            this.sample = target;
            return true;
        }
        return false;
    }

    void setEvent(SBEvent event) {
        this.sbEvent = event;
    }

    void setType(EventType type) {
        this.type = type;
    }

    void setUpdated(int updater, Date updated) {
        this.audit.updater = updater;
        this.audit.updated = updated;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException {
        if (e instanceof WellEvent) {
            if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
                return true;
            }
            WellEvent comp = (WellEvent)e;
            if (this.sample.isFuncEquivalent(comp.sample) && this.type == comp.type && this.sbEvent.getName().toUpperCase().equals(comp.sbEvent.getName().toUpperCase())) {
                return true;
            }
        }
        return false;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for event: " + String.valueOf(this));
        }
        if (this.analyst > 0) {
            this.analyst = analyst.getUsrID();
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public static Double getEventError(Well well, Sample sample, Discipline discID, EventType eventType) throws SQLException {
        int index;
        Double error = null;
        if (eventType == EventType.TOP) {
            Sample prevSample = null;
            index = well.getSamples().indexOf(sample) - 1;
            while (index >= 0) {
                prevSample = well.getSamples().get(index);
                if (prevSample.getType() != SampleType.LOG) {
                    if (discID == null || prevSample.hasDisciplineData(discID.getChar())) break;
                    --index;
                    continue;
                }
                --index;
            }
            if (prevSample != null && (discID == null || prevSample.hasDisciplineData(discID.getChar()))) {
                error = sample.getDepth() - prevSample.getDepth();
            }
        }
        if (eventType == EventType.BASE) {
            Sample nextSample = null;
            index = well.getSamples().indexOf(sample) + 1;
            while (index >= 0 && index < well.getSamples().size()) {
                nextSample = well.getSamples().get(index);
                if (nextSample.getType() != SampleType.LOG) {
                    if (discID == null || nextSample.hasDisciplineData(discID.getChar())) break;
                    ++index;
                    continue;
                }
                ++index;
            }
            if (nextSample != null && (discID == null || nextSample.hasDisciplineData(discID.getChar()))) {
                error = nextSample.getDepth() - sample.getDepth();
            }
        }
        return error;
    }

    static boolean updateType(SBdb db, int evID, boolean single, Boolean updateSingleToTops) throws SQLException {
        assert (single || updateSingleToTops != null);
        try (Statement stmt = db.getDatabase().createStatement();){
            Audit audit = new Audit();
            String sql = "UPDATE " + db.DBTableName("EVENTS") + " SET ev_type=" + SB.DBChar((char)(single ? 83 : (updateSingleToTops != false ? 70 : 76))) + "," + audit.sqlUpdate(db, stmt, false) + " WHERE ev_id=" + evID;
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            boolean bl = nRows > 0;
            return bl;
        }
    }

    private WellEvent(Builder builder, SBdb sbdb) {
        this.sbdb = sbdb;
        this.sbEvent = builder.sbEvent;
        this.sample = builder.sample;
        this.errPlus = builder.errPlus;
        this.errMinus = builder.errMinus;
        this.type = builder.type;
        this.discID = builder.discID;
        this.analyst = builder.analyst;
        this.qualifier = builder.qualifier;
        this.comments = builder.comments;
        this.source = builder.source;
        this.company = builder.company;
        this.audit = builder.audit;
        this.status = builder.status;
        this.confidence = builder.confidence;
    }

    @Override
    public Sample getBaseSample() {
        return null;
    }

    @Override
    public int getSchID() {
        return 0;
    }

    @Override
    public void writeDEX(FileWriter out, String eol, char units, SimpleDateFormat df) throws IOException, SBException, SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDesc() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getItemDescPlural() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static class Builder {
        private SBEvent sbEvent;
        private Sample sample;
        private Double errPlus = null;
        private Double errMinus = null;
        private EventType type;
        private Discipline discID = null;
        private int analyst = 0;
        private String qualifier = "";
        private String comments = "";
        private String source = "";
        private String company = "";
        Color status = SbugsStatus.UNKNOWN;
        private Audit audit = new Audit();
        private Confidence confidence = Confidence.CONFIDENT;

        WellEvent build(SBdb sbdb) {
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build WellEvent with null data model");
            }
            if (this.sbEvent == null) {
                throw new IllegalStateException("Attempt to build WellEvent with null event");
            }
            if (this.sample == null) {
                throw new IllegalStateException("Attempt to build WellEvent with null sample");
            }
            if (this.type == null) {
                throw new IllegalStateException("Attempt to build WellEvent with invalid event type. Ev_id=" + this.sbEvent.getEvID() + "\nName: " + this.sbEvent.getName());
            }
            if (!this.sbEvent.hasEvType(this.type)) {
                throw new IllegalStateException("Attempt to build WellEvent with unregistered event type. Ev_id=" + this.sbEvent.getEvID() + ", type=" + String.valueOf(this.type) + "\nName: " + this.sbEvent.getName());
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new WellEvent(this, sbdb);
        }

        WellEvent build(SBdb sbdb, int wellID, int interpID) throws SBException, SQLException {
            WellEvent event = this.build(sbdb);
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            event.store(wellID, interpID);
            return event;
        }

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder qualifier(String q) {
            if (q != null) {
                this.qualifier = q.trim();
            }
            return this;
        }

        public Builder comments(String q) {
            if (q != null) {
                this.comments = q.trim();
            }
            return this;
        }

        public Builder source(String q) {
            if (q != null) {
                this.source = q.trim();
            }
            return this;
        }

        public Builder company(String q) {
            if (q != null) {
                this.company = q.trim();
            }
            return this;
        }

        public Builder discID(Discipline discID) {
            this.discID = discID;
            return this;
        }

        public Builder analyst(int analyst) {
            if (analyst >= 0) {
                this.analyst = analyst;
            }
            return this;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = new Audit(audit);
            }
            return this;
        }

        public Builder event(SBEvent event) {
            this.sbEvent = event;
            return this;
        }

        public Builder sample(Sample sample) {
            this.sample = sample;
            return this;
        }

        public Builder errPlus(Double errPlus) {
            this.errPlus = errPlus;
            return this;
        }

        public Builder errDefault(boolean errDefault) {
            return this;
        }

        public Builder errMinus(Double errMinus) {
            this.errMinus = errMinus;
            return this;
        }

        public Builder confidence(Confidence confidence) {
            this.confidence = confidence;
            return this;
        }

        public static Builder copyOf(WellEvent rhs) {
            Builder builder = new Builder().type(rhs.getTypeObj());
            builder.discID(rhs.discID).audit(new Audit(rhs.audit));
            builder.source(rhs.source).comments(rhs.comments).company(rhs.company).qualifier(rhs.qualifier).confidence(rhs.confidence);
            builder.errPlus(rhs.errPlus).errMinus(rhs.errMinus);
            return builder;
        }

        public Sample getSample() {
            return this.sample;
        }

        public SBEvent getSBEvent() {
            return this.sbEvent;
        }

        public char getType() {
            return this.type.getChar();
        }
    }
}

