/*
 * Decompiled with CFR 0.152.
 */
package model3;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.well.WellDatum;
import com.stratadata.model3.well.sample.SampleType;
import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model3.Biocom;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;
import model3.ImportFileReader;
import model3.ImportFileReaderType;
import model3.SBdb;
import model3.Sample;
import model3.SampleInsertException;
import model3.Well;
import model3.WellHeader;
import model3.WellInterp;
import model3.WsWell;
import org.apache.commons.lang3.StringUtils;
import util.DepthUtils;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellLstratPetrelXLS
implements ImportFileReader {
    static final int COL_WELL_NAME = 0;
    static final int COL_UWI = 1;
    static final int COL_SURFACE = 2;
    static final int COL_X = 3;
    static final int COL_Y = 4;
    static final int COL_Z = 5;
    static final int COL_MD = 6;
    static final int COL_AGE = 7;
    static final int COL_INTERPRETER = 8;
    static final int COL_OBS_NO = 9;
    static final int COL_COMMENT = 10;
    static final int COL_DATE = 11;
    static final ImportFileReader.ImportFileReaderColumn[] COLUMNS = new ImportFileReader.ImportFileReaderColumn[]{new ImportFileReader.ImportFileReaderColumn(0, true, "Well identifier (Well name)", "Well name"), new ImportFileReader.ImportFileReaderColumn(1, false, "Well identifier (UWI)", "UWI"), new ImportFileReader.ImportFileReaderColumn(2, true, "Surface", "Pick", "pick_identifier"), new ImportFileReader.ImportFileReaderColumn(3, null, "X"), new ImportFileReader.ImportFileReaderColumn(4, null, "Y"), new ImportFileReader.ImportFileReaderColumn(6, true, "MD"), new ImportFileReader.ImportFileReaderColumn(7, null, "Geological age"), new ImportFileReader.ImportFileReaderColumn(8, true, "Interpreter"), new ImportFileReader.ImportFileReaderColumn(9, null, "Observation number"), new ImportFileReader.ImportFileReaderColumn(10, false, "Comment"), new ImportFileReader.ImportFileReaderColumn(11, false, "Last edited", "Date")};
    Set dataTypes;
    SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
    final SBdb ws;

    @Override
    public ImportFileReaderType getType() {
        return ImportFileReaderType.PETREL_LSTRAT;
    }

    @Override
    public ImportFileReader.ImportFileReaderColumn[] getColumns() {
        return COLUMNS;
    }

    public WellLstratPetrelXLS() {
        this.ws = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellLstratPetrelXLS(SBdb ws, File file, char units, Set dataTypes, String country, IGDScheme dbScheme) throws GridReaderException, SBException, SBPermissionException, SQLException, InvalidFieldException {
        this.ws = ws;
        IGDScheme scheme = IGDScheme.copyToWorkspace(ws, dbScheme);
        if (scheme == null) {
            String unassignedSchemeName = IGDInterval.getIGDName(2) + " (undefined)";
            scheme = ws.addIGDScheme(2, unassignedSchemeName, "");
        } else {
            ws.addIGDScheme(scheme);
        }
        GridReader in = null;
        WsWell well = null;
        boolean firstRow = true;
        WellInterp wellInterp = null;
        LinkedList<IGDIntervalZone.Builder> builders = new LinkedList<IGDIntervalZone.Builder>();
        LinkedList<Biocom.Builder> biocoms = new LinkedList<Biocom.Builder>();
        dataTypes.add(12);
        dataTypes.add(3);
        double depth = 0.0;
        double totalDepth = 0.0;
        try {
            in = GridReader.getGridReader((String)file.getPath(), null);
            while (in.nextRow()) {
                Biocom.Builder biocom;
                String cell;
                int column;
                if (firstRow) {
                    firstRow = false;
                    column = 0;
                    while ((cell = in.getNextCell()) != null) {
                        this.setArrayIndex(cell, column);
                        ++column;
                    }
                    String strg = this.checkColumns();
                    if (strg == null) continue;
                    throw new SBException("Warning: columns incorrect for this reader: " + strg);
                }
                String wellName = null;
                String UWI = null;
                String pick = null;
                String data_source = null;
                String description = null;
                int pick_obs_no = 0;
                Date date = null;
                column = 0;
                while ((cell = in.getNextCell()) != null) {
                    ImportFileReader.ImportFileReaderColumn columnType;
                    if ((columnType = this.getColumn(column++)) == null) continue;
                    switch (columnType.colNumber) {
                        case 0: {
                            wellName = cell;
                            break;
                        }
                        case 1: {
                            UWI = cell;
                            break;
                        }
                        case 2: {
                            pick = cell;
                            break;
                        }
                        case 6: {
                            depth = DepthUtils.convToM((double)Double.parseDouble(cell), (char)units);
                            break;
                        }
                        case 8: {
                            data_source = cell;
                            break;
                        }
                        case 9: {
                            pick_obs_no = Integer.parseInt(cell);
                            break;
                        }
                        case 10: {
                            description = cell;
                            break;
                        }
                        case 11: {
                            try {
                                date = this.df.parse(cell);
                                break;
                            }
                            catch (ParseException e) {
                                long dateLong = Long.parseLong(cell);
                                try {
                                    date = new Date(dateLong);
                                    break;
                                }
                                catch (Exception e2) {
                                    System.out.println("Well: " + wellName + "\tCould not parse date: " + cell + "\n" + e2.getMessage());
                                }
                            }
                        }
                    }
                }
                if (wellName == null) {
                    throw new SBException("Well name is null");
                }
                if (well == null || !wellName.equalsIgnoreCase(well.getWellName())) {
                    if (well != null) {
                        this.addIntervals(scheme, well, wellInterp, builders, totalDepth);
                        this.addBiocoms(well, wellInterp, biocoms);
                    }
                    well = ws.addWellToWorkspace(0, null);
                    WellHeader wh = well.getHeader();
                    wh.setWellUnits(units);
                    wh.setCountry(country);
                    wh.setDatum(WellDatum.ROTARY_TABLE.getDbInt());
                    well.loadInterps();
                    wh.setWellName(wellName);
                    wellInterp = well.getInterp(0);
                    totalDepth = 0.0;
                }
                if (StringUtils.equalsAnyIgnoreCase((CharSequence)pick, (CharSequence[])new CharSequence[]{"Total Depth"})) {
                    totalDepth = depth;
                    continue;
                }
                if (well == null) continue;
                IGDIntervalZone.Builder builder = this.addBuilder(well, depth, scheme, pick, data_source, date);
                if (builder != null) {
                    builders.add(builder);
                }
                if ((biocom = this.addBiocom(well, depth, data_source, description)) == null) continue;
                this.addBiocomToList(biocoms, biocom);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (well != null) {
            this.addIntervals(scheme, well, wellInterp, builders, totalDepth);
            this.addBiocoms(well, wellInterp, biocoms);
            Iterator<Well> it = ws.getWellIterator();
            while (it.hasNext()) {
                well = (WsWell)it.next();
                well.updateStatus();
            }
        }
    }

    private Biocom.Builder addBiocom(Well well, double depth, String dataSource, String description) throws SBPermissionException, SampleInsertException, SQLException {
        Sample sample = well.getSample(depth, "LOG", true);
        if (sample == null) {
            sample = well.addSample(depth, SampleType.LOG, null);
        }
        int analyst = this.getUserID(this.ws, dataSource);
        Biocom.Builder builder = new Biocom.Builder(this.ws, Discipline.MICRO, analyst, sample, description);
        return builder;
    }

    private void addBiocomToList(List<Biocom.Builder> biocoms, Biocom.Builder builder) {
        for (Biocom.Builder b : biocoms) {
            if (b.getTopSample() != builder.getTopSample() || b.getAnalyst() != builder.getAnalyst()) continue;
            if (!b.getText().contains(builder.getText())) {
                b.appendComment(builder.getText());
            }
            return;
        }
        biocoms.add(builder);
    }

    private IGDIntervalZone.Builder addBuilder(Well well, double topDepth, IGDScheme scheme, String pick, String source, Date date) throws SBPermissionException, SampleInsertException, SQLException {
        int unitHier;
        IGDUnitBase unit;
        Sample topSample = well.getSample(topDepth, "LOG", true);
        if (topSample == null) {
            topSample = well.addSample(topDepth, SampleType.LOG, null);
        }
        if ((unit = scheme.findUnitBase(pick)) == null) {
            System.out.println("Warning: for well: " + String.valueOf(well) + "\tCould not find unit for: " + pick + "\tAdding as informal.");
            unitHier = IGDIntervalZone.getNHier(scheme.getIGDType(), true);
        } else {
            unitHier = unit.getHier();
        }
        IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, 2, topSample, topSample, unitHier, scheme.getSchID()).uppInf(pick).topBnd(3).baseBnd(3);
        if (unit != null) {
            builder.uppZone(unit.getUnitID());
        }
        builder.audit.modified = date;
        builder.audit.modifier = this.getUserID(this.ws, source);
        return builder;
    }

    private void addBiocoms(Well well, WellInterp wellInterp, List<Biocom.Builder> biocoms) throws SBPermissionException, SBException, SQLException, InvalidFieldException {
        for (Biocom.Builder biocom : biocoms) {
            wellInterp.insertBiocom(biocom.build());
        }
        biocoms.clear();
    }

    private int getUserID(SBdb ws, String source) throws SQLException {
        int userID = ws.getUserID(source);
        if (userID == 0) {
            ws.getAddUserID(source);
        }
        return userID;
    }

    private void addIntervals(IGDScheme scheme, Well well, WellInterp wellInterp, List<IGDIntervalZone.Builder> builders, double totalDepth) throws SBPermissionException, SBException, SQLException {
        IGDIntervalZone.Builder builder2;
        int index;
        boolean swap = true;
        block4: while (swap) {
            swap = false;
            Iterator<IGDIntervalZone.Builder> it = builders.iterator();
            IGDIntervalZone.Builder previous = null;
            index = 0;
            while (it.hasNext()) {
                IGDIntervalZone.Builder b = it.next();
                if (previous != null && (b.getTopSample().getDepth() < previous.getTopSample().getDepth() || Math.abs(b.getTopSample().getDepth() - previous.getTopSample().getDepth()) < (double)0.0029f && b.getHier() < previous.getHier())) {
                    it.remove();
                    builders.add(index - 1, b);
                    swap = true;
                    break block4;
                }
                previous = b;
                ++index;
            }
        }
        Sample baseSampleTD = null;
        if (totalDepth < (double)0.0029f) {
            baseSampleTD = builders.getLast().getTopSample();
        } else {
            baseSampleTD = well.getSample(totalDepth, "LOG", true);
            if (baseSampleTD == null) {
                baseSampleTD = well.addSample(totalDepth, SampleType.LOG, null);
            }
        }
        boolean lastHier = false;
        for (index = 0; index < builders.size(); ++index) {
            builder2 = builders.get(index);
            IGDIntervalZone.Builder nextBuilderAtLevel = null;
            for (int index2 = index + 1; index2 < builders.size(); ++index2) {
                if (builders.get(index2).getHier() > builder2.getHier()) continue;
                nextBuilderAtLevel = builders.get(index2);
                break;
            }
            if (nextBuilderAtLevel == null) {
                builder2.baseSample(baseSampleTD);
                continue;
            }
            builder2.baseSample(nextBuilderAtLevel.getTopSample());
        }
        swap = true;
        block8: while (swap) {
            swap = false;
            block9: for (index = 0; index < builders.size(); ++index) {
                if (index == builders.size() - 1) {
                    swap = false;
                    continue block8;
                }
                builder2 = builders.get(index);
                if (builder2.getUppZone() <= 0) continue;
                double baseUnitAge = scheme.findUnitBase(builder2.getUppZone()).getLage();
                Object nextBuilderAtLevel = null;
                for (int index2 = index + 1; index2 < builders.size(); ++index2) {
                    IGDIntervalZone.Builder builder2 = builders.get(index2);
                    if (builder2.getHier() <= builder2.getHier() || !(builder2.getBaseSample().getDepth() <= builder2.getBaseSample().getDepth()) || builder2.getUppZone() <= 0) continue;
                    double subUnitBaseAge = scheme.findUnitBase(builders.get(index2).getUppZone()).getLage();
                    if (!(subUnitBaseAge > baseUnitAge)) continue block9;
                    builder2.baseSample(builder2.getTopSample());
                    swap = true;
                    continue block9;
                }
            }
        }
        for (IGDIntervalZone.Builder builder2 : builders) {
            try {
                wellInterp.addZone(builder2, well);
            }
            catch (InvalidFieldException ex) {
                boolean inserted = false;
                while (!inserted && builder2.getHier() + 1 <= IGDIntervalZone.getNHier(scheme.getIGDType(), true)) {
                    IGDIntervalZone.Builder newBuilder = new IGDIntervalZone.Builder(builder2.sbdb, builder2.igdType, builder2.getTopSample(), builder2.getBaseSample(), builder2.getHier() + 1, builder2.getSchID());
                    newBuilder.uppZone(builder2.getUppZone()).uppInf(builder2.getName());
                    builder2 = newBuilder;
                    inserted = true;
                    try {
                        wellInterp.addZone(builder2, well);
                    }
                    catch (InvalidFieldException ex2) {
                        inserted = false;
                    }
                }
                if (inserted) continue;
                System.out.println("Can't insert: " + builder2.getIntervalName() + " into well: " + well.toString() + "\tReason: " + ex.getMessage());
            }
        }
        builders.clear();
    }
}

