/*
 * Decompiled with CFR 0.152.
 */
package model3.project;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import model3.Audit;
import model3.SBRestrictable;
import model3.SBdb;
import model3.project.WellListObserver;
import util.SB;
import util.SBPermissionException;
import util.listener.WeakListenerList;

public class WellList
extends com.stratadata.model3.project.WellList {
    private Audit audit;
    private final WeakListenerList<WellListObserver> listeners = new WeakListenerList();

    public WellList(int wlID, int projID, String name, String descr, Audit audit) {
        super(wlID, projID, name, descr);
        assert (wlID > 0);
        assert (name != null && !name.isEmpty());
        assert (audit != null);
        this.audit = audit;
    }

    public void setAudit(Audit audit) {
        this.audit = audit;
    }

    public void addListener(WellListObserver listener) {
        this.listeners.addListener((Object)listener);
    }

    public void deleteListener(WellListObserver listener) {
        this.listeners.deleteListener((Object)listener);
    }

    public List<WellListObserver> getListeners() {
        return this.listeners.getListeners();
    }

    public Date getUpdated() {
        return this.audit.getUpdated();
    }

    public void update(SBdb sbdb, String name, String descr) throws SQLException, SBPermissionException {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Attempt to change well list name to " + name);
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("WELLIST") + " SET name=" + SB.DBString((String)name) + ",descr=" + SB.DBString((String)descr) + "," + temp.sqlUpdate(sbdb, stmt, false) + " WHERE wellist_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.setName(name);
            this.setDescription(descr);
            this.audit = temp;
        }
        this.listeners.getListeners().forEach(l -> l.wellListChanged(this));
    }

    public void updateAudit(SBdb sbdb) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            Audit temp = new Audit(this.audit);
            String sql = "UPDATE " + sbdb.DBTableName("WELLIST") + " SET " + temp.sqlUpdate(sbdb, stmt, false) + " WHERE wellist_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
            this.audit = temp;
        }
    }

    public void store(SBdb sbdb) throws SQLException, SBPermissionException {
        if (this.getName() == null || this.getName().isEmpty()) {
            throw new IllegalStateException("Attempt to store well list with no name");
        }
        if (this.getID() <= 0) {
            throw new IllegalStateException("Attempt to store well list with illegal ID: " + this.getID());
        }
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "INSERT INTO " + sbdb.DBTableName("WELLIST") + " (wellist_id,proj_id,name,descr," + Audit.sqlFieldString() + ") VALUES (" + this.getID() + "," + this.getProjID() + "," + SB.DBString((String)this.getName()) + "," + SB.DBString((String)this.getDescription()) + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }

    public void delete(SBdb sbdb) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "DELETE FROM " + sbdb.DBTableName("WELLIST_MBR") + " WHERE wellist_id=" + this.getID();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
            sql = "DELETE FROM " + sbdb.DBTableName("WELLIST") + " WHERE wellist_id=" + this.getID();
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
    }
}

