/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wfs.internal.parsers;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.eclipse.xsd.XSDElementDeclaration;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.gml3.ApplicationSchemaConfiguration;
import org.geotools.gml3.GML;
import org.geotools.gml3.bindings.GML3ParsingUtils;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.BindingWalkerFactory;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.SchemaIndex;
import org.geotools.xsd.Schemas;
import org.geotools.xsd.impl.BindingFactoryImpl;
import org.geotools.xsd.impl.BindingLoader;
import org.geotools.xsd.impl.BindingWalkerFactoryImpl;
import org.geotools.xsd.impl.NamespaceSupportWrapper;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.DefaultPicoContainer;
import org.xml.sax.helpers.NamespaceSupport;

public class EmfAppSchemaParser {
    private static final Logger LOGGER = Logging.getLogger(EmfAppSchemaParser.class);

    public static SimpleFeatureType parseSimpleFeatureType(QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Configuration wfsConfiguration, Map<QName, Class<?>> mappedBindings) throws IOException {
        return EmfAppSchemaParser.parseSimpleFeatureType(wfsConfiguration, featureName, schemaLocation, crs, mappedBindings);
    }

    public static SimpleFeatureType parseSimpleFeatureType(Configuration wfsConfiguration, QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Map<QName, Class<?>> mappedBindings) throws IOException {
        SimpleFeatureType realType = EmfAppSchemaParser.parse(wfsConfiguration, featureName, schemaLocation, crs, mappedBindings);
        SimpleFeatureType subsetType = EmfAppSchemaParser.toSimpleFeatureType((FeatureType)realType);
        return subsetType;
    }

    public static SimpleFeatureType toSimpleFeatureType(FeatureType realType) throws DataSourceException {
        SimpleFeatureType subsetType;
        Collection descriptors = realType.getDescriptors();
        List attributes = new ArrayList(descriptors);
        ArrayList<String> simpleProperties = new ArrayList<String>();
        HashSet<String> ignoreList = new HashSet<String>(Arrays.asList(GML.location.getLocalPart(), GML.metaDataProperty.getLocalPart(), GML.description.getLocalPart(), GML.name.getLocalPart(), GML.boundedBy.getLocalPart()));
        if (attributes.size() > ignoreList.size()) {
            HashSet firstAtts = new HashSet();
            for (int i = 0; i < ignoreList.size(); ++i) {
                firstAtts.add(((PropertyDescriptor)attributes.get(i)).getName().getLocalPart());
            }
            if (ignoreList.equals(firstAtts)) {
                attributes = attributes.subList(ignoreList.size(), attributes.size());
            }
        }
        for (PropertyDescriptor descriptor : attributes) {
            Class binding = descriptor.getType().getBinding();
            int maxOccurs = descriptor.getMaxOccurs();
            Name name = descriptor.getName();
            if ("http://www.opengis.net/gml".equals(name.getNamespaceURI()) || maxOccurs > 1 || Object.class.equals((Object)binding)) {
                LOGGER.fine("Ignoring multivalued or complex property " + name + " on feature type " + realType.getName());
                continue;
            }
            simpleProperties.add(((AttributeDescriptor)descriptor).getLocalName());
        }
        String[] properties = simpleProperties.toArray(new String[simpleProperties.size()]);
        try {
            subsetType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)realType), (String[])properties);
        }
        catch (SchemaException e) {
            throw new DataSourceException((Throwable)e);
        }
        return subsetType;
    }

    public static SimpleFeatureType parse(Configuration wfsConfiguration, QName featureName, URL schemaLocation, CoordinateReferenceSystem crs, Map<QName, Class<?>> mappedBindings) throws IOException {
        ApplicationSchemaConfiguration configuration = EmfAppSchemaParser.getConfiguration(featureName, schemaLocation);
        XSDElementDeclaration elementDecl = EmfAppSchemaParser.parseFeatureType(featureName, configuration);
        Map bindings = wfsConfiguration.setupBindings();
        if (mappedBindings != null) {
            bindings.putAll(mappedBindings);
        }
        BindingLoader bindingLoader = new BindingLoader(bindings);
        MutablePicoContainer context = wfsConfiguration.setupContext((MutablePicoContainer)new DefaultPicoContainer());
        NamespaceSupport namespaces = new NamespaceSupport();
        context.registerComponentInstance((Object)namespaces);
        context.registerComponentInstance((Object)new NamespaceSupportWrapper(namespaces));
        BindingFactoryImpl bindingFactory = new BindingFactoryImpl(bindingLoader);
        context.registerComponentInstance((Object)bindingFactory);
        BindingWalkerFactoryImpl bwFactory = new BindingWalkerFactoryImpl(bindingLoader, context);
        context.registerComponentInstance((Object)bwFactory);
        try {
            SimpleFeatureType builder;
            SimpleFeatureType featureType = GML3ParsingUtils.featureType((XSDElementDeclaration)elementDecl, (BindingWalkerFactory)bwFactory);
            if (crs != null) {
                builder = new SimpleFeatureTypeBuilder();
                builder.setName(featureType.getName());
                builder.setAbstract(featureType.isAbstract());
                builder.setDescription(featureType.getDescription());
                if (featureType.getSuper() instanceof SimpleFeatureType) {
                    builder.setSuperType((SimpleFeatureType)featureType.getSuper());
                }
                List attributes = featureType.getAttributeDescriptors();
                GeometryDescriptor defaultGeometry = featureType.getGeometryDescriptor();
                for (AttributeDescriptor descriptor : attributes) {
                    if (descriptor instanceof GeometryDescriptor) {
                        String name = descriptor.getLocalName();
                        Class binding = descriptor.getType().getBinding();
                        builder.add(name, binding, crs);
                        continue;
                    }
                    builder.add(descriptor);
                }
                if (defaultGeometry != null) {
                    builder.setDefaultGeometry(defaultGeometry.getLocalName());
                }
                featureType = builder.buildFeatureType();
            }
            builder = featureType;
            return builder;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            String msg = "Error parsing feature type for " + featureName + " from " + schemaLocation.toExternalForm();
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            configuration.getXSD().dispose();
        }
    }

    private static XSDElementDeclaration parseFeatureType(QName featureTypeName, ApplicationSchemaConfiguration configuration) throws DataSourceException {
        SchemaIndex schemaIndex;
        try {
            schemaIndex = Schemas.findSchemas((Configuration)configuration);
        }
        catch (RuntimeException e) {
            throw new DataSourceException("Error parsing feature type for " + featureTypeName, (Throwable)e);
        }
        XSDElementDeclaration elementDeclaration = schemaIndex.getElementDeclaration(featureTypeName);
        schemaIndex.destroy();
        if (elementDeclaration == null) {
            throw new DataSourceException("No XSDElementDeclaration found for " + featureTypeName);
        }
        return elementDeclaration;
    }

    private static ApplicationSchemaConfiguration getConfiguration(QName featureTypeName, URL schemaLocation) {
        String namespaceURI = featureTypeName.getNamespaceURI();
        String uri = schemaLocation.toExternalForm();
        ApplicationSchemaConfiguration configuration = new ApplicationSchemaConfiguration(namespaceURI, uri);
        return configuration;
    }

    public static SimpleFeatureType parseSimpleFeatureType(Configuration configuration, QName featureTypeName, URL schemaLocation, CoordinateReferenceSystem crs) throws IOException {
        return EmfAppSchemaParser.parseSimpleFeatureType(configuration, featureTypeName, schemaLocation, crs, null);
    }
}

