/*
 * Decompiled with CFR 0.152.
 */
package com.stratadata.sbconvert;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OracleBooleanColumnTransform {
    public boolean match(String sql) {
        return sql.contains("BIT") || sql.contains("BOOLEAN");
    }

    public String transform(String sql) {
        String result = sql;
        if (sql.contains("BIT NOT NULL")) {
            Pattern p = Pattern.compile("(\\w+)\\s+BIT NOT NULL", 2);
            Matcher m = p.matcher(sql);
            result = m.replaceAll("$1 NUMBER(1) DEFAULT 0 NOT NULL CHECK ($1 in (1, 0))");
        } else if (sql.contains("BIT DEFAULT 0")) {
            Pattern p = Pattern.compile("(\\w+)\\s+BIT DEFAULT 0", 2);
            Matcher m = p.matcher(sql);
            result = m.replaceAll("$1 NUMBER(1) DEFAULT 0 CHECK ($1 in (1, 0))");
        } else if (sql.contains("BIT DEFAULT 1")) {
            Pattern p = Pattern.compile("(\\w+)\\s+BIT DEFAULT 1", 2);
            Matcher m = p.matcher(sql);
            result = m.replaceAll("$1 NUMBER(1) DEFAULT 1 CHECK ($1 in (1, 0))");
        }
        return result;
    }
}

