/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.text.MessageFormat;
import java.util.Arrays;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.util.Utilities;

public class GridToEnvelopeMapper {
    public static final int SWAP_XY = 1;
    public static final int REVERSE_AXIS = 2;
    private int defined;
    private GridEnvelope gridRange;
    private Bounds envelope;
    private PixelInCell anchor = PixelInCell.CELL_CENTER;
    private Boolean swapXY;
    private boolean[] reverseAxis;
    private MathTransform transform;

    public GridToEnvelopeMapper() {
    }

    public GridToEnvelopeMapper(GridEnvelope gridRange, Bounds userRange) throws MismatchedDimensionException {
        GridToEnvelopeMapper.ensureNonNull("gridRange", gridRange);
        GridToEnvelopeMapper.ensureNonNull("userRange", userRange);
        int gridDim = gridRange.getDimension();
        int userDim = userRange.getDimension();
        if (userDim != gridDim) {
            throw new MismatchedDimensionException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", gridDim, userDim));
        }
        this.gridRange = gridRange;
        this.envelope = userRange;
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }

    private static void ensureDimensionMatch(GridEnvelope gridRange, Bounds envelope, boolean checkingRange) {
        if (gridRange != null && envelope != null) {
            int dim2;
            int dim1;
            String label;
            if (checkingRange) {
                label = "gridRange";
                dim1 = gridRange.getDimension();
                dim2 = envelope.getDimension();
            } else {
                label = "envelope";
                dim1 = envelope.getDimension();
                dim2 = gridRange.getDimension();
            }
            if (dim1 != dim2) {
                throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", label, dim1, dim2));
            }
        }
    }

    private void reset() {
        this.transform = null;
        if (this.isAutomatic(2)) {
            this.reverseAxis = null;
        }
        if (this.isAutomatic(1)) {
            this.swapXY = null;
        }
    }

    public PixelInCell getPixelAnchor() {
        return this.anchor;
    }

    public void setPixelAnchor(PixelInCell anchor) {
        GridToEnvelopeMapper.ensureNonNull("anchor", anchor);
        if (!Utilities.equals((Object)this.anchor, (Object)anchor)) {
            this.anchor = anchor;
            this.reset();
        }
    }

    public GridEnvelope getGridRange() throws IllegalStateException {
        if (this.gridRange == null) {
            throw new IllegalStateException(MessageFormat.format("Missing value for parameter \"{0}\".", "gridRange"));
        }
        return this.gridRange;
    }

    public void setGridRange(GridEnvelope gridRange) {
        GridToEnvelopeMapper.ensureNonNull("gridRange", gridRange);
        GridToEnvelopeMapper.ensureDimensionMatch(gridRange, this.envelope, true);
        if (!Utilities.equals((Object)this.gridRange, (Object)gridRange)) {
            this.gridRange = gridRange;
            this.reset();
        }
    }

    public Bounds getEnvelope() throws IllegalStateException {
        if (this.envelope == null) {
            throw new IllegalStateException(MessageFormat.format("Missing value for parameter \"{0}\".", "envelope"));
        }
        return this.envelope;
    }

    public void setEnvelope(Bounds envelope) {
        GridToEnvelopeMapper.ensureNonNull("envelope", envelope);
        GridToEnvelopeMapper.ensureDimensionMatch(this.gridRange, envelope, false);
        if (!Utilities.equals((Object)this.envelope, (Object)envelope)) {
            this.envelope = envelope;
            this.reset();
        }
    }

    private static boolean swapXY(CoordinateSystem cs) {
        if (cs != null && cs.getDimension() >= 2) {
            return AxisDirection.NORTH.equals((Object)cs.getAxis(0).getDirection().absolute()) && AxisDirection.EAST.equals((Object)cs.getAxis(1).getDirection().absolute());
        }
        return false;
    }

    public boolean getSwapXY() {
        if (this.swapXY == null) {
            boolean value = false;
            if (this.isAutomatic(1)) {
                value = GridToEnvelopeMapper.swapXY(this.getCoordinateSystem());
            }
            this.swapXY = value;
        }
        return this.swapXY;
    }

    public void setSwapXY(boolean swapXY) {
        Boolean newValue = swapXY;
        if (!newValue.equals(this.swapXY)) {
            this.reset();
        }
        this.swapXY = newValue;
        this.defined |= 1;
    }

    public boolean[] getReverseAxis() {
        if (this.reverseAxis == null) {
            CoordinateSystem cs = this.getCoordinateSystem();
            if (cs != null) {
                int dimension = cs.getDimension();
                this.reverseAxis = new boolean[dimension];
                if (this.isAutomatic(2)) {
                    int i;
                    for (i = 0; i < dimension; ++i) {
                        AxisDirection direction = cs.getAxis(i).getDirection();
                        AxisDirection absolute = direction.absolute();
                        this.reverseAxis[i] = direction != AxisDirection.OTHER && direction.equals((Object)absolute.opposite());
                    }
                    if (dimension >= 2) {
                        i = this.getSwapXY() ? 0 : 1;
                        this.reverseAxis[i] = !this.reverseAxis[i];
                    }
                }
            } else {
                int length = 0;
                if (this.gridRange != null) {
                    length = this.gridRange.getDimension();
                } else if (this.envelope != null) {
                    length = this.envelope.getDimension();
                }
                if (length >= 2) {
                    this.reverseAxis = new boolean[length];
                    this.reverseAxis[1] = true;
                }
            }
        }
        return this.reverseAxis;
    }

    public void setReverseAxis(boolean[] reverse) {
        if (!Arrays.equals(this.reverseAxis, reverse)) {
            this.reset();
        }
        this.reverseAxis = reverse;
        this.defined |= 2;
    }

    public void reverseAxis(int dimension) {
        if (this.reverseAxis == null) {
            int length;
            if (this.gridRange != null) {
                length = this.gridRange.getDimension();
            } else {
                GridToEnvelopeMapper.ensureNonNull("envelope", this.envelope);
                length = this.envelope.getDimension();
            }
            this.reverseAxis = new boolean[length];
        }
        if (!this.reverseAxis[dimension]) {
            this.reset();
        }
        this.reverseAxis[dimension] = true;
        this.defined |= 2;
    }

    public boolean isAutomatic(int mask) {
        return (this.defined & mask) == 0;
    }

    public void setAutomatic(int mask) {
        this.defined &= ~mask;
    }

    private CoordinateSystem getCoordinateSystem() {
        CoordinateReferenceSystem crs;
        if (this.envelope != null && (crs = this.envelope.getCoordinateReferenceSystem()) != null) {
            return crs.getCoordinateSystem();
        }
        return null;
    }

    public MathTransform createTransform() throws IllegalStateException {
        if (this.transform == null) {
            double translate;
            GridEnvelope gridRange = this.getGridRange();
            Bounds userRange = this.getEnvelope();
            boolean swapXY = this.getSwapXY();
            boolean[] reverse = this.getReverseAxis();
            PixelInCell gridType = this.getPixelAnchor();
            int dimension = gridRange.getDimension();
            if (PixelInCell.CELL_CENTER.equals((Object)gridType)) {
                translate = 0.5;
            } else if (PixelInCell.CELL_CORNER.equals((Object)gridType)) {
                translate = 0.0;
            } else {
                throw new IllegalStateException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "gridType", gridType));
            }
            XMatrix matrix = MatrixFactory.create(dimension + 1);
            for (int i = 0; i < dimension; ++i) {
                double offset;
                int j = i;
                if (swapXY && j <= 1) {
                    j = 1 - j;
                }
                double scale = userRange.getSpan(j) / (double)gridRange.getSpan(i);
                if (reverse == null || j >= reverse.length || !reverse[j]) {
                    offset = userRange.getMinimum(j);
                } else {
                    scale = -scale;
                    offset = userRange.getMaximum(j);
                }
                matrix.setElement(j, j, 0.0);
                matrix.setElement(j, i, scale);
                matrix.setElement(j, dimension, offset -= scale * ((double)gridRange.getLow(i) - translate));
            }
            this.transform = ProjectiveTransform.create(matrix);
        }
        return this.transform;
    }

    public AffineTransform createAffineTransform() throws IllegalStateException {
        MathTransform transform = this.createTransform();
        if (transform instanceof AffineTransform) {
            return (AffineTransform)transform;
        }
        throw new IllegalStateException("Transform is not affine.");
    }
}

