/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.logging.Level;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class RotatedPole
extends MapProjection {
    private static final long serialVersionUID = 9008485425176368580L;

    protected RotatedPole(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double sinlat = Math.sin(y);
        double coslat = Math.cos(y);
        double sinlatP = Math.sin(1.5707963267948966 - this.latitudeOfOrigin);
        double coslatP = Math.cos(1.5707963267948966 - this.latitudeOfOrigin);
        double sinlon1 = Math.sin(x);
        double coslon1 = Math.cos(x);
        x = Math.toDegrees(Math.atan(coslat * sinlon1 / (coslat * sinlatP * coslon1 + sinlat * coslatP))) / this.globalScale;
        y = Math.toDegrees(Math.asin(sinlat * sinlatP - coslat * coslatP * coslon1)) / this.globalScale;
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double scalePI = this.globalScale * Math.PI / 180.0;
        double sinlat = Math.sin(y * scalePI);
        double coslat = Math.cos(y * scalePI);
        double sinlon = Math.sin(x * scalePI);
        double coslon = Math.cos(x * scalePI);
        double sinlatP = Math.sin(1.5707963267948966 - this.latitudeOfOrigin);
        double coslatP = Math.cos(1.5707963267948966 - this.latitudeOfOrigin);
        x = -Math.atan(coslat * sinlon / (sinlat * coslatP - sinlatP * coslat * coslon));
        y = Math.asin(sinlat * sinlatP + coslat * coslon * coslatP);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 8452425384927757022L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.AUTO, "Rotated_Pole")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException, FactoryException {
            if (Provider.isSpherical(parameters)) {
                return new RotatedPole(parameters);
            }
            MapProjection.LOGGER.log(Level.FINE, "GeoTools RotatedPole transformation is defined only on the sphere, we're going to use spherical equations even if the projection is using an ellipsoid");
            return new RotatedPole(parameters);
        }
    }
}

