/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.prefs.Preferences;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.GeneralPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.Utilities;

public class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform,
org.geotools.referencing.util.Formattable,
Cloneable {
    private static final long serialVersionUID = -5299837898367149069L;
    private transient AffineTransform2D inverse;

    public AffineTransform2D(AffineTransform transform) {
        super(transform);
    }

    public AffineTransform2D(double m00, double m10, double m01, double m11, double m02, double m12) {
        super(m00, m10, m01, m11, m02, m12);
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        super.checkPermission();
    }

    public ParameterValueGroup getParameterValues() {
        return ProjectiveTransform.getParameterValues(this.getMatrix());
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    public Position transform(Position ptSrc, Position ptDst) {
        if (ptDst == null) {
            ptDst = new GeneralPosition(2);
        } else {
            int dimension = ptDst.getDimension();
            if (dimension != 2) {
                throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", "ptDst", dimension, 2));
            }
        }
        double[] array = ptSrc.getCoordinate();
        this.transform(array, 0, array, 0, 1);
        ptDst.setOrdinate(0, array[0]);
        ptDst.setOrdinate(1, array[1]);
        return ptDst;
    }

    @Override
    public Shape createTransformedShape(Shape shape) {
        return AffineTransform2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix3(this);
    }

    public Matrix derivative(Point2D point) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    public Matrix derivative(Position point) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                try {
                    AffineTransform2D affineTransform2D = this;
                    synchronized (affineTransform2D) {
                        this.inverse = new AffineTransform2D(this.createInverse());
                        this.inverse.inverse = this;
                    }
                }
                catch (java.awt.geom.NoninvertibleTransformException exception) {
                    throw new NoninvertibleTransformException(exception.getLocalizedMessage(), (Throwable)exception);
                }
            }
        }
        return this.inverse;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    @Override
    public String formatWKT(Formatter formatter) {
        ParameterValueGroup parameters = this.getParameterValues();
        formatter.append(formatter.getName((IdentifiedObject)parameters.getDescriptor()));
        formatter.append((GeneralParameterValue)parameters);
        return "PARAM_MT";
    }

    public String toWKT() {
        int indentation = 2;
        try {
            indentation = Preferences.userNodeForPackage(Formattable.class).getInt("Indentation", indentation);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Formatter formatter = new Formatter(Symbols.DEFAULT, indentation);
        formatter.append(this);
        return formatter.toString();
    }

    @Override
    public String toString() {
        return this.toWKT();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        AffineTransform a = (AffineTransform)obj;
        return Utilities.equals((double)this.getScaleX(), (double)a.getScaleX()) && Utilities.equals((double)this.getScaleY(), (double)a.getScaleY()) && Utilities.equals((double)this.getShearX(), (double)a.getShearX()) && Utilities.equals((double)this.getShearY(), (double)a.getShearY()) && Utilities.equals((double)this.getTranslateX(), (double)a.getTranslateX()) && Utilities.equals((double)this.getTranslateY(), (double)a.getTranslateY());
    }
}

