/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import si.uom.NonSI;
import si.uom.SI;
import tech.units.indriya.AbstractUnit;

public class SimilarityTransformProvider
extends MathTransformProvider {
    private static final long serialVersionUID = -7413519919588731455L;
    public static final ParameterDescriptor<Double> TRANSLATION_1 = SimilarityTransformProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Ordinate 1 of evaluation point in target CRS"), new NamedIdentifier(Citations.EPSG, "8621")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> TRANSLATION_2 = SimilarityTransformProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Ordinate 2 of evaluation point in target CRS"), new NamedIdentifier(Citations.EPSG, "8622")}, 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, SI.METRE);
    public static final ParameterDescriptor<Double> SCALE = SimilarityTransformProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Scale difference"), new NamedIdentifier(Citations.EPSG, "8611")}, 1.0, Double.MIN_NORMAL, Double.POSITIVE_INFINITY, AbstractUnit.ONE);
    public static final ParameterDescriptor<Double> ROTATION = SimilarityTransformProvider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Rotation angle of source CRS axes"), new NamedIdentifier(Citations.EPSG, "8614")}, 0.0, 0.0, 1296000.0, NonSI.SECOND_ANGLE);
    static final ParameterDescriptorGroup PARAMETERS = SimilarityTransformProvider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Similarity transformation"), new NamedIdentifier(Citations.EPSG, "9621")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{TRANSLATION_1, TRANSLATION_2, SCALE, ROTATION});

    public SimilarityTransformProvider() {
        super(2, 2, PARAMETERS);
    }

    @Override
    protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
        double t1 = SimilarityTransformProvider.doubleValue(TRANSLATION_1, values);
        double t2 = SimilarityTransformProvider.doubleValue(TRANSLATION_2, values);
        double scale = SimilarityTransformProvider.doubleValue(SCALE, values);
        double rotation = SimilarityTransformProvider.doubleValue(ROTATION, values);
        double theta = Math.PI * rotation / 648000.0;
        double p1 = scale * Math.cos(theta);
        double p2 = scale * Math.sin(theta);
        return new AffineTransform2D(p1, -p2, p2, p1, t1, t2);
    }
}

