/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import util.ColourUtils;

public enum AgeConfidence {
    CONFIDENT(0, "Confident"),
    PROBABLE(33, "Probable"),
    POSSIBLE(66, "Possible");

    private final int percent;
    private final String name;

    private AgeConfidence(int percent, String name) {
        this.percent = percent;
        this.name = name;
    }

    public int getDBint() {
        return this.percent;
    }

    public String toString() {
        return this.name;
    }

    public static AgeConfidence getConfidence(int percent) {
        AgeConfidence lastConf = null;
        for (AgeConfidence conf : AgeConfidence.values()) {
            if (lastConf == null) {
                lastConf = conf;
                continue;
            }
            if (percent <= lastConf.percent) break;
            lastConf = conf;
        }
        return lastConf;
    }

    public static AgeConfidence getConfidence(String confidence) {
        for (AgeConfidence conf : AgeConfidence.values()) {
            if (!conf.name.equalsIgnoreCase(confidence)) continue;
            return conf;
        }
        return CONFIDENT;
    }

    public static AgeConfidence getMaxUnconfidence(int percent) {
        for (int i = AgeConfidence.values().length - 1; i >= 0; --i) {
            if (percent < AgeConfidence.values()[i].percent) continue;
            return AgeConfidence.values()[i];
        }
        return CONFIDENT;
    }

    public Color getLighterColor(Color c) {
        if (this.percent > 0) {
            c = ColourUtils.getLighterColour((Color)c, (float)(1.0f - (float)this.percent / 120.0f));
        }
        return c;
    }

    public float getLighterStroke(float basic) {
        if (this.percent > 0) {
            return basic * (1.0f - (float)this.percent / 120.0f);
        }
        return basic;
    }
}

