/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JOptionPane;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.EnvScheme;
import model2_1.IGDInterval;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.SBEvent;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleLithologyUnit;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WellEvent;
import model2_1.WellHeader;
import model2_1.WellInterp;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.InvalidFieldException;
import util.SBException;
import util.SBPermissionException;
import util.status.MergeStatus;

public final class BugWareReader {
    private final Set<Integer> dataTypes;
    private final char units;
    private EnvScheme envScheme;
    int waterDepthUpper = 0;
    int waterDepthLower = 0;
    int topWaterDepthProx = 0;
    int topWaterDepthDist = 0;
    int baseWaterDepthProx = 0;
    int baseWaterDepthDist = 0;
    Sample envSample = null;
    Sample topEnvSample = null;
    Sample baseEnvSample = null;
    boolean useBiostratComments;
    boolean ignoreSemiQuant;
    boolean useSampleLithology;
    boolean primaryCommentsAreEvents;
    SBEvent.EventType eventType;
    SBdb ws;
    int specID = 1;
    private SourceDetails sourceDetails = new SourceDetails();

    public BugWareReader(SBdb ws, String fileName, Set<Integer> dataTypes, char discID, char units, Userdef analyst, boolean useBiostratComments, boolean primaryCommentsAreEvents, SBEvent.EventType eventType, boolean useSampleLithlogy, boolean ignoreSemiQuant, boolean useSampleTops) throws SBException, SQLException, InvalidFieldException {
        this.dataTypes = dataTypes;
        this.units = units;
        this.useBiostratComments = useBiostratComments;
        this.primaryCommentsAreEvents = primaryCommentsAreEvents;
        this.eventType = eventType;
        this.useSampleLithology = useSampleLithlogy;
        this.ignoreSemiQuant = ignoreSemiQuant;
        this.sourceDetails.analystID = ws.getAddUserID(analyst.getAbr());
        Userdef wsAnalyst = ws.getUser(this.sourceDetails.analystID);
        wsAnalyst.setLink(analyst);
        this.ws = ws;
        LinkedList<ChronoRecord> ages = new LinkedList<ChronoRecord>();
        LinkedList<ChronoRecord> stages = new LinkedList<ChronoRecord>();
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 7).equals("BUGWARE")) {
                    System.out.println("WARNING: file type questionable");
                }
                WsWell well = ws.addWellToWorkspace(0, fileName);
                well.loadInterps();
                String wellCode = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf(46));
                well.getHeader().setWellName(wellCode);
                well.getHeader().setWellCode(Well.makeCode(wellCode));
                well.getHeader().setWellUnits(units);
                if (this.envScheme == null) {
                    this.envScheme = new EnvScheme(ws, 1, "BugWare Scheme");
                    ws.addEnvScheme(this.envScheme);
                }
                AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
                analyHdr.setEnvScheme(this.envScheme.getID());
                well.getSamples();
                this.parseWell(in, this.sourceDetails, well, useSampleTops);
                buff = "";
                while (buff != null && !buff.startsWith(" @@@@")) {
                    buff = this.parseSample(discID, in, this.sourceDetails, well, analyHdr, useSampleTops, ages, stages);
                }
                if (well.getSamples().size() > 0) {
                    well.getHeader().setTD(well.getSamples().get(well.getSamples().size() - 1).getDepth('M'));
                }
                if (!ages.isEmpty()) {
                    this.addChrono(well, ages, IGDIntervalZone.getHierNumber(3, "Period", true));
                }
                if (!stages.isEmpty()) {
                    this.addChrono(well, stages, IGDIntervalZone.getHierNumber(3, "Age", true));
                }
                well.updateStatus(dataTypes);
            }
            catch (IOException | IllegalStateException | SQLException | SBException | SBPermissionException eio) {
                eio.printStackTrace();
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, "Cannot open file: " + ioe.getMessage());
        }
    }

    private String parseWell(BufferedReader in, SourceDetails sourceDetails, Well well, boolean useSampleTops) throws IOException, SBException {
        String buff = in.readLine();
        WellHeader header = well.getHeader();
        header.setWellUnits(this.units);
        SimpleDateFormat[] dateFormats = new SimpleDateFormat[]{new SimpleDateFormat("M,y"), new SimpleDateFormat("MM/dd/yy")};
        sourceDetails.analysisDate = new Date();
        while (buff != null && !buff.startsWith(" @@@@")) {
            if ((buff = buff.trim()).indexOf(58) > 0) {
                String value = buff.substring(buff.lastIndexOf(58) + 1).trim();
                if ((buff = buff.toUpperCase(Locale.UK)).startsWith("API:")) {
                    header.setWellCode(value);
                } else if (buff.startsWith("COUNTRY")) {
                    header.setCountry(value);
                } else if (buff.startsWith("AREA")) {
                    header.setWellName(value);
                } else if (buff.startsWith("BLOCK")) {
                    header.setWellName(header.getWellName() + " " + value);
                } else if (buff.startsWith("OCS")) {
                    header.setOCS(value);
                } else if (buff.startsWith("WELL NUMBER")) {
                    header.setWellName(header.getWellName() + "-" + value);
                } else if (buff.startsWith("OPERATOR")) {
                    header.setOper(value);
                } else if (buff.startsWith("LAST SAMPLE")) {
                    if (value != null && value.length() != 0) {
                        Sample.Builder builder = Sample.parseDepthString(value.trim(), this.units, false, useSampleTops);
                        header.setTD(builder.getDepth(useSampleTops));
                    }
                } else if (buff.startsWith("PALEONTOLOGIST")) {
                    sourceDetails.analystName = value;
                } else if (buff.startsWith("SOURCE")) {
                    sourceDetails.sourceName = value;
                } else if (buff.startsWith("DATE")) {
                    for (SimpleDateFormat df : dateFormats) {
                        try {
                            sourceDetails.analysisDate = df.parse(value);
                            break;
                        }
                        catch (ParseException parseException) {
                        }
                    }
                }
            }
            buff = in.readLine();
        }
        return buff;
    }

    /*
     * Unable to fully structure code
     */
    String parseSample(char discID, BufferedReader in, SourceDetails sourceDetails, Well well, AnalystHeader analyHdr, boolean useSampleTops, List<ChronoRecord> ages, List<ChronoRecord> stages) throws IOException, SBException, SQLException {
        block75: {
            recType = '\u0000';
            buff = in.readLine();
            sample = null;
            biocom = null;
            lithcom = null;
            smpdtl = null;
            markerList = new LinkedList<String>();
            COMMENT_TYPES = new String[]{"SECONDARY COMMENT", "AGE", "STAGE", "PALEONTOLOGIST", "LITHOLOGIC ACCESSORIES", "SAMPLE TYPE", "SAMPLE QUALITY", "TOTAL ABUNDANCE", "TIME"};
            try {
                while (buff != null) {
                    block76: {
                        buff = buff.trim();
                        System.out.println(buff);
                        if (buff.length() <= 0) break block76;
                        if (buff.startsWith("@@@@")) break block75;
                        foundCommentRecord = false;
                        for (i = 0; i < COMMENT_TYPES.length; ++i) {
                            if (!buff.toUpperCase().startsWith(COMMENT_TYPES[i])) continue;
                            buff = buff.substring(COMMENT_TYPES[i].length() + 2);
                            block6 : switch (i) {
                                default: {
                                    this.addComment(buff, well, sample, smpdtl, biocom, discID, analyHdr);
                                    break;
                                }
                                case 1: {
                                    System.out.println("Age is: " + buff);
                                    for (ChronoRecord rec : ages) {
                                        if (rec.sample != sample) continue;
                                        rec.unitName = buff;
                                        break block6;
                                    }
                                    break;
                                }
                                case 2: {
                                    System.out.println("Stage is: " + buff);
                                    for (ChronoRecord rec : stages) {
                                        if (rec.sample != sample) continue;
                                        rec.unitName = buff;
                                        break block6;
                                    }
                                    break;
                                }
                                case 3: {
                                    System.out.println("Paleontologist is: " + buff);
                                    sourceDetails.analystName = buff;
                                    break;
                                }
                                case 4: {
                                    System.out.println("Lithology accessories: " + buff);
                                    break;
                                }
                                case 5: {
                                    System.out.println("Sample type: " + buff);
                                    sample.setType(SampleType.parseType(buff));
                                    break;
                                }
                                case 6: {
                                    System.out.println("Sample quality (ignored): " + buff);
                                    break;
                                }
                                case 7: {
                                    System.out.println("Total abundance (ignored): " + buff);
                                    break;
                                }
                                case 8: {
                                    System.out.println("Time (ignored): " + buff);
                                }
                            }
                            foundCommentRecord = true;
                            break;
                        }
                        if (foundCommentRecord) {
                            buff = in.readLine();
                            continue;
                        }
                        recType = buff.charAt(0);
                        buff = buff.substring(1);
                        switch (recType) {
                            default: {
                                System.out.println("Cannot parse line: " + buff);
                                break;
                            }
                            case '.': {
                                return buff;
                            }
                            case '@': {
                                sbuilder = Sample.parseDepthString(buff, this.units, false, useSampleTops).type(SampleType.CU);
                                try {
                                    sample = well.addSample(sbuilder, 0, null);
                                }
                                catch (SBPermissionException pe) {
                                    throw new IllegalStateException("Unexpected permission exception in workspace");
                                }
                                sample.displayUnits = this.units;
                                audit = new Audit(analyHdr.getAnalystUsrid(), sourceDetails.analysisDate, analyHdr.getAnalystUsrid(), sourceDetails.analysisDate);
                                smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", sourceDetails.sourceName, sourceDetails.analystName != null && sourceDetails.analystName.isEmpty() == false ? "Analyst: " + sourceDetails.analystName : null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, audit, Smpdtl.AnalysisType.ANALYSED);
                                sample.insert(smpdtl);
                                if (sample.getBaseDepth('M') > well.getTD()) {
                                    well.getHeader().setTD(sample.getBaseDepth('M'));
                                }
                                markerList.clear();
                                ages.add(new ChronoRecord(sample, null));
                                stages.add(new ChronoRecord(sample, null));
                                break;
                            }
                            case '!': {
                                if (sample == null) {
                                    throw new SBException("Biostratigraphic comment/event lies outside sample: " + buff);
                                }
                                if (this.primaryCommentsAreEvents) {
                                    this.parseEvents(buff, this.ws, well, sample, discID);
                                    break;
                                }
                                biocom = this.addComment(buff, well, sample, smpdtl, biocom, discID, analyHdr);
                                break;
                            }
                            case '$': {
                                if (sample == null) {
                                    throw new SBException("Sample lithology lies outside sample: " + buff);
                                }
                                if (!this.useSampleLithology) ** GOTO lbl103
                                this.parseAddLithology(this.ws, sample, buff);
                                ** GOTO lbl126
lbl103:
                                // 1 sources

                                if (!this.useBiostratComments) ** GOTO lbl120
                                try {
                                    if (lithcom == null || lithcom.getTopID() != sample.getSampID()) {
                                        lithcom = new Biocom.Builder(this.ws, Discipline.MACRO, analyHdr.getAnalystUsrid(), sample, buff.trim()).build();
                                        well.getAddInterp(this.ws.getInterp(0)).insertBiocom(lithcom);
                                        this.addDataType(SBdb.did2comType('A'));
                                    } else {
                                        well.getAddInterp(this.ws.getInterp(0)).updateBiocom(biocom, well.getWellID(), Discipline.MACRO, sample, null, analyHdr.getAnalyst(), null, lithcom.getText() + " " + buff.trim());
                                    }
                                    if (lithcom.getText().length() > 240) {
                                        well.getAddInterp(this.ws.getInterp(0)).updateBiocom(biocom, well.getWellID(), Discipline.MACRO, sample, null, analyHdr.getAnalyst(), null, lithcom.getText().substring(0, 240));
                                        System.out.println("Biostratigraphic Comments truncated");
                                    }
                                    ** GOTO lbl126
                                }
                                catch (InvalidFieldException e) {
                                    System.out.println(e.getMessage());
                                    break;
                                }
lbl120:
                                // 1 sources

                                if (smpdtl == null) {
                                    throw new SBException("Sample record for comment blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                                }
                                buff = buff.trim();
                                if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                                    smpdtl.appendNote("\n");
                                }
                                smpdtl.appendNote(buff);
                            }
lbl126:
                            // 4 sources

                            case '&': 
                            case '(': 
                            case '*': 
                            case ';': {
                                if (smpdtl == null) {
                                    throw new SBException("Cannot read file correctly - Sample record blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                                }
                                buff = buff.trim();
                                if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                                    smpdtl.appendNote("\n");
                                }
                                smpdtl.appendNote(buff);
                                break;
                            }
                            case ')': {
                                if (this.envScheme == null) break;
                                for (index = 0; index < buff.length() && (Character.isDigit(buff.charAt(index)) || Character.isWhitespace(buff.charAt(index)) || buff.charAt(index) == '-' || buff.charAt(index) == ',' || buff.charAt(index) == '.'); ++index) {
                                }
                                if (index >= buff.length()) break;
                                term = buff.substring(index);
                                try {
                                    termIndex = this.envScheme.getTermIndex(term);
                                }
                                catch (SBException sbe) {
                                    termIndex = this.envScheme.getNClasses();
                                    this.envScheme.addRow();
                                    this.envScheme.setTerm(termIndex, term);
                                }
                                if (smpdtl == null) {
                                    throw new SBException("Cannot read file correctly - Sample record blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
                                }
                                smpdtl.setProximal(termIndex);
                                smpdtl.setDistal(termIndex);
                                break;
                            }
                            case '+': 
                            case '/': {
                                if (buff.length() > 32) {
                                    markerList.add(buff.substring(0, 32).trim());
                                    break;
                                }
                                markerList.add(buff.trim());
                                break;
                            }
                            case '-': 
                            case '=': {
                                if (smpdtl == null) {
                                    if (sample == null) {
                                        throw new SBException("Cannot read file correctly - invalid sample around line: " + buff);
                                    }
                                    throw new SBException("Cannot read file correctly - Sample record blank in sample: " + sample.toString());
                                }
                                taxonRef = this.parseTaxon(buff.substring(0, 32).trim());
                                comment = buff.substring(32, 42).trim();
                                rw = false;
                                cv = false;
                                subjAbundString = buff.substring(32, 42).trim();
                                subjAbund = "";
                                if (subjAbundString.equalsIgnoreCase("REWORKED")) {
                                    rw = true;
                                } else if (subjAbundString.equalsIgnoreCase("REWORK")) {
                                    rw = true;
                                } else if (subjAbundString.equalsIgnoreCase("RWK")) {
                                    rw = true;
                                } else if (subjAbundString.equalsIgnoreCase("RW")) {
                                    rw = true;
                                } else if (subjAbundString.equalsIgnoreCase("CAVE")) {
                                    rw = true;
                                } else if (subjAbundString.equalsIgnoreCase("CAVING")) {
                                    cv = true;
                                } else if (subjAbundString.equalsIgnoreCase("CV")) {
                                    cv = true;
                                } else if (!this.ignoreSemiQuant) {
                                    subjAbund = subjAbundString;
                                }
                                ind = 0;
                                ind = buff.indexOf(91);
                                if (ind < 0 || buff.indexOf(93) < ind) {
                                    if (recType == '-') {
                                        System.out.println("(Check abundance bracketing in line:\n \"" + buff + "\" ");
                                        break;
                                    }
                                    throw new SBException("(Check abundance bracketing in line:\n \"" + buff + "\" ");
                                }
                                countString = buff.substring(buff.indexOf(91) + 1, buff.indexOf(93)).trim();
                                q = false;
                                try {
                                    counts = Integer.parseInt(countString);
                                }
                                catch (NumberFormatException nfe) {
                                    if ("?".equals(countString)) {
                                        counts = 1;
                                        q = true;
                                    }
                                    if (countString.contains("?")) {
                                        q = true;
                                        countString = countString.replace("?", "");
                                        counts = Integer.parseInt(countString);
                                    }
                                    throw new SBException("Problem parsing abundance: '" + countString + "' in line: " + buff + "\nSample: " + sample);
                                }
                                if (counts == 0) {
                                    throw new SBException("Counts for taxon: " + taxonRef.toString() + " are zero in sample: " + sample.toString());
                                }
                                marker = false;
                                for (String markerName : markerList) {
                                    if (!markerName.equalsIgnoreCase(taxonRef.donorString)) continue;
                                    marker = true;
                                    break;
                                }
                                builder = new TaxonOcc.Builder(this.ws, taxonRef, rw, q, 0);
                                builder = builder.count(counts).subjAbund(subjAbund).marker(marker).caved(cv).comment(comment);
                                try {
                                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                                }
                                catch (SBException ex) {
                                    throw new SBException(ex.getMessage() + " in Sample: " + sample.toString());
                                }
                                sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                                this.addDataType(1);
                                this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                            }
                            case '#': 
                        }
                    }
                    buff = in.readLine();
                }
            }
            catch (StringIndexOutOfBoundsException ex) {
                throw new SBException("at line: " + buff + "\nError message: " + ex.toString());
            }
        }
        return buff;
    }

    Taxon parseTaxon(String strg) {
        Taxon t = this.ws.getTaxon(strg, this.specID, true);
        if (t.getSpecID() == this.specID) {
            ++this.specID;
        }
        return t;
    }

    void parseAddLithology(SBdb ws, Sample sample, String buff) throws SQLException {
        String[] lithNames = new String[]{"SH", "LS", "SD", "SLT", "SST", "CMT", "MARL", "SLST", "SLTST", "ANHYD"};
        int[] lithCodes = new int[]{1055, 1030, 1008, 1005, 1064, 1901, 1053, 1058, 1058, 1043};
        String delimiters = "\\s+|,\\s*|\\.\\s*";
        buff = buff.replaceAll("Lithology:", "").trim();
        Object[] tokens = buff.split(delimiters);
        System.out.println("Split into: " + Arrays.toString(tokens));
        for (int i = 0; i < tokens.length; i += 2) {
            try {
                int percent = Integer.parseInt(((String)tokens[i]).replace("%", "").trim());
                if (percent <= 0) continue;
                int lithCode = 0;
                Object lithName = tokens[i + 1];
                for (int j = 0; j < lithNames.length; ++j) {
                    if (!((String)lithName).equalsIgnoreCase(lithNames[j])) continue;
                    lithCode = lithCodes[j];
                    break;
                }
                if (lithCode == 0) {
                    System.out.println("Invalid lith code for lithology: " + (String)lithName);
                    continue;
                }
                sample.sampleLithology.add(new SampleLithologyUnit(ws.getLithdesc().getLithology(lithCode), percent));
                this.addDataType(22);
                continue;
            }
            catch (NumberFormatException ne) {
                System.out.println("Can't parse lithology number string: " + (String)tokens[i]);
            }
        }
    }

    private void parseEvents(String buff, SBdb ws, Well well, Sample sample, char discID) throws SQLException, SBException {
        String[] names;
        if ((buff = buff.substring(1).trim()).length() < 1) {
            return;
        }
        for (String name : names = buff.split(",")) {
            SBEvent sbEvent = ws.getSBEvent(name);
            if (sbEvent == null) {
                try {
                    sbEvent = ws.addSBEvent(new SBEvent.Builder().name(name).isGenerate(true).isSingle(this.eventType == SBEvent.EventType.SINGLE));
                }
                catch (SBPermissionException e) {
                    throw new SBException(e.getMessage());
                }
            }
            WellEvent.Builder eventBuilder = new WellEvent.Builder().sample(sample).event(sbEvent).type(this.eventType).discID(Discipline.getDisc(discID));
            well.getAddInterp(ws.getInterp(0)).insertEvent(eventBuilder.build(ws));
            this.addDataType(16);
        }
    }

    Biocom addComment(String buff, Well well, Sample sample, Smpdtl smpdtl, Biocom biocom, char discID, AnalystHeader analyHdr) throws SQLException, SBException {
        if (this.useBiostratComments) {
            if (biocom == null || biocom.getTopID() != sample.getSampID()) {
                biocom = new Biocom.Builder(this.ws, Discipline.getDisc(discID), analyHdr.getAnalystUsrid(), sample, buff.trim()).build();
                well.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
                this.addDataType(SBdb.did2comType(discID));
            } else {
                biocom.setText(biocom.getText() + "\n" + buff.trim());
            }
            if (biocom.getText().length() > 240) {
                biocom.setText(biocom.getText().substring(0, 240));
                System.out.println("Biostratigraphic Comments truncated");
            }
        } else {
            if (smpdtl == null) {
                throw new SBException("Sample record for comment blank in sample: " + (sample != null ? sample.toString() : "") + " Line: " + buff);
            }
            buff = buff.trim();
            if (smpdtl.getNotes() != null && smpdtl.getNotes().length() > 0) {
                smpdtl.appendNote("\n");
            }
            smpdtl.appendNote(buff);
        }
        return biocom;
    }

    private void addChrono(WsWell well, List<ChronoRecord> ages, int hier) throws SQLException, InvalidFieldException, SBException {
        WellInterp wellInterp = well.getAddInterp(this.ws.getInterp(0));
        if (ages == null || ages.isEmpty()) {
            return;
        }
        String unassignedSchemeName = IGDInterval.getIGDName(3) + " (undefined)";
        IGDScheme scheme = this.ws.getIGDScheme(unassignedSchemeName, 3);
        if (scheme == null) {
            scheme = this.ws.addIGDScheme(3, unassignedSchemeName);
        }
        String lastAge = "";
        Sample topSample = null;
        Sample baseSample = null;
        for (ChronoRecord rec : ages) {
            if (rec.unitName == null || rec.unitName.equalsIgnoreCase(lastAge)) {
                baseSample = rec.sample;
                continue;
            }
            if (topSample != null) {
                IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, 3, topSample, baseSample, hier, scheme.getSchID()).uppInf(lastAge);
                wellInterp.addZone(builder, well);
                this.addDataType(10);
            }
            topSample = rec.sample;
            baseSample = rec.sample;
            lastAge = rec.unitName;
        }
        if (topSample != null) {
            IGDIntervalZone.Builder builder = new IGDIntervalZone.Builder(this.ws, 3, topSample, baseSample, hier, scheme.getSchID()).uppInf(lastAge);
            wellInterp.addZone(builder, well);
            this.addDataType(10);
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }

    static void scanForEnvs(String fileName, List envs) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            try {
                String buff = in.readLine();
                if (!buff.substring(0, 7).equals("BUGWARE")) {
                    throw new SBException("Not a BugWare format file");
                }
                while (buff != null) {
                    if (buff.length() > 0 && buff.charAt(0) == ')' && !envs.contains(buff.substring(1).trim())) {
                        envs.add(buff.substring(1).trim());
                    }
                    buff = in.readLine();
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    private static class SourceDetails {
        String analystName;
        String sourceName;
        Date analysisDate;
        int analystID;

        private SourceDetails() {
        }
    }

    private static class ChronoRecord {
        Sample sample;
        String unitName;

        ChronoRecord(Sample sample, String unitName) {
            this.sample = sample;
            this.unitName = unitName;
        }
    }
}

