/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.CSVGridReader;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class CSVReader {
    private final Set dataTypes;
    public final HashSet<String> rejects = new HashSet();
    boolean setEmptyAsBarren;
    GridReader in;
    private final SampleType defaultSampleType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVReader(SBdb db, GridReader in, Set dataTypes, char discID, char units, String analyst, int titleRow, int catRow, int dataRow, int topColumn, int baseColumn, int typeColumn, int analystColumn, int commentsColumn, int labelColumn, int taxaColumn, int taxaColumnEnd, boolean useBioComments, boolean isWell, boolean setEmptyAsBarren, boolean createEmptySmpdtl, SampleType sampleType) throws SBException, SQLException, GridReaderException {
        this.in = in;
        this.dataTypes = dataTypes;
        this.setEmptyAsBarren = setEmptyAsBarren;
        this.defaultSampleType = sampleType;
        if (db.getnLoadedWells() == 0) {
            dataTypes.clear();
        }
        String fileName = in.getFileName();
        WsWell well = db.addWellToWorkspace(0, fileName);
        String wellCode = fileName.substring(fileName.lastIndexOf(File.separatorChar) + 1, fileName.lastIndexOf(46));
        well.getHeader().setWellName(wellCode);
        well.getHeader().setWellCode(Well.makeCode(wellCode));
        well.getHeader().setWellUnits(units);
        if (!isWell) {
            well.getHeader().setType('O');
        }
        well.getSamples();
        well.loadInterps();
        List<String> categories = null;
        try {
            dataTypes.clear();
            int nRow = 0;
            while (in.nextRow()) {
                if (nRow == titleRow) {
                    this.parseTitles(db, taxaColumn);
                } else if (nRow == catRow) {
                    categories = this.parseCategories(taxaColumn);
                } else if (nRow >= dataRow) {
                    String strg;
                    Double topDepth = null;
                    Double baseDepth = null;
                    String label = "";
                    String sampleTypeString = null;
                    Sample sample = null;
                    Smpdtl smpdtl = null;
                    String comment = null;
                    char sampleUnits = units;
                    int col = 0;
                    while ((strg = in.getNextCell(false)) != null) {
                        if (!strg.isEmpty()) {
                            if ((col == topColumn || col == baseColumn) && strg.indexOf("-") > 0) {
                                topDepth = DepthUtils.parseDepthString((String)strg.substring(0, strg.indexOf("-")));
                                baseDepth = DepthUtils.parseDepthString((String)strg.substring(strg.indexOf("-") + 1, strg.length()));
                                if (topColumn == -1) {
                                    topColumn = baseColumn;
                                } else if (baseColumn == -1) {
                                    baseColumn = topColumn;
                                }
                                if (DepthUnits.parseDepthUnitsFromString((String)strg) == DepthUnits.F && units == 'F') {
                                    sampleUnits = 'M';
                                }
                            } else if (col == topColumn) {
                                if (strg.length() > 0) {
                                    topDepth = DepthUtils.parseDepthString((String)strg);
                                    if (DepthUnits.parseDepthUnitsFromString((String)strg) == DepthUnits.F && units == 'F') {
                                        sampleUnits = 'M';
                                    }
                                }
                            } else if (col == baseColumn) {
                                if (strg.length() > 0) {
                                    baseDepth = DepthUtils.parseDepthString((String)strg);
                                    if (DepthUnits.parseDepthUnitsFromString((String)strg) == DepthUnits.F && units == 'F') {
                                        sampleUnits = 'M';
                                    }
                                }
                            } else if (col == typeColumn) {
                                sampleTypeString = strg;
                            } else if (col == analystColumn) {
                                analyst = strg != null ? strg.toUpperCase() : null;
                            } else if (col == commentsColumn) {
                                comment = strg;
                            } else if (col == labelColumn) {
                                label = strg;
                            } else if (!strg.isEmpty() && col >= taxaColumn && col <= taxaColumnEnd) {
                                Taxon taxon;
                                if (topDepth == null && baseDepth == null) {
                                    System.out.println("CSV Reader: Skipping row: " + nRow);
                                    break;
                                }
                                if (smpdtl == null) {
                                    if (sample == null) {
                                        sample = this.getSample(well, sampleUnits, topDepth, baseDepth, sampleTypeString, label);
                                    }
                                    smpdtl = this.getSmpdtl(db, well, sample, analyst, discID);
                                }
                                if ((taxon = db.getTaxon(col)) == null) {
                                    throw new SBException("Error: Taxon name is blank for column: " + col + ", but data column is not blank.");
                                }
                                TaxonOcc.Builder builder = TaxonOcc.Builder.parseOcc(db, taxon, strg, this.rejects);
                                if (builder != null) {
                                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                                    smpdtl.updateBarren(well.getWellID(), Smpdtl.AnalysisType.ANALYSED, false);
                                }
                            }
                        }
                        ++col;
                    }
                    if (smpdtl == null && createEmptySmpdtl && (topDepth != null || baseDepth != null)) {
                        if (sample == null) {
                            sample = this.getSample(well, sampleUnits, topDepth, baseDepth, sampleTypeString, label);
                        }
                        smpdtl = this.getSmpdtl(db, well, sample, analyst, discID);
                    }
                    if (comment != null) {
                        if (topDepth == null && baseDepth == null) {
                            System.out.println("CSV Reader: Skipping comment for row: " + nRow);
                            break;
                        }
                        if (useBioComments) {
                            if (sample == null) {
                                sample = this.getSample(well, sampleUnits, topDepth, baseDepth, sampleTypeString, label);
                            }
                            Biocom biocom = new Biocom.Builder(db, Discipline.getDisc(discID), db.getUserID(analyst), sample, comment).build();
                            well.getAddInterp(db.getInterp(0)).insertBiocom(biocom);
                            this.addDataType(SBdb.did2comType(discID));
                        } else {
                            if (smpdtl == null) {
                                smpdtl = this.getSmpdtl(db, well, sample, analyst, discID);
                            }
                            smpdtl.appendNote(comment);
                        }
                    }
                }
                ++nRow;
            }
            if (categories != null) {
                for (int col = 0; col < categories.size(); ++col) {
                    String strg = categories.get(col);
                    if (strg == null || strg.isEmpty()) continue;
                    Taxon taxon = db.getTaxon(col);
                    if (taxon == null) {
                        throw new SBException("Error: Taxon name is blank (or duplicated) for column: " + (col + 1) + ", but category is not blank");
                    }
                    db.setTaxonCat(taxon.getSpecID(), strg.toUpperCase());
                }
            }
            this.addDataType(SBdb.did2dtype(discID));
            well.updateStatus(dataTypes);
        }
        finally {
            in.close();
        }
    }

    private Sample getSample(Well well, char sampleUnits, Double topDepth, Double baseDepth, String typeString, String label) throws SBException, SQLException {
        SampleType type;
        Sample sample;
        SampleType stype;
        if (topDepth == null && baseDepth == null) {
            return null;
        }
        topDepth = topDepth == null ? null : Double.valueOf(DepthUtils.convToM((double)topDepth, (char)sampleUnits));
        baseDepth = baseDepth == null ? null : Double.valueOf(DepthUtils.convToM((double)baseDepth, (char)sampleUnits));
        SampleType sampleType = stype = typeString != null ? SampleType.parseType(typeString) : this.defaultSampleType;
        if (stype == null) {
            // empty if block
        }
        if (well.getType() == 'O') {
            if (topDepth != null) {
                topDepth = -topDepth.doubleValue();
            }
            if (baseDepth != null) {
                baseDepth = -baseDepth.doubleValue();
            }
        }
        if ((sample = well.getSample(topDepth, baseDepth, type = stype != null ? stype : this.defaultSampleType, false)) == null) {
            try {
                sample = well.addSample(topDepth, baseDepth, type.name(), label);
                if (stype == null) {
                    sample.donorSampleType = typeString;
                }
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace");
            }
        }
        return sample;
    }

    private Smpdtl getSmpdtl(SBdb db, WsWell well, Sample sample, String analyst, char discID) throws SBException, SQLException {
        AnalystHeader header = well.getAnalystHeader(analyst, discID, 1, true);
        Smpdtl smpdtl = sample.getSmpdtl(header.getAnalyID());
        if (smpdtl == null) {
            smpdtl = new Smpdtl(db, sample, header, null, null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), this.setEmptyAsBarren ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.PREPARED);
            sample.addDtl(smpdtl);
        }
        return smpdtl;
    }

    private void parseTitles(SBdb db, int taxaColumn) throws SBException, SQLException, GridReaderException {
        String strg;
        if (taxaColumn < 0) {
            return;
        }
        int col = 0;
        while ((strg = this.in.getNextCell()) != null) {
            if (!strg.isEmpty()) {
                if (this.in instanceof CSVGridReader && strg.charAt(0) == '\"' && !strg.substring(1).contains("\"")) {
                    throw new SBException("Quotation chars found on input line");
                }
                if (col >= taxaColumn) {
                    Taxon temp = db.getTaxon(col);
                    String taxonName = SB.removeExcelQuotes((String)strg);
                    if (temp != null) {
                        if (!taxonName.equals(temp.toString())) {
                            throw new SBException("Attempt to read mismatching spreadsheet files into same workspace");
                        }
                    } else {
                        db.getTaxon(taxonName, col, true);
                    }
                }
            }
            ++col;
        }
    }

    private List<String> parseCategories(int taxaColumn) throws SBException, SQLException, GridReaderException {
        String strg;
        if (taxaColumn < 0) {
            return null;
        }
        int col = 0;
        LinkedList<String> categories = new LinkedList<String>();
        while ((strg = this.in.getNextCell()) != null) {
            if (col >= taxaColumn) {
                categories.add(strg);
            } else {
                categories.add("");
            }
            ++col;
        }
        return categories;
    }

    private void addDataType(int dType) {
        if (!this.dataTypes.contains(dType)) {
            this.dataTypes.add(dType);
        }
    }
}

