/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import model2_1.AbnScheme;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.SBException;
import util.SBPermissionException;

public class ChecklistReader {
    private final Set dataTypes;
    char discID;
    char units;
    boolean isType2 = false;
    AbnScheme abnScheme;
    SBdb ws;
    AnalystHeader analyHdr;
    int specID = 1;
    public HashSet<String> rejects = new HashSet();

    public ChecklistReader(SBdb ws, String fileName, Set dataTypes, char discID, char units, Userdef analyst, SampleType sampleType, boolean useSampleTops) throws SQLException, SBException, IOException {
        this.ws = ws;
        this.dataTypes = dataTypes;
        this.discID = discID;
        this.units = units;
        Object multiWellString = null;
        int analystID = ws.getAddUserID(analyst.getAbr());
        Userdef wsAnalyst = ws.getUser(analystID);
        wsAnalyst.setLink(analyst);
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            int i;
            String fileStem = fileName.substring(0, fileName.lastIndexOf("."));
            this.parseAbnFile(fileStem);
            String buff = in.readLine();
            String wellName = null;
            int nTaxa = 0;
            int nSamples = 0;
            int colWidth = 0;
            this.isType2 = this.getDataFileType(fileStem);
            if (buff.startsWith("REM ")) {
                for (int i2 = 0; i2 < 9; ++i2) {
                    buff = in.readLine();
                    if (buff == null) {
                        throw new SBException("Premature end of .chk file during reading of header");
                    }
                    if (buff.trim().startsWith("Data Set Name")) {
                        wellName = buff.substring(buff.indexOf(61) + 1).trim();
                    }
                    if (buff.trim().startsWith("Abund ColWidth")) {
                        colWidth = Integer.parseInt(buff.substring(buff.indexOf(61) + 1).trim());
                    }
                    if (buff.trim().startsWith("Species In Use")) {
                        nTaxa = Integer.parseInt(buff.substring(buff.indexOf(61) + 1).trim());
                    }
                    if (!buff.trim().startsWith("Samples In Use")) continue;
                    nSamples = Integer.parseInt(buff.substring(buff.indexOf(61) + 1).trim());
                }
            } else {
                wellName = buff;
                in.readLine();
                in.readLine();
                nTaxa = Integer.parseInt(in.readLine().trim());
                nSamples = Integer.parseInt(in.readLine().trim());
            }
            WsWell well = ws.addWellToWorkspace(0, fileName);
            well.getHeader().setWellName(wellName);
            well.getHeader().setWellCode(Well.makeCode(wellName));
            well.getHeader().setWellUnits(units);
            well.loadInterps();
            this.analyHdr = well.getAnalystHeader(wsAnalyst.getAbr(), discID, 1, true);
            if (this.abnScheme != null) {
                this.analyHdr.setAbnScheme(this.abnScheme.getID());
            }
            Taxon[] taxonA = new Taxon[nTaxa];
            Smpdtl[] smpdtlA = new Smpdtl[nSamples];
            Sample[] sampleA = new Sample[nSamples];
            Taxon dummy = this.parseTaxon(in, 0);
            for (i = 0; i < nTaxa; ++i) {
                taxonA[i] = this.parseTaxon(in, i + 1);
            }
            buff = in.readLine();
            if (buff.startsWith("REM")) {
                buff = in.readLine();
            }
            this.readSpeciesCategories(fileStem, taxonA);
            for (i = 0; i < nSamples; ++i) {
                buff = in.readLine().trim();
                if (!buff.startsWith("\\")) {
                    if (buff.trim().length() == 0) {
                        throw new SBException("Error reading file: cannot read sample number " + (i + 1));
                    }
                    if (buff.startsWith("Well:")) {
                        well = this.addWell(fileName, buff.substring("Well:".length()), wsAnalyst);
                        continue;
                    }
                    if (buff.startsWith("...")) continue;
                    Sample.Builder builder = Sample.parseDepthTypeLabelString(buff, units, true, useSampleTops, well.getSectionType(), sampleType);
                    Sample sample = well.addSample(builder, 0, null);
                    sample.displayUnits = units;
                    sampleA[i] = sample;
                    Audit audit = new Audit(this.analyHdr.getAnalystUsrid(), null, this.analyHdr.getAnalystUsrid(), new Date());
                    smpdtlA[i] = new Smpdtl(ws, sample, this.analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, audit, Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtlA[i]);
                    if (sample.getBaseDepth('M') > well.getTD()) {
                        well.getHeader().setTD(sample.getBaseDepth('M'));
                    }
                    dataTypes.add(1);
                    continue;
                }
                System.out.println("Parsing samples: last samples may not be present.");
            }
            if (this.isType2) {
                this.parseType2Data(fileStem, colWidth, taxonA, smpdtlA, well);
            } else {
                DecimalFormat format = new DecimalFormat("00");
                for (int n = 0; n < nSamples / 10 + 1; ++n) {
                    this.parseDataFile(n, fileStem + ".D" + format.format(n), taxonA, smpdtlA, well);
                }
            }
            dataTypes.add(1);
            dataTypes.add(SBdb.did2dtype(discID));
            this.readComments(fileStem, sampleA, smpdtlA, discID, this.analyHdr.getAnalyst(), well);
            well.updateStatus(dataTypes);
        }
        catch (SBPermissionException pe) {
            throw new IllegalStateException("Unexpected permission exception in workspace", pe);
        }
    }

    private boolean getDataFileType(String fileStem) throws SBException {
        File datFileTest = new File(fileStem + ".DAT");
        File d0FileTest = new File(fileStem + ".D00");
        if (datFileTest.exists() && d0FileTest.exists()) {
            throw new SBException("Data files in both formats .DAT and .Dnn exist - remove or rename incorrect file(s)");
        }
        if (!datFileTest.exists() && !d0FileTest.exists()) {
            throw new SBException("No .DAT or .Dnn files found!");
        }
        return datFileTest.exists();
    }

    private void readSpeciesCategories(String fileStem, Taxon[] taxonA) throws SBException, IOException {
        File file = new File(fileStem + ".SPC");
        if (file.exists()) {
            BufferedReader in = new BufferedReader(new FileReader(file));
            for (int i = 0; i < taxonA.length; ++i) {
                String buff = in.readLine();
                if (buff == null) {
                    throw new SBException("Premature end of categories file: '" + fileStem + ".SPC'. Delete file and re-read");
                }
                buff = buff.trim();
                if (taxonA[i] == null || buff.length() <= 0 || !Character.isLetter(buff.charAt(0))) continue;
                this.ws.setTaxonCat(taxonA[i].getSpecID(), buff.trim());
            }
        }
    }

    private void readComments(String fileStem, Sample[] sampleA, Smpdtl[] smpdtlA, char discID, String analyst, Well well) throws FileNotFoundException, IOException, SBException, SQLException {
        File file = new File(fileStem + ".SAC");
        if (file.exists()) {
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                for (int i = 0; i < sampleA.length; ++i) {
                    String buff = in.readLine();
                    if (buff == null) {
                        throw new SBException("Premature end of comments file: '" + fileStem + ".SAC'. Delete file and re-read");
                    }
                    if (sampleA[i] == null) continue;
                    String comment = buff.substring(26, 77).trim();
                    if (comment.length() > 0) {
                        Biocom biocom = new Biocom.Builder(this.ws, Discipline.getDisc(discID), this.analyHdr.getAnalystUsrid(), sampleA[i], comment).build();
                        well.getAddInterp(this.ws.getInterp(0)).insertBiocom(biocom);
                        this.dataTypes.add(SBdb.did2comType(discID));
                    }
                    int endIndex = 161;
                    if (buff.length() < endIndex) {
                        endIndex = buff.length();
                    }
                    if ((comment = buff.substring(83, endIndex).trim()).length() > 0) {
                        smpdtlA[i].appendNote(comment);
                    }
                    if (buff.length() <= 162 || (comment = buff.substring(162).trim()).length() <= 0) continue;
                    Biocom biocom = new Biocom.Builder(this.ws, Discipline.MACRO, this.analyHdr.getAnalystUsrid(), sampleA[i], comment).build();
                    well.getInterp(0).insertBiocom(biocom);
                    this.dataTypes.add(9);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseAbnFile(String fileStem) throws FileNotFoundException, SBException, IOException, SQLException, SBPermissionException {
        file = new File(fileStem + ".ABF");
        if (file.exists()) {
            System.out.println("Parsing abn file: " + file);
            in = new BufferedReader(new FileReader(file));
            try {
                nAbn = Integer.parseInt(in.readLine().trim());
                if (nAbn <= 0) ** GOTO lbl31
                this.abnScheme = new AbnScheme(1);
                this.abnScheme.setName("Checklist Scheme");
                for (i = 0; i < nAbn; ++i) {
                    className = in.readLine().trim();
                    abr = in.readLine().trim();
                    in.readLine();
                    in.readLine();
                    lowBound = Integer.parseInt(in.readLine().trim());
                    oVal = Integer.parseInt(in.readLine().trim());
                    this.abnScheme.addClass(abr, className, lowBound, oVal);
                }
            }
            finally {
                in.close();
            }
        } else {
            this.abnScheme = new AbnScheme(1);
            className = "Present";
            abr = "P";
            lowBound = 1;
            oVal = 1;
            this.abnScheme.addClass(abr, className, lowBound, oVal);
        }
lbl31:
        // 3 sources

        this.ws.addAbnScheme(this.abnScheme);
    }

    private void parseType2Data(String fileName, int colWidth, Taxon[] taxa, Smpdtl[] smpdtls, Well well) throws IOException, SBException, SQLException {
        try (BufferedReader in = new BufferedReader(new FileReader(fileName + ".DAT"));){
            for (Smpdtl smpdtl1 : smpdtls) {
                String buff = in.readLine();
                if (buff == null) {
                    in.close();
                    throw new SBException("Premature end of file in data file: " + fileName);
                }
                Smpdtl smpdtl = smpdtl1;
                if (smpdtl == null) continue;
                for (int iTaxon = 0; iTaxon < taxa.length; ++iTaxon) {
                    TaxonOcc.Builder builder;
                    int index = 25 + iTaxon * (colWidth + 1);
                    String taxonBuff = buff.substring(index, index + colWidth + 1).trim();
                    if (taxonBuff.length() <= 0 || taxonBuff.equals(".") || taxa[iTaxon] == null || (builder = TaxonOcc.Builder.parseOcc(this.ws, taxa[iTaxon], taxonBuff, this.rejects)) == null) continue;
                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                }
            }
        }
    }

    private void parseDataFile(int nFile, String fileName, Taxon[] taxa, Smpdtl[] smpdtls, Well well) throws FileNotFoundException, IOException, SBException, SQLException {
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            String buff;
            int nTaxaInFile = Integer.parseInt(in.readLine().trim());
            for (int i = 0; i < 10; ++i) {
                buff = in.readLine();
                if (buff != null) continue;
                in.close();
                throw new SBException("Premature end of file in data file: " + fileName);
            }
            for (int iTaxon = 0; iTaxon < nTaxaInFile; ++iTaxon) {
                for (int iSamp = 0; iSamp < 10; ++iSamp) {
                    TaxonOcc.Builder builder;
                    Smpdtl smpdtl;
                    buff = in.readLine();
                    if (buff == null) {
                        in.close();
                        throw new SBException("Premature end of file in data file: " + fileName);
                    }
                    int sampleIndex = nFile * 10 + iSamp - 1;
                    if (sampleIndex >= smpdtls.length || sampleIndex < 0 || (smpdtl = smpdtls[sampleIndex]) == null || taxa[iTaxon] == null || (buff = buff.trim()).length() <= 0 || (builder = this.abnScheme != null ? TaxonOcc.Builder.parseOcc(this.ws, taxa[iTaxon], buff, this.rejects) : new TaxonOcc.Builder(this.ws, taxa[iTaxon], false, false, 0)) == null) continue;
                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                }
            }
        }
    }

    private Taxon parseTaxon(BufferedReader in, int donorID) throws IOException {
        String buff = in.readLine().trim();
        if (buff.startsWith("REM")) {
            buff = in.readLine().trim();
        }
        Taxon taxon = null;
        if (!buff.startsWith("\\") && (taxon = this.ws.getTaxon(buff, this.specID, true)).getSpecID() == this.specID) {
            ++this.specID;
        }
        in.readLine();
        in.readLine();
        return taxon;
    }

    private WsWell addWell(String fileName, String wellName, Userdef wsAnalyst) throws SBException, SQLException {
        WsWell well = this.ws.addWellToWorkspace(0, fileName);
        well.getHeader().setWellName(wellName);
        well.getHeader().setWellCode(Well.makeCode(wellName));
        well.getHeader().setWellUnits(this.units);
        well.loadInterps();
        this.analyHdr = well.getAnalystHeader(wsAnalyst.getAbr(), this.discID, 1, true);
        if (this.abnScheme != null) {
            this.analyHdr.setAbnScheme(this.abnScheme.getID());
        }
        return well;
    }
}

