/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import model2_1.Audit;
import model2_1.IGDIntervalZone;
import model2_1.IGDUnitBase;
import model2_1.SBdb;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class Chron
extends IGDUnitBase {
    private Polarity polarity;
    private double u_age;
    private double l_age;

    Chron(SBdb sbdb, int schID, int chronID) {
        super(sbdb, schID, chronID);
    }

    public Polarity getPolarity() {
        return this.polarity;
    }

    @Override
    public double getUage() {
        return this.u_age;
    }

    @Override
    public double getLage() {
        return this.l_age;
    }

    @Override
    public String getAbr() {
        return this.getName();
    }

    @Override
    void writeDEX(FileWriter out, String eol, int igdType) throws IOException {
    }

    @Override
    void writeXML(BufferedWriter out, int indent, int igdType, List<IGDUnitBase> units) throws IOException {
        Object ind1 = new String();
        while (((String)ind1).length() < indent) {
            ind1 = (String)ind1 + " ";
        }
        out.write((String)ind1 + "<Chron>\n");
        String ind = (String)ind1 + (String)ind1;
        out.write(ind + "<UnitName>" + SB.getXMLstring((String)this.getName()) + "</UnitName>\n");
        out.write(ind + "<Type>" + IGDIntervalZone.getDefaultHierName(igdType, this.getHier(), true) + "</Type>\n");
        out.write(ind + "<Youngest>" + this.getUage() + "</Youngest>\n");
        out.write(ind + "<Oldest>" + this.getLage() + "</Oldest>\n");
        out.write(ind + "<DictionaryID>" + this.getUnitID() + "</DictionaryID>\n");
        out.write(ind + "<Polarity>" + this.polarity.toString() + "</Polarity>\n");
        this.getAudit().writeXML(out, indent + indent);
        out.write((String)ind1 + "</Chron>\n");
    }

    Chron(SBdb ws, int schID, Element xml) throws ParseException, SQLException, SBException {
        super(ws, schID, Integer.parseInt(xml.getChildTextNormalize("DictionaryID")));
        Element el;
        String strg = xml.getChildTextNormalize("UnitName");
        if (strg != null) {
            this.setName(strg);
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.setHier(IGDIntervalZone.getHierNumber(26, strg, true));
        }
        if ((strg = xml.getChildTextNormalize("Youngest")) != null) {
            this.u_age = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("Oldest")) != null) {
            this.l_age = Double.parseDouble(strg);
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.setAudit(new Audit(ws, el));
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + this);
        }
        strg = xml.getChildTextNormalize("Polarity");
        if (strg != null) {
            this.polarity = Polarity.parse(strg.toUpperCase().charAt(0));
        }
        this.status = NOTSTORED;
    }

    @Override
    public void copyLink() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void delete(Statement statement) throws SQLException {
        Statement stmt = statement == null ? this.sbdb.getDatabase().createStatement() : statement;
        String sql = "DELETE FROM " + this.sbdb.DBTableName("CHRON") + " WHERE chron_id=" + this.getUnitID();
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        this.status = NOTSTORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void storeDB(int igdType, Statement statement) throws SQLException {
        Statement stmt = statement == null ? this.sbdb.getDatabase().createStatement() : statement;
        String sql = "INSERT INTO " + this.sbdb.DBTableName("CHRON") + " (chron_id,sch_id,hier,name,u_age,l_age,polarity," + Audit.sqlFieldString() + ") VALUES (" + this.getUnitID() + "," + this.getSchID() + "," + this.getHier() + "," + SB.DBString((String)this.getName()) + "," + this.getUage() + "," + this.getLage() + "," + SB.DBChar((char)this.polarity.getChar()) + "," + this.getAudit().sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder builder) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("chron") + " set name=" + SB.DBString((String)builder.getName()) + ",u_age=" + builder.getUage() + ",l_age=" + builder.getLage() + ",hier=" + builder.getHier() + ",polarity=" + SB.DBChar((char)builder.polarity.getChar()) + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE chron_id=" + this.getUnitID();
        try {
            int i = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (i != 1) {
                System.out.println(sql);
                throw new SBException("Could not update unit: " + this);
            }
        }
        finally {
            stmt.close();
        }
        this.setHier(builder.getHier());
        this.setName(builder.getName());
        this.u_age = builder.u_age;
        this.l_age = builder.l_age;
        this.polarity = builder.polarity;
        this.status = STORED;
    }

    @Override
    public Color getColour() {
        if (this.getHier() == 1) {
            return Color.WHITE;
        }
        return this.polarity.getColour();
    }

    static Chron refresh(SBdb sbdb, int schID, List<IGDUnitBase> units, Statement stmt) throws SQLException, SBException {
        ResultSet rs = stmt.executeQuery(sbdb.modQuery("SELECT chron_id,updated FROM " + sbdb.DBTableName("CHRON") + " WHERE sch_id=" + schID));
        Chron notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("chron_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDUnitBase base : units) {
                if (!(base instanceof Chron)) {
                    assert (false);
                    continue;
                }
                Chron o = (Chron)base;
                if (o.getUnitID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                Chron.load(sbdb, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = Chron.load(sbdb, key, null);
            Chron.insert(notifier, units);
        }
        if (keys.size() < units.size()) {
            Iterator<IGDUnitBase> it = units.iterator();
            while (it.hasNext()) {
                IGDUnitBase base = it.next();
                if (!(base instanceof Chron)) {
                    assert (false);
                    continue;
                }
                Chron o = (Chron)base;
                if (keys.contains(o.getUnitID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    private static Chron load(SBdb sbdb, int unitID, Chron chron) throws SQLException, SBException {
        if (chron != null && chron.getUnitID() != unitID) {
            throw new IllegalArgumentException("Attempt to refresh unit with incorrect ID");
        }
        Chron temp = Chron.loadChron(sbdb, unitID);
        if (chron != null) {
            chron.setHier(temp.getHier());
            chron.setName(temp.getName());
            chron.u_age = temp.getUage();
            chron.l_age = temp.getLage();
            chron.setAudit(temp.getAudit());
            chron.status = STORED;
            chron.polarity = temp.polarity;
        } else {
            chron = temp;
        }
        return chron;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAll(SBdb sbdb, int schID, int igdType, List<IGDUnitBase> list) throws SQLException {
        String sql = "SELECT chron_id,hier,name,u_age,l_age,polarity," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("CHRON") + " WHERE sch_id=" + schID + " ORDER BY u_age,hier,l_age";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int chronID = rs.getInt("chron_id");
                Chron chron = new Chron(sbdb, schID, chronID);
                chron.setHier(rs.getInt("hier"));
                chron.setName(rs.getString("name"));
                chron.u_age = rs.getDouble("u_age");
                chron.l_age = rs.getDouble("l_age");
                chron.polarity = Polarity.parse(rs.getString("polarity").charAt(0));
                chron.setAudit(new Audit(rs));
                chron.status = STORED;
                try {
                    Chron.insert(chron, list);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Exception)re);
                }
            }
            rs.close();
        }
    }

    private static Chron loadChron(SBdb sbdb, int chronID) throws SQLException, SBException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT sch_id,hier,name,u_age,l_age,polarity," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("CHRON") + " WHERE chron_id=" + chronID;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                int schID = rs.getInt("sch_id");
                Chron chron = new Chron(sbdb, schID, chronID);
                chron.setHier(rs.getInt("hier"));
                chron.setName(rs.getString("name"));
                chron.u_age = rs.getDouble("u_age");
                chron.l_age = rs.getDouble("l_age");
                chron.polarity = Polarity.parse(rs.getString("polarity").charAt(0));
                chron.setAudit(new Audit(rs));
                chron.status = STORED;
                Chron chron2 = chron;
                return chron2;
            }
            throw new SBException("No unit found with ID: " + chronID);
        }
        finally {
            stmt.close();
        }
    }

    @Override
    public Chron getLink() {
        return (Chron)this.link;
    }

    @Override
    void updateStatusLinkSubclass(List<IGDUnitBase> schemeUnits) {
        if (this.polarity != this.getLink().polarity) {
            this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
        }
    }

    private Chron(Builder builder, int schID, int chronID) {
        super(builder, schID, chronID);
        this.polarity = builder.polarity;
        this.u_age = builder.u_age;
        this.l_age = builder.l_age;
    }

    public static enum Polarity {
        NORMAL("Normal", 'N', Color.BLACK),
        REVERSED("Reversed", 'R', Color.WHITE),
        UNCERTAIN("Uncertain", 'U', Color.LIGHT_GRAY);

        private final String name;
        private final char dbChar;
        private final Color colour;

        private Polarity(String name, char dbChar, Color colour) {
            this.name = name;
            this.dbChar = dbChar;
            this.colour = colour;
        }

        public char getChar() {
            return this.dbChar;
        }

        public Color getColour() {
            return this.colour;
        }

        public String toString() {
            return this.name;
        }

        static Polarity parse(char c) {
            for (Polarity p : Polarity.values()) {
                if (p.getChar() != c) continue;
                return p;
            }
            throw new IllegalArgumentException("Unable to parse Polarity from char: " + c);
        }
    }

    public static class Builder
    extends IGDUnitBase.Builder {
        private Polarity polarity = Polarity.NORMAL;
        private double u_age;
        private double l_age;
        private final Chron original;

        public Builder(SBdb sbdb) {
            super(sbdb);
            this.original = null;
        }

        Builder(SBdb sbdb, Chron chron) {
            super(sbdb);
            this.original = chron.sbdb == sbdb ? chron : null;
        }

        public Builder uAge(double u_age) {
            if (u_age >= 0.0) {
                this.u_age = u_age;
            }
            return this;
        }

        public Builder lAge(double l_age) {
            if (l_age >= 0.0) {
                this.l_age = l_age;
            }
            return this;
        }

        public Builder polarity(Polarity polarity) {
            if (polarity != null) {
                this.polarity = polarity;
            }
            return this;
        }

        @Override
        IGDUnitBase buildThis(int ID, int schID) {
            return new Chron(this, schID, ID);
        }

        @Override
        Chron store(int igdType, int schID) throws SQLException, SBException {
            Chron chron;
            if (!this.sbdb.isConnected()) {
                throw new IllegalStateException("Attempt to store Chron in workspace");
            }
            if (this.original != null) {
                super.validateFields();
                if (!this.getName().equals(this.original.getName()) || Math.abs(this.u_age - this.original.getUage()) > 0.001 || Math.abs(this.l_age - this.original.getLage()) > 0.001 || this.polarity != this.original.getPolarity() || this.getHier() != this.original.getHier()) {
                    this.original.update(this);
                }
                chron = this.original;
            } else {
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("CHRON", "CHRON_ID");
                chron = (Chron)super.build(ID, schID);
                chron.storeDB(schID, null);
            }
            return chron;
        }

        @Override
        public int getOriginalID() {
            if (this.original != null) {
                return this.original.getUnitID();
            }
            return -1;
        }

        @Override
        public Color getColour() {
            return this.polarity.getColour();
        }

        @Override
        public double getUage() {
            return this.u_age;
        }

        @Override
        public double getLage() {
            return this.l_age;
        }

        public Polarity getPolarity() {
            return this.polarity;
        }
    }
}

