/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2_1.Audit;
import model2_1.CoredInterval;
import model2_1.SBdb;
import model2_1.Well;
import util.SB;
import util.SBException;
import util.SBPermissionException;

public class Cores
extends Observable {
    private SBdb SB;
    private List<CoredInterval> cores = new ArrayList<CoredInterval>();

    public Cores(SBdb SB2) {
        this.SB = SB2;
    }

    public int getSize() {
        return this.cores.size();
    }

    public List<CoredInterval> getList() {
        return this.cores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            this.cores.clear();
        }
    }

    Iterator getIterator() {
        return this.cores.iterator();
    }

    public CoredInterval getCore(int index) {
        return this.cores.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoredInterval getCore(String corenum) {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            for (CoredInterval core : this.cores) {
                if (core.getCorenum() == null || !core.getCorenum().equals(corenum)) continue;
                return core;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(CoredInterval core) throws SBException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            if (this.cores.contains(core)) {
                return false;
            }
            int insertPoint = this.checkOverlap(null, core);
            this.cores.add(insertPoint, core);
        }
        this.setChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkOverlap(CoredInterval original, CoredInterval core) throws SBException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            Iterator<CoredInterval> it = this.cores.iterator();
            int insertPoint = 0;
            int nzTD = (int)(core.getTopDepth() * 100.0);
            int nzBD = (int)(core.getBaseDepth() * 100.0);
            while (it.hasNext()) {
                CoredInterval compareWith = it.next();
                if (compareWith == original) continue;
                int cTD = (int)(compareWith.getTopDepth() * 100.0);
                int cBD = (int)(compareWith.getBaseDepth() * 100.0);
                try {
                    util.SB.checkOverlap((int)nzTD, (int)nzBD, (int)cTD, (int)cBD);
                }
                catch (SBException ex) {
                    throw new SBException("Error inserting cored interval: " + ex.getMessage() + " core " + core);
                }
                if (nzTD < cTD) break;
                ++insertPoint;
            }
            return insertPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int wellID) throws SQLException, SBException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            this.cores.clear();
        }
        String sql = "SELECT top_depth, base_depth, corenum, recovered," + Audit.sqlFieldString() + " FROM " + this.SB.DBTableName("CORES") + " WHERE well_id=" + wellID;
        Statement stmt = this.SB.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.SB.modQuery(sql));
        while (rs.next()) {
            double topDepth = rs.getDouble("top_depth");
            double baseDepth = rs.getDouble("base_depth");
            String corenum = rs.getString("corenum");
            if (corenum == null) {
                corenum = "";
            }
            String strg = rs.getString("recovered");
            boolean recovered = true;
            if (strg != null && strg.charAt(0) == 'N') {
                recovered = false;
            }
            CoredInterval core = new CoredInterval(topDepth, baseDepth, corenum, recovered, new Audit(rs));
            this.add(core);
        }
        stmt.close();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromView(SBdb db, String wellCode) throws SQLException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            this.cores.clear();
        }
        String sql = "SELECT  top_depth, base_depth, corenum, recovered FROM " + db.DBTableName("CORES_MASTER") + " WHERE well_code=" + util.SB.DBString((String)wellCode);
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                double topDepth = rs.getDouble("top_depth");
                double baseDepth = rs.getDouble("base_depth");
                String corenum = rs.getString("corenum");
                if (corenum == null) {
                    corenum = "";
                }
                String strg = rs.getString("recovered");
                boolean recovered = true;
                if (strg != null && strg.charAt(0) == 'N') {
                    recovered = false;
                }
                CoredInterval core = new CoredInterval(topDepth, baseDepth, corenum, recovered);
                try {
                    this.add(core);
                }
                catch (SBException e) {
                    System.out.println("Error adding casing point: " + e.getMessage());
                }
            }
        }
        this.setChanged();
    }

    static void deleteAll(SBdb SB2, int wellID) throws SQLException {
        String sql = "DELETE FROM " + SB2.DBTableName("CORES") + " WHERE well_id=" + wellID;
        try (Statement stmt = SB2.getDatabase().createStatement();){
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, Collection<CoredInterval> toDelete) throws SQLException, SBException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            for (CoredInterval core : toDelete) {
                if (!this.cores.contains(core)) {
                    throw new IllegalStateException("Attempt to delete cored interval " + core + " from wrong well");
                }
                if (this.SB == null || !this.SB.isConnected()) continue;
                core.delete(this.SB, wellID);
            }
            this.cores.removeAll(toDelete);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int wellID, CoredInterval core) throws SQLException, SBException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            if (!this.cores.contains(core)) {
                throw new IllegalStateException("Attempt to delete cored interval " + core + " from wrong well");
            }
            if (this.SB != null && this.SB.isConnected()) {
                core.delete(this.SB, wellID);
            }
            this.cores.remove(core);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(int wellID) throws SQLException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            Iterator<CoredInterval> it = this.cores.iterator();
            boolean refresh = false;
            while (it.hasNext()) {
                if (it.next().status != CoredInterval.NOTSTORED) continue;
                refresh = true;
                break;
            }
            if (!refresh) {
                return;
            }
            Cores.deleteAll(this.SB, wellID);
            it = this.cores.iterator();
            while (it.hasNext()) {
                it.next().store(this.SB, wellID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(Statement stmt, int wellID) throws SQLException, SBException {
        Object sql = "SELECT top_depth,updated ";
        sql = (String)sql + " FROM " + this.SB.DBTableName("cores") + " WHERE well_id=" + wellID;
        sql = this.SB.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        boolean reload = false;
        HashSet<Integer> keys = new HashSet<Integer>();
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            while (rs.next()) {
                int topDepth = (int)(rs.getDouble("top_depth") * 1000.0);
                keys.add(topDepth);
                Timestamp time = rs.getTimestamp("updated");
                boolean found = false;
                for (CoredInterval s : this.cores) {
                    if ((int)(s.getTopDepth() * 1000.0) != topDepth) continue;
                    found = true;
                    if (time == null || !time.after(s.getUpdated())) break;
                    reload = true;
                    break;
                }
                if (!found) {
                    reload = true;
                }
                if (!reload) continue;
                break;
            }
            if (keys.size() != this.cores.size()) {
                reload = true;
            }
        }
        if (reload) {
            this.load(wellID);
            this.setChanged();
            this.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIntervalStatus(Color status) {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            Iterator<CoredInterval> it = this.cores.iterator();
            while (it.hasNext()) {
                it.next().status = status;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeDEX(FileWriter out, String eol, char units, Well well) throws IOException, SQLException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            for (CoredInterval core : this.cores) {
                core.writeDEX(out, eol, units, core.getDeltaTop(well), core.getDeltaBase(well));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        List<CoredInterval> list = this.cores;
        synchronized (list) {
            Iterator<CoredInterval> it = this.cores.iterator();
            while (it.hasNext()) {
                it.next().writeXML(out, indent, units);
            }
        }
    }

    public boolean updateFromMaster(int wellID, String wellCode) throws SQLException, SBException, SBPermissionException {
        if (!this.SB.hasCoresMaster) {
            return true;
        }
        Cores viewCores = new Cores(this.SB);
        viewCores.loadFromView(this.SB, wellCode);
        LinkedList<CoredInterval> toAdd = new LinkedList<CoredInterval>();
        boolean conflict = false;
        for (CoredInterval viewC : viewCores.cores) {
            boolean found = false;
            for (CoredInterval dbC : this.cores) {
                if (!dbC.isFuncEquivalent(viewC)) continue;
                if (dbC.getCorenum().equals(viewC.getCorenum()) && dbC.getRecovered() == viewC.getRecovered()) {
                    found = true;
                    break;
                }
                conflict = true;
                break;
            }
            if (!found) {
                try {
                    this.checkOverlap(null, viewC);
                }
                catch (SBException se) {
                    conflict = true;
                }
            }
            if (conflict) break;
            if (found) continue;
            toAdd.add(viewC);
        }
        if (!conflict) {
            for (CoredInterval coredInterval : toAdd) {
                this.add(coredInterval);
            }
        }
        return !conflict;
    }
}

