/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import model2_1.Audit;
import model2_1.LogDef;
import model2_1.LogFile;
import model2_1.SBdb;
import org.jdom2.Element;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;

public class Curve
implements SortEntry {
    private final SBdb db;
    private List<CurveValue> trace = new LinkedList<CurveValue>();
    private int curveID;
    private final String abr;
    private final String mnem;
    private Double top;
    private Double base;
    private String fileName;
    private Audit audit;
    private String comments;

    Curve(SBdb db, int curveID, String abr, String curveMnem, String fileName, String comments, Audit audit) throws SQLException {
        this.db = db;
        this.curveID = curveID;
        this.abr = abr;
        this.mnem = curveMnem;
        this.fileName = fileName;
        this.comments = comments;
        this.audit = audit;
        String sql = "SELECT depth, trace_value FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + curveID + " ORDER BY depth";
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                CurveValue value = new CurveValue();
                value.depth = rs.getDouble("depth");
                if (this.top == null || this.top > value.depth) {
                    this.top = value.depth;
                }
                if (this.base == null || this.base < value.depth) {
                    this.base = value.depth;
                }
                value.value = rs.getDouble("trace_value");
                this.trace.add(value);
            }
        }
    }

    public Curve(SBdb db, Curve curve) throws SQLException {
        this.db = db;
        this.abr = db != curve.db && curve.db != null && curve.db.getLogDef(curve.abr).getLink() != null ? curve.db.getLogDef(curve.abr).getLink().getAbr() : curve.abr;
        this.curveID = curve.curveID;
        this.trace = new LinkedList<CurveValue>();
        for (CurveValue value : curve.trace) {
            CurveValue newValue = new CurveValue();
            newValue.depth = value.depth;
            newValue.value = value.value;
            this.trace.add(newValue);
        }
        this.top = curve.top;
        this.base = curve.base;
        this.mnem = curve.mnem;
        this.comments = curve.comments;
    }

    public List<CurveValue> getTrace() {
        return this.trace;
    }

    public Curve(SBdb db, LogFile file, char units, LogDef logDef, int nCurve, float depthFilter, char sectionType, String comments) throws FileNotFoundException, IOException {
        this.db = db;
        this.abr = logDef.toString();
        this.mnem = file.getMnem(nCurve);
        this.fileName = file.getPath();
        this.comments = comments;
        double lastDepth = 0.0;
        CurveValue lastValue = null;
        for (LogFile.LogValue logFileValue : file.getRecords()) {
            double depth = logFileValue.depth;
            if (!(Math.abs(depth - lastDepth) > (double)depthFilter)) continue;
            CurveValue value = new CurveValue();
            value.depth = DepthUtils.convToM((double)depth, (char)units, (char)sectionType);
            value.value = logFileValue.values[nCurve];
            if (Math.abs(value.value - file.nullValue) > 0.001) {
                if (lastValue != null && value.depth < lastValue.depth) {
                    this.trace.add(0, value);
                } else {
                    this.trace.add(value);
                }
                if (this.top == null || value.depth < this.top) {
                    this.top = value.depth;
                }
                if (this.base == null || value.depth > this.base) {
                    this.base = value.depth;
                }
            }
            lastDepth = depth;
            lastValue = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(SBdb db, int wellID) throws SQLException, SBException {
        this.audit = new Audit();
        this.curveID = db.nextControl("LOG_CURVE", "CURVE_ID");
        Statement stmt = db.getDatabase().createStatement();
        String sql = "INSERT INTO " + db.DBTableName("LOG_CURVE") + " (curve_id,well_id,abr,curve_mnem,filename,comments," + Audit.sqlFieldString() + ") VALUES (" + this.curveID + "," + wellID + "," + SB.DBString((String)this.abr) + "," + SB.DBString((String)this.mnem) + "," + SB.DBString((String)this.fileName) + "," + SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(db, stmt) + ")";
        try {
            stmt.executeUpdate(db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
        sql = "INSERT INTO " + db.DBTableName("LOG_TRACE") + " (curve_id, depth, trace_value) VALUES (" + this.curveID + ",?,?)";
        try (PreparedStatement pStmt = db.getDatabase().prepareStatement(db.modQuery(sql));){
            for (CurveValue value : this.trace) {
                pStmt.setDouble(1, value.depth);
                pStmt.setDouble(2, value.value);
                pStmt.addBatch();
            }
            int[] affectedRows = pStmt.executeBatch();
            int nInserted = 0;
            int nError = 0;
            int nNoInfo = 0;
            for (int row : affectedRows) {
                if (row > 0) {
                    ++nInserted;
                    continue;
                }
                if (row == -3) {
                    ++nError;
                    continue;
                }
                ++nNoInfo;
            }
            System.out.println("Number of rows affected: " + affectedRows.length + ", Inserted: " + nInserted + ", Error: " + nError + ", No Info: " + nNoInfo);
            if (nError == affectedRows.length) {
                throw new SBException("Database error: no log_curve values saved");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(SBdb db) throws SQLException {
        if (this.curveID <= 0) {
            throw new IllegalStateException("Invalid curve ID: " + this.curveID);
        }
        Statement stmt = db.getDatabase().createStatement();
        String sql = "DELETE FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + this.curveID;
        try {
            stmt.executeUpdate(db.modQuery(sql));
            sql = "DELETE FROM " + db.DBTableName("LOG_CURVE") + " WHERE curve_id=" + this.curveID;
            stmt.executeUpdate(db.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    void deleteRows(SBdb db, Collection<CurveValue> toDelete) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            for (CurveValue curveValue : toDelete) {
                String sql = "DELETE FROM " + db.DBTableName("LOG_TRACE") + " WHERE curve_id=" + this.curveID + " AND depth > " + (curveValue.depth - 0.01) + " AND depth < " + (curveValue.depth + 0.01);
                stmt.executeUpdate(db.modQuery(sql));
            }
        }
        this.trace.removeAll(toDelete);
        this.setDepthRange();
    }

    private void setDepthRange() {
        this.base = null;
        this.top = null;
        for (CurveValue value : this.trace) {
            if (this.top == null || value.depth < this.top) {
                this.top = value.depth;
            }
            if (this.base != null && !(value.depth > this.base)) continue;
            this.base = value.depth;
        }
    }

    public Double getTopDepth() {
        return this.top;
    }

    public Double getBaseDepth() {
        return this.base;
    }

    public String getAbr() {
        return this.abr;
    }

    public String getMnem() {
        return this.mnem;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getComments() {
        return this.comments;
    }

    int getID() {
        return this.curveID;
    }

    void updateComments(String newComments, SBdb sbdb) throws SQLException {
        if (SB.equal((Object)newComments, (Object)this.comments)) {
            return;
        }
        String sql = "UPDATE " + sbdb.DBTableName("LOG_CURVE") + " set comments=" + SB.DBString((String)newComments) + " WHERE curve_id=" + this.curveID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        this.comments = newComments;
    }

    void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<WirelineLog LogDef=\"" + this.abr + "\">\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<CurveID>" + this.curveID + "</CurveID>\n");
        out.write(ind + "<Mnemonic>" + SB.getXMLstring((String)this.mnem) + "</Mnemonic>\n");
        if (this.comments != null && !this.comments.isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.comments) + "</Comments>\n");
        }
        String rowString = ind + "<Row Depth=\"%s\" Value=\"%s\"/>\n";
        for (CurveValue row : this.trace) {
            out.write(String.format(rowString, row.depth, row.value));
        }
        out.write(ind1 + "</WirelineLog>\n");
    }

    private Curve(SBdb db, String abr, String mnem) {
        this.db = db;
        this.abr = abr;
        this.mnem = mnem;
    }

    static Curve parseXML(SBdb db, Element el) {
        assert (!db.isConnected());
        Curve curve = new Curve(db, el.getAttributeValue("LogDef"), el.getChildText("Mnemonic"));
        String strg = el.getChildText("Comments");
        if (strg != null) {
            curve.comments = strg;
        }
        curve.curveID = Integer.parseInt(el.getChildText("CurveID"));
        for (Element row : el.getChildren("Row")) {
            CurveValue value = new CurveValue();
            value.depth = Double.parseDouble(row.getAttributeValue("Depth"));
            if (curve.top == null || curve.top > value.depth) {
                curve.top = value.depth;
            }
            if (curve.base == null || curve.base < value.depth) {
                curve.base = value.depth;
            }
            value.value = Double.parseDouble(row.getAttributeValue("Value"));
            curve.trace.add(value);
        }
        return curve;
    }

    public String getSortEntry() {
        String topString = "" + (this.top != null ? (int)(this.top * 1000.0) : 0);
        while (topString.length() < 7) {
            topString = " " + topString;
        }
        String baseString = "" + (this.base != null ? (int)(this.base * 1000.0) : 0);
        while (baseString.length() < 7) {
            baseString = " " + baseString;
        }
        return this.getLinkAbr() + topString + "-" + baseString;
    }

    private String getLinkAbr() {
        String s;
        try {
            s = this.db.getLogDef(this.abr).getLink() != null ? this.db.getLogDef(this.abr).getLink().getAbr() : this.abr;
        }
        catch (SQLException sql) {
            throw new IllegalStateException("LogDefs not loaded", sql);
        }
        return s;
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        return e.getSortEntry().equals(this.getSortEntry());
    }

    public String toString(char units, char sectionType) {
        Object name = this.getLinkAbr();
        if (this.top != null && this.base != null) {
            name = (String)name + " (" + SB.getDepthString((double)this.top, (char)units, (int)2, (char)sectionType).trim() + " - " + SB.getDepthString((double)this.base, (char)units, (int)2, (char)sectionType).trim() + ")";
        }
        return name;
    }

    public static class CurveValue {
        double depth;
        double value;

        public double getDepth() {
            return this.depth;
        }

        public double getValue() {
            return this.value;
        }
    }
}

