/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import model2_1.Audit;
import model2_1.Curve;
import model2_1.SBdb;
import model2_1.Well;
import util.SBException;

public class Curves
extends Observable {
    private final List<Curve> list = new LinkedList<Curve>();

    public Curves(SBdb db, Well well) throws SQLException {
        if (db.isConnected()) {
            String sql = "SELECT curve_id, abr, curve_mnem, filename, comments, " + Audit.sqlFieldString() + " FROM " + db.DBTableName("LOG_CURVE") + " WHERE well_id=" + well.getWellID();
            try (Statement stmt = db.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(db.modQuery(sql));
                while (rs.next()) {
                    int curveID = rs.getInt("curve_id");
                    String abr = rs.getString("abr");
                    String curveMnem = rs.getString("curve_mnem");
                    String fileName = rs.getString("filename");
                    String comments = rs.getString("comments");
                    Audit audit = new Audit(rs);
                    this.list.add(new Curve(db, curveID, abr, curveMnem, fileName, comments, audit));
                }
            }
        }
    }

    public List<Curve> getCurves() {
        return this.list;
    }

    public int getSize() {
        return this.list.size();
    }

    void add(SBdb db, int wellID, Curve curve) throws SQLException, SBException {
        if (db.isConnected()) {
            curve.store(db, wellID);
        } else assert (curve.getID() > 0);
        this.list.add(curve);
        this.setChanged();
    }

    void delete(SBdb db, Collection<Curve> curves) throws SQLException {
        for (Curve curve : curves) {
            if (!this.list.contains(curve)) {
                throw new IllegalArgumentException("Attempt to delete curve from wrong well");
            }
            if (!db.isConnected()) continue;
            curve.delete(db);
        }
        this.list.removeAll(curves);
        this.setChanged();
    }

    public boolean checkOverlap(Curve curve) {
        boolean overlap = false;
        double topDepth = curve.getTopDepth();
        double baseDepth = curve.getBaseDepth();
        for (Curve c : this.list) {
            if (!c.getAbr().equals(curve.getAbr()) || !(c.getTopDepth() >= topDepth && c.getTopDepth() <= baseDepth) && (!(c.getBaseDepth() >= topDepth) || !(c.getBaseDepth() <= baseDepth))) continue;
            overlap = true;
            break;
        }
        return overlap;
    }
}

