/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleInsertException;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.WsWell;
import util.SBException;
import util.SBPermissionException;

public class GenericReader {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    Set dataTypes;
    boolean hasDonorSampleTypes = false;

    public GenericReader(SBdb ws, String fileName, Set dataTypes) throws SBException, SQLException, IOException {
        String analyst = "SYS";
        char units = 'M';
        this.dataTypes = dataTypes;
        ws.getAddUserID(analyst);
        if (ws.getnLoadedWells() == 0) {
            dataTypes.clear();
        }
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String buff = in.readLine();
        while (buff != null) {
            StringTokenizer tok = new StringTokenizer(buff, "\t", false);
            if (!tok.hasMoreTokens()) {
                buff = in.readLine();
                continue;
            }
            System.out.println("buff: " + buff);
            String wellName = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                buff = in.readLine();
                continue;
            }
            String wellCode = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                buff = in.readLine();
                continue;
            }
            String country = tok.nextToken();
            if (!tok.hasMoreTokens()) {
                buff = in.readLine();
                continue;
            }
            String tdString = tok.nextToken();
            double td = Double.parseDouble(tdString);
            WsWell well = ws.addWellToWorkspace(0, null);
            well.getHeader().setWellCode(wellCode);
            well.getHeader().setWellName(wellName);
            well.getHeader().setWellUnits(units);
            well.getHeader().setType('W');
            well.getHeader().setCountry(country);
            well.getHeader().setTD(td);
            well.loadInterps();
            well.updateStatus(dataTypes);
            buff = in.readLine();
        }
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    public static void ReadBugWareDictionary(SBdb ws, SBdb db) throws FileNotFoundException, IOException, SQLException, SBException, SampleInsertException, SBPermissionException {
        String buff;
        BufferedReader in = new BufferedReader(new FileReader("D:\\sbugs\\Clients\\Data\\TotalBS\\Micro\\FORAM ALL.mas"));
        int specID = 0;
        int dictID = 0;
        HashMap<Taxon, Integer> numericCodes = new HashMap<Taxon, Integer>();
        while ((buff = in.readLine()) != null) {
            Taxon t;
            String taxon;
            ++dictID;
            if (buff.length() < 32 || (taxon = buff.substring(0, 32).trim()).length() <= 0 || taxon.equalsIgnoreCase("x")) continue;
            if ((t = ws.getTaxon(taxon, ++specID, false)) == null) {
                System.out.println("Can't parse: " + buff);
            } else if (buff.length() > 32) {
                String taxonCode = buff.substring(32, 44).trim();
                t.setAlphaCode(taxonCode);
            }
            numericCodes.put(t, dictID);
        }
        HashSet<String> occRejects = new HashSet<String>();
        WsWell well = null;
        well = ws.addWellToWorkspace(0, "BW");
        well.getHeader().setWellCode("BW");
        well.getHeader().setWellName("BW");
        well.getHeader().setWellUnits('M');
        well.getHeader().setType('W');
        well.getHeader().setCountry("USA");
        well.getSamples();
        AnalystHeader hdr = well.getAnalystHeader("ANON", 'M', 1, true);
        Sample sample = well.addSample(1.0, SampleType.CU, "");
        Smpdtl smpdtl = new Smpdtl(ws, sample, hdr, null, null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.BARREN);
        sample.addDtl(smpdtl);
        for (Taxon taxon : ws.getTaxa()) {
            TaxonOcc.Builder builder = TaxonOcc.Builder.parseOcc(ws, taxon, "1", occRejects);
            smpdtl.insertOccurrence(builder, well.getWellID(), false);
            System.out.println("Code for taxon: " + taxon + "\t\t" + numericCodes.get(taxon));
        }
        in.close();
    }
}

