/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import model2_1.Audit;
import model2_1.Category;
import model2_1.Qualifier;
import model2_1.SBdb;
import model2_1.TaxonQual;
import model2_1.api.Discipline;
import model2_1.taxa.GenusListener;
import model2_1.taxa.GenusUpdatePublisher;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SbugsLink;
import util.SortEntry;
import util.exception.StackError;
import util.status.SbugsStatus;

public class Genus
implements Comparable,
SortEntry,
SbugsLink,
SbugsStatus {
    private final int genID;
    private Category category;
    private String genusName = "";
    private String subGenus = "";
    private final Qualifier[] qualifiers;
    private Audit audit = new Audit();
    private Genus link;
    private final GenusUpdatePublisher updatePublisher = new GenusUpdatePublisher(this);

    public void registerListener(GenusListener listener) {
        this.updatePublisher.registerListener(listener);
    }

    public void deleteListener(GenusListener listener) {
        this.updatePublisher.deleteListener(listener);
    }

    public void notifyListeners() {
        this.updatePublisher.notifyListeners();
    }

    void setNotifySpeciesAdded(int specID) {
        this.updatePublisher.speciesAdded(specID);
    }

    void setNotifySpeciesRemoved(int specID) {
        this.updatePublisher.speciesRemoved(specID);
    }

    void setNotifyDeleted() {
        this.updatePublisher.setGenusDeleted();
    }

    public String getGenus() {
        return this.genusName;
    }

    public String getSubGenus() {
        return this.subGenus;
    }

    public Category getCategory() {
        return this.category;
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    Discipline getDisc() {
        return this.category.getDisc();
    }

    public int getGenID() {
        return this.genID;
    }

    Date getUpdated() {
        return this.audit.updated;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeCat) {
        return this.toString(includeCat, null);
    }

    String toString(boolean includeCat, List<Integer> italics) {
        Object strg = "";
        if (includeCat) {
            strg = this.category.getMnem();
            while (((String)strg).length() < 6) {
                strg = (String)strg + " ";
            }
        }
        if (this.qualifiers[0].hasQuals()) {
            strg = (String)strg + this.qualifiers[0].toString(true);
        }
        if (italics != null) {
            italics.add(((String)strg).length());
        }
        strg = (String)strg + this.genusName;
        if (italics != null) {
            italics.add(((String)strg).length());
        }
        if (this.qualifiers[1].hasQuals()) {
            strg = (String)strg + this.qualifiers[1].toString(false);
        }
        strg = ((String)strg).trim();
        if (!this.subGenus.isEmpty()) {
            strg = (String)strg + " (";
            if (this.qualifiers[2].hasQuals()) {
                strg = (String)strg + this.qualifiers[2].toString(true);
            }
            if (italics != null) {
                italics.add(((String)strg).length());
            }
            strg = (String)strg + this.getSubGenus();
            if (italics != null) {
                italics.add(((String)strg).length());
            }
            if (this.qualifiers[3].hasQuals()) {
                strg = (String)strg + this.qualifiers[3].toString(false);
            }
            strg = (String)strg + ")";
        }
        return ((String)strg).trim();
    }

    public AttributedString toAttributedString(boolean useItalics, boolean includeCat) {
        LinkedList<Integer> italicsPos = new LinkedList<Integer>();
        String string = this.toString(includeCat, useItalics ? italicsPos : null);
        AttributedString ats = new AttributedString(string);
        Iterator it = italicsPos.iterator();
        while (it.hasNext()) {
            ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, (Integer)it.next(), (Integer)it.next());
        }
        return ats;
    }

    public void setLink(Genus link) {
        this.link = link;
    }

    public Genus getLink() {
        return this.link;
    }

    boolean hasQualifiers() {
        for (Qualifier q : this.qualifiers) {
            if (!q.hasQuals()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQual(TaxonQual qual) {
        for (Qualifier q : this.qualifiers) {
            if (!q.hasQual(qual)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Genus load(SBdb sbdb, int genID, Statement statement, Genus genus) throws SQLException {
        if (genus != null && genus.getGenID() != genID) {
            throw new IllegalArgumentException("Attempt to refresh genus with incorrect ID");
        }
        Object query = "SELECT cat_mnem,genus,sub_genus,q1,q2,q3,q4," + Audit.sqlFieldString();
        query = (String)query + " FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + genID;
        query = sbdb.modQuery((String)query);
        Statement stmt = statement != null ? statement : sbdb.getDatabase().createStatement();
        try {
            ResultSet rs = stmt.executeQuery((String)query);
            if (rs.next()) {
                Builder builder = new Builder();
                String catMnem = rs.getString("cat_mnem");
                builder.category(sbdb.getCategory(catMnem.trim()));
                builder.genusName(rs.getString("genus"));
                builder.subGenus(rs.getString("sub_genus"));
                builder.qual(0, rs.getString("q1"));
                builder.qual(1, rs.getString("q2"));
                builder.qual(2, rs.getString("q3"));
                builder.qual(3, rs.getString("q4"));
                builder.audit(new Audit(rs));
                if (genus == null) {
                    Genus genus2 = builder.build(genID);
                    return genus2;
                }
                genus.category = builder.category;
                genus.genusName = builder.genusName;
                genus.subGenus = builder.subGenus;
                genus.qualifiers[0] = builder.qualifiers[0];
                genus.qualifiers[1] = builder.qualifiers[1];
                genus.qualifiers[2] = builder.qualifiers[2];
                genus.qualifiers[3] = builder.qualifiers[3];
                genus.audit = builder.audit;
                genus.updatePublisher.setGenusDetailsUpdated();
                Genus genus3 = genus;
                return genus3;
            }
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        return null;
    }

    static Genus[] load(SBdb sbdb, String cat_mnem, String genus, String subGenus, Qualifier gq1, Qualifier gq2, Qualifier gq3, Qualifier gq4) throws SQLException {
        List<Genus> genera;
        String sql = "SELECT cat_mnem, gen_id, genus, sub_genus, q1, q2, q3, q4," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GENUS") + " WHERE ";
        if (cat_mnem != null) {
            sql = sql + "cat_mnem='" + cat_mnem + "' AND ";
        }
        sql = sql + " ucase(genus)=" + SB.DBString((String)genus.toUpperCase());
        if (gq1 != null) {
            sql = gq1.hasQuals() ? sql + " AND lcase(q1)='" + gq1 + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (gq2 != null) {
            sql = gq2.hasQuals() ? sql + " AND lcase(q2)='" + gq2 + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (gq3 != null) {
            sql = gq3.hasQuals() ? sql + " AND lcase(q3)='" + gq3 + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subGenus != null) {
            sql = !subGenus.isEmpty() ? sql + " AND ucase(sub_genus)=" + SB.DBString((String)subGenus.toUpperCase()) : sql + " AND (sub_genus IS NULL or sub_genus='')";
        }
        if (gq4 != null) {
            sql = gq4.hasQuals() ? sql + " AND lcase(q4)='" + gq4 + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            genera = Genus.getGeneraFromResultSet(rs, sbdb);
        }
        if (!genera.isEmpty()) {
            return genera.toArray(new Genus[genera.size()]);
        }
        return null;
    }

    private static List<Genus> getGeneraFromResultSet(ResultSet rs, SBdb sbdb) throws SQLException {
        LinkedList<Genus> genera = new LinkedList<Genus>();
        while (rs.next()) {
            Builder builder = new Builder();
            String catMnem = rs.getString("cat_mnem");
            builder.category(sbdb.getCategory(catMnem.trim()));
            int genID = rs.getInt("gen_id");
            builder.genusName(rs.getString("genus"));
            builder.subGenus(rs.getString("sub_genus"));
            builder.qual(0, rs.getString("q1"));
            builder.qual(1, rs.getString("q2"));
            builder.qual(2, rs.getString("q3"));
            builder.qual(3, rs.getString("q4"));
            builder.audit(new Audit(rs));
            genera.add(builder.build(genID));
        }
        return genera;
    }

    public static void loadAll(SBdb sbdb, Map<Integer, Genus> map) throws SQLException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT gen_id,cat_mnem,genus,sub_genus,q1,q2,q3,q4," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("genus");
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int genID = rs.getInt("gen_id");
                Builder builder = new Builder();
                String catMnem = rs.getString("cat_mnem");
                builder.category(sbdb.getCategory(catMnem.trim()));
                builder.genusName(rs.getString("genus"));
                builder.subGenus(rs.getString("sub_genus"));
                builder.qual(0, rs.getString("q1"));
                builder.qual(1, rs.getString("q2"));
                builder.qual(2, rs.getString("q3"));
                builder.qual(3, rs.getString("q4"));
                builder.audit(new Audit(rs));
                try {
                    map.put(genID, builder.build(genID));
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Exception)re);
                }
            }
        }
    }

    static List<Genus> search(SBdb sbdb, Builder builder) throws SQLException {
        String sql = "SELECT cat_mnem, gen_id, genus, sub_genus, q1, q2, q3, q4," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("GENUS");
        LinkedList<CallSite> conditions = new LinkedList<CallSite>();
        if (!builder.genusName.isEmpty()) {
            conditions.add((CallSite)((Object)("ucase(genus) like " + SB.DBString((String)(builder.genusName.toUpperCase() + "%")))));
        }
        if (!builder.subGenus.isEmpty()) {
            conditions.add((CallSite)((Object)("ucase(sub_genus) like " + SB.DBString((String)(builder.subGenus.toUpperCase() + "%")))));
        }
        if (builder.category != null) {
            conditions.add((CallSite)((Object)("cat_mnem like " + SB.DBString((String)(builder.category.getMnem() + "%")))));
        }
        for (int i = 0; i < 4; ++i) {
            if (builder.getQualifier(i) == null || !builder.getQualifier(i).hasQuals()) continue;
            String is = "" + (i + 1);
            conditions.add((CallSite)((Object)("lcase(q" + (String)is + ")='" + builder.getQualifier(i).toString(null) + "'")));
        }
        if (!conditions.isEmpty()) {
            boolean first = true;
            for (String string : conditions) {
                sql = sql + (first ? " WHERE " : " AND ");
                sql = sql + string;
                first = false;
            }
        }
        sql = sql + " ORDER BY genus, cat_mnem";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            List<Genus> list;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            List<Genus> list2 = list = Genus.getGeneraFromResultSet(rs, sbdb);
            return list2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkNSpecies(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT count(spec_id) AS nspecies FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + this.genID;
        int nSpecies = 0;
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                nSpecies = rs.getInt("nspecies");
            }
        }
        finally {
            stmt.close();
        }
        return nSpecies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(SBdb sbdb) throws SQLException {
        if (!sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to store workspace Genus");
        }
        if (this.genID < 1) {
            throw new IllegalStateException("Attempt to store genus with illegal ID: " + this.genID);
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + sbdb.DBTableName("GENUS") + " ( cat_mnem, gen_id, genus";
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.subGenus.isEmpty()) {
            sql = sql + ",sub_genus";
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",q4";
        }
        sql = sql + "," + Audit.sqlFieldString() + ") VALUES ('" + this.category.getMnem() + "'," + this.genID + "," + SB.DBString((String)this.genusName);
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[0].toString(null) + "'";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[1].toString(null) + "'";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[2].toString(null) + "'";
        }
        if (this.subGenus.length() > 0) {
            sql = sql + "," + SB.DBString((String)this.subGenus);
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",'" + this.qualifiers[3].toString(null) + "'";
        }
        sql = sql + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(SBdb sbdb, Builder builder) throws SQLException {
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + sbdb.DBTableName("GENUS") + " SET cat_mnem=" + SB.DBString((String)builder.category.getMnem()) + ",genus=" + SB.DBString((String)builder.genusName) + ",q1=" + SB.DBString((String)builder.qualifiers[0].toString(null)) + ",q2=" + SB.DBString((String)builder.qualifiers[1].toString(null)) + ",q3=" + SB.DBString((String)builder.qualifiers[2].toString(null)) + ",q4=" + SB.DBString((String)builder.qualifiers[3].toString(null)) + ",sub_genus=" + SB.DBString((String)builder.subGenus) + "," + this.audit.sqlUpdate(sbdb, stmt, false) + " WHERE gen_id=" + this.genID;
            try {
                stmt.executeUpdate(sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        this.category = builder.category;
        this.genusName = builder.genusName;
        this.subGenus = builder.subGenus;
        System.arraycopy(builder.qualifiers, 0, this.qualifiers, 0, this.qualifiers.length);
        this.audit = new Audit(builder.audit);
        this.updatePublisher.setGenusDetailsUpdated();
    }

    boolean checkDelete(SBdb sbdb) throws SQLException, SBException {
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            String sql = "SELECT COUNT(spec_id) as n_spec from " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=" + this.genID;
            int count = 0;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (!rs.next()) {
                throw new RuntimeException("Result set did not return any results");
            }
            count = rs.getInt("n_spec");
            if (count == 0) {
                sql = "SELECT COUNT(grp_id) as n_grp from " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=" + this.genID;
                rs = stmt.executeQuery(sbdb.modQuery(sql));
                if (rs.next() && (count = rs.getInt("n_grp")) > 0) {
                    boolean bl = false;
                    return bl;
                }
                sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=" + this.genID;
                int updated = stmt.executeUpdate(sbdb.modQuery(sql));
                if (updated < 1) {
                    throw new SBException("No records updated in delete genus: " + this.genusName);
                }
                this.updatePublisher.setGenusDeleted();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteGenera(SBdb sbdb, Set<Integer> genIDs) throws SQLException {
        int NSTATEMENTS = 3;
        PreparedStatement[] pStmt = new PreparedStatement[3];
        int n = 0;
        String sql = "SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "SELECT distinct grp_id FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        Iterator<Integer> it = genIDs.iterator();
        try {
            while (it.hasNext()) {
                int genID = it.next();
                boolean deleted = false;
                pStmt[0].setInt(1, genID);
                ResultSet rs = pStmt[0].executeQuery();
                if (!rs.next()) {
                    pStmt[1].setInt(1, genID);
                    rs = pStmt[1].executeQuery();
                    if (!rs.next()) {
                        pStmt[2].setInt(1, genID);
                        pStmt[2].executeUpdate();
                        deleted = true;
                    }
                }
                if (deleted) continue;
                it.remove();
            }
        }
        finally {
            for (n = 0; n < pStmt.length; ++n) {
                pStmt[n].close();
            }
        }
    }

    public static int deleteUnusedGenera(SBdb sbdb) throws SQLException {
        int nRows;
        String sql = "DELETE FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + ")";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            nRows = stmt.executeUpdate(sbdb.modQuery(sql));
            System.out.println("Number of rows deleted from GROUPMBR_GENUS: " + nRows);
            sql = "DELETE FROM " + sbdb.DBTableName("GENUS") + " WHERE gen_id NOT IN (SELECT distinct gen_id FROM " + sbdb.DBTableName("SPECIES") + ")";
            nRows = stmt.executeUpdate(sbdb.modQuery(sql));
        }
        return nRows;
    }

    public boolean equalsBuilder(Builder builder, boolean ignoreCase) {
        if (this.category != builder.category) {
            return false;
        }
        if (ignoreCase) {
            if (!this.genusName.equalsIgnoreCase(builder.genusName)) {
                return false;
            }
            if (!this.subGenus.equalsIgnoreCase(builder.subGenus)) {
                return false;
            }
        } else {
            if (!this.genusName.equals(builder.genusName)) {
                return false;
            }
            if (!this.subGenus.equals(builder.subGenus)) {
                return false;
            }
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(builder.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Genus genus) {
        if (this.category != genus.category) {
            return false;
        }
        if (!this.genusName.equals(genus.genusName)) {
            return false;
        }
        if (!this.subGenus.equals(genus.subGenus)) {
            return false;
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(genus.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.genID;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Genus other = (Genus)obj;
        return this.genID == other.genID;
    }

    Audit getAudit() {
        return this.audit;
    }

    Qualifier getQualifier(int pos) {
        if (pos < 0 || pos > this.qualifiers.length - 1) {
            return null;
        }
        return this.qualifiers[pos];
    }

    public int compareTo(Object o) {
        Genus genus = (Genus)o;
        if (this.category != genus.category) {
            return this.category.getMnem().compareTo(genus.getCategory().getMnem());
        }
        if (!this.genusName.equals(genus.genusName)) {
            return this.genusName.compareTo(genus.genusName);
        }
        if (!this.subGenus.equals(genus.subGenus)) {
            return this.subGenus.compareTo(genus.subGenus);
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(genus.qualifiers[i])) continue;
            return this.qualifiers[i].toString().compareTo(genus.qualifiers[i].toString());
        }
        return 0;
    }

    void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write((String)ind + "<Category>" + this.category.getMnem() + "</Category>\n");
        out.write((String)ind);
        out.write("<GenusID>");
        out.write(String.valueOf(this.genID));
        out.write("</GenusID>\n");
        if (this.qualifiers[0].hasQuals()) {
            out.write((String)ind);
            out.write("<GQ1>");
            out.write(this.qualifiers[0].toString(true));
            out.write("</GQ1>\n");
        }
        out.write((String)ind);
        out.write("<Genus>");
        out.write(SB.getXMLstring((String)this.genusName));
        out.write("</Genus>\n");
        if (this.qualifiers[1].hasQuals()) {
            out.write((String)ind);
            out.write("<GQ2>");
            out.write(this.qualifiers[1].toString(false));
            out.write("</GQ2>\n");
        }
        if (this.qualifiers[2].hasQuals()) {
            out.write((String)ind);
            out.write("<GQ3>");
            out.write(this.qualifiers[2].toString(true));
            out.write("</GQ3>\n");
        }
        if (this.subGenus != null && this.subGenus.length() > 0) {
            out.write((String)ind);
            out.write("<SubGenus>");
            out.write(SB.getXMLstring((String)this.subGenus));
            out.write("</SubGenus>\n");
        }
        if (this.qualifiers[3].hasQuals()) {
            out.write((String)ind);
            out.write("<GQ4>");
            out.write(this.qualifiers[3].toString(false));
            out.write("</GQ4>\n");
        }
    }

    void writeDEX(FileWriter out, String eol) throws IOException {
        out.write("   Category : " + this.category.getMnem() + eol);
        if (this.qualifiers[0].hasQuals()) {
            out.write("   Pre-Genus qualifier : " + this.qualifiers[0].toString(true) + eol);
        }
        out.write("   Genus : " + this.genusName + eol);
        if (this.qualifiers[1].hasQuals()) {
            out.write("   Post-Genus qualifier : " + this.qualifiers[1].toString(false) + eol);
        }
        if (this.qualifiers[2].hasQuals()) {
            out.write("   Pre-Subgenus qualifier : " + this.qualifiers[2].toString(true) + eol);
        }
        if (!this.subGenus.isEmpty()) {
            out.write("   Subgenus : " + this.subGenus + eol);
        }
        if (this.qualifiers[3].hasQuals()) {
            out.write("   Post-Subgenus qualifier : " + this.qualifiers[3].toString(false) + eol);
        }
    }

    public static String toGenusCase(String strg) {
        strg = SB.capitalise((String)strg);
        return strg;
    }

    void clean(boolean convertCase, Category cat) {
        if (convertCase) {
            this.genusName = Genus.toGenusCase(this.genusName);
            this.subGenus = Genus.toGenusCase(this.subGenus);
        }
        this.category = cat;
    }

    public static List<Genus> search(SBdb sbdb, String catMnem, boolean includeSubCategories, String genus, String subGenus) throws SQLException {
        ArrayList<Genus> list = new ArrayList<Genus>();
        String sql = "SELECT distinct gen_id FROM " + sbdb.DBTableName("GENUS") + " g ";
        String search = Genus.getSearchString(sbdb, null, catMnem, includeSubCategories, genus, subGenus);
        if (!search.isEmpty()) {
            sql = sql + " WHERE " + search;
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                list.add(sbdb.getGenus(rs.getInt("gen_id")));
            }
        }
        return list;
    }

    static String getSearchString(SBdb db, Discipline disc, String catMnem, boolean includeSubCategories, String genus, String subGenus) {
        String text;
        Object sql = "";
        if (disc != null) {
            sql = (String)sql + "g.cat_mnem=c.cat_mnem AND c.disc_id='" + disc.getChar() + "' ";
        }
        if (catMnem.length() > 0) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = includeSubCategories ? (String)sql + "g.cat_mnem like '" + catMnem + "%'" : (String)sql + "g.cat_mnem='" + catMnem + "'";
        }
        if ((text = genus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(g.genus) like '" + text + "'" : (String)sql + "ucase(g.genus)='" + text + "'";
        }
        if ((text = subGenus.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (!((String)sql).isEmpty()) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(g.sub_genus) like '" + text + "'" : (String)sql + "ucase(g.sub_genus)='" + text + "'";
        }
        return sql;
    }

    private Genus(Builder builder, int genID) {
        this.genID = genID;
        this.category = builder.category;
        this.genusName = builder.genusName;
        this.subGenus = builder.subGenus;
        this.qualifiers = builder.qualifiers;
        this.audit = builder.audit;
    }

    public String getSortEntry() {
        return this.toString(true);
    }

    public boolean isFuncEquivalent(SortEntry e) throws SBException, SQLException {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public String statusString() {
        return this.toString(true);
    }

    void updateCategory(Category cat) {
        if (!Objects.equals(cat.getMnem(), this.category.getMnem())) {
            return;
        }
        this.category = cat;
    }

    public static int getNGenera(SBdb sbdb) throws SQLException {
        String sql = "SELECT count(gen_id) AS ngenera FROM " + sbdb.DBTableName("GENUS");
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                int n = rs.getInt("ngenera");
                return n;
            }
        }
        return 0;
    }

    public static class Builder {
        private Category category;
        private String genusName = "";
        private String subGenus = "";
        private Qualifier[] qualifiers = new Qualifier[4];
        private Audit audit = new Audit();

        public Builder() {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                this.qualifiers[i] = new Qualifier(i);
            }
        }

        public static Builder copyOf(Genus genus) {
            Builder builder = new Builder();
            builder.genusName(genus.genusName).subGenus(genus.subGenus);
            for (int i = 0; i < builder.qualifiers.length; ++i) {
                Qualifier q = genus.getQualifier(i);
                if (q == null) continue;
                builder.qualifiers[i] = q.copy();
            }
            return builder;
        }

        public void verify() throws InvalidFieldException {
            if (this.qualifiers[0].hasQual(TaxonQual.QUOTE) || this.qualifiers[1].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[0].addQual(TaxonQual.QUOTE);
                this.qualifiers[1].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[2].hasQual(TaxonQual.QUOTE) || this.qualifiers[3].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[2].addQual(TaxonQual.QUOTE);
                this.qualifiers[3].addQual(TaxonQual.QUOTE);
            }
        }

        Genus build(int genID) {
            if (genID <= 0) {
                throw new IllegalArgumentException("Attempt to build Genus with ID: " + genID);
            }
            if (this.category == null) {
                throw new IllegalStateException("Attempt to build Genus with no Category");
            }
            if (this.genusName.isEmpty()) {
                throw new IllegalArgumentException("Attempt to build Genus with no name");
            }
            return new Genus(this, genID);
        }

        Genus store(SBdb sbdb) throws SQLException {
            int genID = sbdb.nextControl("GENUS", "GEN_ID");
            Genus genus = this.build(genID);
            genus.store(sbdb);
            return genus;
        }

        public Builder genusName(String name) {
            this.genusName = name != null ? name.trim() : "";
            return this;
        }

        public Builder subGenus(String name) {
            this.subGenus = name != null ? name.trim() : "";
            return this;
        }

        public Builder category(Category cat) {
            this.category = cat;
            return this;
        }

        public Builder qual(int qual, String s) {
            if (s == null || s.isEmpty() || qual < 0 || qual > 3) {
                return this;
            }
            if (!this.qualifiers[qual].hasQuals()) {
                this.qualifiers[qual] = new Qualifier(s.trim(), qual);
            } else {
                for (TaxonQual parsed : TaxonQual.parse(s, qual)) {
                    this.qualifiers[qual].addQual(parsed);
                }
            }
            return this;
        }

        public Builder qual(int qual, Qualifier q) {
            if (qual < 0 || qual > 3) {
                return this;
            }
            this.qualifiers[qual] = q == null ? new Qualifier(qual) : q;
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            for (Qualifier q : this.qualifiers) {
                if (!q.hasQual(qual)) continue;
                return true;
            }
            return false;
        }

        Qualifier getQualifier(int i) {
            return this.qualifiers[i];
        }

        public String getName() {
            return this.genusName;
        }

        public String getSubGenus() {
            return this.subGenus;
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

