/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import model2_1.AgeConfidence;
import model2_1.Audit;
import model2_1.IGDAge;
import model2_1.IGDIntervalZone;
import model2_1.IGDScheme;
import model2_1.IGDUnitBase;
import model2_1.IGDUnitClass;
import model2_1.SBdb;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class IGDUnit
extends IGDUnitBase {
    private IGDAge u_age = new IGDAge(0.0);
    private IGDAge l_age = new IGDAge(0.0);
    private String abr = "";
    private Color colour = Color.WHITE;
    private String comments = "";
    public static final int COMMENTLEN = 255;

    @Override
    public double getUage() {
        return this.u_age.getAge();
    }

    @Override
    public double getLage() {
        return this.l_age.getAge();
    }

    IGDAge getLigdAge() {
        return this.l_age;
    }

    IGDAge getUigdAge() {
        return this.u_age;
    }

    public boolean hasAges() {
        if (this.u_age == null && this.l_age == null) {
            return false;
        }
        return !(this.u_age.getAge() < 1.0E-5) || !(this.l_age.getAge() < 1.0E-5);
    }

    public String getComments() {
        return this.comments;
    }

    public boolean isAgeDerived(boolean upper) {
        if (upper) {
            return this.u_age.getRefID() > 0;
        }
        return this.l_age.getRefID() > 0;
    }

    public int getAgeRef(boolean upper) {
        return (upper ? this.u_age : this.l_age).getRefID();
    }

    public int getAgePercent(boolean upper) {
        return (upper ? this.u_age : this.l_age).getPercent();
    }

    public AgeConfidence getConfidence(boolean upper) {
        return (upper ? this.u_age : this.l_age).getConfidence();
    }

    void calcAges(IGDScheme parentScheme, IGDScheme thisScheme, Statement stmt) throws SQLException {
        assert (thisScheme.getID() == this.getSchID());
        double uAge = this.u_age.getAge();
        double lAge = this.l_age.getAge();
        this.u_age.calcAge(parentScheme, thisScheme);
        this.l_age.calcAge(parentScheme, thisScheme);
        if (stmt != null && (Math.abs(uAge - this.u_age.getAge()) > 1.0E-6 || Math.abs(lAge - this.l_age.getAge()) > 1.0E-6)) {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " set u_age=" + this.getUage() + ",l_age=" + this.getLage() + " WHERE igd_id=" + this.getUnitID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    void calcAges(List<IGDUnitBase> thisScheme) throws SQLException {
        this.u_age.calcAge(thisScheme);
        this.l_age.calcAge(thisScheme);
    }

    void updateAges(IGDUnit hasChanged, Statement stmt) throws SQLException {
        boolean change = false;
        for (IGDAge age : new IGDAge[]{this.u_age, this.l_age}) {
            if (age.getRefID() != hasChanged.getUnitID()) continue;
            age.calcAge(hasChanged);
            change = true;
        }
        if (change) {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " set u_age=" + this.getUage() + ",l_age=" + this.getLage() + " WHERE igd_id=" + this.getUnitID();
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    @Override
    public String getAbr() {
        return this.abr;
    }

    public void setUage(double uAge) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Cannot assign to IGDUnit in database");
        }
        this.u_age.setAge(uAge);
    }

    public void setLage(double lAge) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Cannot assign to IGDUnit in database");
        }
        this.l_age.setAge(lAge);
    }

    public void setComments(String c) {
        this.comments = c == null ? "" : c;
    }

    private static IGDUnit loadIGDUnit(SBdb sbdb, int igdID) throws SQLException, SBException {
        String sql = "SELECT sch_id,hier,name,abr,comments," + IGDAge.sqlFieldString("u_") + "," + IGDAge.sqlFieldString("l_") + ",red,green,blue," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_DICT") + " WHERE igd_id=" + igdID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            if (rs.next()) {
                int schID = rs.getInt("sch_id");
                Builder builder = new Builder(sbdb);
                builder.hier(rs.getInt("hier"));
                builder.name(rs.getString("name"));
                String abr = rs.getString("abr");
                if (abr == null) {
                    abr = "";
                }
                builder.abr(abr);
                builder.comments(rs.getString("comments"));
                builder.age(true, IGDAge.parseRS(rs, "u_"));
                builder.age(false, IGDAge.parseRS(rs, "l_"));
                Color colour = new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue"));
                if (colour.equals(Color.BLACK)) {
                    colour = Color.WHITE;
                }
                builder.colour(colour);
                builder.audit(new Audit(rs));
                IGDUnit unit = new IGDUnit(builder, igdID, schID);
                unit.status = STORED;
                IGDUnit iGDUnit = unit;
                return iGDUnit;
            }
            throw new SBException("No unit found with ID: " + igdID);
        }
    }

    private static IGDUnit load(SBdb sbdb, int unitID, IGDUnit unit) throws SQLException, SBException {
        if (unit != null && unit.getUnitID() != unitID) {
            throw new IllegalArgumentException("Attempt to refresh unit with incorrect ID");
        }
        IGDUnit temp = IGDUnit.loadIGDUnit(sbdb, unitID);
        if (unit != null) {
            unit.setHier(temp.getHier());
            unit.setName(temp.getName());
            unit.abr = temp.abr;
            unit.comments = temp.comments;
            unit.u_age.setAge(temp.getUage());
            unit.l_age.setAge(temp.getLage());
            unit.setAudit(temp.getAudit());
            unit.status = STORED;
            unit.colour = temp.colour;
        } else {
            unit = temp;
        }
        return unit;
    }

    static IGDUnit refresh(SBdb sbdb, int schID, List<IGDUnitBase> units, Statement stmt) throws SQLException, SBException {
        Object sql = "SELECT igd_id,updated FROM " + sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + schID;
        sql = sbdb.modQuery((String)sql);
        ResultSet rs = stmt.executeQuery((String)sql);
        IGDUnit notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("igd_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDUnitBase base : units) {
                if (!(base instanceof IGDUnit)) {
                    assert (false);
                    continue;
                }
                IGDUnit o = (IGDUnit)base;
                if (o.getUnitID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                IGDUnit.load(sbdb, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = IGDUnit.load(sbdb, key, null);
            IGDUnit.insert(notifier, units);
        }
        if (keys.size() < units.size()) {
            Iterator<IGDUnitBase> it = units.iterator();
            while (it.hasNext()) {
                IGDUnitBase base = it.next();
                if (!(base instanceof IGDUnit)) {
                    assert (false);
                    continue;
                }
                IGDUnit o = (IGDUnit)base;
                if (keys.contains(o.getUnitID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    static void loadAll(SBdb sbdb, int schID, int igdType, List<IGDUnitBase> list, IGDScheme parent) throws SQLException {
        String sql = "SELECT igd_id,hier,name,abr,comments," + IGDAge.sqlFieldString("u_") + "," + IGDAge.sqlFieldString("l_") + ",red,green,blue," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_DICT") + " WHERE sch_id=" + schID + " ORDER BY u_age,hier,l_age";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Builder b = new Builder(sbdb);
                int igdID = rs.getInt("igd_id");
                int hier = rs.getInt("hier");
                if (igdType == 10 && hier == 0) {
                    hier = 1;
                }
                b.hier(hier);
                b.name(rs.getString("name"));
                b.abr(rs.getString("abr"));
                b.comments(rs.getString("comments"));
                b.age(true, IGDAge.parseRS(rs, "u_"));
                b.age(false, IGDAge.parseRS(rs, "l_"));
                b.colour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
                b.audit(new Audit(rs)).status(STORED);
                try {
                    IGDUnit unit = b.build(igdID, schID);
                    IGDUnit.insert(unit, list);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Exception)re);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder builder) throws SQLException, SBException {
        String sqlLinkRefreshLow;
        String sqlLinkRefreshUpp;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("igd_dict") + " set name=" + SB.DBString((String)builder.getName()) + ",abr='" + builder.abr + "',hier=" + builder.getHier() + ",comments=" + SB.DBString((String)builder.comments) + "," + builder.getigdAge(true).getSQLInsert("u_") + "," + builder.getigdAge(false).getSQLInsert("l_") + ",red=" + builder.colour.getRed() + ",green=" + builder.colour.getGreen() + ",blue=" + builder.colour.getBlue() + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE igd_id=" + this.getUnitID();
        if (!this.getName().equals(builder.getName())) {
            sqlLinkRefreshUpp = "UPDATE " + this.sbdb.DBTableName("igd") + " set upp_inf=" + SB.DBString((String)builder.getName()) + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND upp_zone=" + this.getUnitID() + " AND upp_inf=" + SB.DBString((String)this.getName());
            sqlLinkRefreshLow = "UPDATE " + this.sbdb.DBTableName("igd") + " set low_inf=" + SB.DBString((String)builder.getName()) + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND low_zone=" + this.getUnitID() + " AND low_inf=" + SB.DBString((String)this.getName());
        } else {
            sqlLinkRefreshUpp = "UPDATE " + this.sbdb.DBTableName("igd") + " set " + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND upp_zone=" + this.getUnitID();
            sqlLinkRefreshLow = "UPDATE " + this.sbdb.DBTableName("igd") + " set " + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND low_zone=" + this.getUnitID();
        }
        try {
            int i = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (i != 1) {
                throw new SBException("Could not update unit: " + this);
            }
            if (sqlLinkRefreshUpp != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshUpp));
            }
            if (sqlLinkRefreshLow != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshLow));
            }
        }
        finally {
            stmt.close();
        }
        this.setHier(builder.getHier());
        this.setName(builder.getName());
        this.abr = builder.abr;
        this.comments = builder.comments;
        this.u_age = new IGDAge(builder.getigdAge(true));
        this.l_age = new IGDAge(builder.getigdAge(false));
        this.colour = builder.colour;
        this.status = STORED;
    }

    @Override
    public void copyLink() {
        if (this.link == null || this.status != CONFLICT) {
            return;
        }
        this.setName(this.link.getName());
        this.abr = this.getLink().getAbr();
        this.comments = this.getLink().getComments();
        this.u_age.setAge(this.link.getUage());
        this.l_age.setAge(this.link.getLage());
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void storeDB(int igdType, Statement statement) throws SQLException {
        Statement stmt = statement == null ? this.sbdb.getDatabase().createStatement() : statement;
        String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_DICT") + " (igd_id,sch_id,igd_type,hier,name,abr,comments," + IGDAge.sqlFieldString("u_") + "," + IGDAge.sqlFieldString("l_") + ",red,green,blue," + Audit.sqlFieldString() + ") VALUES (" + this.getUnitID() + "," + this.getSchID() + "," + igdType + "," + this.getHier() + "," + SB.DBString((String)this.getName()) + "," + SB.DBString((String)this.abr) + "," + SB.DBString((String)this.comments) + "," + this.u_age.sqlValueString() + "," + this.l_age.sqlValueString() + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + this.getAudit().sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void delete(Statement stmt) throws SQLException {
        int updated;
        Statement statement = stmt == null ? this.sbdb.getDatabase().createStatement() : stmt;
        try {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET upp_zone=NULL WHERE upp_zone=" + this.getUnitID() + " AND sch_id=" + this.getSchID();
            updated = statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD") + " SET low_zone=NULL WHERE low_zone=" + this.getUnitID() + " AND sch_id=" + this.getSchID();
            updated += statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " set u_unit_ref=NULL,l_unit_ref=NULL WHERE sch_id=" + this.getSchID();
            statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT") + " WHERE igd_id=" + this.getUnitID();
            statement.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        if (updated > 0) {
            System.out.println("WARNING: IGD table updated during delete unit '" + this.getName() + "'");
        }
        this.status = NOTSTORED;
    }

    @Override
    void writeDEX(FileWriter out, String eol, int igdType) throws IOException {
        out.write("Unit = " + this.getName() + eol);
        if (this.getAbr() != null) {
            out.write("  Abbreviation : " + this.getAbr() + eol);
        }
        out.write("  Type = " + IGDIntervalZone.getDefaultHierName(igdType, this.getHier(), true) + eol);
        out.write("  Youngest : " + this.getUage() + eol);
        out.write("  Oldest : " + this.getLage() + eol);
        out.write("  Dictionary ID : " + this.getUnitID() + eol);
        if (this.colour != Color.WHITE) {
            out.write("  Colour : " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        }
    }

    @Override
    void writeXML(BufferedWriter out, int indent, int igdType, List<IGDUnitBase> units) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<Unit>\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<UnitName>" + SB.getXMLstring((String)this.getName()) + "</UnitName>\n");
        if (this.getAbr() != null) {
            out.write(ind + "<Abbreviation>" + SB.getXMLstring((String)this.getAbr()) + "</Abbreviation>\n");
        }
        if (!this.getComments().isEmpty()) {
            out.write(ind + "<Comments>" + SB.getXMLstring((String)this.getComments()) + "</Comments>\n");
        }
        out.write(ind + "<Type>" + IGDIntervalZone.getDefaultHierName(igdType, this.getHier(), true) + "</Type>\n");
        out.write(ind + "<Youngest>" + this.getUage() + "</Youngest>\n");
        if (this.u_age.getConfidence() != AgeConfidence.CONFIDENT) {
            out.write(ind + "<YoungestUncertainty>" + this.u_age.getConfidence().getDBint() + "</YoungestUncertainty>\n");
        }
        if (this.u_age.getRefID() > 0) {
            for (IGDUnitBase unit : units) {
                if (unit.getUnitID() != this.u_age.getRefID()) continue;
                out.write(ind + "<YoungestUnitReference>" + this.u_age.getRefID() + "</YoungestUnitReference>\n");
                out.write(ind + "<YoungestReferencePercent>" + this.u_age.getPercent() + "</YoungestReferencePercent>\n");
                break;
            }
        }
        out.write(ind + "<Oldest>" + this.getLage() + "</Oldest>\n");
        if (this.l_age.getConfidence() != AgeConfidence.CONFIDENT) {
            out.write(ind + "<OldestUncertainty>" + this.l_age.getConfidence().getDBint() + "</OldestUncertainty>\n");
        }
        if (this.l_age.getRefID() > 0) {
            for (IGDUnitBase unit : units) {
                if (unit.getUnitID() != this.l_age.getRefID()) continue;
                out.write(ind + "<OldestUnitReference>" + this.l_age.getRefID() + "</OldestUnitReference>\n");
                out.write(ind + "<OldestReferencePercent>" + this.l_age.getPercent() + "</OldestReferencePercent>\n");
                break;
            }
        }
        out.write(ind + "<DictionaryID>" + this.getUnitID() + "</DictionaryID>\n");
        if (this.colour != Color.WHITE) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind);
        }
        this.getAudit().writeXML(out, indent + indent);
        out.write(ind1 + "</Unit>\n");
    }

    IGDUnit(SBdb ws, int schID, int igdType, Element xml) throws ParseException, SQLException, SBException {
        super(ws, schID, Integer.parseInt(xml.getChildTextNormalize("DictionaryID")));
        Element el;
        String strg = xml.getChildTextNormalize("UnitName");
        if (strg != null) {
            this.setName(strg);
        }
        if ((strg = xml.getChildTextNormalize("Abbreviation")) != null) {
            this.abr = strg;
        }
        if ((strg = xml.getChildTextNormalize("Comments")) != null) {
            this.comments = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.setHier(IGDIntervalZone.getHierNumber(igdType, strg, true));
        }
        if ((strg = xml.getChildTextNormalize("Youngest")) != null) {
            this.u_age.setAge(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("YoungestUncertainty")) != null) {
            this.u_age.setConfidence(AgeConfidence.getConfidence(Integer.parseInt(strg)));
        }
        if ((strg = xml.getChildTextNormalize("YoungestUnitReference")) != null) {
            this.u_age.setRef(Integer.parseInt(strg));
            strg = xml.getChildTextNormalize("YoungestReferencePercent");
            if (strg != null) {
                this.u_age.setPercent(Integer.parseInt(strg));
            }
        }
        if ((strg = xml.getChildTextNormalize("Oldest")) != null) {
            this.l_age.setAge(Double.parseDouble(strg));
        }
        if ((strg = xml.getChildTextNormalize("OldestUncertainty")) != null) {
            this.l_age.setConfidence(AgeConfidence.getConfidence(Integer.parseInt(strg)));
        }
        if ((strg = xml.getChildTextNormalize("OldestUnitReference")) != null) {
            this.l_age.setRef(Integer.parseInt(strg));
            strg = xml.getChildTextNormalize("OldestReferencePercent");
            if (strg != null) {
                this.l_age.setPercent(Integer.parseInt(strg));
            }
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.setAudit(new Audit(ws, el));
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + this);
        }
        el = xml.getChild("Colour");
        if (el != null) {
            this.colour = SB.parseColour((Element)el);
        }
        this.status = NOTSTORED;
    }

    @Override
    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) throws SQLException {
        if (colour.equals(this.colour)) {
            return;
        }
        if (this.sbdb.isConnected()) {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT") + " SET red=" + colour.getRed() + ", green=" + colour.getGreen() + ", blue=" + colour.getBlue() + " WHERE igd_id=" + this.getUnitID();
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                stmt.executeUpdate(sql);
            }
        }
        this.colour = colour;
    }

    @Override
    public IGDUnit getLink() {
        return (IGDUnit)this.link;
    }

    @Override
    void updateStatusLinkSubclass(List<IGDUnitBase> schemeUnits) {
        if (!(this.abr == null || this.abr.isEmpty() || this.getLink().getAbr() == null || this.getLink().getAbr().isEmpty() || this.abr.equals(this.getLink().getAbr()))) {
            this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
        } else if (this.abr != null && this.abr.isEmpty() && this.getLink().getAbr() != null && !this.getLink().getAbr().isEmpty()) {
            this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
        }
        IGDAge[] thisAge = new IGDAge[]{this.u_age, this.l_age};
        IGDAge[] compAge = new IGDAge[]{this.getLink().u_age, this.getLink().l_age};
        for (int i = 0; i < 2; ++i) {
            if (thisAge[i].getRefID() > 0) {
                if (compAge[i].getRefID() == 0) {
                    this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
                    continue;
                }
                if (schemeUnits != null) {
                    IGDUnitBase thisRef = null;
                    for (IGDUnitBase base : schemeUnits) {
                        if (base.getUnitID() != thisAge[i].getRefID()) continue;
                        thisRef = base;
                        break;
                    }
                    if (thisRef == null) {
                        throw new IllegalStateException("No reference unit found in scheme for: " + this);
                    }
                    if (thisRef.getLink().getUnitID() != compAge[i].getRefID()) {
                        this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                    } else if (compAge[i].getPercent() != thisAge[i].getPercent()) {
                        this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                    }
                }
            }
            if (thisAge[i].getConfidence() == compAge[i].getConfidence()) continue;
            this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
        }
    }

    public void setLink(IGDUnit linkUnit, boolean updateStatus) {
        this.link = linkUnit;
        if (updateStatus && this.link != null) {
            this.status = STORED;
        }
    }

    public static void getAllLstrat(SBdb db, DefaultComboBoxModel comboBoxModelUnits) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "SELECT DISTINCT name FROM " + db.DBTableName("IGD_DICT_LSTRAT") + " ORDER BY name";
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                comboBoxModelUnits.addElement(rs.getString("name"));
            }
        }
    }

    private IGDUnit(Builder builder, int ID, int schID) {
        super(builder, schID, ID);
        this.l_age = new IGDAge(builder.l_age);
        this.u_age = new IGDAge(builder.u_age);
        this.abr = builder.abr;
        this.comments = builder.comments;
        this.colour = builder.colour;
    }

    public static class Builder
    extends IGDUnitBase.Builder {
        private String abr = "";
        private String comments = "";
        private Color colour = Color.WHITE;
        private IGDAge u_age = new IGDAge(0.0);
        private IGDAge l_age = new IGDAge(0.0);
        private IGDUnit original;
        public IGDUnitClass u_age_ref;
        public IGDUnitClass l_age_ref;

        public Builder(SBdb sbdb) {
            super(sbdb);
        }

        public Builder(SBdb sbdb, IGDUnit unit) {
            super(sbdb);
            this.original = unit.sbdb == sbdb ? unit : null;
        }

        public Builder age(boolean upper, IGDAge age) {
            if (age != null) {
                if (upper) {
                    this.u_age = age;
                } else {
                    this.l_age = age;
                }
            }
            return this;
        }

        public Builder age(boolean upper, double age) {
            if (age >= 0.0) {
                if (upper) {
                    this.u_age.setAge(age);
                } else {
                    this.l_age.setAge(age);
                }
            }
            return this;
        }

        public Builder age(double uAge, double lAge) {
            this.u_age.setAge(uAge);
            this.l_age.setAge(lAge);
            return this;
        }

        public Builder ageRef(boolean upper, int unitID) {
            (upper ? this.u_age : this.l_age).setRef(unitID);
            if (unitID == 0) {
                if (upper) {
                    this.u_age_ref = null;
                } else {
                    this.l_age_ref = null;
                }
            }
            return this;
        }

        public Builder ageVal(boolean upper, int val) {
            (upper ? this.u_age : this.l_age).setPercent(val);
            return this;
        }

        public Builder colour(Color colour) {
            if (colour != null && !colour.equals(Color.BLACK)) {
                this.colour = colour;
            }
            return this;
        }

        public Builder abr(String abr) {
            if (abr != null) {
                if (abr.length() > 80) {
                    abr = abr.substring(0, 80);
                }
                this.abr = abr.trim().replaceAll("\\s+", " ");
            } else {
                this.abr = "";
            }
            return this;
        }

        public Builder comments(String c) {
            this.comments = c == null ? "" : (c.length() > 255 ? c.substring(0, 255) : c);
            return this;
        }

        @Override
        IGDUnit build(int ID, int schID) {
            return (IGDUnit)super.build(ID, schID);
        }

        @Override
        IGDUnit buildThis(int ID, int schID) {
            return new IGDUnit(this, ID, schID);
        }

        @Override
        void validateFields() {
            if (this.u_age_ref != null) {
                this.u_age = new IGDAge(((IGDUnitBase)this.u_age_ref).getUnitID(), this.u_age.getPercent(), this.u_age.getAge(), this.u_age.getConfidence());
            }
            if (this.l_age_ref != null) {
                this.l_age = new IGDAge(((IGDUnitBase)this.l_age_ref).getUnitID(), this.l_age.getPercent(), this.l_age.getAge(), this.l_age.getConfidence());
            }
            super.validateFields();
            if (this.u_age.getAge() < 0.0 || this.l_age.getAge() < 0.0) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.getName() + "' with uncalculated age");
            }
            if (this.u_age.getAge() > this.l_age.getAge()) {
                throw new IllegalStateException("Attempt to build IGD Unit '" + this.getName() + "' with upper age greater than lower age");
            }
        }

        @Override
        IGDUnit store(int igdType, int schID) throws SQLException, SBException {
            IGDUnit unit;
            if (!this.sbdb.isConnected()) {
                throw new IllegalStateException("Attempt to store IGDUnit in workspace");
            }
            if (this.original != null) {
                this.validateFields();
                if (!(this.getName().equals(this.original.getName()) && this.abr.equals(this.original.abr) && this.getigdAge(true).equals(this.original.getUigdAge()) && this.getigdAge(false).equals(this.original.getLigdAge()) && this.colour.equals(this.original.colour) && this.getHier() == this.original.getHier() && this.comments.equals(this.original.comments))) {
                    this.original.update(this);
                }
                unit = this.original;
            } else {
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("IGD_DICT", "IGD_ID");
                unit = this.build(ID, schID);
                unit.storeDB(igdType, null);
            }
            return unit;
        }

        public IGDUnit getOrigianlUnit() {
            return this.original;
        }

        @Override
        public int getOriginalID() {
            if (this.original != null) {
                return this.original.getUnitID();
            }
            return -1;
        }

        boolean equalsOriginalAge() {
            if (this.original == null) {
                return true;
            }
            return this.getigdAge(true).equals(this.original.getUigdAge()) && this.getigdAge(false).equals(this.original.getLigdAge());
        }

        void clearOriginal() {
            this.original = null;
        }

        @Override
        public Color getColour() {
            return this.colour;
        }

        public String getAbr() {
            return this.abr;
        }

        public String getComments() {
            return this.comments;
        }

        public IGDAge getigdAge(boolean upper) {
            return upper ? this.u_age : this.l_age;
        }

        @Override
        public double getUage() {
            return this.u_age.getAge();
        }

        @Override
        public double getLage() {
            return this.l_age.getAge();
        }
    }
}

