/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import model2_1.Audit;
import model2_1.IGDInterval;
import model2_1.SBdb;
import model2_1.Userdef;
import org.jdom2.Element;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class Intcom
implements SbugsStatus,
SortEntry {
    private final SBdb sbdb;
    private double topDepth;
    private double baseDepth;
    private String comments;
    private Color status = UNKNOWN;
    private Audit audit = new Audit();
    private final int igdType;

    static Intcom load(SBdb db, int wellID, int interpID, int igdType, double topDepth, Intcom i) throws SQLException, SBException {
        Builder builder;
        String sql = "SELECT base_depth,comments," + Audit.sqlFieldString() + " FROM " + db.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND igd_type=" + igdType + " AND top_depth >= " + (topDepth - (double)0.0029f) + " AND top_depth <=" + (topDepth + (double)0.0029f);
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            builder = null;
            if (rs.next()) {
                builder = new Builder(db, igdType, topDepth);
                builder.baseDepth(rs.getDouble("base_depth"));
                builder.comments(rs.getString("comments"));
                builder.audit = new Audit(rs);
            }
        }
        if (builder == null) {
            return null;
        }
        if (i == null) {
            return builder.build();
        }
        if (Math.abs(builder.topDepth - i.topDepth) > 0.001) {
            throw new SBException("Attempt to copy fields to unequivalent Intcom object");
        }
        i.baseDepth = builder.baseDepth;
        i.comments = builder.comments;
        i.audit = builder.audit;
        return i;
    }

    Intcom(SBdb ws, Intcom dbIntcom) throws SQLException, SBException {
        this.sbdb = ws;
        this.igdType = dbIntcom.igdType;
        this.copyPrimitives(dbIntcom);
        this.audit = new Audit(dbIntcom.audit);
        this.audit.fillWorkspace(dbIntcom.sbdb, ws);
        this.status = STORED;
    }

    Intcom(Intcom wsIntcom, SBdb db) throws SQLException, SBException {
        this.sbdb = db;
        this.igdType = wsIntcom.igdType;
        this.copyPrimitives(wsIntcom);
        this.audit = new Audit(this.sbdb, wsIntcom.sbdb, this.audit);
        this.status = NOTSTORED;
    }

    private void copyPrimitives(Intcom rhs) {
        this.topDepth = rhs.topDepth;
        this.baseDepth = rhs.baseDepth;
        this.comments = rhs.comments;
    }

    public String getSortEntry() {
        String entry = this.igdType + "-";
        int top = (int)Math.round(this.getTopDepth() * 100.0);
        entry = entry + top;
        while (entry.length() < 8) {
            entry = " " + entry;
        }
        int base = (int)Math.round(this.getBaseDepth() * 100.0);
        String sbase = "" + base;
        while (sbase.length() < 8) {
            sbase = " " + sbase;
        }
        return entry + "-" + sbase;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.toString();
    }

    public String toString() {
        return this.comments;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public int getIGDType() {
        return this.igdType;
    }

    void writeDEX(FileWriter out, String eol, char units) throws SBException {
        throw new SBException("Interval comments cannot be exported to DEX files.");
    }

    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String bdepth;
        String tdepth;
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        out.write("<IntervalComment>\n");
        if (this.igdType > 0) {
            out.write((String)ind + "<Type>" + IGDInterval.getIGDName(this.igdType) + "</Type>\n");
        }
        if ((tdepth = SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim()) != null && tdepth.length() > 0) {
            out.write((String)ind + "<TopDepth>" + tdepth + "</TopDepth>\n");
        }
        if ((bdepth = SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim()) != null && bdepth.length() > 0) {
            out.write((String)ind + "<BaseDepth>" + bdepth + "</BaseDepth>\n");
        }
        out.write((String)ind + "<Comment>" + SB.getXMLstring((String)this.comments) + "</Comment>\n");
        this.audit.writeXML(out, indent);
        out.write("</IntervalComment>\n");
    }

    Intcom(SBdb db, Element xml) throws SBException, ParseException, SQLException {
        Element el;
        this.sbdb = db;
        String strg = xml.getChildTextNormalize("Type");
        this.igdType = strg != null ? IGDInterval.getIGDType(strg) : 0;
        strg = xml.getChildTextNormalize("TopDepth");
        if (strg != null) {
            this.topDepth = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            this.baseDepth = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildText("Comment")) != null) {
            this.comments = strg;
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.audit = new Audit(db, el);
        } else {
            System.out.println("Warning: no audit info for interval comment: " + this);
        }
    }

    void store(int wellID, int interpID) throws SQLException {
        if (this.status == NOTSTORED) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "INSERT INTO " + this.sbdb.DBTableName("INTCMMNTS") + " (well_id,interp_id,igd_type,top_depth,base_depth,comments," + Audit.sqlFieldString() + ") VALUES (" + wellID + "," + interpID + "," + this.igdType + "," + this.topDepth + "," + this.baseDepth + "," + SB.DBString((String)this.comments) + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            this.status = STORED;
        }
    }

    void delete(int wellID, int interpID) throws SQLException {
        if (wellID < 1 || interpID < 0) {
            throw new IllegalArgumentException("Illegal arguments to interval comment deletion from well: " + wellID + ", interp: " + interpID);
        }
        String sql = "DELETE FROM " + this.sbdb.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND top_depth >=" + (this.topDepth - (double)0.0029f) + " AND top_depth <=" + (this.topDepth + (double)0.0029f);
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        this.status = NOTSTORED;
    }

    static void load(List<Intcom> list, SBdb db, int wellID, int interpID, int igdType) throws SQLException {
        String sql = "SELECT top_depth, base_depth,comments," + Audit.sqlFieldString() + " FROM " + db.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID + " AND igd_type=" + igdType;
        try (Statement stmt = db.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                Intcom intcom;
                Builder builder = new Builder(db, igdType, rs.getDouble("top_depth"));
                builder.baseDepth(rs.getDouble("base_depth"));
                builder.comments(rs.getString("comments"));
                builder.audit(new Audit(rs)).status(STORED);
                try {
                    intcom = builder.build();
                }
                catch (IllegalStateException e) {
                    System.out.println("Did not build illegal intcom: " + builder.comments);
                    e.printStackTrace();
                    continue;
                }
                Intcom.insert(list, intcom);
            }
        }
    }

    static void insert(List<Intcom> list, Intcom intcom) {
        int insertPos = 0;
        for (Intcom ic : list) {
            if (intcom.getIGDType() != ic.getIGDType()) {
                throw new IllegalArgumentException("Mismatch in Intcom IGD type");
            }
            if (intcom.getSortEntry().compareTo(ic.getSortEntry()) < 0) break;
            ++insertPos;
        }
        list.add(insertPos, intcom);
    }

    static void deleteAll(SBdb SB2, int wellID, int interpID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null well_id comment interval from well");
        }
        String sql = "DELETE FROM " + SB2.DBTableName("INTCMMNTS") + " WHERE well_id=" + wellID + " AND interp_id=" + interpID;
        try (Statement stmt = SB2.getDatabase().createStatement();){
            stmt.executeUpdate(SB2.modQuery(sql));
        }
    }

    public String getComments() {
        return this.comments;
    }

    public int getCreator() {
        return this.audit.creator;
    }

    public int getModifier() {
        return this.audit.modifier;
    }

    public String getModifierString() throws SQLException, SBException {
        return this.sbdb.getUser(this.audit.modifier).getAbr();
    }

    public int getUpdater() {
        return this.audit.updater;
    }

    public Date getCreated() {
        return this.audit.created;
    }

    public Date getModified() {
        return this.audit.modified;
    }

    public Date getUpdated() {
        return this.audit.updated;
    }

    void updateStatus(List<Intcom> intcoms) throws SQLException, SBException {
        this.status = NOTSTORED;
        int nzTD = (int)(100.0 * this.topDepth);
        int nzBD = (int)(100.0 * this.baseDepth);
        for (Intcom zone : intcoms) {
            if (zone == this) continue;
            if (zone.getSortEntry().equals(this.getSortEntry())) {
                this.status = STORED;
                if (this.comments.equalsIgnoreCase(zone.comments)) break;
                this.status = CONFLICT;
                break;
            }
            if (zone.getIGDType() != this.igdType) continue;
            int cTD = (int)(100.0 * zone.topDepth);
            int cBD = (int)(100.0 * zone.baseDepth);
            try {
                SB.checkOverlap((int)cTD, (int)cBD, (int)nzTD, (int)nzBD);
            }
            catch (SBException sbe) {
                this.status = CONFLICT;
                break;
            }
        }
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void move(int wellID, int interpID, int newInterpID) throws SQLException, SBException {
        if (wellID < 1 || interpID < 0 || newInterpID < 0) {
            throw new IllegalArgumentException("Illegal argument to Intcom.move: wellID is " + wellID + ", interpID is " + interpID + ", newInterpID is " + newInterpID);
        }
        Audit tempAudit = new Audit(this.audit);
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("INTCMMNTS") + " SET interp_id=" + newInterpID + "," + tempAudit.sqlUpdate(this.sbdb, stmt, true) + " WHERE well_id=" + wellID + " AND top_depth=" + this.topDepth + " AND interp_id=" + interpID;
        try {
            int nRow = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (nRow < 1) {
                throw new SBException("Cannot update interval comment: " + this);
            }
        }
        finally {
            stmt.close();
        }
        this.audit = tempAudit;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for interval comment: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    void setComments(String comments) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set comments on connected database for interval comment: " + this);
        }
        this.comments = comments;
    }

    private Intcom(Builder builder) {
        this.sbdb = builder.sbdb;
        this.igdType = builder.igdType;
        this.topDepth = builder.topDepth;
        this.baseDepth = builder.baseDepth;
        this.comments = builder.comments;
        this.audit = builder.audit;
        this.status = builder.status;
    }

    public static class Builder {
        private final double topDepth;
        private final SBdb sbdb;
        final int igdType;
        private double baseDepth;
        private String comments = "";
        private Audit audit = new Audit();
        private Color status = SbugsStatus.UNKNOWN;

        public Builder(SBdb sbdb, int igdType, double topDepth) {
            this.sbdb = sbdb;
            this.topDepth = topDepth;
            this.igdType = igdType;
        }

        public Builder baseDepth(double depth) {
            if (!(this.baseDepth >= 0.0)) {
                throw new IllegalStateException("Attempt to set intcom base depth to " + depth);
            }
            this.baseDepth = depth;
            return this;
        }

        public Builder comments(String comments) {
            if (comments != null) {
                this.comments = comments;
            }
            return this;
        }

        Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder status(Color status) {
            if (status != null) {
                this.status = status;
            }
            return this;
        }

        public static Builder copyOf(Intcom intcom) {
            Builder builder = new Builder(intcom.sbdb, intcom.igdType, intcom.topDepth).baseDepth(intcom.baseDepth).comments(intcom.comments);
            builder.audit = intcom.audit;
            return builder;
        }

        Intcom build() {
            if (this.sbdb == null) {
                throw new IllegalStateException("Attempt to build Intcom with no data model");
            }
            if (this.baseDepth < this.topDepth) {
                throw new IllegalStateException("Attempt to build Intcom with illegal base depth less than top depth");
            }
            if (this.comments.isEmpty()) {
                System.out.println("WARNING: building Intcom with empty comment");
            }
            if (this.status == SbugsStatus.UNKNOWN) {
                this.status = SbugsStatus.NOTSTORED;
            }
            return new Intcom(this);
        }

        Intcom build(int wellID, int interpID) throws SQLException {
            Intcom intcom = this.build();
            intcom.store(wellID, interpID);
            return intcom;
        }

        public double getTopDepth() {
            return this.topDepth;
        }

        public double getBaseDepth() {
            return this.baseDepth;
        }

        public String getComment() {
            return this.comments;
        }
    }
}

