/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import model2_1.LOCNode;
import util.AgeFormat;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;

public class LOCNodePair {
    private final LOCNode topNode;
    private final LOCNode baseNode;

    public LOCNodePair(LOCNode topNode, LOCNode baseNode) {
        this.topNode = topNode;
        this.baseNode = baseNode;
    }

    public double getAccumRate() {
        if (Math.abs(this.topNode.getAge() - this.baseNode.getAge()) < 0.001) {
            return Double.POSITIVE_INFINITY;
        }
        return (this.topNode.getDepth() - this.baseNode.getDepth()) / (this.topNode.getAge() - this.baseNode.getAge());
    }

    public double getAccumRate(char units, AgeFormat af) {
        if (Math.abs(this.topNode.getAge() - this.baseNode.getAge()) < 0.001) {
            return Double.POSITIVE_INFINITY;
        }
        double rate = (DepthUtils.convFromM((double)this.topNode.getDepth(), (char)units) - DepthUtils.convFromM((double)this.baseNode.getDepth(), (char)units)) / (this.topNode.getAge() - this.baseNode.getAge());
        return rate /= af.getMultiplyer();
    }

    public String getAccumRateString(char units, AgeFormat af) {
        double rate = this.getAccumRate(units, af);
        String rateString = Double.isInfinite(rate) ? "\u221e" : Double.toString(SB.roundToSignificantFigures((double)rate, (int)3));
        return rateString + " " + DepthUnits.getUnits((char)units).getAbr() + "/" + af.getDescr();
    }

    public double getTopDepth() {
        return this.topNode.getDepth();
    }

    public double getBaseDepth() {
        return this.baseNode.getDepth();
    }
}

