/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import model2_1.LithBase;
import model2_1.LithQualifier;
import model2_1.Lithology;
import model2_1.SBdb;
import org.jdom2.Element;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.status.SbugsStatus;

public class LithInterval
extends LithBase
implements SbugsStatus,
SortEntry {
    double baseDepth = 0.0;

    public String getSortEntry() {
        int top = (int)Math.round(this.getTopDepth() * 100.0) + 10000000;
        String entry = "" + top;
        while (entry.length() < 8) {
            entry = " " + entry;
        }
        int base = (int)Math.round(this.getBaseDepth() * 100.0) + 10000000;
        String sbase = "" + base;
        while (sbase.length() < 8) {
            sbase = " " + sbase;
        }
        return entry + "-" + sbase + "-" + (this.desc != null ? this.desc.getLithID() : 0);
    }

    @Override
    public Color getStatus() {
        return this.status;
    }

    public LithInterval(SBdb SB2) {
        super(SB2);
        this.status = UNKNOWN;
    }

    LithInterval(SBdb SB2, int wellID, LithInterval wsLithInterval) throws SQLException, SBException {
        super(wsLithInterval, SB2);
        this.baseDepth = wsLithInterval.baseDepth;
        this.status = NOTSTORED;
        this.store(SB2, wellID);
    }

    public LithInterval(SBdb db, LithInterval lithInterval) {
        super(db, lithInterval);
        this.baseDepth = lithInterval.baseDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public void setBaseDepth(double depth) throws SBException {
        if (this.getSbdb() != null) {
            throw new SBException("Attempt to set Lithology field");
        }
        this.baseDepth = depth;
    }

    @Override
    void writeDEX(FileWriter out, String eol, char units) throws IOException {
        out.write("[INTERVAL " + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + "]" + eol);
        out.write("Interval Lithology = " + this.toString() + eol);
        out.write("  Top depth : " + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + eol);
        out.write("  Base depth : " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + eol);
        out.write("  Dictionary ID : " + this.getLithCode() + eol);
        out.write(eol);
    }

    LithInterval(SBdb db, Element xml) throws SBException, SQLException {
        super(db);
        String strg = xml.getChildTextNormalize("TopDepth");
        if (strg != null) {
            this.topDepth = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("BaseDepth")) != null) {
            this.baseDepth = DepthUtils.parseDepthString((String)strg);
        }
        if ((strg = xml.getChildTextNormalize("LithologyID")) != null) {
            int lithCode = Integer.parseInt(strg);
            this.desc = db.getLithdesc().getLithology(lithCode);
        }
    }

    public LithInterval(SBdb ws, double topDepth, double baseDepth, Lithology lithology) {
        super(ws);
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.desc = lithology;
        this.status = NOTSTORED;
    }

    @Override
    void writeXML(BufferedWriter out, int indent, char units) throws IOException {
        String bdepth;
        String tdepth;
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<LithologyInterval Depth=\"" + SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim() + " - " + SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim() + "\">\n");
        String ind2 = SB.getXMLIndent((int)(indent + 3));
        if (this.toString() != null && this.toString().length() > 0) {
            out.write(ind2 + "<Lithology>" + this.toString() + "</Lithology>\n");
        }
        if ((tdepth = SB.getDepthString((double)this.topDepth, (char)units, (int)2).trim()) != null && tdepth.length() > 0) {
            out.write(ind2 + "<TopDepth>" + tdepth + "</TopDepth>\n");
        }
        if ((bdepth = SB.getDepthString((double)this.baseDepth, (char)units, (int)2).trim()) != null && bdepth.length() > 0) {
            out.write(ind2 + "<BaseDepth>" + bdepth + "</BaseDepth>\n");
        }
        if (this.getLithCode() > 0) {
            out.write(ind2 + "<LithologyID>" + this.getLithCode() + "</LithologyID>\n");
        }
        out.write(ind1 + "</LithologyInterval>\n");
    }

    @Override
    final void store(SBdb SB2, int wellID) throws SQLException {
        if (this.getLithCode() > 0 && this.status == NOTSTORED) {
            String sql = "INSERT INTO " + SB2.DBTableName("SBILITH") + " (well_Id,top_depth,base_depth,lith_id) VALUES (" + wellID + "," + this.topDepth + "," + this.baseDepth + "," + this.getLithCode() + ")";
            Statement stmt = SB2.getDatabase().createStatement();
            stmt.executeUpdate(SB2.modQuery(sql));
            stmt.close();
            this.status = STORED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(int wellID, Statement stmt) throws SQLException {
        if (wellID <= 0) {
            throw new IllegalStateException("Attempt to delete lithology from wellID: " + wellID);
        }
        String sql = "DELETE FROM " + this.getSbdb().DBTableName("SBILITH") + " WHERE well_id=" + wellID + " AND top_depth >=" + (this.topDepth - (double)0.0029f) + " AND top_depth <=" + (this.topDepth + (double)0.0029f);
        Statement statement = stmt == null ? this.getSbdb().getDatabase().createStatement() : stmt;
        try {
            statement.executeUpdate(this.getSbdb().modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        this.status = NOTSTORED;
    }

    public static void deleteAll(SBdb SB2, int wellID) throws SQLException, SBException {
        if (wellID == 0) {
            throw new SBException("Attempt to delete null lithology interval from well");
        }
        String sql = "DELETE FROM " + SB2.DBTableName("SBILITH") + " WHERE well_id=" + wellID;
        Statement stmt = SB2.getDatabase().createStatement();
        stmt.executeUpdate(SB2.modQuery(sql));
        stmt.close();
    }

    @Override
    public void updateStatus(List<LithBase> oldData, boolean oldDataStored) {
        Iterator<LithBase> en = oldData.iterator();
        int nzTD = (int)Math.round(this.topDepth * 100.0);
        int nzBD = (int)Math.round(this.baseDepth * 100.0);
        this.status = NOTSTORED;
        while (en.hasNext()) {
            LithBase lithBase = en.next();
            if (lithBase == this || lithBase instanceof LithQualifier) continue;
            LithInterval lithInt = (LithInterval)lithBase;
            int cTD = (int)Math.round(lithInt.topDepth * 100.0);
            int cBD = (int)Math.round(lithInt.baseDepth * 100.0);
            if (cTD == nzTD && cBD == nzBD) {
                if (oldDataStored) {
                    this.status = STORED;
                }
                if (this.getLithCode() == lithInt.getLithCode()) break;
                this.status = CONFLICT;
                break;
            }
            if (nzTD == nzBD) {
                if (nzTD > cTD && nzTD < cBD) {
                    this.status = CONFLICT;
                }
                if (nzTD == cTD && nzTD == cBD) {
                    this.status = CONFLICT;
                }
            } else {
                if (nzTD < cTD && nzBD > cTD) {
                    this.status = CONFLICT;
                }
                if (nzTD < cBD && nzBD > cBD) {
                    this.status = CONFLICT;
                }
                if (nzTD > cTD && nzBD < cBD) {
                    this.status = CONFLICT;
                }
                if (nzTD < cTD && nzBD > cBD) {
                    this.status = CONFLICT;
                }
            }
            if (this.status != CONFLICT) continue;
            break;
        }
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    public boolean isNeighbourAbove(LithInterval i) {
        return Math.abs(i.getTopDepth() - this.baseDepth) < 0.5;
    }

    public boolean isNeighbourBelow(LithInterval i) {
        return Math.abs(i.getBaseDepth() - this.topDepth) < 0.5;
    }

    private LithInterval(Builder builder) {
        super(builder);
        this.baseDepth = builder.baseDepth;
    }

    public static class Builder
    extends LithBase.Builder {
        final double baseDepth;

        public Builder(SBdb sbdb, double topDepth, Lithology desc, double baseDepth) {
            super(sbdb, topDepth, desc);
            if (baseDepth < topDepth) {
                throw new IllegalArgumentException("Attempt to create LithInterval buider when base depth is less than top depth");
            }
            this.baseDepth = baseDepth;
        }

        static Builder copyOf(LithInterval rhs, Lithology newLith) throws SBException {
            return new Builder(rhs.getSbdb(), rhs.topDepth, newLith, rhs.baseDepth);
        }

        @Override
        LithInterval build() {
            return new LithInterval(this);
        }

        double getBaseDepth() {
            return this.baseDepth;
        }
    }
}

