/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import model2_1.LithTrnEntry;
import model2_1.SBdb;
import util.SBException;

public class LithTrnScheme
implements Comparable {
    String descr;
    private int ID;
    Date created;
    String creator;
    private boolean useCodes = true;
    SBdb sbdb;
    private LinkedList<LithTrnEntry> entries;

    public LithTrnScheme(SBdb sbdb, int ID, String descr, boolean usecodes) {
        this.sbdb = sbdb;
        this.ID = ID;
        this.descr = descr;
        this.useCodes = usecodes;
    }

    public LithTrnScheme(SBdb sbdb, LinkedList<LithTrnEntry> entries) {
        this.sbdb = sbdb;
        this.entries = entries;
        this.ID = 0;
    }

    public String toString() {
        return this.descr;
    }

    public void loadEntries() throws SQLException {
        if (this.entries != null) {
            return;
        }
        this.entries = new LinkedList();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT lith_id, descr, impcode, sch_id FROM " + this.sbdb.DBTableName("SBLTHTRN") + " WHERE sch_id=" + this.getID();
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        while (rs.next()) {
            int lithID = rs.getInt("lith_id");
            String description = rs.getString("descr");
            int impcode = rs.getInt("impcode");
            this.entries.add(new LithTrnEntry(impcode, description, lithID));
        }
        stmt.close();
    }

    public static LinkedList<LithTrnScheme> loadSchemes(SBdb sbdb) throws SBException, SQLException {
        if (sbdb == null || !sbdb.isConnected()) {
            throw new SBException("Attempt to load translation schemes with empty/unconnected datamodel");
        }
        LinkedList<LithTrnScheme> schemes = new LinkedList<LithTrnScheme>();
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT sch_id, descr, usecodes FROM " + sbdb.DBTableName("LTHTRNSCH") + " ORDER BY descr";
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            int id = rs.getInt("sch_id");
            String descrip = rs.getString("descr");
            String codess = rs.getString("usecodes");
            boolean codes = false;
            if (codess.length() > 0 && codess.charAt(0) == 'Y') {
                codes = true;
            }
            LithTrnScheme scheme = new LithTrnScheme(sbdb, id, descrip, codes);
            schemes.add(scheme);
        }
        stmt.close();
        return schemes;
    }

    public void store() throws SQLException, SBException {
        String sql;
        Statement stmt = this.sbdb.getDatabase().createStatement();
        if (this.getID() == 0) {
            this.ID = this.sbdb.nextControl("LTHTRNSCH", "SCH_ID");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            if (this.created == null) {
                this.created = new Date();
            }
            sql = "INSERT INTO " + this.sbdb.DBTableName("LTHTRNSCH") + " (sch_id,descr,created,creator,usecodes) VALUES (" + this.getID() + ",'" + this.descr + "','" + df.format(this.created) + "','" + this.creator + "','" + (this.isUseCodes() ? (char)'Y' : 'N') + "')";
        } else {
            sql = "UPDATE " + this.sbdb.DBTableName("LTHTRNSCH") + " SET descr='" + this.descr + "',usecodes='" + (this.isUseCodes() ? (char)'Y' : 'N') + "' WHERE sch_id=" + this.getID();
        }
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        stmt.close();
    }

    public void storeAll() throws SBException, SQLException {
        this.store();
        if (this.getID() == 0) {
            throw new SBException("Attempt to store LthTrnScheme with ID 0");
        }
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + this.sbdb.DBTableName("SBLTHTRN") + " WHERE sch_id=" + this.getID();
        stmt.executeUpdate(this.sbdb.modQuery(sql));
        for (LithTrnEntry entry : this.entries) {
            entry.store(this.sbdb, stmt, this.getID());
        }
        stmt.close();
    }

    public static void delete(SBdb sbdb, int schID) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "DELETE FROM " + sbdb.DBTableName("SBLTHTRN") + " WHERE sch_id=" + schID;
        stmt.executeUpdate(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("LTHTRNSCH") + " WHERE sch_id=" + schID;
        stmt.executeUpdate(sbdb.modQuery(sql));
        stmt.close();
    }

    public boolean containsEntry(int code) {
        if (code <= 0) {
            return false;
        }
        for (LithTrnEntry entry : this.entries) {
            if (entry.getCode() != code) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(String descr) {
        if (descr.isEmpty()) {
            return false;
        }
        for (LithTrnEntry entry : this.entries) {
            if (!entry.getDescr().equals(descr)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseCodes() {
        return this.useCodes;
    }

    public LinkedList<LithTrnEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(LinkedList<LithTrnEntry> entries) {
        this.entries = entries;
    }

    public boolean addEntry(LithTrnEntry entry, boolean checkDuplicate) {
        if (checkDuplicate) {
            if (this.containsEntry(entry.getDescr())) {
                return false;
            }
            if (this.containsEntry(entry.getCode())) {
                return false;
            }
        }
        this.entries.add(entry);
        return true;
    }

    public void setName(String name) {
        this.descr = name;
    }

    public void setUseCodes(boolean useCodes) {
        this.useCodes = useCodes;
    }

    public String getName() {
        return this.descr;
    }

    public int getID() {
        return this.ID;
    }

    public int compareTo(Object o) {
        LithTrnScheme rhs = (LithTrnScheme)o;
        return this.descr.compareToIgnoreCase(rhs.getName());
    }
}

