/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import model2_1.Audit;
import model2_1.IGDIntervalZone;
import model2_1.IGDUnitBase;
import model2_1.Lithology;
import model2_1.LithostratUnitClass;
import model2_1.SBdb;
import org.jdom2.Element;
import util.SB;
import util.SBException;
import util.SortEntry;
import util.exception.StackError;
import util.status.MergeStatus;
import util.status.SbugsStatus;

public class LithostratUnit
extends IGDUnitBase
implements LithostratUnitClass {
    public static final int UW = 0;
    public static final int UE = 1;
    public static final int LE = 2;
    public static final int LW = 3;
    private final double[] age = new double[4];
    private final float[] x = new float[4];
    private String abr;
    private Color colour;
    private Lithology lithology;
    private IGDIntervalZone.Boundary upperBnd;
    private IGDIntervalZone.Boundary lowerBnd;
    private Area area;
    private Line2D upperBndLine;
    private Line2D lowerBndLine;

    @Override
    public String getAbr() {
        return this.abr;
    }

    @Override
    public Lithology getLithology() {
        return this.lithology;
    }

    @Override
    public IGDIntervalZone.Boundary getUBnd() {
        return this.upperBnd;
    }

    @Override
    public IGDIntervalZone.Boundary getLBnd() {
        return this.lowerBnd;
    }

    @Override
    public double getAge(int i) {
        return this.age[i];
    }

    @Override
    public float getX(int i) {
        return this.x[i];
    }

    public double[] getAges() {
        return Arrays.copyOf(this.age, 4);
    }

    public float[] getXs() {
        return Arrays.copyOf(this.x, 4);
    }

    @Override
    public Area getArea() {
        if (this.area == null) {
            this.area = LithostratUnit.getArea(this.age, this.x);
        }
        return this.area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void delete(Statement stmt) throws SQLException {
        int updated;
        Statement statement = stmt == null ? this.sbdb.getDatabase().createStatement() : stmt;
        try {
            String sql = "UPDATE " + this.sbdb.DBTableName("IGD_LSTRAT") + " SET upp_zone=NULL WHERE upp_zone=" + this.getUnitID() + " AND sch_id=" + this.getSchID();
            updated = statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "UPDATE " + this.sbdb.DBTableName("IGD_LSTRAT") + " SET low_zone=NULL WHERE low_zone=" + this.getUnitID() + " AND sch_id=" + this.getSchID();
            updated += statement.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("IGD_DICT_LSTRAT") + " WHERE unit_id=" + this.getUnitID();
            statement.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (stmt == null) {
                statement.close();
            }
        }
        if (updated > 0) {
            System.out.println("WARNING: IGD table updated during delete unit '" + this.getName() + "'");
        }
        this.status = NOTSTORED;
    }

    static void loadAll(SBdb sbdb, int schID, List<IGDUnitBase> list) throws SQLException {
        block16: {
            String sql = "SELECT unit_id,hier,name,abr,uw_age,ue_age,lw_age,le_age,uw_x,ue_x,lw_x,le_x,red,green,blue,lith_id,u_bnd_int,l_bnd_int," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_DICT_LSTRAT") + " WHERE sch_id=" + schID + " ORDER BY hier,name";
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                block12: while (true) {
                    while (rs.next()) {
                        Builder b = new Builder(sbdb);
                        int igdID = rs.getInt("unit_id");
                        b.hier(rs.getInt("hier")).name(rs.getString("name"));
                        b.abr(rs.getString("abr"));
                        b.age(0, rs.getDouble("uw_age")).age(1, rs.getDouble("ue_age")).age(3, rs.getDouble("lw_age")).age(2, rs.getDouble("le_age"));
                        b.x(0, rs.getFloat("uw_x")).x(1, rs.getFloat("ue_x")).x(3, rs.getFloat("lw_x")).x(2, rs.getFloat("le_x"));
                        b.colour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
                        b.lithology(sbdb.getLithdesc().getLithology(rs.getInt("lith_id")));
                        b.bnd(true, rs.getInt("u_bnd_int")).bnd(false, rs.getInt("l_bnd_int"));
                        b.audit(new Audit(rs)).status(STORED);
                        try {
                            LithostratUnit unit = new LithostratUnit(b, igdID, schID);
                            LithostratUnit.insert(unit, list);
                            continue block12;
                        }
                        catch (RuntimeException re) {
                            StackError.showStackError((String)"", (Exception)re);
                        }
                    }
                    break block16;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void storeDB(int igdType, Statement statement) throws SQLException {
        Statement stmt = statement == null ? this.sbdb.getDatabase().createStatement() : statement;
        String sql = "INSERT INTO " + this.sbdb.DBTableName("IGD_DICT_LSTRAT") + " (unit_id,sch_id,hier,name,abr,uw_age,ue_age,lw_age,le_age,uw_x,ue_x,lw_x,le_x,red,green,blue,lith_id,u_bnd_int,l_bnd_int," + Audit.sqlFieldString() + ") VALUES (" + this.getUnitID() + "," + this.getSchID() + "," + this.getHier() + "," + SB.DBString((String)this.getName()) + "," + SB.DBString((String)this.abr) + "," + this.age[0] + "," + this.age[1] + "," + this.age[3] + "," + this.age[2] + "," + this.x[0] + "," + this.x[1] + "," + this.x[3] + "," + this.x[2] + "," + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + "," + (Serializable)(this.lithology != null ? Integer.valueOf(this.lithology.getLithID()) : "NULL") + "," + this.upperBnd.getBndInt() + "," + this.lowerBnd.getBndInt() + "," + this.getAudit().sqlInsert(this.sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
        finally {
            if (statement == null) {
                stmt.close();
            }
        }
        this.status = STORED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(Builder builder) throws SQLException, SBException {
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "UPDATE " + this.sbdb.DBTableName("IGD_DICT_LSTRAT") + " set name=" + SB.DBString((String)builder.getName()) + ",abr=" + SB.DBString((String)builder.abr) + ",hier=" + builder.getHier() + ",uw_age=" + builder.age[0] + ",ue_age=" + builder.age[1] + ",lw_age=" + builder.age[3] + ",le_age=" + builder.age[2] + ",uw_x=" + builder.x[0] + ",ue_x=" + builder.x[1] + ",lw_x=" + builder.x[3] + ",le_x=" + builder.x[2] + ",u_bnd_int=" + builder.upperBnd.getBndInt() + ",l_bnd_int=" + builder.lowerBnd.getBndInt() + ",lith_id=" + (Serializable)(builder.lithology != null ? Integer.valueOf(builder.lithology.getLithID()) : "NULL") + ",red=" + builder.colour.getRed() + ",green=" + builder.colour.getGreen() + ",blue=" + builder.colour.getBlue() + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE unit_id=" + this.getUnitID();
        String sqlLinkRefreshUpp = null;
        String sqlLinkRefreshLow = null;
        if (!this.getName().equals(builder.getName())) {
            sqlLinkRefreshUpp = "UPDATE " + this.sbdb.DBTableName("igd") + " set upp_inf=" + SB.DBString((String)builder.getName()) + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND upp_zone=" + this.getUnitID() + " AND upp_inf=" + SB.DBString((String)this.getName());
            sqlLinkRefreshLow = "UPDATE " + this.sbdb.DBTableName("igd") + " set low_inf=" + SB.DBString((String)builder.getName()) + "," + this.getAudit().sqlUpdate(this.sbdb, stmt, false) + " WHERE sch_id=" + this.getSchID() + " AND low_zone=" + this.getUnitID() + " AND low_inf=" + SB.DBString((String)this.getName());
        }
        try {
            int i = stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (i != 1) {
                throw new SBException("Could not update unit: " + this);
            }
            if (sqlLinkRefreshUpp != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshUpp));
            }
            if (sqlLinkRefreshLow != null) {
                stmt.executeUpdate(this.sbdb.modQuery(sqlLinkRefreshLow));
            }
        }
        finally {
            stmt.close();
        }
        this.setHier(builder.getHier());
        this.setName(builder.getName());
        this.abr = builder.abr;
        System.arraycopy(builder.age, 0, this.age, 0, 4);
        System.arraycopy(builder.x, 0, this.x, 0, 4);
        this.lithology = builder.lithology;
        this.upperBnd = builder.upperBnd;
        this.lowerBnd = builder.lowerBnd;
        this.colour = builder.colour;
        this.area = null;
        this.status = STORED;
    }

    @Override
    public Color getColour() {
        return this.colour;
    }

    @Override
    public LithostratUnit getLink() {
        return (LithostratUnit)this.link;
    }

    @Override
    public void copyLink() {
        if (this.link == null || this.status != CONFLICT) {
            return;
        }
        this.setName(this.link.getName());
        this.abr = this.getLink().getAbr();
        System.arraycopy(this.getLink().age, 0, this.age, 0, 4);
        System.arraycopy(this.getLink().x, 0, this.x, 0, 4);
        this.status = STORED;
    }

    @Override
    void updateStatusLink(List<IGDUnitBase> schemeUnits) {
        if (this.link != null) {
            this.status = STORED;
            if (!this.getName().toUpperCase().equals(this.link.getName().toUpperCase())) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                return;
            }
            if (!(this.abr == null || this.abr.isEmpty() || this.getLink().getAbr() == null || this.getLink().getAbr().isEmpty() || this.abr.equals(this.getLink().getAbr()))) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                return;
            }
            if (this.abr != null && this.abr.isEmpty() && this.getLink().getAbr() != null && !this.getLink().getAbr().isEmpty()) {
                this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            }
            if (this.lithology != this.getLink().getLithology() && this.lithology != null) {
                if (((LithostratUnit)this.link).getLithology() != null) {
                    this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                    return;
                }
                this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            }
            if (this.upperBnd != this.getLink().upperBnd || this.lowerBnd != this.getLink().lowerBnd) {
                this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
            }
            for (int i = 0; i < 4; ++i) {
                if (Math.abs(this.getAge(i) - this.getLink().getAge(i)) > 0.001) {
                    if (this.getAge(i) > 0.001) {
                        this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                        return;
                    }
                    this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
                }
                if (!((double)Math.abs(this.getX(i) - this.getLink().getX(i)) > 0.001)) continue;
                if ((i == 0 || i == 3) && (double)this.getX(i) > 0.001 || (i == 1 || i == 2) && this.getX(i) < 100.0f) {
                    this.status = MergeStatus.merge((Color)this.status, (Color)CONFLICT);
                    return;
                }
                this.status = MergeStatus.merge((Color)this.status, (Color)PARTSTORED);
            }
        } else {
            this.status = NOTSTORED;
        }
    }

    @Override
    void updateStatusLinkSubclass(List<IGDUnitBase> schemeUnits) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFuncEquivalent(SortEntry e) {
        if (this.getSortEntry().compareTo(e.getSortEntry()) == 0) {
            return ((LithostratUnit)e).getArea().equals(this.getArea());
        }
        return false;
    }

    @Override
    public double getUage() {
        return Math.min(this.age[0], this.age[1]);
    }

    @Override
    public double getLage() {
        return Math.max(this.age[3], this.age[2]);
    }

    private static Area getArea(double[] age, float[] x) {
        int[] ageInts = new int[4];
        int[] xInts = new int[4];
        for (int i = 0; i < 4; ++i) {
            ageInts[i] = (int)(age[i] * 1000000.0);
            xInts[i] = (int)(x[i] * 100000.0f);
        }
        return new Area(new Polygon(xInts, ageInts, 4));
    }

    private static Line2D getLine(boolean upper, double[] age, float[] x) {
        if (upper) {
            return new Line2D.Double(x[0], age[0], x[1], age[1]);
        }
        return new Line2D.Double(x[3], age[3], x[2], age[2]);
    }

    @Override
    public Line2D getLine(boolean upper) {
        if (upper) {
            if (this.upperBndLine == null) {
                this.upperBndLine = LithostratUnit.getLine(true, this.age, this.x);
            }
            return this.upperBndLine;
        }
        if (this.lowerBndLine == null) {
            this.lowerBndLine = LithostratUnit.getLine(false, this.age, this.x);
        }
        return this.lowerBndLine;
    }

    static boolean hasAges(LithostratUnitClass unit) {
        for (int i = 0; i < 4; ++i) {
            if (!(unit.getAge(i) > 0.0)) continue;
            return true;
        }
        return false;
    }

    static LithostratUnit refresh(SBdb sbdb, int schID, List<IGDUnitBase> units, Statement stmt) throws SQLException, SBException {
        String sql = "SELECT unit_id,updated FROM " + sbdb.DBTableName("IGD_DICT_LSTRAT") + " WHERE sch_id=" + schID;
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        LithostratUnit notifier = null;
        HashSet<Integer> keys = new HashSet<Integer>();
        while (rs.next()) {
            int key = rs.getInt("unit_id");
            keys.add(key);
            Timestamp time = rs.getTimestamp("updated");
            boolean found = false;
            for (IGDUnitBase base : units) {
                if (!(base instanceof LithostratUnit)) {
                    assert (false);
                    continue;
                }
                LithostratUnit o = (LithostratUnit)base;
                if (o.getUnitID() != key) continue;
                found = true;
                if (time == null || o.getUpdated() != null && !time.after(o.getUpdated())) break;
                LithostratUnit.load(sbdb, key, o);
                notifier = o;
                break;
            }
            if (found) continue;
            notifier = LithostratUnit.load(sbdb, key, null);
            LithostratUnit.insert(notifier, units);
        }
        if (keys.size() < units.size()) {
            Iterator<IGDUnitBase> it = units.iterator();
            while (it.hasNext()) {
                IGDUnitBase base = it.next();
                if (!(base instanceof LithostratUnit)) {
                    assert (false);
                    continue;
                }
                LithostratUnit o = (LithostratUnit)base;
                if (keys.contains(o.getUnitID())) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = o;
            }
        }
        return notifier;
    }

    private static LithostratUnit loadLithostratUnit(SBdb sbdb, int unitID) throws SQLException, SBException {
        String sql = "SELECT sch_id,hier,name,abr,uw_age,ue_age,lw_age,le_age,uw_x,ue_x,lw_x,le_x,red,green,blue,lith_id,u_bnd_int,l_bnd_int," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("IGD_DICT_LSTRAT") + " WHERE unit_id=" + unitID;
        try (Statement stmt = sbdb.getDatabase().createStatement();
             ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));){
            if (rs.next()) {
                Builder b = new Builder(sbdb);
                int schID = rs.getInt("sch_id");
                b.hier(rs.getInt("hier")).name(rs.getString("name"));
                b.abr(rs.getString("abr"));
                b.age(0, rs.getDouble("uw_age")).age(1, rs.getDouble("ue_age")).age(3, rs.getDouble("lw_age")).age(2, rs.getDouble("le_age"));
                b.x(0, rs.getFloat("uw_x")).x(1, rs.getFloat("ue_x")).x(3, rs.getFloat("lw_x")).x(2, rs.getFloat("le_x"));
                b.colour(new Color(rs.getInt("red"), rs.getInt("green"), rs.getInt("blue")));
                b.lithology(sbdb.getLithdesc().getLithology(rs.getInt("lith_id")));
                b.bnd(true, rs.getInt("u_bnd_int")).bnd(false, rs.getInt("l_bnd_int"));
                b.audit(new Audit(rs)).status(STORED);
                LithostratUnit unit = new LithostratUnit(b, unitID, schID);
                unit.status = STORED;
                LithostratUnit lithostratUnit = unit;
                return lithostratUnit;
            }
            throw new SBException("No unit found with ID: " + unitID);
        }
    }

    private static LithostratUnit load(SBdb sbdb, int unitID, LithostratUnit unit) throws SQLException, SBException {
        if (unit != null && unit.getUnitID() != unitID) {
            throw new IllegalArgumentException("Attempt to refresh unit with incorrect ID");
        }
        LithostratUnit temp = LithostratUnit.loadLithostratUnit(sbdb, unitID);
        if (unit != null) {
            unit.setHier(temp.getHier());
            unit.setName(temp.getName());
            unit.abr = temp.abr;
            System.arraycopy(temp.age, 0, unit.age, 0, 4);
            System.arraycopy(temp.x, 0, unit.x, 0, 4);
            unit.upperBnd = temp.upperBnd;
            unit.lowerBnd = temp.lowerBnd;
            unit.lithology = temp.lithology;
            unit.setAudit(temp.getAudit());
            unit.status = STORED;
            unit.colour = temp.colour;
        } else {
            unit = temp;
        }
        return unit;
    }

    private LithostratUnit(Builder builder, int ID, int schID) {
        super(builder, schID, ID);
        this.x[1] = 1.0f;
        this.x[2] = 1.0f;
        this.upperBnd = IGDIntervalZone.Boundary.CONF;
        this.lowerBnd = IGDIntervalZone.Boundary.CONF;
        System.arraycopy(builder.age, 0, this.age, 0, 4);
        System.arraycopy(builder.x, 0, this.x, 0, 4);
        this.colour = builder.colour;
        this.abr = builder.abr;
        this.lithology = builder.lithology;
        this.upperBnd = builder.upperBnd;
        this.lowerBnd = builder.lowerBnd;
    }

    @Override
    void writeDEX(FileWriter out, String eol, int igdType) throws IOException {
        out.write("Unit = " + this.getName() + eol);
        if (this.getAbr() != null) {
            out.write("  Abbreviation : " + this.getAbr() + eol);
        }
        out.write("  Type = " + IGDIntervalZone.getDefaultHierName(igdType, this.getHier(), true) + eol);
        out.write("  Youngest : " + this.getUage() + eol);
        out.write("  Oldest : " + this.getLage() + eol);
        out.write("  Dictionary ID : " + this.getUnitID() + eol);
        if (this.colour != Color.WHITE) {
            out.write("  Colour : " + this.colour.getRed() + "," + this.colour.getGreen() + "," + this.colour.getBlue() + eol);
        }
    }

    @Override
    void writeXML(BufferedWriter out, int indent, int igdType, List<IGDUnitBase> units) throws IOException {
        String ind1 = SB.getXMLIndent((int)indent);
        out.write(ind1 + "<LithostratUnit>\n");
        String ind = SB.getXMLIndent((int)(indent + 3));
        out.write(ind + "<UnitName>" + SB.getXMLstring((String)this.getName()) + "</UnitName>\n");
        if (this.getAbr() != null) {
            out.write(ind + "<Abbreviation>" + SB.getXMLstring((String)this.getAbr()) + "</Abbreviation>\n");
        }
        out.write(ind + "<Type>" + IGDIntervalZone.getDefaultHierName(igdType, this.getHier(), true) + "</Type>\n");
        out.write(ind + "<YoungestWest>" + this.age[0] + "</YoungestWest>\n");
        out.write(ind + "<YoungestWestX>" + this.x[0] + "</YoungestWestX>\n");
        out.write(ind + "<OldestWest>" + this.age[3] + "</OldestWest>\n");
        out.write(ind + "<OldestWestX>" + this.x[3] + "</OldestWestX>\n");
        out.write(ind + "<YoungestEast>" + this.age[1] + "</YoungestEast>\n");
        out.write(ind + "<YoungestEastX>" + this.x[1] + "</YoungestEastX>\n");
        out.write(ind + "<OldestEast>" + this.age[2] + "</OldestEast>\n");
        out.write(ind + "<OldestEastX>" + this.x[2] + "</OldestEastX>\n");
        out.write(ind + "<DictionaryID>" + this.getUnitID() + "</DictionaryID>\n");
        out.write(ind + "<YoungestBoundary>" + this.upperBnd.name() + "</YoungestBoundary>\n");
        out.write(ind + "<OldestBoundary>" + this.lowerBnd.name() + "</OldestBoundary>\n");
        if (this.lithology != null) {
            out.write(ind + "<Lithology>" + this.lithology.getLithID() + "</Lithology>\n");
        }
        if (this.colour != Color.WHITE) {
            SB.writeXMLColour((Color)this.colour, (BufferedWriter)out, (String)ind);
        }
        this.getAudit().writeXML(out, indent);
        out.write(ind1 + "</LithostratUnit>\n");
    }

    LithostratUnit(SBdb ws, int schID, Element xml) throws ParseException, SQLException, SBException {
        super(ws, schID, Integer.parseInt(xml.getChildTextNormalize("DictionaryID")));
        Element el;
        IGDIntervalZone.Boundary bnd;
        this.x[1] = 1.0f;
        this.x[2] = 1.0f;
        this.upperBnd = IGDIntervalZone.Boundary.CONF;
        this.lowerBnd = IGDIntervalZone.Boundary.CONF;
        String strg = xml.getChildTextNormalize("UnitName");
        if (strg != null) {
            this.setName(strg);
        }
        if ((strg = xml.getChildTextNormalize("Abbreviation")) != null) {
            this.abr = strg;
        }
        if ((strg = xml.getChildTextNormalize("Type")) != null) {
            this.setHier(IGDIntervalZone.getHierNumber(2, strg, true));
        }
        if ((strg = xml.getChildTextNormalize("YoungestWest")) != null) {
            this.age[0] = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("YoungestEast")) != null) {
            this.age[1] = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("OldestEast")) != null) {
            this.age[2] = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("OldestWest")) != null) {
            this.age[3] = Double.parseDouble(strg);
        }
        if ((strg = xml.getChildTextNormalize("YoungestWestX")) != null) {
            this.x[0] = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("YoungestEastX")) != null) {
            this.x[1] = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("OldestEastX")) != null) {
            this.x[2] = Float.parseFloat(strg);
        }
        if ((strg = xml.getChildTextNormalize("OldestWestX")) != null) {
            this.x[3] = Float.parseFloat(strg);
        }
        boolean parsedLegacyAge = false;
        strg = xml.getChildTextNormalize("Youngest");
        if (strg != null) {
            double youngest = Double.parseDouble(strg);
            if (strg.contains(".") && strg.substring(strg.indexOf("."), strg.length()).length() > 6) {
                youngest = SB.round((double)youngest, (int)2);
            }
            this.age[0] = youngest;
            this.age[1] = youngest;
            parsedLegacyAge = true;
        }
        if ((strg = xml.getChildTextNormalize("Oldest")) != null) {
            double oldest = Double.parseDouble(strg);
            if (strg.contains(".") && strg.substring(strg.indexOf("."), strg.length()).length() > 6) {
                oldest = SB.round((double)oldest, (int)2);
            }
            this.age[3] = oldest;
            this.age[2] = oldest;
            parsedLegacyAge = true;
        }
        if (parsedLegacyAge && Math.abs(this.age[0] - this.age[3]) <= 0.0) {
            this.age[0] = 0.0;
            this.age[1] = 0.0;
            this.age[3] = 0.0;
            this.age[2] = 0.0;
        }
        if ((strg = xml.getChildTextNormalize("YoungestBoundary")) != null && (bnd = IGDIntervalZone.Boundary.valueOf(strg)) != null) {
            this.upperBnd = bnd;
        }
        if ((strg = xml.getChildTextNormalize("OldestBoundary")) != null && (bnd = IGDIntervalZone.Boundary.valueOf(strg)) != null) {
            this.lowerBnd = bnd;
        }
        if ((strg = xml.getChildTextNormalize("Lithology")) != null) {
            this.lithology = ws.getLithdesc().getLithology(Integer.parseInt(strg));
        }
        if ((el = xml.getChild("Audit")) != null) {
            this.setAudit(new Audit(ws, el));
        } else {
            System.out.println("Warning: no audit info for IGDUnit: " + this);
        }
        el = xml.getChild("Colour");
        if (el != null) {
            this.colour = SB.parseColour((Element)el);
        }
        this.status = NOTSTORED;
    }

    public static class Builder
    extends IGDUnitBase.Builder
    implements LithostratUnitClass {
        private final double[] age = new double[4];
        private final float[] x = new float[]{0.0f, 1.0f, 1.0f, 0.0f};
        private String abr = "";
        private Color colour = Color.WHITE;
        private Lithology lithology;
        private IGDIntervalZone.Boundary upperBnd = IGDIntervalZone.Boundary.CONF;
        private IGDIntervalZone.Boundary lowerBnd = IGDIntervalZone.Boundary.CONF;
        private LithostratUnit original;
        private Area area;
        private Line2D upperBndLine;
        private Line2D lowerBndLine;

        public Builder(SBdb sbdb) {
            super(sbdb);
        }

        public Builder(SBdb sbdb, LithostratUnit unit) {
            super(sbdb);
            this.original = unit.sbdb == sbdb ? unit : null;
        }

        public Builder abr(String abr) {
            if (abr != null) {
                if (abr.length() > 80) {
                    abr = abr.substring(0, 80);
                }
                this.abr = abr.trim().replaceAll("\\s+", " ");
            } else {
                this.abr = "";
            }
            return this;
        }

        public Builder colour(Color colour) {
            if (colour != null && !colour.equals(Color.BLACK)) {
                this.colour = colour;
            }
            return this;
        }

        public Builder lithology(Lithology lithology) {
            this.lithology = lithology;
            return this;
        }

        public Builder age(int i, double age) {
            if (age >= 0.0) {
                this.age[i] = age;
            }
            this.area = null;
            return this;
        }

        public Builder age(double[] age) {
            System.arraycopy(age, 0, this.age, 0, 4);
            this.area = null;
            return this;
        }

        public Builder x(float[] x) {
            System.arraycopy(x, 0, this.x, 0, 4);
            this.area = null;
            return this;
        }

        public Builder x(int i, float x) {
            if (x >= 0.0f && x <= 1.0f) {
                this.x[i] = x;
            }
            this.area = null;
            return this;
        }

        public Builder bnd(boolean upper, int bnd) {
            IGDIntervalZone.Boundary boundary = IGDIntervalZone.Boundary.getBnd(bnd);
            return this.bnd(upper, boundary);
        }

        public Builder bnd(boolean upper, IGDIntervalZone.Boundary boundary) {
            if (boundary != null) {
                if (upper) {
                    this.upperBnd = boundary;
                } else {
                    this.lowerBnd = boundary;
                }
            }
            return this;
        }

        @Override
        void validateFields() {
            super.validateFields();
            if (this.age[1] > this.age[2] || this.age[0] > this.age[3]) {
                throw new IllegalStateException("Attempt to build lithostrat unit '" + this.getName() + "' with upper age greater than lower age");
            }
            if (this.x[0] > this.x[1] || this.x[3] > this.x[2]) {
                throw new IllegalStateException("Attempt to build lithostrat unit '" + this.getName() + "' with east less than west");
            }
        }

        @Override
        IGDUnitBase buildThis(int ID, int schID) {
            return new LithostratUnit(this, ID, schID);
        }

        @Override
        IGDUnitBase store(int igdType, int schID) throws SQLException, SBException {
            LithostratUnit unit;
            if (!this.sbdb.isConnected()) {
                throw new IllegalStateException("Attempt to store IGDUnit in workspace");
            }
            this.validateFields();
            if (this.original != null) {
                if (!(this.getName().equals(this.original.getName()) && this.abr.equals(this.original.abr) && Arrays.equals(this.age, this.original.age) && Arrays.equals(this.x, this.original.x) && this.colour.equals(this.original.colour) && this.lithology == this.original.lithology && this.upperBnd == this.original.getUBnd() && this.lowerBnd == this.original.lowerBnd && this.getHier() == this.original.getHier())) {
                    this.original.update(this);
                }
                unit = this.original;
            } else {
                this.status = SbugsStatus.NOTSTORED;
                int ID = this.sbdb.nextControl("IGD_DICT_LSTRAT", "UNIT_ID");
                unit = (LithostratUnit)this.build(ID, schID);
                unit.storeDB(igdType, null);
            }
            return unit;
        }

        public LithostratUnit getOriginal() {
            return this.original;
        }

        @Override
        public int getOriginalID() {
            return this.original != null ? this.original.getUnitID() : 0;
        }

        @Override
        public Area getArea() {
            if (this.area == null) {
                this.area = LithostratUnit.getArea(this.age, this.x);
            }
            return this.area;
        }

        @Override
        public Line2D getLine(boolean upper) {
            if (upper) {
                if (this.upperBndLine == null) {
                    this.upperBndLine = LithostratUnit.getLine(true, this.age, this.x);
                }
                return this.upperBndLine;
            }
            if (this.lowerBndLine == null) {
                this.lowerBndLine = LithostratUnit.getLine(false, this.age, this.x);
            }
            return this.lowerBndLine;
        }

        void clearOriginal() {
            this.original = null;
        }

        @Override
        public Color getColour() {
            return this.colour;
        }

        @Override
        public double getUage() {
            return Math.min(this.age[0], this.age[1]);
        }

        @Override
        public double getLage() {
            return Math.max(this.age[3], this.age[2]);
        }

        @Override
        public String getAbr() {
            return this.abr;
        }

        @Override
        public double getAge(int i) {
            return this.age[i];
        }

        public int getXint(int i) {
            return Math.round(this.x[i] * 100.0f);
        }

        @Override
        public float getX(int i) {
            return this.x[i];
        }

        @Override
        public Lithology getLithology() {
            return this.lithology;
        }

        public IGDIntervalZone.Boundary getBnd(boolean upper) {
            return upper ? this.upperBnd : this.lowerBnd;
        }

        @Override
        public IGDIntervalZone.Boundary getUBnd() {
            return this.upperBnd;
        }

        @Override
        public IGDIntervalZone.Boundary getLBnd() {
            return this.lowerBnd;
        }
    }
}

