/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import model2_1.AbnScheme;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.Biocom;
import model2_1.IGDIntervalZone;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Well;
import model2_1.WsWell;
import model2_1.api.Discipline;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;

public class RGReader {
    Set dataTypes;
    SBdb ws;
    int specID = 1;
    AbnScheme abnScheme = null;
    String[] re = new String[]{"@", "\\^", "\\*", "# #", "#", "\\\\", "\\$F0", "\\$F1", "\\$F2", "\\$F3", "\\$F4", "\\$F5", "\\$F6"};
    String[] subs = new String[]{"RARE", "OCCASIONAL", "COMMON", "SUPER ABUNDANT", "ABUNDANT", "\r", "", "", "", "", "", "", ""};
    Date date;
    SimpleDateFormat rgDf1 = new SimpleDateFormat("yyMMdd");
    SimpleDateFormat rgDf2 = new SimpleDateFormat("yyyyMMdd");
    boolean[] hasAbnEntries = new boolean[]{false, false, false, false};
    boolean hasPseudoQuantData = false;
    boolean attemptedIntervalData = false;
    final boolean DEBUG = false;

    public RGReader(String fileName, Set dataTypes, SBdb ws) {
        this.dataTypes = dataTypes;
        this.ws = ws;
        boolean useSampleTops = ws.useSampleTops();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            WsWell well = null;
            char sepChar = '~';
            String dataType = "";
            String analystAbr = "RRI";
            try {
                String buff;
                this.setupAbnScheme(ws.getAbnSchemes());
                while ((buff = in.readLine()) != null) {
                    Biocom biocom2;
                    if ((buff = buff.trim()).length() <= 0 || buff.charAt(0) == '*') continue;
                    int index = buff.indexOf(61);
                    if (index > 0 && buff.indexOf(sepChar) < 0) {
                        if (buff.startsWith("FS")) {
                            sepChar = buff.charAt(index + 1);
                            continue;
                        }
                        if (buff.startsWith("WELLNAME")) {
                            well = ws.addWellToWorkspace(0, fileName);
                            well.getHeader().setWellName(buff.substring(index + 1));
                            well.loadInterps();
                            well.getAddInterp(ws.getInterp(0)).load(well);
                            continue;
                        }
                        if (buff.startsWith("WELLNO")) {
                            this.checkNullWell(well);
                            well.getHeader().setWellCode(buff.substring(index + 1));
                            continue;
                        }
                        if (buff.startsWith("UNITS")) {
                            this.checkNullWell(well);
                            well.getHeader().setWellUnits(buff.substring(index + 1).charAt(0));
                            continue;
                        }
                        if (buff.startsWith("TD")) {
                            this.checkNullWell(well);
                            well.getHeader().setTD(DepthUtils.convToM((double)Double.parseDouble(buff.substring(index + 1)), (char)well.getWellUnits()));
                            continue;
                        }
                        if (buff.startsWith("DATUM=")) {
                            this.checkNullWell(well);
                            well.getHeader().setRTE(DepthUtils.convToM((double)Double.parseDouble(buff.substring(index + 1)), (char)well.getWellUnits()));
                            continue;
                        }
                        if (buff.startsWith("DATUMTYPE=")) {
                            this.checkNullWell(well);
                            String datum = buff.substring(index + 1);
                            if (datum.equals("KB") || datum.equals("RTE")) {
                                well.getHeader().setDatum(1);
                                continue;
                            }
                            if (datum.equals("SL")) {
                                well.getHeader().setDatum(2);
                                continue;
                            }
                            if (!datum.equals("SB")) continue;
                            well.getHeader().setDatum(3);
                            continue;
                        }
                        if (buff.startsWith("AUTHOR")) {
                            analystAbr = buff.substring(index + 1);
                            continue;
                        }
                        if (buff.startsWith("CREATE")) {
                            try {
                                String dateString = buff.substring(index + 1, buff.lastIndexOf(46));
                                if (dateString.length() > 6) {
                                    this.date = this.rgDf2.parse(dateString);
                                    continue;
                                }
                                this.date = this.rgDf1.parse(dateString);
                            }
                            catch (Exception eio) {
                                System.out.println("Can't parse date format: " + buff);
                            }
                            continue;
                        }
                        if (!buff.startsWith("$DATATYPE")) continue;
                        this.checkNullWell(well);
                        dataType = buff.substring(index + 1);
                        continue;
                    }
                    if (dataType.equals("HEADER")) {
                        this.parseHeader(buff, sepChar, well);
                        continue;
                    }
                    if (dataType.startsWith("PALY")) {
                        this.parseOccs(buff, sepChar, well, 'P', analystAbr, useSampleTops);
                        this.addDataType(6);
                        continue;
                    }
                    if (dataType.startsWith("MPAL")) {
                        this.parseOccs(buff, sepChar, well, 'M', analystAbr, useSampleTops);
                        this.addDataType(2);
                        continue;
                    }
                    if (dataType.startsWith("NPAL") || dataType.equals("NANN")) {
                        this.parseOccs(buff, sepChar, well, 'N', analystAbr, useSampleTops);
                        this.addDataType(4);
                        continue;
                    }
                    if (dataType.equals("AGES") || dataType.equals("SYS") || dataType.equals("STA")) {
                        try {
                            well.getAddInterp(ws.getInterp(0)).insertZone(this.parseIGDInterval(buff, sepChar, well, 3, useSampleTops));
                            this.addDataType(10);
                        }
                        catch (NullPointerException eio) {
                        }
                        catch (SBException sbe) {
                            System.out.println("Error: " + sbe.getMessage());
                        }
                        continue;
                    }
                    if (dataType.equals("MZON") || dataType.equals("NZON") || dataType.equals("PZON")) {
                        try {
                            well.getAddInterp(ws.getInterp(0)).insertZone(this.parseIGDInterval(buff, sepChar, well, 4, useSampleTops));
                            this.addDataType(11);
                        }
                        catch (NullPointerException sbe) {
                        }
                        catch (SBException sbe) {
                            System.out.println("Error: " + sbe.getMessage());
                        }
                        continue;
                    }
                    if (dataType.equals("FLIT")) {
                        try {
                            well.getAddInterp(ws.getInterp(0)).insertZone(this.parseIGDInterval(buff, sepChar, well, 2, useSampleTops));
                            this.addDataType(12);
                        }
                        catch (NullPointerException sbe) {
                        }
                        catch (SBException sbe) {
                            System.out.println("Error: " + sbe.getMessage());
                        }
                        continue;
                    }
                    if (dataType.equals("MCOM")) {
                        try {
                            biocom2 = this.parseBiocom(in, buff, sepChar, well, 'M', analystAbr, useSampleTops);
                            if (biocom2 == null) continue;
                            well.getAddInterp(ws.getInterp(0)).insertBiocom(biocom2);
                            this.addDataType(3);
                        }
                        catch (NullPointerException biocom2) {}
                        continue;
                    }
                    if (dataType.equals("NCOM")) {
                        try {
                            biocom2 = this.parseBiocom(in, buff, sepChar, well, 'N', analystAbr, useSampleTops);
                            if (biocom2 == null) continue;
                            well.getAddInterp(ws.getInterp(0)).insertBiocom(biocom2);
                            this.addDataType(5);
                        }
                        catch (NullPointerException biocom3) {}
                        continue;
                    }
                    if (dataType.equals("PCOM")) {
                        try {
                            biocom2 = this.parseBiocom(in, buff, sepChar, well, 'P', analystAbr, useSampleTops);
                            if (biocom2 == null) continue;
                            well.getAddInterp(ws.getInterp(0)).insertBiocom(biocom2);
                            this.addDataType(7);
                        }
                        catch (NullPointerException biocom4) {}
                        continue;
                    }
                    if (!dataType.equals("LCOM")) continue;
                    try {
                        biocom2 = this.parseBiocom(in, buff, sepChar, well, 'A', analystAbr, useSampleTops);
                        if (biocom2 == null) continue;
                        well.getAddInterp(ws.getInterp(0)).insertBiocom(biocom2);
                        this.addDataType(9);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                if (well != null) {
                    well.updateStatus(dataTypes);
                    this.addDataType(1);
                }
            }
            catch (Exception eio) {
                JOptionPane.showMessageDialog(null, "Problem reading file: " + eio.getMessage());
                eio.printStackTrace();
            }
            if (this.attemptedIntervalData) {
                JOptionPane.showMessageDialog(null, "File contained interval data which was not parsed");
            }
            in.close();
        }
        catch (Exception fnf) {
            JOptionPane.showMessageDialog(null, "Can't open file for some reason - sorry");
            return;
        }
    }

    void setupAbnScheme(List abnSchemes) throws SBException, SQLException {
        String[] abnSubj = new String[]{"P", "R", "O", "C", "A", "SA"};
        String[] abnText = new String[]{"Present", "Rare", "Occasional", "Common", "Abundant", "Super Abundant"};
        int[] bound = new int[]{1, 1, 6, 21, 51, 1000, 0};
        int[] oVal = new int[]{1, 1, 3, 12, 35, 500, 0};
        this.abnScheme = new AbnScheme(1);
        for (int i = 0; i < abnSubj.length; ++i) {
            this.abnScheme.addClass(abnSubj[i], abnText[i], bound[i], oVal[i]);
        }
        this.abnScheme.setName("RRI Scheme");
        for (AbnScheme scheme : abnSchemes) {
            if (!this.abnScheme.match(scheme)) continue;
            this.abnScheme = scheme;
            return;
        }
        try {
            this.ws.addAbnScheme(this.abnScheme);
        }
        catch (SBPermissionException pe) {
            throw new SBException("PermissionException parsing AbnScheme: " + pe.getMessage(), (Throwable)pe);
        }
    }

    void checkNullWell(Well well) throws SBException {
        if (well == null) {
            throw new SBException("No WELLNAME defined in RG file");
        }
    }

    void parseHeader(String buff, char sepChar, Well well) throws SBException {
        StringTokenizer tok = new StringTokenizer(buff, "" + sepChar, true);
        int nTok = 1;
        block3: while (tok.hasMoreTokens()) {
            String field = tok.nextToken();
            if (!field.equals("" + sepChar)) {
                switch (nTok) {
                    case 1: {
                        if (field.equals(well.getHeader().getWellCode())) continue block3;
                        throw new SBException("Well code in record: " + buff + " does not match file header");
                    }
                }
                continue;
            }
            ++nTok;
        }
    }

    IGDIntervalZone parseIGDInterval(String buff, char sepChar, Well well, int igdType, boolean useSampleTops) throws SBException, SQLException {
        this.attemptedIntervalData = true;
        throw new SBException("RG Reader tried to parse IGD Intervals - not implemented");
    }

    Biocom parseBiocom(BufferedReader in, String buff, char sepChar, Well well, char discID, String analyst, boolean useSampleTops) throws SBException, IOException, SQLException {
        String field;
        StringTokenizer tok = new StringTokenizer(buff, "" + sepChar, true);
        int nTok = 1;
        boolean hier = true;
        double depth = 0.0;
        Object text = null;
        boolean questionable = false;
        int symbol = 0;
        String SIStext = null;
        AnalystHeader analyHdr = well.getAnalystHeader(analyst, discID, 1, true);
        int analystID = this.ws.getAddUserID(analyst);
        block10: while (tok.hasMoreTokens()) {
            field = tok.nextToken();
            if (!field.equals("" + sepChar)) {
                if (field.length() <= 0) continue;
                switch (nTok) {
                    case 1: {
                        if (field.equals(well.getWellCode())) continue block10;
                        throw new SBException("Well code in record: " + buff + " does not match file header");
                    }
                    case 2: {
                        try {
                            symbol = Integer.parseInt(field);
                            if (symbol >= 0) continue block10;
                            symbol = -symbol;
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                    case 3: {
                        depth = Double.parseDouble(field);
                        break;
                    }
                    case 4: {
                        SIStext = field;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 10: {
                        text = field;
                    }
                }
                continue;
            }
            ++nTok;
        }
        if (nTok < 6) {
            text = SIStext;
        }
        if (text == null) {
            return null;
        }
        while (nTok < 11 && nTok > 6 && (buff = in.readLine()) != null) {
            tok = new StringTokenizer(buff, "" + sepChar, true);
            while (tok.hasMoreTokens()) {
                field = tok.nextToken();
                if (!field.equals("" + sepChar)) {
                    text = (String)text + " " + field;
                    continue;
                }
                ++nTok;
            }
        }
        for (int j = 0; j < this.re.length; ++j) {
            text = ((String)text).replaceAll(this.re[j], this.subs[j]);
        }
        boolean isUpper = true;
        for (int i = 0; i < ((String)text).length(); ++i) {
            if (!Character.isLowerCase(((String)text).charAt(i))) continue;
            isUpper = false;
        }
        if (isUpper) {
            text = ((String)text).toLowerCase();
        }
        List<Biocom> comments = well.getInterp(0).getComments();
        Iterator<Biocom> it = comments.iterator();
        Biocom comment = null;
        Sample sample = this.getSample(well, (float)DepthUtils.convToM((double)depth, (char)well.getHeader().getWellUnits()), "LOG", useSampleTops);
        if (sample == null) {
            return null;
        }
        while (it.hasNext() && ((comment = it.next()).getTopSample() != sample || comment.getDiscID() != discID)) {
            comment = null;
        }
        if (comment == null) {
            comment = new Biocom.Builder(this.ws, Discipline.getDisc(discID), analystID, sample, (String)text).build();
            return comment;
        }
        text = comment.getText() + "\r\n" + (String)text;
        comment.setText((String)text);
        return null;
    }

    Sample getSample(Well well, double depth, String type, boolean useSampleTops) throws SBException, SQLException {
        well.getSamples();
        Sample sample = well.getSample(depth, type, true);
        if (sample == null) {
            try {
                sample = well.addSample(depth, SampleType.parseType(type), "");
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace", pe);
            }
        }
        return sample;
    }

    void parseOccs(String buff, char sepChar, Well well, char discID, String analyst, boolean useSampleTops) throws SBException, SQLException {
        Smpdtl smpdtl;
        int analystID = this.ws.getAddUserID(analyst);
        AnalystHeader analyHdr = well.getAnalystHeader(analyst, discID, 1, true);
        if (analyHdr.getAbnSchID() != this.abnScheme.getID()) {
            analyHdr.setAbnScheme(this.abnScheme.getID());
        }
        StringTokenizer tok = new StringTokenizer(buff, "" + sepChar, true);
        int nTok = 1;
        String sampleType = "";
        double depth = 0.0;
        int siteStatus = -999;
        int counts = 0;
        String taxonName = null;
        String taxonCategory = null;
        char ageDiagnostic = '\u0000';
        String taxonCode = null;
        boolean questionable = false;
        boolean occIsBarren = false;
        block32: while (tok.hasMoreTokens()) {
            String field = tok.nextToken();
            if (!field.equals("" + sepChar)) {
                if (field.length() <= 0) continue;
                switch (nTok) {
                    case 1: {
                        if (field.equals(well.getHeader().getWellCode())) continue block32;
                        throw new SBException("Well code in record: " + buff + " does not match file header");
                    }
                    case 2: {
                        switch (field.charAt(0)) {
                            case 'S': {
                                sampleType = "SC";
                                break;
                            }
                            case 'D': {
                                sampleType = "CU";
                                break;
                            }
                            case 'C': {
                                sampleType = "CO";
                            }
                        }
                        continue block32;
                    }
                    case 3: {
                        depth = Double.parseDouble(field);
                        continue block32;
                    }
                    case 4: {
                        if (field.charAt(0) == '?') {
                            siteStatus = -999;
                            questionable = true;
                            continue block32;
                        }
                        siteStatus = Integer.parseInt(field);
                        continue block32;
                    }
                    case 5: {
                        counts = Integer.parseInt(field);
                        continue block32;
                    }
                    case 6: {
                        taxonName = field;
                        continue block32;
                    }
                    case 7: {
                        taxonCategory = field;
                        continue block32;
                    }
                    case 8: {
                        ageDiagnostic = field.charAt(0);
                        continue block32;
                    }
                    case 9: 
                    case 10: {
                        System.out.println("Subjective abundance ranges defined");
                        continue block32;
                    }
                    case 11: {
                        taxonCode = field;
                    }
                }
                continue;
            }
            ++nTok;
        }
        double depthM = DepthUtils.convToM((double)depth, (char)well.getHeader().getWellUnits());
        Sample sample = this.getSample(well, depthM, sampleType, false);
        if (sample == null) {
            try {
                sample = well.addSample(depth, SampleType.parseType(sampleType), "");
            }
            catch (SBPermissionException pe) {
                throw new IllegalStateException("Unexpected permission exception in workspace", pe);
            }
        }
        int taxonCodeNumber = 0;
        try {
            taxonCodeNumber = Integer.parseInt(taxonCode);
            if (taxonCodeNumber < 0) {
                occIsBarren = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (taxonName != null && !occIsBarren && taxonName.toUpperCase().startsWith("BARREN")) {
            occIsBarren = true;
        }
        if ((smpdtl = sample.getAnySmpdtl(discID, analyst)) == null) {
            Audit audit = new Audit(analystID, this.date, analyHdr.getAnalystUsrid(), this.date);
            smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, audit, occIsBarren ? Smpdtl.AnalysisType.BARREN : Smpdtl.AnalysisType.ANALYSED);
            sample.insert(smpdtl);
        }
        if (!(taxonName == null || occIsBarren || siteStatus == counts && counts == 0)) {
            if (siteStatus == counts) {
                siteStatus = -999;
                this.hasPseudoQuantData = true;
            }
            String subjAbund = "";
            switch (siteStatus) {
                case 0: {
                    subjAbund = this.abnScheme.getEntry(0);
                    siteStatus = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    subjAbund = this.abnScheme.getEntry(siteStatus - 1);
                    siteStatus = 0;
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    if (counts > 0) break;
                    subjAbund = "R";
                    counts = 0;
                    break;
                }
                default: {
                    System.out.println("Abundance class in siteStatus field not recognised in record: " + buff);
                    break;
                }
                case -999: {
                    siteStatus = 0;
                }
            }
            if (counts < 0) {
                siteStatus = counts;
                counts = 0;
            }
            boolean rw = false;
            boolean cv = false;
            switch (siteStatus) {
                case -1: {
                    if (counts == 0 && subjAbund.length() == 0) {
                        subjAbund = "+";
                        counts = 0;
                    }
                    cv = true;
                    break;
                }
                case -2: {
                    if (counts == 0 && subjAbund.length() == 0) {
                        subjAbund = "+";
                        counts = 0;
                    }
                    rw = true;
                    break;
                }
                case -3: {
                    subjAbund = "+";
                    counts = 0;
                    break;
                }
            }
            if (subjAbund != null && subjAbund.length() > 0) {
                this.hasAbnEntries[SBdb.did2i((char)discID)] = true;
            }
            Taxon taxonRef = this.parseTaxon(taxonName);
            if (taxonCategory != null) {
                this.ws.setTaxonCat(taxonRef.getSpecID(), taxonCategory);
            }
            boolean marker = false;
            if (ageDiagnostic == 'Y') {
                marker = true;
            }
            TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, rw, questionable, 0);
            builder.count(counts).subjAbund(subjAbund).caved(cv).marker(marker);
            smpdtl.insertOccurrence(builder, well.getWellID(), false);
        }
    }

    Taxon parseTaxon(String strg) {
        Taxon t = this.ws.getTaxon(strg, this.specID, true);
        if (t.getSpecID() == this.specID) {
            ++this.specID;
        }
        return t;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    void quantToSemiQuant(AbnScheme abnScheme, List wellList) throws SQLException, SBException {
        if (!this.hasPseudoQuantData) {
            return;
        }
        for (Well well : wellList) {
            Iterator<Sample> sampleIt = well.getSamples().iterator();
            Object discs = "";
            while (sampleIt.hasNext()) {
                Sample sample = sampleIt.next();
                for (Smpdtl dtl : sample.analyses) {
                    if (((String)discs).indexOf(dtl.getDiscID()) < 0) {
                        discs = (String)discs + dtl.getDiscID();
                    }
                    Iterator<TaxonOcc> fssIt = dtl.getOccurIterator();
                    while (fssIt.hasNext()) {
                        TaxonOcc fss = fssIt.next();
                        if (fss.getSubAbund().length() != 0) continue;
                        fss.setSubjAbund(abnScheme.getAbr(fss.getMedium()));
                        fss.setMedium(0);
                    }
                }
            }
        }
        this.hasPseudoQuantData = false;
    }
}

