/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import model2_1.SBdb;
import model2_1.TxGroupSet;
import model2_1.Well;
import util.SB;
import util.SBException;

public class SBChart {
    SBdb db;
    int chartID;
    String owner;
    boolean isPublic = false;
    int wellID;
    String wellName;
    String project;
    String name;
    float topDepth;
    float baseDepth;
    float scale;
    char units = (char)77;
    int hdrHeight;
    boolean monoLithology;
    int interpID;
    int synScheme;
    int additionalSynScheme;
    List<Panel> panels = new LinkedList<Panel>();
    List<Cline> clines = new LinkedList<Cline>();

    public int getChartID() {
        return this.chartID;
    }

    public boolean hasGroup(int grpID) throws SQLException, SBException {
        this.loadData();
        for (Panel panel : this.panels) {
            TxGroupSet set;
            panel.decodeAttributes();
            if (panel.highlightGroup == grpID) {
                return true;
            }
            if (panel.groupID == grpID) {
                return true;
            }
            if (panel.filterGroup == grpID) {
                return true;
            }
            if (panel.setID > 0) {
                set = null;
                set = this.db.getTxGroupSet(panel.setID);
                if (set != null) {
                    set.loadGroups();
                    if (set.isGroupMember(grpID)) {
                        return true;
                    }
                }
            }
            if (panel.sumGroupSet <= 0) continue;
            set = null;
            set = this.db.getTxGroupSet(panel.sumGroupSet);
            if (set == null) continue;
            set.loadGroups();
            if (!set.isGroupMember(grpID)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSet(int setID) throws SQLException, SBException {
        this.loadData();
        for (Panel panel : this.panels) {
            panel.decodeAttributes();
            if (panel.setID == setID) {
                return true;
            }
            if (panel.sumGroupSet != setID) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    SBChart(SBdb db) {
        this.db = db;
    }

    public static void load(SBdb SB2, List charts, String project) throws SQLException {
        Object sql = "SELECT chart_id,owner,global,well_id,name,top_depth,base_depth,scale,units,hdr_height,mono_lith";
        sql = (String)sql + ",interp_id";
        sql = (String)sql + " FROM " + SB2.DBTableName("SBCHARTS") + " WHERE project like '" + project + "' AND (global='Y' OR owner='" + SB2.getUser().getAbr() + "') ORDER BY chart_id";
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery((String)sql));
        while (rs.next()) {
            SBChart chart = new SBChart(SB2);
            chart.chartID = rs.getInt("chart_id");
            chart.owner = rs.getString("owner");
            String strg = rs.getString("global");
            if (strg != null && strg.charAt(0) != 'N') {
                chart.isPublic = true;
            }
            chart.wellID = rs.getInt("well_id");
            chart.name = rs.getString("name");
            chart.topDepth = rs.getFloat("top_depth");
            chart.baseDepth = rs.getFloat("base_depth");
            chart.scale = rs.getFloat("scale");
            strg = rs.getString("units");
            if (strg != null && strg.charAt(0) == 'F') {
                chart.units = (char)70;
            }
            chart.hdrHeight = rs.getInt("hdr_height");
            chart.monoLithology = rs.getInt("mono_lith") > 0;
            chart.interpID = rs.getInt("interp_id");
            chart.loadWell();
            charts.add(chart);
        }
        stmt.close();
    }

    public void loadWell() throws SQLException {
        if (this.wellName == null) {
            if (this.wellID == 0) {
                this.wellName = "(multi-well)";
            } else {
                this.wellName = Well.getName(this.db, this.wellID);
                if (this.wellName == null) {
                    this.wellName = "(deleted)";
                }
            }
        }
    }

    public void loadData() throws SQLException {
        this.panels.clear();
        String sql = "SELECT chart_id,panel_no,attributes FROM " + this.db.DBTableName("SBCHPANL") + " WHERE chart_id=" + this.chartID + " ORDER BY panel_no";
        Statement stmt = this.db.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(this.db.modQuery(sql));
        while (rs.next()) {
            Panel panel = new Panel(this.db);
            panel.chartID = this.chartID;
            panel.number = rs.getInt("panel_no");
            panel.attributes = rs.getString("attributes");
            panel.decodeAttributes();
            this.panels.add(panel);
        }
        stmt.close();
    }

    String getWellName() {
        return this.wellName;
    }

    void delete() throws SQLException {
        if (this.chartID > 0) {
            String sql = "DELETE FROM " + this.db.DBTableName("SBCHARTS") + " WHERE chart_id=" + this.chartID;
            Statement stmt = this.db.getDatabase().createStatement();
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("SBCHPANL") + " WHERE chart_id=" + this.chartID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("SBCHCLIN") + " WHERE chart_id=" + this.chartID;
            stmt.executeUpdate(this.db.modQuery(sql));
            sql = "DELETE FROM " + this.db.DBTableName("SBLOGTRC") + " WHERE chart_id=" + this.chartID;
            stmt.executeUpdate(this.db.modQuery(sql));
            this.chartID = 0;
            stmt.close();
        }
    }

    void setProject(String project) throws SQLException {
        this.project = project;
        if (this.chartID > 0) {
            String sql = "UPDATE " + this.db.DBTableName("SBCHARTS") + " SET project=" + SB.DBString((String)project) + " WHERE chart_id=" + this.chartID;
            Statement stmt = this.db.getDatabase().createStatement();
            stmt.executeUpdate(this.db.modQuery(sql));
            stmt.executeUpdate(this.db.modQuery(sql));
            stmt.close();
        }
    }

    public List getPanels() {
        return this.panels;
    }

    public static class Panel {
        public static final int PTYPE_DEPTHKEY = 1;
        public static final int PTYPE_BLANK = 2;
        public static final int PTYPE_SAMPLEKEY = 3;
        public static final int PTYPE_INT_LITHOLOGY = 4;
        public static final int PTYPE_QUA_LITHOLOGY = 5;
        public static final int PTYPE_CHRONOSTRAT = 6;
        public static final int PTYPE_LITHOSTRAT = 7;
        public static final int PTYPE_SEQUENCE = 8;
        public static final int PTYPE_BIOZONE = 9;
        public static final int PTYPE_ENVIRONMENT = 10;
        public static final int PTYPE_WELLNAMES = 11;
        public static final int PTYPE_TITLE = 12;
        public static final int PTYPE_CHARTKEY = 13;
        public static final int PTYPE_TAXON = 14;
        public static final int PTYPE_BIOS_COMMENT = 15;
        public static final int PTYPE_CORE = 16;
        public static final int PTYPE_CASING = 17;
        public static final int PTYPE_WLOG = 18;
        public static final int PTYPE_SMARK = 19;
        public static final int PTYPE_SRAGE = 20;
        public static final int PTYPE_SAMPLES = 21;
        public static final int PTYPE_EVENTS = 22;
        public static final int PTYPE_STRIPLOG = 23;
        public static final int PTYPE_VERTSCALE = 24;
        public static final int PTYPE_SAMPLITH = 25;
        private final SBdb db;
        int chartID;
        int number;
        String attributes;
        String name;
        int panelType;
        public int wellID;
        public int groupID;
        public int filterGroup;
        public int highlightGroup;
        public int setID;
        public int sumGroupSet;
        public int cmpStdID;
        String logFileName = null;

        Panel(SBdb db) {
            this.db = db;
        }

        public String toString() {
            return this.name;
        }

        void decodeAttributes() {
            StringTokenizer tok = new StringTokenizer(this.attributes, "|", true);
            String[] pAtts = new String[50];
            int i = 0;
            while (tok.hasMoreTokens()) {
                String strg = tok.nextToken();
                if (!strg.equals("|")) {
                    switch (i) {
                        case 0: {
                            this.panelType = Integer.parseInt(strg.trim());
                            break;
                        }
                        case 11: {
                            this.name = strg;
                        }
                    }
                    pAtts[i] = strg.trim();
                    if (pAtts[i].length() != 0) continue;
                    pAtts[i] = null;
                    continue;
                }
                ++i;
            }
            int wellIDattNo = Panel.getWellAttNo(this.panelType);
            if (wellIDattNo >= 0 && pAtts[wellIDattNo] != null) {
                this.wellID = Integer.parseInt(pAtts[wellIDattNo]);
            }
            if (this.panelType == 22 && pAtts[16] != null) {
                this.cmpStdID = Integer.parseInt(pAtts[16]);
            }
            if (this.panelType == 14) {
                if (pAtts[15] != null) {
                    this.groupID = Integer.parseInt(pAtts[15]);
                }
                if (pAtts[21] != null) {
                    this.setID = Integer.parseInt(pAtts[21]);
                }
                if (pAtts[12] != null) {
                    this.decodeTProp(pAtts[12]);
                }
            }
            if (this.panelType == 18 && pAtts[12] != null) {
                this.logFileName = pAtts[12];
            }
        }

        void decodeTProp(String prop) {
            StringTokenizer tok = new StringTokenizer(prop, ",", true);
            int i = 0;
            while (tok.hasMoreTokens()) {
                String strg = tok.nextToken();
                if (!strg.equals(",")) {
                    switch (i) {
                        case 26: {
                            this.filterGroup = Integer.parseInt(strg);
                            break;
                        }
                        case 27: {
                            this.highlightGroup = Integer.parseInt(strg);
                            break;
                        }
                        case 35: {
                            this.sumGroupSet = Integer.parseInt(strg);
                        }
                    }
                    continue;
                }
                ++i;
            }
        }

        void delete() throws SQLException {
            if (this.chartID > 0 && this.number > 0) {
                Statement stmt = this.db.getDatabase().createStatement();
                String sql = "DELETE FROM " + this.db.DBTableName("SBCHPANL") + " WHERE chart_id=" + this.chartID + " AND panel_no=" + this.number;
                stmt.executeUpdate(this.db.modQuery(sql));
                stmt.close();
                this.chartID = 0;
                this.number = 0;
            }
        }

        public static int getWellAttNo(int SBPanelType) {
            int wellIDattNo = -1;
            switch (SBPanelType) {
                case 24: 
                case 25: {
                    wellIDattNo = 12;
                    break;
                }
                case 18: 
                case 20: 
                case 21: 
                case 22: {
                    wellIDattNo = 13;
                    break;
                }
                case 8: 
                case 16: 
                case 17: 
                case 19: 
                case 23: {
                    wellIDattNo = 14;
                    break;
                }
                case 1: 
                case 4: 
                case 10: {
                    wellIDattNo = 15;
                    break;
                }
                case 6: {
                    wellIDattNo = 16;
                    break;
                }
                case 14: {
                    wellIDattNo = 17;
                    break;
                }
                case 7: {
                    wellIDattNo = 18;
                    break;
                }
                case 9: 
                case 15: {
                    wellIDattNo = 19;
                    break;
                }
                case 12: {
                    wellIDattNo = 21;
                }
            }
            return wellIDattNo;
        }
    }

    class Cline {
        int chartID;
        int lineNumber;
        Color colour;
        boolean datum = false;
        int style;
        int ID;
        int interpID;
        char surface;
        float width;

        Cline() {
        }
    }
}

