/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.sql.SQLException;
import model2_1.Sample;
import model2_1.Well;

public class SampleDepth
implements Comparable {
    private final double depth;
    private final Double correction;

    public SampleDepth(double depth) {
        this.depth = depth;
        this.correction = null;
    }

    public SampleDepth(double depth, double correction) {
        this.depth = depth;
        this.correction = correction;
    }

    public boolean hasCorrection() {
        return this.correction != null;
    }

    public double getDepth() {
        return this.depth;
    }

    public Double getCorrection() {
        return this.correction;
    }

    public double getCorrectedDepth() {
        if (this.hasCorrection()) {
            return this.depth + this.correction;
        }
        return this.depth;
    }

    public String toString() {
        return Double.toString(this.getCorrectedDepth());
    }

    public int compareTo(SampleDepth o) {
        if (this.getCorrectedDepth() < o.getCorrectedDepth()) {
            return -1;
        }
        if (o.getCorrectedDepth() < this.getCorrectedDepth()) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (o instanceof SampleDepth) {
            return this.compareTo((SampleDepth)o);
        }
        return this.toString().compareTo(o.toString());
    }

    public static SampleDepth BuildCorrectedSampleDepth(Well well, Sample sample) throws SQLException {
        double depth;
        double correctedDepth = well.getDepth(sample, true, true);
        double correction = correctedDepth - (depth = sample.getDepth());
        if (Math.abs(correction) > (double)0.0029f) {
            return new SampleDepth(depth, correction);
        }
        return new SampleDepth(depth);
    }
}

