/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model2_1.AnalystHeader;
import model2_1.Audit;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleInsertException;
import model2_1.SampleType;
import model2_1.Smpdtl;
import model2_1.Taxon;
import model2_1.TaxonOcc;
import model2_1.Userdef;
import model2_1.Well;
import model2_1.WsWell;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;
import util.status.MergeStatus;

public class SampleOccReaderXLS {
    List nonInserts = new LinkedList();
    int donorSampleID = 1;
    Set<Integer> dataTypes;
    int topDepthColumn = -1;
    int baseDepthColumn = -1;
    int sampleTypeColumn = -1;
    int genusColumn = -1;
    int speciesColumn = -1;
    int countsColumn = -1;
    int taxonColumn = -1;
    char units = (char)77;
    int specID = 1;
    SBdb ws;
    final int COLUMN_REPEAT = 1;
    final int ROW_NAMES = 2;
    final String defaultSampleType;

    public SampleOccReaderXLS(int format, SBdb ws, File file, Set<Integer> dataTypes, Userdef analyst, char discID, char units, String defaultSampleType) throws SBException, FileNotFoundException, IOException, SQLException, InvalidFormatException, SampleInsertException, SBPermissionException {
        this.dataTypes = dataTypes;
        this.ws = ws;
        this.units = units;
        this.defaultSampleType = defaultSampleType;
        Workbook wb = WorkbookFactory.create((File)file);
        dataTypes.clear();
        Sheet sheet = wb.getSheetAt(0);
        System.out.println("processing sheet: " + wb.getSheetName(0) + "\n");
        if (format == 1) {
            this.parseSheet(sheet, analyst, discID);
        } else {
            this.parseSheet2(sheet, analyst, discID);
        }
    }

    final void parseSheet(Sheet sheet, Userdef analyst, char discID) throws SBException, SQLException {
        boolean parsedTitles = false;
        WsWell well = null;
        this.addDataType(1);
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
        well = this.ws.addWellToWorkspace(0, null);
        well.loadInterps();
        System.out.println("Setting well name as: " + sheet.getSheetName());
        well.getHeader().setWellName(sheet.getSheetName());
        well.getHeader().setWellCode(Well.makeCode(sheet.getSheetName()));
        well.getHeader().setWellUnits(this.units);
        AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
        double lastDepth = 0.0;
        String lastType = null;
        Sample sample = null;
        Smpdtl smpdtl = null;
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            if (!parsedTitles) {
                parsedTitles = this.parseTitles(row);
                continue;
            }
            Double topDepth = null;
            Double baseDepth = null;
            String type = "CO";
            String genus = null;
            String species = null;
            String taxon = null;
            int counts = 0;
            block17: for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
                Cell cell = row.getCell((int)i);
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                if (i == this.baseDepthColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            baseDepth = cell.getNumericCellValue();
                            break;
                        }
                        case STRING: {
                            baseDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.topDepthColumn) {
                    switch (cell.getCellType()) {
                        case NUMERIC: 
                        case FORMULA: {
                            topDepth = cell.getNumericCellValue();
                            break;
                        }
                        case STRING: {
                            topDepth = new Double(cell.getStringCellValue());
                            break;
                        }
                    }
                    continue;
                }
                if (i == this.sampleTypeColumn) {
                    type = cell.getStringCellValue();
                    continue;
                }
                if (i == this.genusColumn) {
                    genus = cell.getStringCellValue();
                    continue;
                }
                if (i == this.speciesColumn) {
                    species = cell.getStringCellValue();
                    continue;
                }
                if (i == this.taxonColumn) {
                    taxon = cell.getStringCellValue();
                    continue;
                }
                if (i != this.countsColumn) continue;
                switch (cell.getCellType()) {
                    case NUMERIC: 
                    case FORMULA: {
                        counts = (int)cell.getNumericCellValue();
                        continue block17;
                    }
                    case STRING: {
                        counts = new Integer(cell.getStringCellValue());
                        continue block17;
                    }
                }
            }
            if (Math.max(baseDepth == null ? 0.0 : baseDepth, topDepth == null ? 0.0 : topDepth) < (double)0.0029f) continue;
            try {
                block36: {
                    block35: {
                        if (this.units == 'F') {
                            if (topDepth != null) {
                                topDepth = DepthUtils.convToM((double)topDepth, (char)this.units);
                            }
                            if (baseDepth != null) {
                                baseDepth = DepthUtils.convToM((double)baseDepth, (char)this.units);
                            }
                        }
                        if (sample == null) break block35;
                        double d = baseDepth == null ? 0.0 : baseDepth;
                        double d2 = topDepth == null ? 0.0 : topDepth;
                        if (!(Math.max(d, d2) - lastDepth > (double)0.0029f) && type.equals(lastType)) break block36;
                    }
                    sample = well.addSample(topDepth, baseDepth, type, null);
                    System.out.println("Sample: " + sample.toString() + " Added to well: " + well);
                    smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                    sample.insert(smpdtl);
                    lastDepth = Math.max(baseDepth == null ? 0.0 : baseDepth, topDepth == null ? 0.0 : topDepth);
                    lastType = type;
                }
                if (smpdtl == null) {
                    throw new SBException("Failed to parse smpdtl");
                }
                Taxon taxonRef = this.ws.getTaxon((String)(taxon != null ? taxon : genus + " " + species), this.specID, true);
                if (taxonRef.getSpecID() == this.specID) {
                    ++this.specID;
                }
                TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, false, false, 0);
                builder = builder.count(counts);
                try {
                    smpdtl.insertOccurrence(builder, well.getWellID(), false);
                }
                catch (SBException ex) {
                    throw new SBException(ex.getMessage() + " in Sample: " + sample.toString());
                }
                sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                this.addDataType(1);
                this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                continue;
            }
            catch (Exception ex) {
                System.out.println("Exception ading sample: " + topDepth + "," + baseDepth + "," + type + " to Well:" + well);
                ex.printStackTrace();
            }
        }
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
    }

    final void parseSheet2(Sheet sheet, Userdef analyst, char discID) throws SBException, SQLException, SampleInsertException, SBPermissionException {
        WsWell well = null;
        this.addDataType(1);
        if (well != null) {
            well.updateStatus(this.dataTypes);
        }
        well = this.ws.addWellToWorkspace(0, null);
        well.loadInterps();
        System.out.println("Setting well name as: " + sheet.getSheetName());
        well.getHeader().setWellName(sheet.getSheetName());
        well.getHeader().setWellCode(Well.makeCode(sheet.getSheetName()));
        well.getHeader().setWellUnits(this.units);
        AnalystHeader analyHdr = well.getAnalystHeader(analyst.getAbr(), discID, 1, true);
        Sample sample = null;
        Smpdtl smpdtl = null;
        for (int nRow = 0; nRow <= sheet.getLastRowNum(); ++nRow) {
            Cell cell;
            int noCols;
            Row row = sheet.getRow(nRow);
            if (row == null) continue;
            for (noCols = row.getLastCellNum(); noCols > 1 && this.cellIsBlank(cell = row.getCell(noCols - 1)); --noCols) {
            }
            cell = row.getCell(0);
            if (cell != null && cell.getCellType() != CellType.BLANK) {
                switch (noCols) {
                    case 1: {
                        switch (cell.getCellType()) {
                            case NUMERIC: 
                            case FORMULA: {
                                Double depth = cell.getNumericCellValue();
                                if (this.units == 'F') {
                                    depth = DepthUtils.convToM((double)depth, (char)this.units);
                                }
                                sample = well.addSample(depth, SampleType.getType(this.defaultSampleType), (String)null);
                                break;
                            }
                            case STRING: {
                                Sample.Builder sampleBuilder = Sample.parseDepthString(cell.getStringCellValue(), this.units, true, false);
                                sampleBuilder.type(SampleType.getType(this.defaultSampleType));
                                sample = well.addSample(sampleBuilder, 0, null);
                                break;
                            }
                        }
                        System.out.println("Sample: " + sample.toString() + " Added to well: " + well);
                        smpdtl = new Smpdtl(this.ws, sample, analyHdr, "", null, null, 0, 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, new Audit(), Smpdtl.AnalysisType.ANALYSED);
                        sample.insert(smpdtl);
                        break;
                    }
                    case 2: {
                        int counts = 0;
                        Taxon taxonRef = this.ws.getTaxon(cell.getStringCellValue(), this.specID, true);
                        if (taxonRef.getSpecID() == this.specID) {
                            ++this.specID;
                        }
                        TaxonOcc.Builder builder = new TaxonOcc.Builder(this.ws, taxonRef, false, false, 0);
                        cell = row.getCell(1);
                        switch (cell.getCellType()) {
                            case NUMERIC: 
                            case FORMULA: {
                                counts = (int)cell.getNumericCellValue();
                                break;
                            }
                            case STRING: {
                                String countString = cell.getStringCellValue().trim();
                                if (countString.isEmpty()) break;
                                counts = Integer.parseInt(cell.getStringCellValue());
                                break;
                            }
                        }
                        if (counts <= 0) break;
                        builder = builder.count(counts);
                        try {
                            smpdtl.insertOccurrence(builder, well.getWellID(), false);
                        }
                        catch (SBException ex) {
                            throw new SBException(ex.getMessage() + " in Sample: " + sample.toString());
                        }
                        sample.status = MergeStatus.merge((Color)sample.status, (Color)smpdtl.status);
                        this.addDataType(1);
                        this.addDataType(SBdb.did2dtype(smpdtl.getDiscID()));
                    }
                }
            }
            if (well == null) continue;
            well.updateStatus(this.dataTypes);
        }
    }

    boolean cellIsBlank(Cell cell) {
        if (cell == null) {
            return true;
        }
        switch (cell.getCellType()) {
            default: {
                return false;
            }
            case STRING: {
                return cell.getStringCellValue().trim().isEmpty();
            }
            case BLANK: 
        }
        return true;
    }

    void addDataType(int dType) {
        if (!this.dataTypes.contains(new Integer(dType))) {
            this.dataTypes.add(new Integer(dType));
        }
    }

    boolean parseTitles(Row row) {
        boolean isTitleRow = false;
        for (short i = 0; i <= row.getLastCellNum(); i = (short)(i + 1)) {
            Cell cell = row.getCell((int)i);
            if (cell == null || cell.getCellType() != CellType.STRING) continue;
            String strg = cell.getStringCellValue();
            if (strg.toUpperCase().startsWith("DEPTH")) {
                if (this.ws.useSampleTops()) {
                    this.topDepthColumn = i;
                } else {
                    this.baseDepthColumn = i;
                }
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("TOP DEPTH") && this.topDepthColumn < 0) {
                this.topDepthColumn = i;
                isTitleRow = true;
                if (strg.toLowerCase().contains("(ft)")) {
                    this.units = (char)70;
                }
            }
            if (strg.toUpperCase().startsWith("BASE DEPTH")) {
                if (this.baseDepthColumn >= 0) continue;
                this.baseDepthColumn = i;
                isTitleRow = true;
                if (!strg.toLowerCase().contains("(ft)")) continue;
                this.units = (char)70;
                continue;
            }
            if (strg.equalsIgnoreCase("SAMPLE TYPE") || strg.equalsIgnoreCase("TYPE")) {
                if (this.sampleTypeColumn >= 0) continue;
                this.sampleTypeColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("GENUS")) {
                this.genusColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("SPECIES")) {
                this.speciesColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("COUNTS")) {
                this.countsColumn = i;
                continue;
            }
            if (strg.equalsIgnoreCase("MEDIUM")) {
                this.countsColumn = i;
                continue;
            }
            if (!strg.toUpperCase().equalsIgnoreCase("TAXON NAME") && !strg.equalsIgnoreCase("TAXON")) continue;
            this.taxonColumn = i;
        }
        return isTitleRow;
    }
}

