/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import model2_1.Audit;
import model2_1.CoOccurrence;
import model2_1.Genus;
import model2_1.IGDUnit;
import model2_1.ImageSet;
import model2_1.Project;
import model2_1.Qualifier;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.SynonymScheme;
import model2_1.TaxonCompareAlphaCode;
import model2_1.TaxonCompareCategory;
import model2_1.TaxonCompareGenus;
import model2_1.TaxonCompareSIPMCode;
import model2_1.TaxonCompareSpecies;
import model2_1.TaxonOcc;
import model2_1.TaxonQual;
import model2_1.TxGroup;
import model2_1.Userdef;
import model2_1.api.Discipline;
import model2_1.taxa.GenusListener;
import model2_1.taxa.TaxonListener;
import model2_1.taxa.TaxonUpdatePublisher;
import util.InvalidFieldException;
import util.ProgressBarMonitor;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.SortEntry;
import util.exception.StackError;
import util.listener.Observable;
import util.listener.Publisher;
import util.status.SbugsStatus;

public class Taxon
implements Comparable,
SortEntry,
SbugsStatus,
SbugsLink,
GenusListener,
Observable<TaxonListener>,
Publisher {
    private final SBdb sbdb;
    private final int specID;
    private Genus genus;
    private String species = "";
    private String subSpecies = "";
    private final Qualifier[] qualifiers;
    private String author = "";
    private int year;
    private String alphaCode = "";
    private String notes = null;
    private String reference = null;
    private String url = null;
    private Audit audit = new Audit();
    String donorString = "";
    String noAuthorDonorString = null;
    String donorOccType = "In-situ";
    private Taxon link;
    private HashMap<Integer, Integer> sipmCode = null;
    public static final String INSITU_OCC = "In-situ";
    public static final String REWORKED_OCC = "Reworked";
    public static final String CAVED_OCC = "Caved";
    public static final String QUESTIONABLE_OCC = "Questionable";
    boolean highlight = false;
    static Boolean exportImages = null;
    private final TaxonUpdatePublisher updatePublisher = new TaxonUpdatePublisher(this);
    private int imageSetCount = -1;
    private int hasTypeImage = -1;
    List<ImageSet> wsImages = null;
    private ImageSet imageType = null;
    static SimpleDateFormat databaseDate = new SimpleDateFormat("yyyy-MM-dd");
    public static boolean includeAuthorInString = false;
    public static boolean includeCategoryInString = true;
    public static boolean includeAlphaInString = false;
    static int NQUAL = 8;
    static int[] preqal = new int[]{1, 0, 1, 0, 1, 0, 1, 0};
    static int NSYM = 9;
    static int MAXSYM = 6;
    static String[] qulsym = new String[]{"\"", "?", "cf.", "aff.", "ss.", "sl.", "grp.", "sensu", "var."};
    static int[][] symord = new int[][]{{1, 2, 3, 0, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, -1}, {2, 3, 0, -1, -1, -1}, {1, 0, 6, 4, 5, 7}, {2, 3, 0, 8, -1, -1}, {1, 0, 4, 5, 7, -1}};
    static int[][] mutexc = new int[][]{{1, 1, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 0, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 2, 2, 2, 2, 0}, {1, 0, 2, 2, 0, 0, 0, 0, 2}, {1, 1, 0, 0, 2, 2, 0, 2, 0}};

    public boolean isHighlight() {
        if (this.species.contains("ium")) {
            this.highlight = true;
        }
        return this.highlight;
    }

    public void registerListener(TaxonListener l) {
        this.updatePublisher.registerListener(l);
    }

    public void deleteListener(TaxonListener l) {
        this.updatePublisher.deleteListener(l);
    }

    public void notifyListeners() {
        this.genus.notifyListeners();
        this.updatePublisher.notifyListeners();
    }

    public void setNotifyDeleted() {
        this.updatePublisher.setTaxonDeleted();
    }

    public SBdb getDatabase() {
        return this.sbdb;
    }

    public Taxon getLink() {
        return this.link;
    }

    public Color getStatus() {
        if (this.link != null) {
            return STORED;
        }
        return NOTSTORED;
    }

    public void setLink(Taxon link) {
        this.link = link;
    }

    public int getSpecID() {
        return this.specID;
    }

    public String getSortEntry() {
        return this.toString(false, true);
    }

    public int getGenID() {
        return this.genus.getGenID();
    }

    public String getDonorString() {
        return this.donorString;
    }

    public String getDonorOccType() {
        return this.donorOccType;
    }

    public void setDonorOccType(String str) {
        this.donorOccType = str;
    }

    public String getCatMnem() {
        return this.genus.getCategory().getMnem();
    }

    public String getGenusName() {
        return this.genus.getGenus();
    }

    public String getSubGenus() {
        return this.genus.getSubGenus();
    }

    public String getSpecies() {
        return this.species;
    }

    public String getSubSpecies() {
        return this.subSpecies;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getYear() {
        return this.year;
    }

    public String getAlphaCode() {
        return this.alphaCode;
    }

    public Genus getGenus() {
        return this.genus;
    }

    public Audit getAudit() {
        return new Audit(this.audit);
    }

    public Date getModified() {
        if (this.audit.modified != null) {
            return new Date(this.audit.modified.getTime());
        }
        return null;
    }

    public String getModifier() {
        if (this.audit.modifier < 1) {
            return "";
        }
        try {
            Userdef user = this.sbdb.getUser(this.audit.modifier);
            if (user != null) {
                return user.getAbr();
            }
            return "";
        }
        catch (SQLException sql) {
            return "Error loading users";
        }
    }

    public Qualifier getQualifier(int field) {
        if (field < 0 || field > 7) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + field);
        }
        if (field < 4) {
            return this.genus.getQualifier(field);
        }
        return this.qualifiers[field - 4];
    }

    public Qualifier getQualifierSpecies(int field) {
        if (field < 0 || field > 3) {
            throw new IllegalArgumentException("Attempt to get taxon qualifier " + field);
        }
        return this.qualifiers[field];
    }

    public Qualifier getQ1() {
        return this.qualifiers[0];
    }

    public Qualifier getQ2() {
        return this.qualifiers[1];
    }

    public Qualifier getQ3() {
        return this.qualifiers[2];
    }

    public Qualifier getQ4() {
        return this.qualifiers[3];
    }

    public String getNotes() throws SQLException {
        this.loadNotesAndRefs(null);
        return this.notes;
    }

    public String getReference() throws SQLException {
        this.loadNotesAndRefs(null);
        return this.reference;
    }

    public String getReference(boolean load) throws SQLException {
        if (load) {
            this.loadNotesAndRefs(null);
        }
        return this.reference;
    }

    public void setURL(String url, boolean storeInDatabase) {
        if (storeInDatabase) assert (false);
        this.url = url;
    }

    public String getURL(boolean load) throws SQLException {
        if (load) {
            this.loadNotesAndRefs(null);
        }
        return this.url;
    }

    private static boolean containsQualifier(String donorString) {
        for (int i = 0; i < qulsym.length; ++i) {
            if (!donorString.contains(qulsym[i])) continue;
            return true;
        }
        return false;
    }

    void copyFields(Builder builder) {
        builder.validateFields();
        this.species = builder.species;
        this.subSpecies = builder.subSpecies;
        this.genus = builder.genus;
        System.arraycopy(builder.qualifiers, 0, this.qualifiers, 0, this.qualifiers.length);
        this.author = builder.author;
        this.year = builder.year;
        this.alphaCode = builder.alphaCode;
        this.audit = builder.audit;
        this.notes = builder.notes;
        this.reference = builder.reference;
        this.updatePublisher.setTaxonDetailsChanged();
    }

    void copyLinkImageSet() throws SQLException, SBException {
        if (this.link == null) {
            return;
        }
        if (this.imageType != null) {
            return;
        }
        assert (!this.sbdb.isConnected());
        assert (this.link.sbdb.isConnected());
        try {
            if (this.link.getImageType() != null) {
                this.imageType = new ImageSet(this.sbdb, this.link.imageType);
            }
        }
        catch (IOException ioe) {
            throw new SBException("Unexpected IO Exception", (Throwable)ioe);
        }
    }

    public void setAuthor(SBdb db, String author, int year) throws SQLException {
        if (db != null && this.specID > 0) {
            Audit tempAudit = new Audit(this.audit);
            Statement stmt = db.getDatabase().createStatement();
            Object sql = "UPDATE " + db.DBTableName("species") + " SET author=" + SB.DBString((String)author);
            sql = year > 0 ? (String)sql + ",year=" + year : (String)sql + ",year=NULL";
            sql = (String)sql + "," + tempAudit.sqlUpdate(db, stmt, false) + " WHERE spec_id=" + this.specID;
            sql = db.modQuery((String)sql);
            stmt.executeUpdate((String)sql);
            stmt.close();
            this.audit = tempAudit;
        }
        this.author = author;
        this.year = year;
        this.updatePublisher.setTaxonDetailsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAlphaCode(String alphaCode) throws SQLException {
        if (this.sbdb.isConnected()) {
            Audit tempAudit = new Audit(this.audit);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + this.sbdb.DBTableName("species") + " SET alphacode=" + SB.DBString((String)alphaCode) + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE spec_id=" + this.specID;
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
            this.audit = tempAudit;
        }
        this.alphaCode = alphaCode;
        this.updatePublisher.setTaxonDetailsChanged();
    }

    Date getSpeciesUpdated() {
        return this.audit.updated;
    }

    static PreparedStatement getFillSpeciesStatement(SBdb db) throws SQLException {
        Object sql = "SELECT gen_id,q1,species,q2,q3,sub_spec,q4,author,year,alphaCode," + Audit.sqlFieldString();
        sql = (String)sql + " FROM " + db.DBTableName("species") + " s WHERE spec_id=?";
        sql = db.modQuery((String)sql);
        PreparedStatement pStmt = db.getDatabase().prepareStatement((String)sql);
        return pStmt;
    }

    static int fillSpecies(int specID, PreparedStatement pStmt, Builder builder) throws SQLException {
        pStmt.setInt(1, specID);
        int genID = 0;
        ResultSet rs = pStmt.executeQuery();
        if (rs.next()) {
            genID = rs.getInt("gen_id");
            builder.qual(4, rs.getString("q1"));
            builder.species(rs.getString("species"));
            builder.qual(5, rs.getString("q2"));
            builder.qual(6, rs.getString("q3"));
            builder.subSpecies(rs.getString("sub_spec"));
            builder.qual(7, rs.getString("q4"));
            builder.author(rs.getString("author"));
            builder.year(rs.getInt("year"));
            builder.alphaCode(rs.getString("alphacode"));
            builder.audit(new Audit(rs));
        }
        return genID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getSipmCode(int dictionary) throws SQLException {
        if (this.sipmCode == null) {
            this.sipmCode = new HashMap();
            String sql = "SELECT ccode,sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int ccode = rs.getInt("ccode");
                    int code = rs.getInt("sipm_code");
                    this.sipmCode.put(ccode, code);
                }
            }
        }
        if (this.sipmCode.get(dictionary) == null) {
            String sql = "SELECT sipm_code FROM " + this.sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + this.specID + " AND ccode=" + dictionary;
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                if (rs.next()) {
                    int code = rs.getInt("SIPM_CODE");
                    this.sipmCode.put(dictionary, code);
                }
            }
        }
        return this.sipmCode.get(dictionary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCoOccurrences(SBdb sbdb, int donor, int target, int targetSpecType, int wellListID, int restrictToWellID) throws SBException, SQLException {
        if (wellListID > 0 && restrictToWellID > 0) {
            throw new IllegalArgumentException("Error in call to checkOccOccurrences - can't specify both well list and wellID");
        }
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT w.well_name,w.units,v.well_id,v.well_code,s.top_depth,s.base_depth,s.type,f1.samp_id,f1.analy_id,f1.ident_type,f1.status,f1.spec_type_id FROM " + sbdb.DBTableName("TAXONOCC") + " f1, " + sbdb.DBTableName("TAXONOCC") + " f2," + sbdb.DBTableName("WELLS") + " w," + sbdb.DBTableName("WELL_IDENT") + " v," + sbdb.DBTableName("SAMPLES") + " s ";
        if (wellListID > 0) {
            sql = sql + ", " + sbdb.DBTableName("SBWLMB") + " l ";
        }
        sql = sql + " WHERE  f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id AND f1.spec_id=" + donor + " AND f2.spec_id=" + target + " AND ((f1.status=f2.status) or (f1.status is null and f2.status is null))  AND f1.ident_type=f2.ident_type  AND f1.spec_type_id=f2.spec_type_id  AND f1.well_id=f2.well_id  AND f1.samp_id=s.samp_id AND f1.well_id=v.well_id AND v.well_id=s.well_id AND w.well_code=v.well_code";
        if (wellListID > 0) {
            sql = sql + " AND s.well_id = l.well_id AND l.id=" + wellListID;
        }
        if (restrictToWellID > 0) {
            sql = sql + " AND s.well_id=" + restrictToWellID;
        }
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            LinkedList<CoOccurrence> coOccurrences = new LinkedList<CoOccurrence>();
            String lastCode = "";
            while (rs.next()) {
                String wellName = rs.getString("well_name");
                char units = SB.getDBChar((ResultSet)rs, (String)"units");
                int wellID = rs.getInt("well_id");
                String wellCode = rs.getString("well_code");
                Object item = "";
                if (!wellCode.equals(lastCode)) {
                    item = wellName;
                    item = (String)item + "(";
                    item = (String)item + wellCode;
                    item = (String)item + ")";
                    item = (String)item + ", ";
                    lastCode = wellCode;
                } else {
                    item = (String)item + "  ...";
                }
                BigDecimal topDepth = SB.getBigDecimal((ResultSet)rs, (String)"top_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                BigDecimal baseDepth = SB.getBigDecimal((ResultSet)rs, (String)"base_depth", (sbdb.getDBType() == SBdb.DBType.SQLITE ? 1 : 0) != 0);
                if (topDepth != null) {
                    item = (String)item + SB.getDepthString((double)topDepth.doubleValue(), (char)units, (int)2);
                }
                if (baseDepth != null) {
                    if (topDepth != null) {
                        item = (String)item + "-";
                    }
                    item = (String)item + SB.getDepthString((double)baseDepth.doubleValue(), (char)units, (int)2);
                }
                item = (String)item + ", ";
                item = (String)item + rs.getString("type");
                item = (String)item + " (SampID=";
                int sampID = rs.getInt("samp_id");
                item = (String)item + sampID;
                item = (String)item + ")";
                int analyID = rs.getInt("analy_id");
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                boolean reworked = SB.getDBChar((ResultSet)rs, (String)"status") == 'R';
                int specType = rs.getInt("spec_type_id");
                CoOccurrence coOcc = new CoOccurrence();
                coOcc.wellID = wellID;
                coOcc.sampID = sampID;
                coOcc.analyID = analyID;
                coOcc.reason = item;
                coOcc.target = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(target), reworked, identType, specType);
                coOcc.donor = TaxonOcc.load(sbdb, wellID, sampID, analyID, sbdb.getTaxon(donor), reworked, identType, specType);
                coOccurrences.add(coOcc);
            }
            if (coOccurrences.size() > 0) {
                SBException e = new SBException("Cannot update/merge taxon (ID=" + donor + ", to ID=" + target + ") because it would create co-occurring data\nThe samples in which this happens are listed");
                e.setData(coOccurrences);
                throw e;
            }
        }
        finally {
            stmt.close();
        }
    }

    public void updateOccSpecType(int newSpecType) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "SELECT w.well_name,f1.well_id,f1.samp_id,f1.analy_id,f1.ident_type,f1.status,f1.spec_type_id FROM " + this.sbdb.DBTableName("TAXONOCC") + " f1, " + this.sbdb.DBTableName("TAXONOCC") + " f2," + this.sbdb.DBTableName("WELLS") + " w," + this.sbdb.DBTableName("WELL_IDENT") + " v WHERE  f1.well_id=f2.well_id AND f1.samp_id=f2.samp_id AND f1.analy_id=f2.analy_id AND f1.spec_id=" + this.specID + " AND f2.spec_id=" + this.specID + " AND ((f1.status=f2.status) or (f1.status is null and f2.status is null))  AND f1.ident_type=f2.ident_type  AND f1.spec_type_id<>f2.spec_type_id AND f1.well_id=v.well_id AND w.well_code=v.well_code";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            HashMap<CallSite, Integer> occs = new HashMap<CallSite, Integer>();
            while (rs.next()) {
                int wellID = rs.getInt("well_id");
                int sampID = rs.getInt("samp_id");
                int analyID = rs.getInt("analy_id");
                char identType = rs.getString("ident_type").charAt(0);
                char status = rs.getString("status").charAt(0);
                int specType = rs.getInt("spec_type_id");
                String wellName = rs.getString("well_name");
                String key = "" + wellID + sampID + analyID + identType + status;
                if (occs.get(key) != null) {
                    throw new SBException("Cannot update sub-type for '" + this + "' because it would cause conflicting occurrences in well " + wellName + ".");
                }
                occs.put((CallSite)((Object)key), specType);
            }
            sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET spec_type_id=" + newSpecType + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void loadAll(SBdb sbdb, Map<Integer, Taxon> set, Map<Integer, Genus> genera) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "SELECT gen_id,spec_id,q1,species,q2,q3,sub_spec,q4,author,year,alphacode," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("species") + " ORDER BY spec_id";
        try {
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                int genID = rs.getInt("gen_id");
                int specID = rs.getInt("spec_id");
                if (set.get(specID) != null) continue;
                Builder builder = new Builder();
                builder.genus(genera.get(genID));
                builder.qual(4, rs.getString("q1"));
                builder.species(SB.getDBString((ResultSet)rs, (String)"species"));
                builder.qual(5, rs.getString("q2"));
                builder.qual(6, rs.getString("q3"));
                builder.subSpecies(rs.getString("sub_spec"));
                builder.qual(7, rs.getString("q4"));
                builder.year(rs.getInt("year"));
                builder.alphaCode(rs.getString("alphaCode"));
                builder.audit(new Audit(rs));
                try {
                    Taxon t = builder.build(specID, sbdb);
                    set.put(t.specID, t);
                }
                catch (RuntimeException re) {
                    StackError.showStackError((String)"", (Exception)re);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    static boolean merge(SBdb sbdb, boolean checkCoOccurrences, int donor, int target, int targetSpecType, int retainJuniorSynonym) throws SBException, SQLException, SBPermissionException {
        if (checkCoOccurrences) {
            Taxon.checkCoOccurrences(sbdb, donor, target, targetSpecType, 0, 0);
        }
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            boolean bl;
            block43: {
                Statement stmt2 = sbdb.getDatabase().createStatement();
                try {
                    TxGroup g;
                    int grpID;
                    Object sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + target;
                    ResultSet rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        grpID = rs.getInt("grp_id");
                        sql = "DELETE FROM ";
                        sql = (String)sql + sbdb.DBTableName("GROUPMBR");
                        sql = (String)sql + " WHERE spec_id=" + donor;
                        sql = (String)sql + " AND grp_id=" + grpID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        g = sbdb.getTxGroup(grpID);
                        g.updateAudit();
                    }
                    sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        grpID = rs.getInt("grp_id");
                        g = sbdb.getTxGroup(grpID);
                        g.updateAudit();
                    }
                    sql = "UPDATE " + sbdb.DBTableName("GROUPMBR") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    int donorGenID = 0;
                    sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        donorGenID = rs.getInt("gen_id");
                    }
                    boolean deleteGenus = true;
                    sql = "SELECT gen_id FROM " + sbdb.DBTableName("species") + " WHERE gen_id=" + donorGenID + " AND spec_id <>" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    if (rs.next()) {
                        deleteGenus = false;
                    }
                    if (retainJuniorSynonym == 0 && deleteGenus) {
                        Genus genus = sbdb.getGenus(donorGenID);
                        ArrayList<Genus> genera = new ArrayList<Genus>();
                        genera.add(genus);
                        sql = "SELECT grp_id FROM " + sbdb.DBTableName("GROUPMBR_GENUS") + " WHERE gen_id=" + donorGenID;
                        rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                        while (rs.next()) {
                            grpID = rs.getInt("grp_id");
                            TxGroup g2 = sbdb.getTxGroup(grpID);
                            g2.deleteGenera(genera);
                            g2.updateAudit();
                        }
                    }
                    sql = "SELECT ovr_id FROM ";
                    sql = (String)sql + sbdb.DBTableName("OVR_MAP");
                    sql = (String)sql + " WHERE spec_id=" + target;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        int ovrID = rs.getInt("ovr_id");
                        sql = "DELETE FROM ";
                        sql = (String)sql + sbdb.DBTableName("OVR_MAP");
                        sql = (String)sql + " WHERE spec_id=" + donor;
                        sql = (String)sql + " AND ovr_id=" + ovrID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("OVR_MAP") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    if (retainJuniorSynonym == 0) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=" + donor + " AND pref=" + target;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=" + target + " AND pref=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    if (retainJuniorSynonym > 0) {
                        sql = "SELECT pref FROM ";
                        sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                        rs = stmt.executeQuery(sbdb.modQuery((String)(sql = (String)sql + " WHERE pref=" + target + " AND spec_id=" + donor + " AND sch_id=" + retainJuniorSynonym)));
                        if (!rs.next()) {
                            sql = "INSERT INTO ";
                            sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                            sql = (String)sql + " (sch_id, pref, spec_id) VALUES (" + retainJuniorSynonym + "," + target + "," + donor + ")";
                            stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        }
                    } else {
                        sql = "SELECT pref,sch_id FROM ";
                        sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                        sql = (String)sql + " WHERE spec_id=" + target;
                        rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                        while (rs.next()) {
                            int prefID = rs.getInt("pref");
                            int schID = rs.getInt("sch_id");
                            sql = "DELETE FROM ";
                            sql = (String)sql + sbdb.DBTableName("SYNONYMY");
                            sql = (String)sql + " WHERE spec_id=" + donor;
                            sql = (String)sql + " AND pref=" + prefID;
                            sql = (String)sql + " AND sch_id=" + schID;
                            stmt2.executeUpdate(sbdb.modQuery((String)sql));
                        }
                        sql = "UPDATE " + sbdb.DBTableName("SYNONYMY") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                        sql = "UPDATE " + sbdb.DBTableName("SYNONYMY") + " SET pref=" + target + " WHERE pref=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("SIPMCODE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    Audit.setServerDate(sbdb, stmt);
                    sql = "SELECT well_id, samp_id, analy_id FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + donor;
                    rs = stmt.executeQuery(sbdb.modQuery((String)sql));
                    while (rs.next()) {
                        int wellID = rs.getInt("well_id");
                        int sampID = rs.getInt("samp_id");
                        int analyID = rs.getInt("analy_id");
                        sql = "UPDATE " + sbdb.DBTableName("SMPDTL") + " SET updater=" + sbdb.getUser().getUsrID() + ",updated='" + SB.DBdtf.format(Audit.serverDate) + "' WHERE  well_id=" + wellID + " AND samp_id=" + sampID + " AND analy_id=" + analyID;
                        stmt2.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    stmt2.close();
                    sql = "UPDATE " + sbdb.DBTableName("TAXONOCC") + " SET spec_id=" + target;
                    if (targetSpecType > -1) {
                        sql = (String)sql + ",spec_type_id=" + targetSpecType;
                    }
                    sql = (String)sql + " WHERE spec_id=" + donor;
                    System.out.println("SQL: " + sbdb.modQuery((String)sql));
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXLOAD") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXDEPTH") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXDEPTH") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXNOTES") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXREFS") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    sql = "UPDATE " + sbdb.DBTableName("TXIMAGE") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                    stmt.executeUpdate(sbdb.modQuery((String)sql));
                    try {
                        sql = "UPDATE " + sbdb.DBTableName("TXURL") + " SET spec_id=" + target + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    catch (SQLException ex) {
                        sql = "DELETE FROM " + sbdb.DBTableName("TXURL") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                    }
                    if (retainJuniorSynonym == 0) {
                        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=" + donor;
                        stmt.executeUpdate(sbdb.modQuery((String)sql));
                        if (deleteGenus) {
                            sql = "DELETE FROM " + sbdb.DBTableName("groupmbr_genus") + " WHERE gen_id=" + donorGenID;
                            sql = "DELETE FROM " + sbdb.DBTableName("genus") + " WHERE gen_id=" + donorGenID;
                            stmt.executeUpdate(sbdb.modQuery((String)sql));
                        }
                    }
                    boolean bl2 = bl = deleteGenus && retainJuniorSynonym == 0;
                    if (stmt2 == null) break block43;
                }
                catch (Throwable throwable) {
                    if (stmt2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt2.close();
            }
            return bl;
        }
    }

    public int checkNSpeciesOfGenus() throws SQLException {
        if (this.sbdb == null) {
            throw new IllegalStateException("database reference null in checkNspecies");
        }
        if (this.genus == null) {
            throw new IllegalStateException("Genus ID zero in checkNspecies");
        }
        return this.genus.checkNSpecies(this.sbdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(SBdb sbdb, Builder builder) throws SQLException, SBPermissionException {
        if (sbdb.isConnected() && !SBRestrictable.canWrite(sbdb)) {
            throw new SBPermissionException("No permission to edit taxon");
        }
        if (sbdb.isConnected()) {
            Statement stmt = sbdb.getDatabase().createStatement();
            String sql = "UPDATE " + sbdb.DBTableName("species") + " SET gen_id=" + builder.genus.getGenID() + ",q1=" + SB.DBString((String)builder.qualifiers[0].toString(null)) + ",q2=" + SB.DBString((String)builder.qualifiers[1].toString(null)) + ",q3=" + SB.DBString((String)builder.qualifiers[2].toString(null)) + ",q4=" + SB.DBString((String)builder.qualifiers[3].toString(null)) + ",species=" + SB.DBString((String)builder.species) + ",sub_spec=" + SB.DBString((String)builder.subSpecies) + ",author=" + SB.DBString((String)builder.author);
            sql = builder.year > 0 ? sql + ",year=" + builder.year : sql + ",year=NULL";
            sql = sql + ",alphacode=" + SB.DBString((String)builder.alphaCode) + "," + builder.audit.sqlUpdate(this.sbdb, stmt, false) + " WHERE spec_id=" + this.specID;
            try {
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            finally {
                stmt.close();
            }
        }
        this.copyFields(builder);
    }

    public int checkOcc(boolean withSpecType) throws SQLException {
        if (this.specID < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        Object sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID;
        if (withSpecType) {
            sql = (String)sql + " AND spec_type_id > 0";
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        return nSpecies;
    }

    public int checkOcc(int specTypeID) throws SQLException {
        if (this.specID < 1) {
            return 0;
        }
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkOcc()");
        }
        int nSpecies = 0;
        Object sql = "SELECT count(spec_id) as nspecies FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID + " AND spec_type_id=" + specTypeID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nSpecies += rs.getInt("nspecies");
            }
        }
        return nSpecies;
    }

    public int checkGroupOcc() throws SQLException {
        if (this.sbdb == null) {
            throw new IllegalStateException("Database reference not initialised in taxon.checkGroupOcc()");
        }
        int nGroups = 0;
        Object sql = "SELECT count(grp_id) as ngroup FROM ";
        sql = (String)sql + this.sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=" + this.specID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            if (rs.next()) {
                nGroups += rs.getInt("ngroup");
            }
        }
        return nGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDB(SBdb sbdb) throws SQLException {
        Statement stmt = sbdb.getDatabase().createStatement();
        String sql = "INSERT INTO " + sbdb.DBTableName("species") + " ( gen_id, species, spec_id ";
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + ",q1";
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + ",q2";
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + ",q3";
        }
        if (!this.subSpecies.isEmpty()) {
            sql = sql + ",sub_spec";
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + ",q4";
        }
        if (!this.author.isEmpty()) {
            sql = sql + ",author";
        }
        if (this.year > 0) {
            sql = sql + ",year";
        }
        if (!this.alphaCode.isEmpty()) {
            sql = sql + ",alphacode";
        }
        sql = sql + "," + Audit.sqlFieldString();
        sql = sql + ") VALUES (" + this.genus.getGenID() + "," + SB.DBString((String)this.species) + "," + this.specID;
        if (this.qualifiers[0].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[0].toString(null));
        }
        if (this.qualifiers[1].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[1].toString(null));
        }
        if (this.qualifiers[2].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[2].toString(null));
        }
        if (!this.subSpecies.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.subSpecies);
        }
        if (this.qualifiers[3].hasQuals()) {
            sql = sql + "," + SB.DBString((String)this.qualifiers[3].toString(null));
        }
        if (!this.author.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.author);
        }
        if (this.year > 0) {
            sql = sql + "," + this.year;
        }
        if (!this.alphaCode.isEmpty()) {
            sql = sql + "," + SB.DBString((String)this.alphaCode);
        }
        sql = sql + "," + this.audit.sqlInsert(sbdb, stmt) + ")";
        try {
            stmt.executeUpdate(sbdb.modQuery(sql));
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateNoteRefs(String notes, String reference, String url) throws SQLException {
        String sql = "DELETE FROM " + this.sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (!notes.isEmpty()) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXNOTES") + " (spec_id,notes) VALUES (" + this.specID + "," + SB.DBString((String)notes) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (!reference.isEmpty()) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXREFS") + " (spec_id,reference) VALUES (" + this.specID + "," + SB.DBString((String)reference) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("TXURL") + " WHERE spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (!url.isEmpty()) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("TXURL") + " (spec_id,url) VALUES (" + this.specID + "," + SB.DBString((String)url) + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        this.notes = notes;
        this.reference = reference;
        this.url = url;
    }

    public void setReference(String source, String reference) {
        if (this.reference == null || this.reference.isEmpty()) {
            this.reference = source != null ? "<html><strong>" + source + "</strong>: " + reference + "</html>" : reference;
        }
    }

    void clean(boolean convertSpeciesCase, Boolean spSpp) {
        if (convertSpeciesCase) {
            this.species = Taxon.toSpeciesCase(this.species);
            this.subSpecies = Taxon.toSpeciesCase(this.subSpecies);
        }
        if (spSpp.booleanValue()) {
            if ((this.species.equals("sp") || this.species.equals("sp.")) && this.subSpecies.isEmpty()) {
                this.species = "spp.";
            }
            if (this.species.equals("spp")) {
                this.species = "spp.";
            }
        } else {
            if (this.species.equals("sp") && this.subSpecies.isEmpty()) {
                this.species = "sp.";
            }
            if (this.species.equals("spp")) {
                this.species = "spp.";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List lookupSpecies(SBdb sbdb, String catMnem, String genus, String species) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String sql = "SELECT s.species, s.sub_spec FROM " + sbdb.DBTableName("GENUS") + " g," + sbdb.DBTableName("SPECIES") + " s WHERE ";
        if (!catMnem.isEmpty()) {
            sql = sql + "g.cat_mnem='" + catMnem + "' AND ";
        }
        if (!genus.isEmpty()) {
            sql = sql + " ucase(g.genus)='" + genus.toUpperCase() + "' AND ";
        }
        if (!species.isEmpty()) {
            sql = sql + " ucase(s.species) like '" + species.toUpperCase() + "%' AND";
        }
        sql = sql + " g.gen_id=s.gen_id ORDER by species";
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                Object item = rs.getString("species");
                String subSpec = rs.getString("sub_spec");
                if (subSpec != null && subSpec.length() > 0) {
                    item = (String)item + " subsp. " + subSpec;
                }
                list.add((String)item);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadNotesAndRefs(Statement dbStmt) throws SQLException {
        if (this.notes != null && this.reference != null && this.url != null) {
            return;
        }
        if (this.sbdb.isConnected()) {
            Statement stmt = null;
            try {
                stmt = dbStmt != null ? dbStmt : this.sbdb.getDatabase().createStatement();
                String sql = "SELECT notes FROM " + this.sbdb.DBTableName("TXNOTES") + " WHERE spec_id=" + this.specID;
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                this.notes = rs.next() ? rs.getString("notes") : "";
                sql = "SELECT reference FROM " + this.sbdb.DBTableName("TXREFS") + " WHERE spec_id=" + this.specID;
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                this.reference = rs.next() ? rs.getString("reference") : "";
                sql = "SELECT url FROM " + this.sbdb.DBTableName("TXURL") + " WHERE spec_id=" + this.specID;
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                this.url = rs.next() ? rs.getString("url") : "";
            }
            finally {
                if (dbStmt == null) {
                    stmt.close();
                }
            }
        } else {
            this.notes = "";
            this.reference = "";
            this.url = "";
        }
    }

    public Discipline getDisc() {
        return this.genus.getDisc();
    }

    static Taxon[] load(SBdb sbdb, Statement stmt, Genus g, String species, String subSpecies, Qualifier sq1, Qualifier sq2, Qualifier sq3, Qualifier sq4) throws SQLException {
        String sql = "SELECT spec_id, species, q1, q2, q3, sub_spec, q4, author, year, alphacode," + Audit.sqlFieldString() + " FROM " + sbdb.DBTableName("SPECIES");
        sql = sql + " WHERE (species=" + SB.DBString((String)species) + " OR ucase(species)=" + SB.DBString((String)species.toUpperCase()) + ") AND gen_id=" + g.getGenID();
        if (sq1 != null) {
            sql = sq1.hasQuals() ? sql + " AND lcase(q1)='" + sq1 + "'" : sql + " AND (q1 IS NULL or q1='')";
        }
        if (sq2 != null) {
            sql = sq2.hasQuals() ? sql + " AND lcase(q2)='" + sq2 + "'" : sql + " AND (q2 IS NULL or q2='')";
        }
        if (sq3 != null) {
            sql = sq3.hasQuals() ? sql + " AND lcase(q3)='" + sq3 + "'" : sql + " AND (q3 IS NULL or q3='')";
        }
        if (subSpecies != null) {
            sql = !subSpecies.isEmpty() ? sql + " AND ucase(sub_spec)=" + SB.DBString((String)subSpecies.toUpperCase()) : sql + " AND (sub_spec IS NULL or sub_spec='')";
        }
        if (sq4 != null) {
            sql = sq4.hasQuals() ? sql + " AND lcase(q4)='" + sq4 + "'" : sql + " AND (q4 IS NULL or q4='')";
        }
        LinkedList<Taxon> results = new LinkedList<Taxon>();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        while (rs.next()) {
            Builder builder = new Builder();
            int specID = rs.getInt("spec_id");
            builder.genus(g);
            builder.species(rs.getString("species"));
            builder.qual(4, rs.getString("q1"));
            builder.qual(5, rs.getString("q2"));
            builder.qual(6, rs.getString("q3"));
            builder.subSpecies(rs.getString("sub_spec"));
            builder.qual(7, rs.getString("q4"));
            builder.author(rs.getString("author"));
            builder.year(rs.getInt("year"));
            builder.alphaCode(rs.getString("alphacode"));
            results.add(builder.build(specID, sbdb));
        }
        if (!results.isEmpty()) {
            return results.toArray(new Taxon[results.size()]);
        }
        return null;
    }

    public String statusString() {
        return this.toString(true, false, true);
    }

    public String toString() {
        return this.toString(includeAuthorInString, includeAlphaInString, includeCategoryInString);
    }

    public AttributedString toAttributedString(boolean useAuthor, boolean includeCat) {
        return this.toAttributedString(true, useAuthor, includeCat, null, null);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean useAuthor, boolean includeCat, Integer synschID) {
        return this.toAttributedString(useItalics, useAuthor, includeCat, null, synschID);
    }

    public AttributedString toAttributedString(boolean useItalics, boolean useAuthor, boolean includeCat, String suffix, Integer synschID) {
        LinkedList<Integer> italicsPos = new LinkedList<Integer>();
        Object string = this.toString(useAuthor, includeCat, useItalics ? italicsPos : null, false);
        if (suffix != null) {
            string = (String)string + suffix;
        }
        if (synschID != null) {
            try {
                Taxon pref = this.getPreferred(synschID);
                if (pref != null) {
                    LinkedList<Integer> italicsPos2 = new LinkedList<Integer>();
                    String prefString = pref.toString(useAuthor, includeCat, useItalics ? italicsPos2 : null, false);
                    string = (String)string + "  (";
                    for (Integer i : italicsPos2) {
                        italicsPos.add(i + ((String)string).length());
                    }
                    string = (String)string + prefString + ")";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AttributedString ats = new AttributedString((String)string);
        Iterator it = italicsPos.iterator();
        while (it.hasNext()) {
            ats.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, (Integer)it.next(), (Integer)it.next());
        }
        return ats;
    }

    public String toQuotedString(boolean useAuthor, boolean useSynonymy, SynonymScheme sch) throws SQLException, SBException {
        Object strg;
        if (useSynonymy && sch != null && sch.getPref(this.specID) > 0) {
            Taxon pref = this.sbdb.getTaxon(sch.getPref(this.specID));
            if (pref != null) {
                strg = pref.toString(useAuthor, false, null, true);
            } else {
                System.out.println("Problem getting preferred taxon term for: " + this);
                strg = this.toString(useAuthor, false, null, true);
            }
        } else {
            strg = this.toString(useAuthor, false, null, true);
        }
        if (((String)strg).indexOf(44) >= 0) {
            if (((String)strg).indexOf(34) >= 0) {
                strg = ((String)strg).replace('\"', '\'');
            }
            strg = "\"" + (String)strg + "\"";
        }
        return strg;
    }

    public String toStringWithSynonym(boolean useAuthor, boolean useSynonymy, SynonymScheme sch) throws SQLException, SBException {
        String strg;
        if (useSynonymy && sch != null && sch.getPref(this.specID) > 0) {
            Taxon pref = this.sbdb.getTaxon(sch.getPref(this.specID));
            if (pref != null) {
                strg = pref.toString(useAuthor, false, null, true);
            } else {
                System.out.println("Problem getting preferred taxon term for: " + this);
                strg = this.toString(useAuthor, false, null, true);
            }
        } else {
            strg = this.toString(useAuthor, false, null, true);
        }
        return strg;
    }

    public String toString(boolean useAuthor, boolean useAlphaCode, boolean includeCat) {
        Object name = this.toString(useAuthor, includeCat, null, false);
        if (useAlphaCode && this.alphaCode != null && this.alphaCode.length() > 0) {
            name = (String)name + " (" + this.alphaCode + ")";
        }
        return name;
    }

    public String toString(boolean useAuthor) {
        return this.toString(useAuthor, false, true);
    }

    public String toString(boolean useAuthor, boolean includeCat) {
        return this.toString(useAuthor, false, includeCat);
    }

    public String toGenString(boolean abr, boolean includeCat) {
        if (!abr) {
            return this.toString(false, includeCat, null, false);
        }
        Object strg = "";
        if (includeCat) {
            strg = this.getCatMnem();
            while (((String)strg).length() < 6) {
                strg = (String)strg + " ";
            }
        }
        Object genString = !this.genus.getGenus().isEmpty() && !Character.isUpperCase(this.genus.getGenus().charAt(0)) || this.isUndifferentiated() == 1 ? this.getGenusName() : this.getGenusName().charAt(0) + ".";
        return (String)strg + (String)genString + " " + this.toSpeciesString(false, null, false);
    }

    int isUndifferentiated() {
        if (this.species.equals("spp.") || this.species.startsWith("sp. ") || this.species.equals("fragments") || this.species.equals("group") || this.species.equals(".") || this.species.startsWith("indet") || this.species.startsWith("undiff")) {
            return 1;
        }
        return 0;
    }

    private String toString(boolean useAuthor, boolean includeCat, List<Integer> italics, boolean includeDotSpecName) {
        Object name = this.genus.toString(includeCat, italics);
        LinkedList<Integer> spItalics = null;
        if (italics != null) {
            spItalics = new LinkedList<Integer>();
        }
        int genusNameLen = ((String)name).length() + 1;
        name = (String)name + " " + this.toSpeciesString(useAuthor, spItalics, includeDotSpecName);
        if (spItalics != null) {
            for (Integer i : spItalics) {
                italics.add(i + genusNameLen);
            }
        }
        return name;
    }

    private String toSpeciesString(boolean useAuthor, List<Integer> italics, boolean includeDotSpecName) {
        boolean italicsFlag = false;
        Object name = "";
        if (!(this.species.isEmpty() || !includeDotSpecName && this.species.equals("."))) {
            if (this.qualifiers[0].hasQuals()) {
                name = (String)name + this.qualifiers[0].toString(true);
            }
            if (!this.species.startsWith("sp.") && !this.species.startsWith("spp.") && italics != null) {
                italics.add(((String)name).length());
                italicsFlag = true;
            }
            name = (String)name + this.species;
            if (italicsFlag && italics != null) {
                italics.add(((String)name).length());
            }
            if (this.qualifiers[1].hasQuals()) {
                name = (String)name + this.qualifiers[1].toString(false);
            }
        }
        name = ((String)name).trim();
        if (this.qualifiers[2].hasQuals()) {
            name = (String)name + " " + this.qualifiers[2].toString(true);
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            if (italicsFlag && this.qualifiers[1].hasQual(TaxonQual.SENSU)) {
                italicsFlag = false;
            }
            if (italicsFlag && italics != null) {
                italics.add(((String)name).length());
            }
            if (!this.qualifiers[2].hasQuals()) {
                name = (String)name + " ";
            }
            name = (String)name + this.subSpecies;
            if (italicsFlag && italics != null) {
                italics.add(((String)name).length());
            }
        }
        if (this.qualifiers[3].hasQuals()) {
            name = (String)name + this.qualifiers[3].toString(false);
        }
        if (((String)(name = (String)name + this.getAuthorString(useAuthor))).isEmpty() && !this.species.equals(".") && this.donorString != null && this.donorString.length() > 0) {
            name = this.donorString;
        }
        return ((String)name).trim();
    }

    public String getAuthorString(boolean useAuthor) {
        Object name = "";
        if (useAuthor || this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.subSpecies.isEmpty() || this.qualifiers[3].hasQual(TaxonQual.SENSU)) {
            if (this.author != null && !this.author.isEmpty()) {
                name = (String)name + " " + this.author;
            }
            if (this.year != 0) {
                name = (String)name + ", " + String.valueOf(this.year);
            }
        }
        return name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != Taxon.class) {
            return false;
        }
        return ((Taxon)o).specID == this.specID && ((Taxon)o).sbdb == this.sbdb;
    }

    public int compareTo(Object rhs) {
        return this.compareTo((Taxon)rhs);
    }

    public int compareTo(Taxon rhs) {
        int result = 0;
        result = this.getGenusName().compareToIgnoreCase(rhs.getGenusName());
        if (result != 0) {
            return result;
        }
        if (!this.getSubGenus().isEmpty() && (result = this.getSubGenus().compareToIgnoreCase(rhs.getSubGenus())) != 0) {
            return result;
        }
        result = this.species.compareToIgnoreCase(rhs.species);
        if (result != 0) {
            return result;
        }
        result = this.subSpecies.compareToIgnoreCase(rhs.subSpecies);
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ1().toString().compareTo(rhs.genus.getQ1().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ2().toString().compareTo(rhs.genus.getQ2().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ3().toString().compareTo(rhs.genus.getQ3().toString());
        if (result != 0) {
            return result;
        }
        result = this.genus.getQ4().toString().compareTo(rhs.genus.getQ4().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ1().toString().compareTo(rhs.getQ1().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ2().toString().compareTo(rhs.getQ2().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ3().toString().compareTo(rhs.getQ3().toString());
        if (result != 0) {
            return result;
        }
        result = this.getQ4().toString().compareTo(rhs.getQ4().toString());
        if (result != 0) {
            return result;
        }
        result = this.getCatMnem().compareToIgnoreCase(rhs.getCatMnem());
        return result;
    }

    public int hashCode() {
        return this.specID;
    }

    public void setFssOccType(TaxonOcc fss) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to set occurrence type in connected workspace");
        }
        if (this.donorOccType != null && !this.donorOccType.isEmpty()) {
            if (this.donorOccType.equalsIgnoreCase(REWORKED_OCC)) {
                fss.setReworked(true, false);
            } else if (this.donorOccType.equalsIgnoreCase(CAVED_OCC)) {
                fss.setCaved(true, false);
            } else if (this.donorOccType.equalsIgnoreCase(QUESTIONABLE_OCC)) {
                fss.setIdentType('?', false);
            } else {
                try {
                    Object existing = "";
                    if (fss.getSpecType() > 0 && !((String)(existing = (String)existing + fss.getSpecTypeString())).isEmpty()) {
                        existing = (String)existing + "/";
                    }
                    int specType = this.sbdb.getAddSpecType((String)existing + this.donorOccType);
                    fss.setSpecType(specType);
                }
                catch (SQLException sql) {
                    throw new RuntimeException("Unexpected SQLException in workspace", sql);
                }
            }
        }
    }

    public void writeDEX(FileWriter out, String eol, boolean usePreferredTerm, int synScheme) throws IOException, SQLException, SBException {
        Taxon taxon;
        if (usePreferredTerm && (taxon = this.getPreferred(synScheme)) != null) {
            taxon.writeDEX(out, eol, usePreferredTerm, synScheme);
            return;
        }
        out.write("Species = " + this.toString(true, false, false) + eol);
        out.write("   ID : " + this.getSpecID() + eol);
        this.genus.writeDEX(out, eol);
        if (this.getQ1().hasQuals()) {
            out.write("   Pre-Species qualifier : " + this.getQ1().toString() + eol);
        }
        out.write("   Species : " + this.species + eol);
        if (this.getQ2().hasQuals()) {
            out.write("   Post-Species qualifier : " + this.getQ2().toString() + eol);
        }
        if (this.getQ3().hasQuals()) {
            out.write("   Pre-Subspecies qualifier : " + this.getQ3().toString() + eol);
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            out.write("   Subspecies : " + this.subSpecies + eol);
        }
        if (this.getQ4().hasQuals()) {
            out.write("   Post-Subspecies qualifier : " + this.getQ4().toString() + eol);
        }
        if (this.author != null && this.author.length() > 0) {
            out.write("   Author : " + this.author + eol);
        }
        if (this.year > 0) {
            out.write("   Year : " + this.year + eol);
        }
        if (this.alphaCode != null && this.alphaCode.length() > 0) {
            out.write("   Alphanumeric Code : " + this.alphaCode + eol);
        }
        out.write(eol);
    }

    @Deprecated
    public void writeSbugs(FileWriter out) throws IOException {
        out.write(String.valueOf(this.specID) + "\t" + this.toString() + "\n");
        out.write(this.getCatMnem() + "\t" + this.genus.getQ1().toString(true) + "\t" + this.getGenusName() + "\t" + this.genus.getQ2().toString(false) + "\t" + this.genus.getQ3().toString(true) + "\t" + this.getSubGenus() + "\t" + this.genus.getQ4().toString(false) + "\t" + this.getQ1().toString() + "\t" + this.species + "\t" + this.getQ2().toString() + "\t" + this.getQ3().toString() + "\t" + this.subSpecies + "\t" + this.getQ4().toString() + "\t" + this.author + "\t");
        if (this.year > 0) {
            out.write(this.year);
        }
        out.write("\t\n");
    }

    public void writeXMLSpecies(BufferedWriter out, int indent) throws IOException, SQLException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        if (this.specID > 0) {
            out.write((String)ind + "<SpeciesID>" + this.specID + "</SpeciesID>\n");
        }
        if (this.getQ1().hasQuals()) {
            out.write((String)ind);
            out.write("<SQ1>");
            out.write(this.getQ1().toString());
            out.write("</SQ1>\n");
        }
        out.write((String)ind);
        out.write("<Species>");
        out.write(SB.getXMLstring((String)this.species));
        out.write("</Species>\n");
        if (this.getQ2().hasQuals()) {
            out.write((String)ind);
            out.write("<SQ2>");
            out.write(this.getQ2().toString());
            out.write("</SQ2>\n");
        }
        if (this.getQ3().hasQuals()) {
            out.write((String)ind);
            out.write("<SQ3>");
            out.write(this.getQ3().toString());
            out.write("</SQ3>\n");
        }
        if (this.subSpecies != null && this.subSpecies.length() > 0) {
            out.write((String)ind);
            out.write("<SubSpecies>");
            out.write(SB.getXMLstring((String)this.subSpecies));
            out.write("</SubSpecies>\n");
        }
        if (this.getQ4().hasQuals()) {
            out.write((String)ind);
            out.write("<SQ4>");
            out.write(this.getQ4().toString());
            out.write("</SQ4>\n");
        }
        if (this.author != null && this.author.length() > 0) {
            out.write((String)ind);
            out.write("<Author>");
            out.write(SB.getXMLstring((String)this.author));
            out.write("</Author>\n");
        }
        if (this.year > 0) {
            out.write((String)ind);
            out.write("<Year>");
            out.write(String.valueOf(this.year));
            out.write("</Year>\n");
        }
        if (this.alphaCode != null && this.alphaCode.length() > 0) {
            out.write((String)ind);
            out.write("<Alphacode>");
            out.write(SB.getXMLstring((String)this.alphaCode));
            out.write("</Alphacode>\n");
        }
        if (this.reference != null && this.reference.length() > 0) {
            out.write((String)ind);
            out.write("<Reference>");
            out.write(SB.getXMLstring((String)this.reference));
            out.write("</Reference>\n");
        }
        if (this.notes != null && this.notes.length() > 0) {
            out.write((String)ind);
            out.write("<Notes>");
            out.write(SB.getXMLstring((String)this.notes));
            out.write("</Notes>\n");
        }
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        assert (!this.sbdb.isConnected());
        this.genus.writeXML(out, indent, files);
        this.writeXMLSpecies(out, indent);
        if (this.imageType != null) {
            if (exportImages == null) {
                exportImages = JOptionPane.showConfirmDialog(null, "Export taxon images for type specimens?", "Export Type Images", 0) == 0;
            }
            if (exportImages.booleanValue()) {
                Object ind = new String();
                while (((String)ind).length() < indent) {
                    ind = (String)ind + " ";
                }
                this.imageType.writeXML(out, (String)ind, files, true);
            }
        }
    }

    public void storeSipmCode(int dictionary, Integer code) throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException("Insufficient privilege to update taxon numeric code");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT COUNT(*) FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND sipm_code=" + code + " AND spec_id<>" + this.specID;
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                int count = rs.getInt(1);
                if (count <= 0) continue;
                throw new SBException("SIPM code is not unique to dictionary");
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("sipmcode") + " WHERE ccode=" + dictionary + " AND spec_id=" + this.specID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            if (code != null) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("sipmcode") + "(spec_ID,ccode,sipm_code) VALUES (" + this.specID + "," + dictionary + "," + code + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
        }
        if (this.sipmCode != null) {
            this.sipmCode.remove(dictionary);
        } else {
            this.sipmCode = new HashMap();
        }
        if (code != null) {
            this.sipmCode.put(dictionary, code);
        }
    }

    public Taxon getPreferred(int synSch) throws SQLException, SBException {
        if (this.specID > 0) {
            return this.sbdb.getPreferredTerm(synSch, this.specID);
        }
        return null;
    }

    public String getPrefString(int synSch) throws SQLException, SBException {
        if (this.specID > 0) {
            Taxon t = this.sbdb.getPreferredTerm(synSch, this.specID);
            if (t != null) {
                return t.toString();
            }
            List<Taxon> syns = this.sbdb.getSynonymy(synSch, this.specID);
            String s = null;
            for (Taxon syn : syns) {
                s = (String)(s == null ? "(" : (String)s + ",") + syn.toString();
            }
            if (s != null) {
                s = s + ")";
            }
            return s;
        }
        return null;
    }

    public boolean hasEvents() throws SQLException {
        String sql = "SELECT count(spec_id) AS total FROM " + this.sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=" + this.specID;
        int nRows = 0;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            if (rs.next()) {
                nRows = rs.getInt("total");
            }
        }
        return nRows > 0;
    }

    public void getStats(int[] stats) throws SQLException {
        String sql = "SELECT status,ident_type,caved FROM " + this.sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=" + this.specID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            for (int i = 0; i < stats.length; ++i) {
                stats[i] = 0;
            }
            while (rs.next()) {
                char status = SB.getDBChar((ResultSet)rs, (String)"status");
                char identType = SB.getDBChar((ResultSet)rs, (String)"ident_type");
                char caved = SB.getDBChar((ResultSet)rs, (String)"caved");
                stats[0] = stats[0] + 1;
                if (status == 'R') {
                    stats[2] = stats[2] + 1;
                } else {
                    stats[1] = stats[1] + 1;
                }
                if (identType == '?') {
                    stats[4] = stats[4] + 1;
                } else {
                    stats[3] = stats[3] + 1;
                }
                if (caved == 'Y') {
                    stats[5] = stats[5] + 1;
                    continue;
                }
                stats[6] = stats[6] + 1;
            }
        }
    }

    public int updateOcc(String field, char value) throws SQLException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        String sql = "UPDATE " + this.sbdb.DBTableName("TAXONOCC") + " SET " + field + "='" + value + "' WHERE spec_id=" + this.specID;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            int nUpdated;
            int n = nUpdated = stmt.executeUpdate(this.sbdb.modQuery(sql));
            return n;
        }
    }

    void storeMatch(String sourceID, String donorString, String donorOccType, SBdb db) throws SQLException {
        try (Statement stmt = db.getDatabase().createStatement();){
            String sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND ucase(txt)=" + SB.DBString((String)donorString.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5'));
            int nRows = stmt.executeUpdate(db.modQuery(sql));
            if (nRows == 0) {
                sql = "DELETE FROM " + db.DBTableName("TXLOAD") + " WHERE source_id='" + sourceID + "' AND txt=" + SB.DBString((String)donorString);
                stmt.executeUpdate(db.modQuery(sql));
            }
            if (this.link != null && (!donorString.equals(this.link.toString(false, false, null, true)) || !this.link.getCatMnem().equals(this.getCatMnem()) || Taxon.containsQualifier(donorString) || !this.link.getSubGenus().isEmpty() || this.link.subSpecies != null && this.link.subSpecies.length() > 0)) {
                sql = "INSERT INTO " + db.DBTableName("TXLOAD") + " (source_id,spec_id,txt,occ_type";
                sql = sql + ") VALUES('" + sourceID + "'," + this.link.specID + "," + SB.DBString((String)donorString);
                sql = sql + "," + SB.DBString((String)donorOccType);
                sql = sql + ")";
                stmt.executeUpdate(db.modQuery(sql));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void deleteSpecies(SBdb sbdb, Collection<Integer> specIDs, boolean delFss, ProgressBarMonitor prog) throws SQLException {
        PreparedStatement[] pStmt = new PreparedStatement[14];
        int n = 0;
        String sql = "DELETE FROM " + sbdb.DBTableName("TAXONOCC") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("EVENTDIC") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("GROUPMBR") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXIMAGE") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("OVR_MAP") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SIPMCODE") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SYNONYMY") + " WHERE pref=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXDEPTH") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXLOAD") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXNOTES") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXREFS") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("TXURL") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        sql = "DELETE FROM " + sbdb.DBTableName("SPECIES") + " WHERE spec_id=?";
        pStmt[n++] = sbdb.getDatabase().prepareStatement(sbdb.modQuery(sql));
        if (prog != null) {
            prog.getProgressBar().setMinimum(0);
            prog.getProgressBar().setMaximum(specIDs.size());
        }
        int i = 0;
        Iterator<Integer> it = specIDs.iterator();
        try {
            while (it.hasNext()) {
                int specID = it.next();
                System.out.println("Deleting species: " + specID);
                int n2 = n = delFss ? 0 : 1;
                while (n < pStmt.length) {
                    pStmt[n].setInt(1, specID);
                    pStmt[n].execute();
                    ++n;
                }
                if (prog == null) continue;
                if (prog.getInterrupt()) {
                    return;
                }
                prog.getProgressBar().setValue(i++);
            }
            return;
        }
        finally {
            n = 0;
            while (true) {
                if (n >= pStmt.length) {
                }
                pStmt[n].close();
                ++n;
            }
        }
    }

    public static List<Taxon> search(SBdb SB2, Discipline disc, String catMnem, boolean includeSubCategories, String genus, String subGenus, String species, String subSpecies, String alphaCode, String gq1, String gq2, String gq3, String gq4, String sq1, String sq2, String sq3, String sq4) throws SQLException, SBException {
        LinkedList<Taxon> resultList;
        Object sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s ";
        if (disc != null) {
            sql = (String)sql + ", " + SB2.DBTableName("category") + " c ";
        }
        sql = (String)sql + "WHERE s.gen_id=g.gen_id AND ";
        sql = (String)sql + Genus.getSearchString(SB2, disc, catMnem, includeSubCategories, genus.trim(), subGenus.trim());
        String text = species.trim().toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5');
        if (text.length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "(ucase(s.species) like '" + text + "' OR ucase(s.species) like '(" + text + "')" : (String)sql + "ucase(s.species)='" + text + "'";
        }
        if ((text = subSpecies.toUpperCase().replace(Character.toUpperCase('\u00b5'), '\u00b5')).length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "(ucase(s.sub_spec) like '" + text + "' OR ucase(s.sub_spec) like '(" + text + "')" : (String)sql + "ucase(s.sub_spec)='" + text + "'";
        }
        if ((text = alphaCode.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (((String)sql).lastIndexOf("AND ") != ((String)sql).length() - 4) {
                sql = (String)sql + " AND ";
            }
            sql = text.indexOf(37) >= 0 ? (String)sql + "ucase(s.alphaCode) like '" + text + "'" : (String)sql + "ucase(s.alphaCode)='" + text + "'";
        }
        if (((String)(sql = ((String)sql).trim())).endsWith("AND")) {
            sql = ((String)sql).substring(0, ((String)sql).length() - 4);
        }
        try (Statement stmt = SB2.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(SB2.modQuery((String)sql));
            resultList = new LinkedList<Taxon>();
            while (rs.next()) {
                Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
                boolean toAdd = true;
                if (gq1 != null && !taxon.getQualifier(0).toString().equalsIgnoreCase(gq1)) {
                    toAdd = false;
                }
                if (gq2 != null && !taxon.getQualifier(1).toString().equalsIgnoreCase(gq2)) {
                    toAdd = false;
                }
                if (gq3 != null && !taxon.getQualifier(2).toString().equalsIgnoreCase(gq3)) {
                    toAdd = false;
                }
                if (gq4 != null && !taxon.getQualifier(3).toString().equalsIgnoreCase(gq4)) {
                    toAdd = false;
                }
                if (sq1 != null && !taxon.getQualifier(4).toString().equalsIgnoreCase(sq1)) {
                    toAdd = false;
                }
                if (sq2 != null && !taxon.getQualifier(5).toString().equalsIgnoreCase(sq2)) {
                    toAdd = false;
                }
                if (sq3 != null && !taxon.getQualifier(6).toString().equalsIgnoreCase(sq3)) {
                    toAdd = false;
                }
                if (sq4 != null && !taxon.getQualifier(7).toString().equalsIgnoreCase(sq4)) {
                    toAdd = false;
                }
                if (!toAdd) continue;
                resultList.add(taxon);
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        }
        return resultList;
    }

    public static List<Taxon> searchSoundex(SBdb SB2, String genus, String subGenus, String species, String subSpecies) throws SQLException, SBException {
        String sql = "SELECT spec_id FROM " + SB2.DBTableName("genus") + " g," + SB2.DBTableName("species") + " s WHERE s.gen_id=g.gen_id ";
        String text = genus.toUpperCase();
        if (text.length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(g.genus))=soundex('" + text + "')";
        }
        if ((text = subGenus.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(g.sub_genus))=soundex('" + text + "')";
        }
        if ((text = species.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(s.species))=soundex('" + text + "')";
        }
        if ((text = subSpecies.toUpperCase()).length() > 0 && !text.equals("%")) {
            if (sql.lastIndexOf("AND ") != sql.length() - 4) {
                sql = sql + " AND ";
            }
            text = text.replaceAll("%", "");
            sql = sql + "upper(soundex(s.sub_spec))=soundex('" + text + "')";
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            Taxon taxon = SB2.getTaxon(rs.getInt("spec_id"));
            resultList.add(taxon);
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getUnusedSpecies(SBdb sbdb, List<Integer> taxaToDie) throws SQLException {
        String sql = "SELECT spec_id FROM " + sbdb.DBTableName("species");
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            int specID;
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                taxaToDie.add(new Integer(rs.getInt("spec_id")));
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("taxonocc");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove(new Integer(specID))) continue;
                System.out.println("TAXONOCC SpecID with no corresponding species record: " + specID);
            }
            sql = "SELECT distinct(spec_id) FROM " + sbdb.DBTableName("eventdic");
            rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                specID = rs.getInt("spec_id");
                if (taxaToDie.remove(new Integer(specID))) continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaxonWellOccTotal> search(SBdb db, Project project, Double upper, Double lower, int abund, String addSql) throws SQLException {
        Object sql = "SELECT f.well_id, count(f.spec_id) as Total FROM ";
        sql = (String)sql + this.sbdb.DBTableName("TAXONOCC");
        sql = (String)sql + " f, ";
        if (project != null && project.getID() > 0) {
            sql = (String)sql + this.sbdb.DBTableName("SBWLMB");
            sql = (String)sql + " w, ";
        }
        sql = (String)sql + this.sbdb.DBTableName("SAMPLES");
        sql = (String)sql + " s WHERE f.well_id=s.well_id AND f.samp_id=s.samp_id AND f.spec_id=" + this.specID;
        if (abund > 0) {
            sql = (String)sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = this.sbdb.dbType == SBdb.DBType.ACCESS ? (String)sql + " AND IIF(IsNull(s.top_depth),s.base_depth,s.top_depth)>=" + upper : (String)sql + " AND NVL(s.top_depth,s.base_depth)>=" + upper;
        }
        if (lower != null) {
            sql = this.sbdb.dbType == SBdb.DBType.ACCESS ? (String)sql + " AND IIF(IsNull(s.base_depth),s.top_depth,s.base_depth)<=" + lower : (String)sql + " AND NVL(s.base_depth,s.top_depth)<=" + lower;
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + " AND f.well_id=w.well_id AND w.id=" + project.getID();
        }
        if (addSql != null) {
            sql = (String)sql + addSql;
        }
        sql = (String)sql + " Group by f.well_id";
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery((String)sql));
            LinkedList<TaxonWellOccTotal> resultList = new LinkedList<TaxonWellOccTotal>();
            while (rs.next()) {
                resultList.add(new TaxonWellOccTotal(rs.getInt("well_id"), rs.getInt("total")));
            }
            LinkedList<TaxonWellOccTotal> linkedList = resultList;
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Taxon> search(SBdb db, int upperCode, int lowerCode, int dictID) throws SQLException {
        if (upperCode < lowerCode) {
            int temp = upperCode;
            upperCode = lowerCode;
            lowerCode = temp;
        }
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        Statement stmt = db.getDatabase().createStatement();
        String sql = "SELECT DISTINCT spec_id FROM " + db.DBTableName("SIPMCODE") + " WHERE sipm_code";
        sql = upperCode < 0 ? sql + "=" + lowerCode : (lowerCode < 0 ? sql + "=" + upperCode : sql + ">=" + lowerCode + " AND sipm_code<=" + upperCode);
        try {
            ResultSet rs = stmt.executeQuery(db.modQuery(sql));
            while (rs.next()) {
                resultList.add(db.getTaxon(rs.getInt("spec_id")));
            }
            Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
            LinkedList<Taxon> linkedList = resultList;
            return linkedList;
        }
        finally {
            stmt.close();
        }
    }

    public static List<Taxon> search(SBdb SB2, String discs, TxGroup group, Project project, IGDUnit unit, int abund, String addSql) throws SQLException, SBException {
        Statement stmt = SB2.getDatabase().createStatement();
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        String sql = "SELECT i.well_id,min(s1." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS upper,max(s2." + (SB2.useSampleTops() ? "top_depth" : "base_depth") + ") AS lower ";
        sql = sql + "FROM " + SB2.DBTableName("IGD") + " i, " + SB2.DBTableName("SAMPLES") + " s1, " + SB2.DBTableName("SAMPLES") + " s2";
        if (project != null && project.getID() > 0) {
            sql = sql + ",";
            sql = sql + SB2.DBTableName("SBWLMB");
            sql = sql + " w ";
        }
        sql = sql + " WHERE (i.upp_zone=" + unit.getUnitID() + " OR i.low_zone=" + unit.getUnitID() + ") AND s1.well_id=i.well_id AND s2.well_id=i.well_id AND s1.samp_id=i.top_id AND s2.samp_id=i.base_id ";
        if (project != null && project.getID() > 0) {
            sql = sql + " AND i.well_id=w.well_id AND w.id=" + project.getID();
        }
        sql = sql + " GROUP BY i.well_id";
        System.out.println(sql);
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        while (rs.next()) {
            int wellID = rs.getInt("well_id");
            BigDecimal upper = rs.getBigDecimal("upper");
            BigDecimal lower = rs.getBigDecimal("lower");
            if (upper == null || lower == null) continue;
            System.out.println("Executing query for wellID=" + wellID + " upper=" + upper + ", lower=" + lower);
            List<Taxon> wellResultList = Taxon.search(SB2, discs, group, null, wellID, upper.doubleValue(), lower.doubleValue(), abund, addSql);
            for (Taxon taxon : wellResultList) {
                if (resultList.contains(taxon)) continue;
                resultList.add(taxon);
            }
        }
        stmt.close();
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        return resultList;
    }

    public static List<Taxon> search(SBdb SB2, String discs, TxGroup group, Project project, int wellID, Double upper, Double lower, int abund, String addSql) throws SQLException, SBException {
        Object sql = "SELECT DISTINCT f.spec_id FROM ";
        sql = (String)sql + SB2.DBTableName("TAXONOCC");
        sql = (String)sql + " f, ";
        sql = (String)sql + SB2.DBTableName("ANALY_HDR");
        sql = (String)sql + " a, ";
        if (group != null) {
            sql = (String)sql + SB2.DBTableName("GROUPMBR");
            sql = (String)sql + " g, ";
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + SB2.DBTableName("SBWLMB");
            sql = (String)sql + " w, ";
        }
        sql = (String)sql + SB2.DBTableName("SAMPLES");
        sql = (String)sql + " s WHERE f.analy_id=a.analy_id AND a.well_id=f.well_id AND f.samp_id=s.samp_id AND f.well_id=s.well_id";
        sql = (String)sql + " AND (";
        for (int i = 0; i < discs.length(); ++i) {
            if (i > 0) {
                sql = (String)sql + " OR ";
            }
            sql = (String)sql + "a.disc_id='" + discs.charAt(i) + "'";
        }
        sql = (String)sql + ")";
        if (abund > 0) {
            sql = (String)sql + " AND (f.coarse>" + abund + " OR f.medium>" + abund + " OR f.fine>" + abund + ")";
        }
        if (upper != null) {
            sql = (String)sql + " AND (s.top_depth>" + upper + " OR s.base_depth > " + upper + ")";
        }
        if (lower != null) {
            sql = (String)sql + " AND (s.base_depth<" + lower + " OR s.top_depth < " + lower + ")";
        }
        if (group != null) {
            sql = (String)sql + " AND f.spec_id=g.spec_id AND g.grp_id=" + group.getID();
        }
        if (project != null && project.getID() > 0) {
            sql = (String)sql + " AND f.well_id=w.well_id AND w.id=" + project.getID();
        }
        if (wellID > 0) {
            sql = (String)sql + " AND f.well_id=" + wellID;
        }
        if (addSql != null) {
            sql = (String)sql + addSql;
        }
        Statement stmt = SB2.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(SB2.modQuery((String)sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            resultList.add(SB2.getTaxon(rs.getInt("spec_id")));
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    public static List<Taxon> search(SBdb sbdb, Date dateFrom, Date dateTo) throws SQLException, SBException {
        if (dateFrom == null && dateTo == null) {
            throw new SBException("No dates to search on");
        }
        if (dateFrom == null && dateTo != null) {
            throw new SBException("Date from null in between date search");
        }
        String sql = "SELECT distinct spec_id from " + sbdb.DBTableName("SPECIES");
        sql = dateTo != null ? sql + " WHERE modified BETWEEN " + sbdb.DBDate(dateFrom) + " AND " + sbdb.DBDate(dateTo) : sql + " WHERE modified > " + sbdb.DBDate(dateFrom);
        Statement stmt = sbdb.getDatabase().createStatement();
        ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
        LinkedList<Taxon> resultList = new LinkedList<Taxon>();
        while (rs.next()) {
            resultList.add(sbdb.getTaxon(rs.getInt("spec_id")));
        }
        Collections.sort(resultList, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
        stmt.close();
        return resultList;
    }

    private boolean checkQualField(String field) {
        if (field == null || field.length() == 0) {
            return true;
        }
        if (field.startsWith("?") || field.endsWith("?")) {
            return false;
        }
        for (int i = 0; i < preqal.length; ++i) {
            if (preqal[i] > 0 && field.startsWith(qulsym[i])) {
                return false;
            }
            if (preqal[i] != 0 || !field.endsWith(qulsym[i])) continue;
            return false;
        }
        return true;
    }

    void removeImageType(int imageSetID) {
        if (this.imageType != null && this.imageType.getID() == imageSetID) {
            this.imageType = null;
        }
    }

    public String getNwsImages() {
        if (this.wsImages != null && this.wsImages.size() > 0) {
            return "" + this.wsImages.size();
        }
        return null;
    }

    public List<ImageSet> getWsImageSets() {
        return this.wsImages;
    }

    public boolean isFuncEquivalent(SortEntry e) {
        return this.getSortEntry().compareTo(e.getSortEntry()) == 0;
    }

    @Override
    public void onGenusDetailsUpdated(Genus genus) {
        this.updatePublisher.setTaxonDetailsChanged();
    }

    @Override
    public void onGenusSpeciesListUpdated(Genus genus, Collection<Integer> speciesAdded, Collection<Integer> speciesRemoved) {
    }

    @Override
    public void onGenusDelete(Genus genus) {
    }

    public static void sort(List<Taxon> list, SortOrder order) {
        switch (order) {
            case SORT_GENUS: {
                Collections.sort(list, new TaxonCompareGenus(new TaxonCompareSpecies()));
                break;
            }
            case SORT_SPECIES: {
                Collections.sort(list, new TaxonCompareSpecies());
                break;
            }
            case SORT_CATEGORY: {
                Collections.sort(list, new TaxonCompareCategory(new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            case SORT_ALPHACODE: {
                Collections.sort(list, new TaxonCompareAlphaCode(new TaxonCompareGenus(new TaxonCompareSpecies())));
            }
        }
    }

    public static void sort(List<Taxon> list, SortOrder order, int sipmDictID) {
        switch (order) {
            case SORT_SIPMCODE: {
                Collections.sort(list, new TaxonCompareSIPMCode(sipmDictID, new TaxonCompareGenus(new TaxonCompareSpecies())));
                break;
            }
            default: {
                Taxon.sort(list, order);
            }
        }
    }

    public static String toSpeciesCase(String strg) {
        if (((String)(strg = ((String)strg).toLowerCase())).startsWith("sp.") || ((String)strg).startsWith("sp ") || ((String)strg).startsWith("var ")) {
            String upper = ((String)strg).substring(3);
            upper = upper.toUpperCase();
            strg = ((String)strg).substring(0, 3) + upper;
        }
        String[] replacers = new String[]{" spt", " rri", " ms"};
        for (int j = 0; j < replacers.length; ++j) {
            String replacer = replacers[j];
            int i = ((String)strg).indexOf(replacer + " ");
            if (i >= 0) {
                strg = ((String)strg).substring(0, i) + replacer.toUpperCase() + " " + ((String)strg).substring(i + replacer.length(), ((String)strg).length());
            }
            if (!((String)strg).endsWith(replacer) || (i = ((String)strg).indexOf(replacer)) < 0) continue;
            strg = ((String)strg).substring(0, i) + replacer.toUpperCase();
        }
        return strg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNSpecies(SBdb sbdb) throws SQLException {
        Object sql = "SELECT count(spec_id) AS nspecies FROM " + sbdb.DBTableName("species");
        sql = sbdb.modQuery((String)sql);
        int nSpecies = 0;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery((String)sql);
            if (rs.next()) {
                nSpecies = rs.getInt("nspecies");
            }
        }
        return nSpecies;
    }

    public List<TxGroup> getGroups() throws SQLException, SBException {
        if (this.sbdb == null || !this.sbdb.isConnected()) {
            throw new SBException("Taxon.getGroups(). Not connected to database.");
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        Statement stmt = this.sbdb.getDatabase().createStatement();
        String sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("groupmbr") + " WHERE spec_id=" + this.specID;
        ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        while (rs.next()) {
            groups.add(this.sbdb.getTxGroup(rs.getInt("grp_id")));
        }
        sql = "SELECT grp_id FROM " + this.sbdb.DBTableName("groupmbr_genus") + " WHERE gen_id=" + this.genus.getGenID();
        rs = stmt.executeQuery(this.sbdb.modQuery(sql));
        while (rs.next()) {
            TxGroup group = this.sbdb.getTxGroup(rs.getInt("grp_id"));
            if (groups.contains(group)) continue;
            groups.add(group);
        }
        stmt.close();
        return groups;
    }

    public int getImageSetCount(boolean refresh) throws SQLException {
        if (this.sbdb.isConnected() && refresh || this.imageSetCount < 0) {
            this.imageSetCount = 0;
            String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0";
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                LinkedList<Integer> imageSets = new LinkedList<Integer>();
                while (rs.next()) {
                    imageSets.add(rs.getInt("image_set_id"));
                }
                this.imageSetCount = imageSets.size();
                sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("taxonocc") + " WHERE spec_id=" + this.specID + " AND image_set_id IS NOT NULL";
                rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    if (imageSets.contains(rs.getInt("image_set_id"))) continue;
                    ++this.imageSetCount;
                }
            }
            if (this.hasUnreferencedImages()) {
                ++this.imageSetCount;
            }
        }
        return this.imageSetCount;
    }

    ImageSet getUnreferencedImages() throws SQLException, SBException {
        ImageSet unreferenced;
        if (this.sbdb.getImageFolder() != null && (unreferenced = new ImageSet(this.sbdb, this.subsFileNameChars(this.toString(false, false)))).getSize(false) > 0) {
            this.hasTypeImage = this.hasTypeImage > 0 ? (this.hasTypeImage += unreferenced.getSize()) : (this.hasTypeImage() ? (this.hasTypeImage += unreferenced.getSize()) : unreferenced.getSize());
            return unreferenced;
        }
        return null;
    }

    private boolean hasUnreferencedImages() throws SQLException {
        String imageFolder = this.sbdb.getImageFolder();
        if (imageFolder == null || imageFolder.isEmpty()) {
            return false;
        }
        File dir = new File(imageFolder);
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getPath().toLowerCase().startsWith((imageFolder + "\\" + this.subsFileNameChars(this.toString(false, false))).toLowerCase() + "_")) continue;
            return true;
        }
        return false;
    }

    private String subsFileNameChars(String name) {
        char[] ILLEGAL_CHARACTERS = new char[]{'/', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
        Object newName = "";
        for (int n : name.toCharArray()) {
            for (char ill : ILLEGAL_CHARACTERS) {
                if (ill != n) continue;
                n = ill == '\"' ? 39 : 45;
                break;
            }
            newName = (String)newName + (char)n;
        }
        return newName;
    }

    public boolean hasTypeImage() throws SQLException {
        if (this.hasTypeImage < 0) {
            Object sql = "SELECT count(image_set_id) AS nset FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0 and type='Y'";
            sql = this.sbdb.modQuery((String)sql);
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery((String)sql);
            this.hasTypeImage = 0;
            while (rs.next()) {
                this.hasTypeImage = rs.getInt("nset");
            }
            stmt.close();
            if (this.hasUnreferencedImages()) {
                this.hasTypeImage = 1;
                return true;
            }
        }
        return this.hasTypeImage > 0;
    }

    public void incrementTypeImage() {
        ++this.hasTypeImage;
    }

    public void decrementTypeImage() {
        --this.hasTypeImage;
    }

    public ImageSet getImageType() throws SQLException, SBException {
        if (this.sbdb.isConnected() && this.imageSetCount != 0 && this.imageType == null) {
            this.getImageSetCount(true);
            List<ImageSet> sets = this.getImageTypes();
            if (sets != null && sets.size() > 0) {
                this.imageType = sets.get(0);
            }
        }
        return this.imageType;
    }

    public void decrementImageSetCount() {
        --this.imageSetCount;
        this.updatePublisher.setTaxonDetailsChanged();
    }

    public List<ImageSet> getImageTypes() throws SQLException, SBException {
        LinkedList<ImageSet> sets = null;
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql = "SELECT image_set_id FROM " + this.sbdb.DBTableName("tximage") + " WHERE spec_id=" + this.specID + " AND image_set_id > 0 AND type='Y'";
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                int imageSetID = rs.getInt("image_set_id");
                if (sets == null) {
                    sets = new LinkedList<ImageSet>();
                }
                sets.add(new ImageSet(this.sbdb, imageSetID));
            }
        }
        if (sets != null) {
            return sets;
        }
        ImageSet unref = this.getUnreferencedImages();
        if (unref != null) {
            sets = new LinkedList();
            sets.add(unref);
        }
        return sets;
    }

    public boolean equalsBuilder(Builder builder) {
        if (!this.equalsBuilder(builder, true)) {
            return false;
        }
        if (!this.author.equals(builder.author)) {
            return false;
        }
        if (!this.alphaCode.equals(builder.alphaCode)) {
            return false;
        }
        return this.year == builder.year;
    }

    public boolean equalsBuilder(Builder builder, boolean uniqueFieldsOnly) {
        if (builder.genus != null && this.genus != builder.genus) {
            return false;
        }
        if (!this.species.equals(builder.species)) {
            return false;
        }
        if (!this.subSpecies.equals(builder.subSpecies)) {
            return false;
        }
        for (int i = 0; i < this.qualifiers.length; ++i) {
            if (this.qualifiers[i].equals(builder.qualifiers[i])) continue;
            return false;
        }
        return true;
    }

    private Taxon(Builder builder, int specID, SBdb sbdb) {
        this.specID = specID;
        this.sbdb = sbdb;
        this.genus = builder.genus;
        this.species = builder.species;
        this.subSpecies = builder.subSpecies;
        this.qualifiers = builder.qualifiers;
        this.alphaCode = builder.alphaCode;
        this.author = builder.author;
        this.year = builder.year;
        this.notes = builder.notes;
        this.reference = builder.reference;
        this.audit = builder.audit;
        this.genus.registerListener(this);
    }

    public static class Builder {
        private Genus genus;
        private String species = "";
        private String subSpecies = "";
        private Qualifier[] qualifiers = new Qualifier[4];
        private String alphaCode = "";
        private String author = "";
        private int year;
        Audit audit = new Audit();
        String notes = null;
        String reference = null;

        public Builder() {
            for (int i = 0; i < this.qualifiers.length; ++i) {
                this.qualifiers[i] = new Qualifier(i + 4);
            }
        }

        static Builder copyOf(Taxon taxon) {
            Builder builder = new Builder();
            builder.species(taxon.species).subSpecies(taxon.subSpecies);
            for (int i = 0; i < builder.qualifiers.length; ++i) {
                Qualifier q = taxon.getQualifierSpecies(i);
                if (q == null) continue;
                builder.qualifiers[i] = q.copy();
            }
            builder.alphaCode(taxon.getAlphaCode()).author(taxon.author).year(taxon.year).notes(taxon.notes).reference(taxon.reference);
            return builder;
        }

        public void verify() throws InvalidFieldException {
            if (this.qualifiers[0].hasQual(TaxonQual.QUOTE) || this.qualifiers[1].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[0].addQual(TaxonQual.QUOTE);
                this.qualifiers[1].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[2].hasQual(TaxonQual.QUOTE) || this.qualifiers[3].hasQual(TaxonQual.QUOTE)) {
                this.qualifiers[2].addQual(TaxonQual.QUOTE);
                this.qualifiers[3].addQual(TaxonQual.QUOTE);
            }
            if (this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.qualifiers[3].hasQual(TaxonQual.SENSU)) {
                throw new InvalidFieldException("You may not use the 'sensu' qualifier twice.");
            }
            if (this.qualifiers[1].hasQual(TaxonQual.SENSU) && this.subSpecies.isEmpty() && this.author.isEmpty()) {
                throw new InvalidFieldException("You must enter an author name in the sub-species or author fields if you use the 'sensu' qualifier.");
            }
            if (this.qualifiers[3].hasQual(TaxonQual.SENSU) && this.author.isEmpty()) {
                throw new InvalidFieldException("You must enter an author name if you use the 'sensu' qualifier.");
            }
        }

        private void validateFields() {
            if (this.genus == null) {
                throw new IllegalStateException("Attempt to build Taxon with no Genus: " + this.species);
            }
            if (this.species.isEmpty()) {
                throw new IllegalStateException("Attempt to build Taxon with no name: " + this.genus);
            }
        }

        Taxon build(int specID, SBdb sbdb) {
            if (specID < 1) {
                throw new IllegalArgumentException("Attempt to build Taxon with illegal specID: " + specID);
            }
            if (sbdb == null) {
                throw new IllegalArgumentException("Attempt to build Taxon with null data model");
            }
            this.validateFields();
            return new Taxon(this, specID, sbdb);
        }

        Taxon store(SBdb sbdb) throws SQLException, SBPermissionException {
            if (!SBRestrictable.canWrite(sbdb)) {
                throw new SBPermissionException("No permission to create new taxon");
            }
            int specID = sbdb.nextControl("SPECIES", "spec_id");
            Taxon taxon = this.build(specID, sbdb);
            taxon.storeDB(sbdb);
            return taxon;
        }

        public Builder genus(Genus g) {
            this.genus = g;
            return this;
        }

        public Builder qual(int qual, String s) {
            if (s == null || s.isEmpty() || qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4] = new Qualifier(s.trim(), qual);
            return this;
        }

        public Builder qual(int qual, Qualifier q) {
            if (qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4] = q == null ? new Qualifier(qual - 4) : q;
            return this;
        }

        public Builder qual(int qual, TaxonQual q) {
            if (q == null || qual < 4 || qual > 7) {
                return this;
            }
            this.qualifiers[qual - 4].addQual(q);
            return this;
        }

        public Builder speciesAdd(String species) {
            if (species != null) {
                if (!this.species.isEmpty()) {
                    this.species = this.species + " ";
                }
                this.species = this.species + species;
            }
            return this;
        }

        public Builder species(String species) {
            this.species = species != null ? species.trim() : "";
            return this;
        }

        public Builder subSpecies(String subSpecies) {
            this.subSpecies = subSpecies != null ? subSpecies.trim() : "";
            return this;
        }

        public Builder author(String author) {
            if (author == null) {
                author = "";
            }
            this.author = author.trim();
            return this;
        }

        public Builder alphaCode(String alphaCode) {
            if (alphaCode == null) {
                alphaCode = "";
            }
            this.alphaCode = alphaCode.trim();
            return this;
        }

        public Builder year(int year) {
            if (year < 1000 || year > 3000) {
                year = 0;
            }
            this.year = year;
            return this;
        }

        public boolean hasQual(TaxonQual qual) {
            for (Qualifier q : this.qualifiers) {
                if (!q.hasQual(qual)) continue;
                return true;
            }
            return false;
        }

        public Builder audit(Audit audit) {
            if (audit != null) {
                this.audit = audit;
            }
            return this;
        }

        Builder notes(String notes) {
            this.notes = notes;
            return this;
        }

        Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        Qualifier getQualifier(int i) {
            return this.qualifiers[i];
        }

        public String getName() {
            return this.species;
        }

        public String getSubSpecies() {
            return this.subSpecies;
        }

        public String getAlphaCode() {
            return this.alphaCode;
        }

        String getAuthor() {
            return this.author;
        }

        Genus getGenus() {
            return this.genus;
        }
    }

    public class TaxonWellOccTotal {
        int wellID;
        int nOcc;

        TaxonWellOccTotal(int w, int n) {
            this.wellID = w;
            this.nOcc = n;
        }

        public int getWellID() {
            return this.wellID;
        }

        public int getNOcc() {
            return this.nOcc;
        }
    }

    public static enum SortOrder {
        SORT_GENUS,
        SORT_SPECIES,
        SORT_CATEGORY,
        SORT_ALPHACODE,
        SORT_SIPMCODE;

    }

    public static enum OccType {
        INSITU("In-situ"),
        REWORKED("Reworked"),
        CAVED("Caved"),
        QUESTIONABLE("Questionable");

        String name;

        private OccType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static OccType getType(String type) {
            for (OccType val : OccType.values()) {
                if (!val.toString().equalsIgnoreCase(type)) continue;
                return val;
            }
            return null;
        }
    }
}

