/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.util.Collections;
import java.util.LinkedList;
import model2_1.QualComparator;
import model2_1.Qualifier;

public enum TaxonQual {
    QUOTE("\"", false, new int[]{2, 0, 1, 0, 1, 0, 1, 0}, false),
    Q("?", false, new int[]{0, 1, -1, 1, -1, 1, -1, 1}, false),
    CF("cf", true, new int[]{1, -1, 0, -1, 0, -1, 0, -1}, true),
    AFF("aff", true, new int[]{1, -1, 0, -1, 0, -1, 0, -1}, true),
    SS("ss", true, new int[]{-1, 2, -1, 2, -1, 2, -1, 2}, true),
    SL("sl", true, new int[]{-1, 2, -1, 2, -1, 2, -1, 2}, true),
    GRP("grp", true, new int[]{-1, 2, -1, 2, -1, 2, -1, -1}, true),
    SENSU("sensu", false, new int[]{-1, -1, -1, -1, -1, 2, -1, 2}, true),
    VAR("var", true, new int[]{-1, -1, -1, -1, -1, -1, 0, -1}, true);

    final String descr;
    final boolean whitespace;
    final boolean dot;
    int[] position;
    public static final int GQ1 = 0;
    public static final int GQ2 = 1;
    public static final int GQ3 = 2;
    public static final int GQ4 = 3;
    public static final int SQ1 = 4;
    public static final int SQ2 = 5;
    public static final int SQ3 = 6;
    public static final int SQ4 = 7;

    private TaxonQual(String s, boolean dot, int[] position, boolean whitespace) {
        this.descr = s;
        this.dot = dot;
        this.position = position;
        this.whitespace = whitespace;
    }

    public static TaxonQual[] getQualifiers(int qualifier) {
        LinkedList<TaxonQual> list = new LinkedList<TaxonQual>();
        for (TaxonQual q : TaxonQual.values()) {
            if (q.position[qualifier] <= -1) continue;
            list.add(q);
        }
        return list.toArray(new TaxonQual[list.size()]);
    }

    public String toString() {
        return this.descr + (this.dot ? "." : "");
    }

    static TaxonQual[] parse(String s, int qualifier) {
        if (qualifier < 0 || qualifier > 7) {
            throw new IllegalArgumentException("Cannot create qualifier comparator for qualifier " + qualifier);
        }
        LinkedList<TaxonQual> matches = new LinkedList<TaxonQual>();
        s = s.toLowerCase();
        for (TaxonQual q : TaxonQual.values()) {
            if (!s.contains(q.toString()) || q.position[qualifier] <= -1) continue;
            matches.add(q);
        }
        Collections.sort(matches, new QualComparator(qualifier));
        return matches.toArray(new TaxonQual[matches.size()]);
    }

    static String stripQualifiers(String s, Qualifier q1, Qualifier q2) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (TaxonQual qual : TaxonQual.values()) {
            String d;
            String string = d = qual == Q ? "\\?" : qual.descr;
            if (!s.equals(d) && !s.startsWith(qual.toString()) && !s.endsWith(qual.toString())) continue;
            if (qual == Q && q2 != null && q1.getPos() == 0 && q2.getPos() == 1) {
                if (s.startsWith(qual.toString())) {
                    q1.addQual(qual);
                } else {
                    q2.addQual(qual);
                }
            } else {
                q1.addQual(qual);
                if (q2 != null) {
                    q2.addQual(qual);
                }
            }
            s = qual.dot && s.contains(qual.toString()) ? s.replaceAll(qual.toString(), "") : s.replaceAll(d, "").trim();
            if (s.isEmpty()) break;
        }
        return s;
    }

    public static boolean allowName(String field) {
        if (field == null || field.isEmpty()) {
            return true;
        }
        for (TaxonQual q : TaxonQual.values()) {
            if (!q.whitespace) {
                if (!field.startsWith(q.descr) && !field.endsWith(q.descr)) continue;
                return false;
            }
            if (field.startsWith(q.toString()) || field.endsWith(q.toString())) {
                return false;
            }
            if (!field.equals(q.descr)) continue;
            return false;
        }
        return true;
    }

    public boolean use(int qualifier) {
        return this.position[qualifier] > -1;
    }

    boolean isMutuallyExclusive(TaxonQual q, int i) {
        return q.position[i] == this.position[i];
    }
}

