/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import model2_1.Audit;
import model2_1.ProjectMember;
import model2_1.SBRestrictable;
import model2_1.SBdb;
import model2_1.Taxon;
import model2_1.TxGroup;
import model2_1.Userdef;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.SbugsLink;
import util.status.SbugsStatus;

public class TxGroupSet
extends SBRestrictable
implements Comparable,
ProjectMember,
SbugsLink,
SbugsStatus {
    private final SBdb sbdb;
    private final int grpSetID;
    private String name;
    private LinkedHashSet<Integer> grpIDs = null;
    private Audit audit = new Audit();
    private int projID;
    private boolean isOrdered;
    private String descr;
    private Color status = NOTSTORED;
    private TxGroupSet link;

    TxGroupSet(SBdb sbdb, int ID, String name, int projID, String descr, Audit audit, boolean isOrdered) {
        super("GROUPSET", "GRPSET_ID", false);
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group set with no data model");
        }
        if (ID <= 0) {
            throw new IllegalArgumentException("Attempt to create group set with illegal ID: " + ID);
        }
        this.sbdb = sbdb;
        this.grpSetID = ID;
        this.name = name;
        this.projID = projID;
        if (descr != null && (descr = descr.trim()).isEmpty()) {
            descr = null;
        }
        this.descr = descr;
        this.audit = audit;
        this.isOrdered = isOrdered;
    }

    TxGroupSet(SBdb sbdb, String name, LinkedHashSet<Integer> groupIDs, int setID, int projID, String descr, boolean isOrdered) throws SQLException, SBException, SBPermissionException {
        super("GROUPSET", "GRPSET_ID", false);
        if (sbdb == null) {
            throw new IllegalArgumentException("Attempt to create group set with no data model");
        }
        if (setID <= 0) {
            throw new IllegalArgumentException("Attempt to create group set with illegal ID: " + setID);
        }
        this.sbdb = sbdb;
        this.grpSetID = setID;
        this.name = name;
        this.grpIDs = groupIDs;
        this.projID = projID;
        if (descr != null && (descr = descr.trim()).isEmpty()) {
            descr = null;
        }
        this.descr = descr;
        this.isOrdered = isOrdered;
        if (sbdb.isConnected()) {
            this.store();
        }
        this.setAcm(0);
    }

    private TxGroupSet(SBdb sbdb, int ID) throws SQLException {
        super("GROUPSET", "GRPSET_ID", false);
        this.sbdb = sbdb;
        this.grpSetID = ID;
        String sql = "SELECT name,descr,proj_id," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("GROUPSET") + " WHERE grpset_id=" + ID;
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
            while (rs.next()) {
                this.name = rs.getString("name");
                this.descr = rs.getString("descr");
                this.projID = rs.getInt("proj_id");
                this.audit = new Audit(rs);
                this.setAcm(rs.getInt("acm"));
            }
        }
    }

    static TxGroupSet copyToWorkspace(SBdb ws, TxGroupSet dbSet) throws SQLException, SBException {
        if (ws.isConnected() || !dbSet.sbdb.isConnected()) {
            throw new IllegalArgumentException("Incorrect data model arguments to TxGroup.copyToDatabase");
        }
        TxGroupSet set = new TxGroupSet(ws, dbSet.grpSetID, dbSet.name, 0, dbSet.descr, new Audit(dbSet.audit), dbSet.isOrdered);
        dbSet.audit.fillWorkspace(dbSet.sbdb, ws);
        set.setAcm(0);
        set.loadGroups();
        return set;
    }

    public TxGroupSet getLink() {
        return this.link;
    }

    public void setLink(TxGroupSet link) {
        this.link = link;
    }

    public List<TxGroup> getGroups() throws SQLException {
        if (this.grpIDs == null) {
            this.loadGroups();
        }
        LinkedList<TxGroup> groups = new LinkedList<TxGroup>();
        Iterator iterator = this.grpIDs.iterator();
        while (iterator.hasNext()) {
            int grpId = (Integer)iterator.next();
            groups.add(this.sbdb.getTxGroup(grpId));
        }
        if (!this.isOrdered) {
            Collections.sort(groups);
        }
        return groups;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int getID() {
        return this.grpSetID;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getProjID() {
        return this.projID;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public String getDescr() {
        return this.descr;
    }

    void loadGroups() throws SQLException {
        if (this.grpSetID == 0 || this.grpIDs != null && this.grpIDs.isEmpty()) {
            return;
        }
        if (this.grpIDs == null) {
            this.grpIDs = new LinkedHashSet();
        }
        if (this.sbdb.isConnected()) {
            try (Statement stmt = this.sbdb.getDatabase().createStatement();){
                String sql = "SELECT grp_id,group_no FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID + " ORDER BY group_no";
                ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
                while (rs.next()) {
                    int grpID = rs.getInt("grp_id");
                    int no = rs.getInt("group_no");
                    if (no > 0) {
                        this.isOrdered = true;
                    }
                    this.grpIDs.add(grpID);
                }
            }
        }
    }

    public boolean isMember(int specID, int synSchID) throws SBException, SQLException {
        if (this.grpIDs == null) {
            throw new SBException("Groups in set: " + this + " not loaded");
        }
        Iterator it = this.grpIDs.iterator();
        while (it.hasNext()) {
            int grpID = (Integer)it.next();
            TxGroup group = this.sbdb.getTxGroup(grpID);
            if (group == null) {
                throw new SBException("Cannot find group, ID " + grpID + " in set " + this.name);
            }
            group.load();
            if (!group.isMember(specID, synSchID)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupMember(int grpID) {
        return this.grpIDs.contains(grpID);
    }

    void delete() throws SQLException, SBPermissionException {
        if (this.grpSetID == 0) {
            return;
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group set", true));
            }
            String sql = "DELETE FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            sql = "DELETE FROM " + this.sbdb.DBTableName("GROUPSET") + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
        }
    }

    public void updateName(String newName) {
        if (this.sbdb.isConnected()) {
            throw new IllegalStateException("Attempt to update name of db set");
        }
        this.name = newName.trim();
    }

    public void update(String newName, int projID, Collection<TxGroup> groups, boolean isOrdered, String descr) throws SQLException, SBException, SBPermissionException {
        if (this.grpSetID == 0) {
            throw new SBException("Cannot update null group set");
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            String sql;
            if (!this.canWrite(this.sbdb, stmt)) {
                throw new SBPermissionException(this.getDeniedReason(this.sbdb, "group set", true));
            }
            for (TxGroup group : groups) {
                if (projID == 0 && group.getProjID() > 0) {
                    throw new IllegalArgumentException("Global group set contains non-global group");
                }
                if (projID <= 0 || group.getProjID() <= 0 || group.getProjID() == projID) continue;
                throw new IllegalArgumentException("Project group set contains group from another project");
            }
            Audit tempAudit = new Audit(this.audit);
            if (!newName.equals(this.name) || projID != this.projID || this.isOrdered != isOrdered || !SB.equal((Object)this.descr, (Object)descr)) {
                sql = "UPDATE " + this.sbdb.DBTableName("GROUPSET") + " SET name=" + SB.DBString((String)newName) + ",descr=" + (descr != null ? SB.DBString((String)descr) : "NULL") + ",proj_id=" + (Serializable)(projID > 0 ? Integer.valueOf(projID) : "NULL") + "," + tempAudit.sqlUpdate(this.sbdb, stmt, false) + " WHERE grpset_id=" + this.grpSetID;
                stmt.executeUpdate(this.sbdb.modQuery(sql));
            }
            sql = "DELETE FROM " + this.sbdb.DBTableName("SETMBR") + " WHERE grpset_id=" + this.grpSetID;
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            int i = 1;
            for (TxGroup group : groups) {
                sql = "INSERT INTO " + this.sbdb.DBTableName("SETMBR") + " (grpset_id,grp_id,group_no) VALUES (" + this.grpSetID + "," + group.getID() + "," + (Serializable)(isOrdered ? Integer.valueOf(i) : "NULL") + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                ++i;
            }
            this.name = newName;
            this.audit = tempAudit;
            this.projID = projID;
            this.isOrdered = isOrdered;
            this.descr = descr;
            this.grpIDs.clear();
            for (TxGroup group : groups) {
                this.grpIDs.add(group.getID());
            }
        }
        this.setChanged();
    }

    private void store() throws SQLException, SBException, SBPermissionException {
        if (!SBRestrictable.canWrite(this.sbdb)) {
            throw new SBPermissionException(SBRestrictable.getDeniedReason(true));
        }
        try (Statement stmt = this.sbdb.getDatabase().createStatement();){
            ResultSet rs;
            String sql = "SELECT grpset_id FROM " + this.sbdb.DBTableName("GROUPSET") + " WHERE ucase(name)=" + SB.DBString((String)this.name.toUpperCase()) + " AND (proj_id=0 OR proj_id=" + this.projID + ")";
            if (this.grpSetID > 0) {
                sql = sql + " AND grpset_id <> " + this.grpSetID;
            }
            if ((rs = stmt.executeQuery(this.sbdb.modQuery(sql))).next()) {
                throw new SBException("Group set name is not unique");
            }
            sql = "INSERT INTO " + this.sbdb.DBTableName("GROUPSET") + " (grpset_id,name,descr,proj_id," + Audit.sqlFieldString() + ") VALUES (" + this.grpSetID + "," + SB.DBString((String)this.name) + "," + (this.descr != null ? SB.DBString((String)this.descr) : "NULL") + "," + (Serializable)(this.projID > 0 ? Integer.valueOf(this.projID) : "NULL") + "," + this.audit.sqlInsert(this.sbdb, stmt) + ")";
            stmt.executeUpdate(this.sbdb.modQuery(sql));
            Iterator it = this.grpIDs.iterator();
            int i = 1;
            while (it.hasNext()) {
                int grpID = (Integer)it.next();
                sql = "INSERT INTO " + this.sbdb.DBTableName("SETMBR") + " (grpset_id,grp_id,group_no) VALUES (" + this.grpSetID + "," + grpID + "," + (Serializable)(this.isOrdered ? Integer.valueOf(i) : "NULL") + ")";
                stmt.executeUpdate(this.sbdb.modQuery(sql));
                ++i;
            }
        }
    }

    static TreeMap<Integer, TxGroupSet> loadAll(SBdb sbdb) throws SQLException {
        TreeMap<Integer, TxGroupSet> sets = new TreeMap<Integer, TxGroupSet>();
        if (sbdb.isConnected()) {
            String sql = "SELECT grpset_id,name,descr,proj_id," + Audit.sqlFieldString() + ",acm FROM " + sbdb.DBTableName("GROUPSET") + " order by name";
            try (Statement stmt = sbdb.getDatabase().createStatement();){
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int grpSetID = rs.getInt("grpset_id");
                    String name = rs.getString("name");
                    String descr = rs.getString("descr");
                    int projID = rs.getInt("proj_id");
                    TxGroupSet set = new TxGroupSet(sbdb, grpSetID, name, projID, descr, new Audit(rs), false);
                    set.setAcm(rs.getInt("acm"));
                    sets.put(grpSetID, set);
                }
            }
        }
        return sets;
    }

    static synchronized TxGroupSet refresh(SBdb SB2, TreeMap<Integer, TxGroupSet> sets, Statement stmt) throws SQLException {
        String sql = "SELECT grpset_id, updated FROM " + SB2.DBTableName("GROUPSET");
        ResultSet rs = stmt.executeQuery(SB2.modQuery(sql));
        HashSet<Integer> keys = new HashSet<Integer>();
        TxGroupSet notifier = null;
        while (rs.next()) {
            TxGroupSet s;
            int ID = rs.getInt("grpset_id");
            keys.add(ID);
            Timestamp time = rs.getTimestamp("updated");
            TxGroupSet set = sets.get(ID);
            if (set == null) {
                s = new TxGroupSet(SB2, ID);
                sets.put(ID, s);
                notifier = s;
                continue;
            }
            if (time == null || set.audit.updated != null && !time.after(set.audit.updated)) continue;
            s = new TxGroupSet(SB2, ID);
            set.name = s.name;
            set.descr = s.descr;
            set.grpIDs = s.grpIDs;
            set.audit = new Audit(s.audit);
            set.setChanged();
            set.notifyObservers();
        }
        if (sets.size() != keys.size()) {
            Iterator<TxGroupSet> it = sets.values().iterator();
            while (it.hasNext()) {
                TxGroupSet set = it.next();
                if (keys.contains(set.grpSetID)) continue;
                it.remove();
                if (notifier != null) continue;
                notifier = set;
            }
        }
        return notifier;
    }

    void setAnalyst(Userdef analyst) throws SQLException, SBException {
        if (this.sbdb != null && this.sbdb.isConnected()) {
            throw new SBException("Attempt to set analyst on connected database for set: " + this);
        }
        this.audit.setAnalyst(analyst.getUsrID());
    }

    public void writeXML(BufferedWriter out, int indent, List<File> files) throws IOException, SQLException, SBException {
        Object ind = new String();
        while (((String)ind).length() < indent) {
            ind = (String)ind + " ";
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalStateException("TxGroupSet name is null (ID " + this.grpSetID + ")");
        }
        out.write("<GroupSet Name=\"" + SB.getXMLstring((String)this.name) + "\">\n");
        out.write((String)ind + "<SetName>" + SB.getXMLstring((String)this.name) + "</SetName>\n");
        if (this.descr != null) {
            out.write((String)ind + "<Description>" + SB.getXMLstring((String)this.descr) + "</Description>\n");
        }
        out.write((String)ind + "<SetID>" + this.grpSetID + "</SetID>\n");
        out.write((String)ind + "<Ordered>" + this.isOrdered + "</Ordered>\n");
        this.audit.writeXML(out, ((String)ind).length());
        for (Integer id : this.grpIDs) {
            out.write((String)ind + "<Group GroupID=\"" + id + "\"/>\n");
        }
        out.write("</GroupSet>\n");
    }

    public void removeGroup(int ID) throws SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to remove database group from set: use update");
        }
        this.grpIDs.remove(ID);
    }

    void addGroupID(int groupID) throws SQLException, SBException {
        if (this.sbdb.isConnected()) {
            throw new SBException("Attempt to add database group to set: use update");
        }
        if (this.grpIDs == null) {
            this.grpIDs = new LinkedHashSet();
        }
        this.grpIDs.add(groupID);
    }

    public int compareTo(Object o) {
        if (o instanceof TxGroupSet) {
            return this.name.compareToIgnoreCase(((TxGroupSet)o).name);
        }
        return 0;
    }

    public int compareTo(TxGroupSet o) {
        return this.name.compareToIgnoreCase(o.name);
    }

    public boolean equals(Object o) {
        return o instanceof TxGroupSet && ((TxGroupSet)o).getID() == this.grpSetID;
    }

    void groupUpdated(TxGroup group) {
        if (!this.grpIDs.contains(group.getID())) {
            throw new IllegalArgumentException("Attempt to update group set with non-member group");
        }
        this.setChanged();
        this.notifyObservers(group);
    }

    boolean isLoaded() {
        return this.grpIDs != null;
    }

    public Color getStatus() {
        return this.status;
    }

    public String statusString() {
        return this.name;
    }

    public void updateStatus() throws SQLException {
        this.status = UNKNOWN;
        if (this.sbdb.isConnected()) {
            assert (false);
            this.status = STORED;
            return;
        }
        if (this.link == null) {
            this.status = NOTSTORED;
            return;
        }
        this.status = STORED;
        ArrayList<TxGroup> linkedGroups = new ArrayList<TxGroup>();
        for (TxGroup group : this.getGroups()) {
            if (group.getLink() != null) {
                linkedGroups.add(group.getLink());
                continue;
            }
            this.status = CONFLICT;
            return;
        }
        List<TxGroup> linksGroups = this.link.getGroups();
        if (!linkedGroups.equals(linksGroups)) {
            this.status = CONFLICT;
            return;
        }
        for (TxGroup group : this.getGroups()) {
            if (group.getStatus() != CONFLICT) continue;
            this.status = CONFLICT;
            return;
        }
    }

    public int compareGroups(TxGroup group1, TxGroup group2) {
        if (!this.isOrdered) {
            return 0;
        }
        Iterator iterator = this.grpIDs.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            if (id == group1.getID()) {
                return -1;
            }
            if (id != group2.getID()) continue;
            return 1;
        }
        throw new IllegalArgumentException("Groups were not both members of " + this + ": " + group1 + ", " + group2);
    }

    public static List<Taxon> findDuplicateTaxa(SBdb db, LinkedList<TxGroup> groups) throws SQLException {
        HashSet<Integer> totalSpecies = new HashSet<Integer>();
        HashSet<Integer> totalGenera = new HashSet<Integer>();
        LinkedList<Taxon> list = new LinkedList<Taxon>();
        boolean first = true;
        for (TxGroup group : groups) {
            group.load();
            if (first) {
                first = false;
                totalSpecies.addAll(group.getSpecIDs());
                totalGenera.addAll(group.getGenIDs());
                continue;
            }
            for (int specID : group.getSpecIDs()) {
                if (!totalSpecies.add(specID)) {
                    list.add(db.getTaxon(specID));
                }
                if (!totalGenera.contains(db.getTaxon(specID).getGenID())) continue;
                list.add(db.getTaxon(specID));
            }
            for (int genID : group.getGenIDs()) {
                if (totalGenera.add(genID)) continue;
                list.addAll(db.getTaxa(genID));
            }
        }
        return list;
    }
}

