/*
 * Decompiled with CFR 0.152.
 */
package model2_1;

import java.io.File;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JOptionPane;
import model2_1.SBdb;
import model2_1.WellHeader;
import model2_1.WsWell;
import util.DepthUtils;
import util.SBException;
import util.SBPermissionException;
import util.gridreader.GridReader;
import util.gridreader.GridReaderException;

public class WellHeaderXLS {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WellHeaderXLS(SBdb ws, File file, char units) throws GridReaderException, SBException, SBPermissionException, SQLException {
        boolean COL_CODE = true;
        int COL_GRIDX = 2;
        int COL_GRIDY = 3;
        int COL_LAT = 4;
        int COL_LONG = 5;
        int COL_OPER = 6;
        int COL_NAME = 7;
        int COL_COUNTY = 8;
        int COL_COUNTRY = 9;
        int COL_TD = 10;
        int COL_RTE = 11;
        int COL_SPUD = 12;
        int COL_COMP = 13;
        int COL_FIELD = 14;
        int COL_SB = 15;
        int COL_GEODATUM = 16;
        int COL_SL = 17;
        int COL_OCS = 18;
        int COL_KICKO = 19;
        String[] columnNames = new String[]{"name", "code", "well code", "api", "well name", "wellnumber", "Surface X", "Surface Y", "lat", "latitude", "long", "longitude", "operator", "county", "country", "td", "rte", "Elevation", "SPUD date", "Completion date", "Field", "Location", "Water depth", "SB", "Geodatum", "Sea Level", "SL", "OCS", "OCS Number", "Kickoff"};
        int[] columnType = new int[]{7, 1, 1, 1, 7, 7, 2, 3, 4, 4, 5, 5, 6, 8, 9, 10, 11, 11, 12, 13, 14, 8, 15, 15, 16, 17, 17, 18, 18, 19};
        boolean first = true;
        int[] cols = null;
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        try (GridReader in = null;){
            in = GridReader.getGridReader((String)file.getPath(), null);
            while (in.nextRow()) {
                String cell;
                if (first) {
                    LinkedList<String> titles = new LinkedList<String>();
                    while ((cell = in.getNextCell()) != null) {
                        titles.add(cell);
                    }
                    cols = new int[titles.size()];
                    block51: for (int i = 0; i < cols.length; ++i) {
                        for (int j = 0; j < columnNames.length; ++j) {
                            if (!columnNames[j].equalsIgnoreCase((String)titles.get(i))) continue;
                            cols[i] = columnType[j];
                            continue block51;
                        }
                    }
                    first = false;
                    continue;
                }
                if (cols == null) {
                    throw new SBException("No column titles in first row of file/sheet");
                }
                int i = 0;
                String name = "";
                String code = "";
                String OCS = null;
                Double lat = null;
                Double lon = null;
                String operator = null;
                String county = null;
                String field = null;
                String country = null;
                Double td = null;
                Double sb = null;
                Double rte = null;
                Double sl = null;
                Double gridX = null;
                Double gridY = null;
                Date spud = null;
                Date comp = null;
                String geodatum = null;
                while ((cell = in.getNextCell()) != null) {
                    if (i >= cols.length) {
                        System.out.println("Line for cell: " + cell + " Exceeds titles length");
                        break;
                    }
                    if (cell == null || cell.isEmpty()) {
                        ++i;
                        continue;
                    }
                    switch (cols[i]) {
                        case 7: {
                            name = cell;
                            break;
                        }
                        case 1: {
                            code = cell;
                            break;
                        }
                        case 4: {
                            try {
                                lat = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 5: {
                            try {
                                lon = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 2: {
                            try {
                                gridX = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 3: {
                            try {
                                gridY = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 8: {
                            county = cell;
                            break;
                        }
                        case 14: {
                            field = cell;
                            break;
                        }
                        case 18: {
                            OCS = cell;
                            break;
                        }
                        case 9: {
                            country = cell;
                            break;
                        }
                        case 6: {
                            operator = cell;
                            break;
                        }
                        case 16: {
                            geodatum = cell;
                            break;
                        }
                        case 10: {
                            try {
                                td = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 15: {
                            try {
                                sb = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 11: {
                            try {
                                rte = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 17: {
                            try {
                                sl = Double.parseDouble(cell);
                            }
                            catch (IllegalArgumentException p) {
                                System.out.println(p.getMessage());
                            }
                            break;
                        }
                        case 12: {
                            try {
                                spud = df.parse(cell);
                            }
                            catch (ParseException p) {
                                try {
                                    spud = new Date(Long.parseLong(cell));
                                }
                                catch (NumberFormatException p2) {
                                    System.out.println(p.getMessage());
                                    System.out.println(p2.getMessage());
                                }
                            }
                            break;
                        }
                        case 13: {
                            try {
                                comp = df.parse(cell);
                                break;
                            }
                            catch (ParseException p) {
                                try {
                                    comp = new Date(Long.parseLong(cell));
                                    break;
                                }
                                catch (NumberFormatException p2) {
                                    System.out.println(p.getMessage());
                                    System.out.println(p2.getMessage());
                                }
                            }
                        }
                    }
                    ++i;
                }
                WsWell well = ws.addWellToWorkspace(0, null);
                WellHeader wh = well.getHeader();
                System.out.println("Setting well name as: " + name);
                wh.setWellName(name);
                wh.setWellCode(code);
                wh.setWellUnits(units);
                if (county != null) {
                    wh.setCounty(county);
                }
                if (field != null) {
                    wh.setField(field);
                }
                if (OCS != null) {
                    wh.setOCS(OCS);
                }
                if (country != null) {
                    wh.setCountry(country);
                }
                if (td != null) {
                    wh.setTD(DepthUtils.convToM((double)td, (char)units));
                }
                if (sb != null) {
                    wh.setSB(DepthUtils.convToM((double)sb, (char)units));
                }
                if (sl != null) {
                    wh.setSL(DepthUtils.convToM((double)sl, (char)units));
                }
                if (rte != null) {
                    wh.setRTE(DepthUtils.convToM((double)rte, (char)units));
                }
                if (gridX != null && gridY != null) {
                    wh.setGrid(gridX, gridY);
                }
                if (lat != null) {
                    wh.setLat(lat);
                }
                if (lon != null) {
                    wh.setLong(lon);
                }
                if (operator != null) {
                    wh.setOper(operator);
                }
                if (geodatum != null) {
                    wh.setGeoDatum(geodatum);
                }
                try {
                    if (spud != null) {
                        wh.setSpud(spud);
                    }
                    if (comp != null) {
                        wh.setComp(comp);
                    }
                }
                catch (SBException ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), "XLS Reader", 2);
                }
                well.loadInterps();
            }
        }
    }
}

