/*
 * Decompiled with CFR 0.152.
 */
package model2_1.organiser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PaleoImportRecord {
    private final Double topDepth;
    private final Double baseDepth;
    private final String paleoLabel;
    private final String wellName;
    private final String wellCode;

    public PaleoImportRecord(Double topDepth, Double baseDepth, String paleoLabel, String wellName, String wellCode) {
        if (topDepth == null && baseDepth == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null for both top and base depth.");
        }
        if (paleoLabel == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null for paleoLabel.");
        }
        if (wellCode == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null value for wellCode parameter.");
        }
        if (wellName == null) {
            throw new IllegalArgumentException("Can't contruct a PaleoImportRecord with null value for wellName parameter.");
        }
        this.wellName = wellName;
        this.wellCode = wellCode;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.paleoLabel = paleoLabel;
    }

    public Double getTopDepth() {
        return this.topDepth;
    }

    public Double getBaseDepth() {
        return this.baseDepth;
    }

    public String getPaleoLabel() {
        return this.paleoLabel;
    }

    public String getWellName() {
        return this.wellName;
    }

    public String getWellCode() {
        return this.wellCode;
    }

    public Double getDepth(boolean useTopDepth) {
        if (useTopDepth) {
            if (this.getTopDepth() != null) {
                return this.getTopDepth();
            }
            return this.getBaseDepth();
        }
        if (this.getBaseDepth() != null) {
            return this.getBaseDepth();
        }
        return this.getTopDepth();
    }

    public static <T extends PaleoImportRecord> Map<String, List<T>> buildMapOfWellCodesToRecords(List<T> records) {
        HashMap<String, List<T>> map = new HashMap<String, List<T>>();
        for (PaleoImportRecord record : records) {
            String code = record.getWellCode();
            if (!map.containsKey(code)) {
                map.put(code, new ArrayList());
            }
            ((List)map.get(code)).add(record);
        }
        return map;
    }
}

