/*
 * Decompiled with CFR 0.152.
 */
package model2_1.organiser;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import model2_1.EnvScheme;
import model2_1.IGDIntervalEnv;
import model2_1.SBdb;
import model2_1.Sample;
import model2_1.SampleInsertException;
import model2_1.SampleType;
import model2_1.Well;
import model2_1.WellInterp;
import model2_1.WsWell;
import model2_1.organiser.PaleoImporSampletRecord;
import model2_1.organiser.PaleoImportRecord;
import model2_1.organiser.PaleoRangeImportRecord;
import util.SBException;
import util.SBPermissionException;

public class PaleoWorkspaceImporter {
    private final SampleType defaultSampleType = SampleType.CU;

    public void addSampleRecords(SBdb ws, List<PaleoImporSampletRecord> records, EnvScheme selectedDBScheme, char units) throws SBException, SQLException, SBPermissionException {
        EnvScheme scheme = ws.getEnvScheme(selectedDBScheme.getName());
        if (scheme == null) {
            scheme = EnvScheme.createCopy(selectedDBScheme, ws);
            ws.addEnvScheme(scheme);
        } else if (!this.schemeTermsMatch(scheme, selectedDBScheme)) {
            throw new SBException("The scheme " + selectedDBScheme.getName() + " already exists in the workspace, but has different terms to the database scheme. Can't continue with import.");
        }
        List<PaleoImporSampletRecord> validRecords = this.getRecordsThatMatchScheme(scheme, records);
        if (validRecords.isEmpty()) {
            return;
        }
        Map<String, List<PaleoImporSampletRecord>> codeRecordMap = PaleoImportRecord.buildMapOfWellCodesToRecords(validRecords);
        ArrayList<String> wellCodes = new ArrayList<String>(codeRecordMap.keySet());
        Collections.sort(wellCodes);
        for (String wellCode : wellCodes) {
            List<PaleoImporSampletRecord> recordsForWell = codeRecordMap.get(wellCode);
            WsWell well = this.findOrCreateWsWell(ws, recordsForWell.get(0).getWellName(), wellCode, units);
            well.loadInterps();
            WellInterp wi = well.getInterp(0);
            this.sortSampleRecords(ws, recordsForWell);
            int currentTermIndex = scheme.getTermIndex(recordsForWell.get(0).getPaleoLabel());
            PaleoImporSampletRecord firstRecord = recordsForWell.get(0);
            Sample topSample = this.addOrGetWellSample(well, firstRecord.getTopDepth(), firstRecord.getBaseDepth(), firstRecord.getType(), firstRecord.getLabel());
            for (PaleoImporSampletRecord record : recordsForWell) {
                int termIndex = scheme.getTermIndex(record.getPaleoLabel());
                if (termIndex == currentTermIndex) continue;
                Sample baseSample = this.addOrGetWellSample(well, record.getTopDepth(), record.getBaseDepth(), record.getType(), record.getLabel());
                this.addPaleoRangeToInterp(ws, wi, scheme, topSample, baseSample, currentTermIndex);
                topSample = baseSample;
                currentTermIndex = termIndex;
            }
            PaleoImporSampletRecord lastRecord = recordsForWell.get(recordsForWell.size() - 1);
            Sample baseSample = this.addOrGetWellSample(well, lastRecord.getTopDepth(), lastRecord.getBaseDepth(), lastRecord.getType(), lastRecord.getLabel());
            this.addPaleoRangeToInterp(ws, wi, scheme, topSample, baseSample, currentTermIndex);
            HashSet<Integer> s = new HashSet<Integer>();
            s.add(15);
            well.updateStatus(s);
        }
    }

    public void addRangeRecords(SBdb ws, List<PaleoRangeImportRecord> records, EnvScheme selectedDBScheme, char units) throws SBException, SQLException, SBPermissionException {
        EnvScheme scheme = ws.getEnvScheme(selectedDBScheme.getName());
        if (scheme == null) {
            scheme = EnvScheme.createCopy(selectedDBScheme, ws);
            ws.addEnvScheme(scheme);
        } else if (!this.schemeTermsMatch(scheme, selectedDBScheme)) {
            throw new SBException("The scheme " + selectedDBScheme.getName() + " already exists in the workspace, but has different terms to the database scheme. Can't continue with import.");
        }
        List<PaleoRangeImportRecord> validRecords = this.getRecordsThatMatchScheme(scheme, records);
        if (validRecords.isEmpty()) {
            return;
        }
        Map<String, List<PaleoRangeImportRecord>> codeRecordMap = PaleoImportRecord.buildMapOfWellCodesToRecords(validRecords);
        ArrayList<String> wellCodes = new ArrayList<String>(codeRecordMap.keySet());
        Collections.sort(wellCodes);
        for (String wellCode : wellCodes) {
            List<PaleoRangeImportRecord> recordsForWell = codeRecordMap.get(wellCode);
            WsWell well = this.findOrCreateWsWell(ws, recordsForWell.get(0).getWellName(), wellCode, units);
            well.loadInterps();
            WellInterp wi = well.getInterp(0);
            this.sortRangeRecords(recordsForWell);
            int currentTermIndex = -1;
            double rangeTop = 0.0;
            double rangeBase = 0.0;
            for (PaleoRangeImportRecord record : recordsForWell) {
                int termIndex = scheme.getTermIndex(record.getPaleoLabel());
                if (termIndex != currentTermIndex) {
                    if (currentTermIndex != -1) {
                        this.createPaleoRangeAndSamplesInWs(ws, wi, scheme, well, rangeTop, rangeBase, currentTermIndex);
                    }
                    currentTermIndex = termIndex;
                    rangeTop = record.getTopDepth();
                }
                rangeBase = record.getBaseDepth();
            }
            if (currentTermIndex != -1) {
                this.createPaleoRangeAndSamplesInWs(ws, wi, scheme, well, rangeTop, rangeBase, currentTermIndex);
            }
            HashSet<Integer> s = new HashSet<Integer>();
            s.add(15);
            well.updateStatus(s);
        }
    }

    private void createPaleoRangeAndSamplesInWs(SBdb ws, WellInterp wi, EnvScheme scheme, Well well, double topDepth, double baseDepth, int termIndex) throws SQLException, SampleInsertException, SBPermissionException {
        Sample base;
        Sample top;
        if (ws.useSampleTops()) {
            top = this.addOrGetWellSample(well, topDepth, null, null, null);
            base = this.addOrGetWellSample(well, baseDepth, null, null, null);
        } else {
            top = this.addOrGetWellSample(well, null, topDepth, null, null);
            base = this.addOrGetWellSample(well, null, baseDepth, null, null);
        }
        this.addPaleoRangeToInterp(ws, wi, scheme, top, base, termIndex);
    }

    private WsWell findOrCreateWsWell(SBdb ws, String wellName, String wellCode, char units) throws SQLException, SBException {
        WsWell well = (WsWell)ws.getWell(wellCode);
        if (well == null) {
            well = ws.addWellToWorkspace(0, "");
            if (wellName == null) {
                wellName = wellCode;
            }
            well.getHeader().setWellName(wellName);
            well.getHeader().setWellCode(wellCode);
            well.getHeader().setWellUnits(units);
        }
        return well;
    }

    private Sample addOrGetWellSample(Well well, Double top, Double base, SampleType type, String label) throws SQLException, SampleInsertException, SBPermissionException {
        Sample s;
        if (type == null) {
            type = this.defaultSampleType;
        }
        if ((s = well.getSample(top, base, type)) == null) {
            s = well.addSample(top, base, type.name(), label);
        }
        return s;
    }

    private void addPaleoRangeToInterp(SBdb ws, WellInterp wi, EnvScheme scheme, Sample topSample, Sample baseSample, int termIndex) {
        IGDIntervalEnv.Builder b = new IGDIntervalEnv.Builder(ws, topSample, baseSample, scheme.getID());
        b.up(termIndex).ud(termIndex).lp(termIndex).ld(termIndex);
        wi.insertEnv(b);
    }

    private <T extends PaleoImportRecord> List<T> getRecordsThatMatchScheme(EnvScheme scheme, List<T> records) {
        List<String> schemeTerms = this.buildTermList(scheme);
        ArrayList<PaleoImportRecord> validRecords = new ArrayList<PaleoImportRecord>();
        for (PaleoImportRecord record : records) {
            if (!schemeTerms.contains(record.getPaleoLabel())) continue;
            validRecords.add(record);
        }
        return validRecords;
    }

    private List<String> buildTermList(EnvScheme scheme) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i <= scheme.getNClasses(); ++i) {
            list.add(scheme.getTerm(i));
        }
        return list;
    }

    private void sortSampleRecords(SBdb ws, List<PaleoImporSampletRecord> validRecords) {
        final boolean useTops = ws.useSampleTops();
        Collections.sort(validRecords, new Comparator(){

            public int compare(Object a, Object b) {
                PaleoImporSampletRecord recordA = (PaleoImporSampletRecord)a;
                PaleoImporSampletRecord recordB = (PaleoImporSampletRecord)b;
                return recordA.getDepth(useTops).compareTo(recordB.getDepth(useTops));
            }
        });
    }

    private void sortRangeRecords(List<PaleoRangeImportRecord> rangeReocrds) {
        Collections.sort(rangeReocrds, new Comparator(){

            public int compare(Object a, Object b) {
                PaleoRangeImportRecord recordA = (PaleoRangeImportRecord)a;
                PaleoRangeImportRecord recordB = (PaleoRangeImportRecord)b;
                return recordA.getTopDepth().compareTo(recordB.getTopDepth());
            }
        });
    }

    private boolean schemeTermsMatch(EnvScheme lhs, EnvScheme rhs) {
        List<String> lhsTerms = this.buildTermList(lhs);
        List<String> rhsTerms = this.buildTermList(rhs);
        return new HashSet<String>(lhsTerms).equals(new HashSet<String>(rhsTerms));
    }
}

